/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology;

import at.grid.cms.element.CmsElement;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.webdav.NextCloudWebDAV;
import java.io.File;
import java.io.IOException;

public class ThemisCloud {
    public static boolean uploadFile(NextCloudWebDAV webdav, File f) {
        try {
            webdav.putFile(null, f);
            return true;
        }
        catch (IOException ex) {
            ThemisApplication.getInstance().getDialog().showErrorDialog("Die Datei kann nicht hochgeladen werden: {0}", ex.getMessage());
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean uploadElement(NextCloudWebDAV webdav, CmsElement e) {
        return ThemisCloud.uploadElement(webdav, null, e);
    }

    public static boolean uploadElement(NextCloudWebDAV webdav, String folder, CmsElement e) {
        if (e == null) {
            return false;
        }
        try {
            webdav.putStringAsZip(folder, e.toXML(), e.getElementcode() + "_" + e.getId() + "_element.xmlz");
            return true;
        }
        catch (IOException ex) {
            ThemisApplication.getInstance().getDialog().showErrorDialog("Die Datei kann nicht hochgeladen werden: {0}", ex.getMessage());
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean uploadString(NextCloudWebDAV webdav, String folder, String s, String filename) {
        if (s == null) {
            return false;
        }
        try {
            webdav.putStringAsZip(folder, s, filename);
            return true;
        }
        catch (IOException ex) {
            ThemisApplication.getInstance().getDialog().showErrorDialog("Die Datei kann nicht hochgeladen werden: {0}", ex.getMessage());
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean createFolder(NextCloudWebDAV webdav, String folder) {
        try {
            webdav.createFolder(new String[]{folder});
            return true;
        }
        catch (IOException ex) {
            ThemisApplication.getInstance().getDialog().showErrorDialog("Die Datei kann nicht hochgeladen werden: {0}", ex.getMessage());
            ex.printStackTrace();
            return false;
        }
    }
}

