/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology;

import at.grid.cms.CmsApplication;
import at.grid.cms.content.Keytable;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.element.CmsElementXml;
import at.grid.cms.element.CmsUser;
import at.grid.cms.search.CmsBasicSearch;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.gui.Dialogs;
import at.grid.themis.ontology.Closing;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFileFolderOutputter;
import at.grid.themis.ontology.ThemisFileImportSummary;
import at.grid.themis.ontology.ThemisFileOutputter;
import at.grid.themis.ontology.ThemisFileServerOutputter;
import at.grid.themis.ontology.ThemisFileZipOutputter;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsFormular;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.project.ProjectExport;
import at.grid.themis.ontology.report.ReportTableLayout;
import at.grid.util.DefaultProgressHandler;
import at.grid.util.ProgressHandler;
import at.grid.util.Timer;
import at.grid.util.Util;
import at.grid.webdav.NextCloudWebDAV;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ThemisFile {
    public static final int THEMISFILE_VERSION = 3;
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    private ArrayList<File> files = new ArrayList();
    private CmsElementXml projectXml = null;
    private boolean applyProjectAttributes = false;
    private boolean applyProjectUUID = false;
    private CmsElement event = null;
    private boolean withEvent = false;
    private ArrayList<Long> contentIds = new ArrayList();
    private File analysedFile = null;
    private int countTemplate;
    private int countObservation;
    private int countLocation;
    private int countPlan;
    private int countForm;
    private int countElements;
    private int countIcon;
    private int countContact;
    private int countDocument;
    private int countReportTemplate;
    private long maxIdInFile;
    private ArrayList<Long> planIds = new ArrayList();
    private ArrayList<Long> documentIds = new ArrayList();
    private boolean addPlansForLocations = false;
    private boolean withTemplates = true;
    private boolean withDocuments = true;
    private boolean withRelevantDocuments = false;
    private boolean withImages = false;
    private boolean withContacts = true;
    private boolean withIcons = true;
    private boolean withKeytables = true;
    private boolean withTrash = false;
    private boolean withFilter = true;
    private boolean withForms = true;
    private boolean withReportTemplates = true;
    private boolean withSettings = true;
    private boolean withProject = true;
    private boolean keepLocationNumbers = false;
    private boolean useCurrentEvent = false;
    private ArrayList<String> exceptions = new ArrayList();
    private ContentType contentType = ContentType.FILTER;
    private ProgressHandler ph;
    private String md5;
    HashMap<String, String> strings = new HashMap();

    private void setError(String ex) {
        this.exceptions.add(ex);
    }

    public boolean hasError() {
        return !this.exceptions.isEmpty();
    }

    public ArrayList<String> getExceptions() {
        return this.exceptions;
    }

    public ThemisFile() {
        this(null);
    }

    public ThemisFile(ProgressHandler ph) {
        this.setContentType(ContentType.FILTER);
        this.ph = ph;
    }

    public ThemisFile setProgressHandler(ProgressHandler ph) {
        this.ph = ph;
        return this;
    }

    public String getMd5() {
        return this.md5;
    }

    public ThemisFile setEvent(CmsEvent event) {
        this.event = event;
        this.withEvent = event != null;
        return this;
    }

    public ThemisFile setEvent(long id) {
        CmsElement e;
        this.event = null;
        if (id >= 0L && (e = this.project.loadElement(id, this.project.getUser())) instanceof CmsEvent) {
            this.event = (CmsEvent)e;
        }
        this.withEvent = this.event != null;
        return this;
    }

    public boolean hasEvent() {
        return this.withEvent;
    }

    public CmsEvent getEvent() {
        return (CmsEvent)this.event;
    }

    public ThemisFile addFile(File f) {
        if (f != null) {
            this.files.add(f);
        }
        return this;
    }

    public ThemisFile addFiles(ArrayList<File> files) {
        if (files != null) {
            this.files.addAll(files);
        }
        return this;
    }

    public ThemisFile addString(String filename, String s) {
        this.strings.put(filename, s);
        return this;
    }

    public ThemisFile setWithTemplates(boolean flg) {
        this.withTemplates = flg;
        return this;
    }

    public ThemisFile setWithTemplates() {
        this.withTemplates = true;
        return this;
    }

    public ThemisFile setWithoutTemplates() {
        this.withTemplates = false;
        return this;
    }

    public ThemisFile setWithDocuments(boolean flg) {
        this.withDocuments = flg;
        return this;
    }

    public ThemisFile setWithDocuments() {
        this.withDocuments = true;
        return this;
    }

    public ThemisFile setWithoutDocuments() {
        this.withDocuments = false;
        return this;
    }

    public ThemisFile setWithRelevantDocuments() {
        this.withRelevantDocuments = true;
        return this;
    }

    public ThemisFile setWithoutRelevantDocuments() {
        this.withRelevantDocuments = false;
        return this;
    }

    public ThemisFile setWithContacts(boolean flg) {
        this.withContacts = flg;
        return this;
    }

    public ThemisFile setWithContacts() {
        this.withContacts = true;
        return this;
    }

    public ThemisFile setWithoutContacts() {
        this.withContacts = false;
        return this;
    }

    public ThemisFile setWithIcons(boolean flg) {
        this.withIcons = flg;
        return this;
    }

    public ThemisFile setWithIcons() {
        this.withIcons = true;
        return this;
    }

    public ThemisFile setWithoutIcons() {
        this.withIcons = false;
        return this;
    }

    public ThemisFile setWithKeytables(boolean flg) {
        this.withKeytables = flg;
        return this;
    }

    public ThemisFile setWithKeytables() {
        this.withKeytables = true;
        return this;
    }

    public ThemisFile setWithoutKeytables() {
        this.withKeytables = false;
        return this;
    }

    public ThemisFile setWithForms(boolean flg) {
        this.withForms = flg;
        return this;
    }

    public ThemisFile setWithForms() {
        this.withForms = true;
        return this;
    }

    public ThemisFile setWithoutForms() {
        this.withForms = false;
        return this;
    }

    public ThemisFile setWithReportTemplates(boolean flg) {
        this.withReportTemplates = flg;
        return this;
    }

    public ThemisFile setWithReportTemplates() {
        this.withReportTemplates = true;
        return this;
    }

    public ThemisFile setWithoutReportTemplates() {
        this.withReportTemplates = false;
        return this;
    }

    public ThemisFile setWithSettings(boolean flg) {
        this.withSettings = flg;
        return this;
    }

    public ThemisFile setWithSettings() {
        this.withSettings = true;
        return this;
    }

    public ThemisFile setWithoutSettings() {
        this.withSettings = false;
        return this;
    }

    public ThemisFile setWithAllImages() {
        this.withImages = true;
        return this;
    }

    public ThemisFile setWithRelevantImages() {
        this.withImages = true;
        return this;
    }

    public ThemisFile addContent(ArrayList<Long> ids) {
        if (ids != null) {
            for (long id : ids) {
                this.addContent(id);
            }
        }
        return this;
    }

    public ThemisFile addContent(long id) {
        if (id >= 0L && !this.contentIds.contains(id)) {
            this.contentIds.add(id);
        }
        return this;
    }

    public ThemisFile addPlans(ArrayList<Long> ids) {
        if (ids != null) {
            for (long id : ids) {
                this.addPlan(id);
            }
        }
        return this;
    }

    public ThemisFile addPlan(long id) {
        if (id >= 0L && !this.planIds.contains(id) && "plan".equals(this.project.getDatastorage().getElementtypeById(id))) {
            this.planIds.add(id);
            this.addContent(this.project.getBuildingForPlan(id));
        }
        return this;
    }

    public ThemisFile setWithPlans() {
        for (CmsElementSummary ele : this.project.getPlans()) {
            this.planIds.add(ele.getId());
        }
        for (CmsElementSummary ele : this.project.getBuildings()) {
            this.addContent(ele.getId());
        }
        return this;
    }

    public ThemisFile setWithPlansForLocations() {
        this.addPlansForLocations = true;
        return this;
    }

    public ThemisFile setContentType(ContentType c) {
        this.contentType = c;
        switch (c) {
            case ARCHIVE: 
            case TEMPLATE: 
            case TRASH: 
            case REPORTTEMPLATE: 
            case FORM: {
                this.applyProjectAttributes = false;
            }
        }
        this.applyProjectAttributes = true;
        return this;
    }

    public ThemisFile setAsSpecific() {
        this.setContentType(ContentType.SPECIFIC);
        this.withProject = false;
        this.withKeytables = false;
        this.withContacts = false;
        this.withTrash = false;
        this.withFilter = false;
        this.withForms = false;
        this.withSettings = false;
        this.withImages = false;
        this.withTemplates = false;
        this.withIcons = false;
        this.withDocuments = false;
        this.withRelevantDocuments = false;
        this.withReportTemplates = false;
        return this;
    }

    public ThemisFile setAsProjectTemplate() {
        this.setContentType(ContentType.TEMPLATE);
        this.withProject = false;
        this.withKeytables = true;
        this.withContacts = true;
        this.withTrash = false;
        this.withFilter = true;
        this.withForms = true;
        this.withSettings = true;
        this.withImages = false;
        this.withTemplates = true;
        this.withIcons = true;
        this.withDocuments = true;
        this.withRelevantDocuments = false;
        this.withReportTemplates = true;
        return this;
    }

    public boolean isProjectTemplate() {
        return this.contentType == ContentType.TEMPLATE;
    }

    public ThemisFile setAsArchive() {
        this.setContentType(ContentType.ARCHIVE);
        return this;
    }

    public boolean isArchive() {
        return this.contentType == ContentType.ARCHIVE;
    }

    public ThemisFile setAsTrash() {
        this.setContentType(ContentType.TRASH);
        return this;
    }

    public boolean isTrash() {
        return this.contentType == ContentType.TRASH;
    }

    public ThemisFile setAsForm() {
        this.setContentType(ContentType.FORM);
        return this;
    }

    public boolean isForm() {
        return this.contentType == ContentType.FORM;
    }

    public ThemisFile setAsReportTemplate() {
        this.setContentType(ContentType.REPORTTEMPLATE);
        return this;
    }

    public boolean isReportTemplate() {
        return this.contentType == ContentType.REPORTTEMPLATE;
    }

    public ThemisFile setAsFullProject() {
        this.setContentType(ContentType.PROJECT);
        return this;
    }

    public ThemisFile setAsContentOnly() {
        this.setContentType(ContentType.CONTENT);
        this.withProject = false;
        this.withKeytables = false;
        this.withContacts = false;
        this.withTrash = false;
        this.withFilter = false;
        this.withForms = false;
        this.withSettings = false;
        this.withImages = false;
        this.withTemplates = false;
        this.withIcons = false;
        this.withDocuments = false;
        this.withRelevantDocuments = false;
        this.withReportTemplates = false;
        return this;
    }

    public boolean doReadProject() {
        switch (this.contentType) {
            case TEMPLATE: 
            case REPORTTEMPLATE: 
            case FORM: {
                return false;
            }
        }
        return true;
    }

    private boolean doReadElementtype(String elementCode) {
        if (elementCode == null) {
            return false;
        }
        switch (this.contentType) {
            case REPORTTEMPLATE: {
                switch (elementCode) {
                    case "report": 
                    case "reporttable": 
                    case "filter": {
                        return true;
                    }
                }
                return false;
            }
            case FORM: {
                switch (elementCode) {
                    case "form": 
                    case "filter": {
                        return true;
                    }
                }
                return false;
            }
            case TEMPLATE: {
                switch (elementCode) {
                    case "icon": {
                        return this.withIcons;
                    }
                    case "company": {
                        return this.withContacts;
                    }
                    case "info": {
                        return this.withDocuments;
                    }
                    case "form": {
                        return this.withForms;
                    }
                    case "report": 
                    case "reporttable": {
                        return this.withReportTemplates;
                    }
                    case "locationgroup": 
                    case "locationtemplate": 
                    case "observationtemplate": 
                    case "measuretemplate": {
                        return this.withTemplates;
                    }
                    case "event": {
                        return this.withEvent;
                    }
                }
                return true;
            }
        }
        return true;
    }

    private boolean doReadEvent() {
        switch (this.contentType) {
            case TEMPLATE: 
            case REPORTTEMPLATE: 
            case FORM: {
                return false;
            }
        }
        return true;
    }

    private boolean doReadKeytables() {
        switch (this.contentType) {
            case PROJECT: {
                return true;
            }
            case TEMPLATE: {
                return this.withKeytables;
            }
        }
        return false;
    }

    private boolean doReadTextTemplates() {
        switch (this.contentType) {
            case REPORTTEMPLATE: 
            case FORM: {
                return false;
            }
            case TEMPLATE: {
                return this.withTemplates;
            }
        }
        return true;
    }

    private boolean doReadSettings() {
        switch (this.contentType) {
            case PROJECT: {
                return true;
            }
            case TEMPLATE: {
                return this.withSettings;
            }
        }
        return false;
    }

    private boolean isEventRequired() {
        switch (this.contentType) {
            case ARCHIVE: 
            case TEMPLATE: 
            case TRASH: 
            case REPORTTEMPLATE: 
            case FORM: {
                return false;
            }
        }
        return true;
    }

    public ThemisFile setApplyProjectAttributes() {
        this.applyProjectAttributes = true;
        return this;
    }

    public ThemisFile setApplyProjectUUID() {
        this.applyProjectUUID = true;
        return this;
    }

    public boolean hasAnalysedFile() {
        return this.analysedFile != null;
    }

    public int getCountTemplate() {
        return this.countTemplate;
    }

    public int getCountObservation() {
        return this.countObservation;
    }

    public int getCountLocation() {
        return this.countLocation;
    }

    public int getCountPlan() {
        return this.countPlan;
    }

    public int getCountForm() {
        return this.countForm;
    }

    public int getCountIcon() {
        return this.countIcon;
    }

    public int getCountContact() {
        return this.countContact;
    }

    public int getCountDocument() {
        return this.countDocument;
    }

    public int getCountReportTemplate() {
        return this.countReportTemplate;
    }

    public boolean hasKeytables() {
        return this.withKeytables;
    }

    public boolean hasSettings() {
        return this.withSettings;
    }

    public CmsElementXml getProjectInFile() {
        return this.projectXml;
    }

    public ThemisFile setKeepLocationNumbers() {
        this.keepLocationNumbers = true;
        return this;
    }

    public ThemisFile setUseCurrentEvent() {
        this.useCurrentEvent = true;
        return this;
    }

    public boolean saveToCloud(String url, String pwd, String name, boolean forceOverwrite) throws FileNotFoundException, IOException {
        File tempfile = new File(this.app.getApplicationDataTempFolder(), name);
        this.saveToFile(tempfile, true);
        ThemisUtil.uploadFileToNextcloud(url, pwd, tempfile);
        Util.delete((File)tempfile);
        return false;
    }

    public boolean saveToCloud(NextCloudWebDAV webdav, String name, boolean forceOverwrite) throws FileNotFoundException, IOException {
        File f = this.saveToTempFile(name);
        webdav.putFile(null, f);
        return false;
    }

    public File saveToTempFile(String name) throws IOException {
        File tempfile = new File(this.project.getTempfileLocation(), name);
        ThemisApplication.getLogger().info("writing *.themis with " + this.contentIds.size() + " entries file to '" + tempfile.getAbsolutePath() + "'");
        this.saveToFile(tempfile, true);
        return tempfile;
    }

    public boolean saveToFile(File themisfile, boolean forceOverwrite) throws FileNotFoundException, IOException {
        String info = "creating";
        if (themisfile.exists()) {
            if (!forceOverwrite && !this.app.getDialog().showConfirmDialog("ask.overwrite-file", "Datei speichern", new String[]{themisfile.getName()})) {
                return false;
            }
            info = "overwriting";
            themisfile.delete();
        }
        ThemisApplication.getLogger().info(info + " file: " + themisfile.getAbsolutePath());
        File f = new File(this.app.getApplicationDataTempFolder(), Long.toString(new Date().getTime()));
        ThemisFileZipOutputter out = new ThemisFileZipOutputter(f);
        this.saveToFile(out, forceOverwrite);
        Util.copy((File)f, (File)themisfile);
        Util.delete((File)f);
        return themisfile.isFile();
    }

    public boolean saveToServer(NextCloudWebDAV webdav, String filename, boolean forceOverwrite) throws FileNotFoundException, IOException {
        File f = new File(this.app.getApplicationDataTempFolder(), filename);
        if (f.exists()) {
            f.delete();
        }
        f.getAbsoluteFile().getParentFile().mkdirs();
        ThemisFileOutputter out = new ThemisFileZipOutputter(f);
        ThemisApplication.getLogger().info("creating *.themis with " + this.contentIds.size() + " entries file to '" + f.getAbsolutePath() + "'");
        this.saveToFile(out, forceOverwrite);
        if (this.ph.isCancelled()) {
            return false;
        }
        long filesize = f.length();
        ThemisApplication.getLogger().info("file size of created *.themis is " + filesize / 10000000L + " MB");
        if (filesize > 1000000000L) {
            out = new ThemisFileServerOutputter(webdav, filename);
            ThemisApplication.getLogger().info("direct write to server " + webdav.getUrl());
            this.saveToFile(out, forceOverwrite);
            if (this.ph.isCancelled()) {
                return false;
            }
        } else {
            try {
                String webdavProjectfolder = "projects/" + this.project.getProjectElement().getUUIDasString();
                ThemisApplication.getLogger().info("copying file to server " + webdav.getUrl());
                webdav.putFile(webdavProjectfolder, f);
                if (this.ph.isCancelled()) {
                    return false;
                }
            }
            catch (IOException ex) {
                this.project.getLogger().severe("Cannot write to WEBDAV: " + ex.getMessage());
            }
        }
        Util.delete((File)f);
        return true;
    }

    public boolean saveToFolder(File fld, boolean forceOverwrite) throws FileNotFoundException, IOException {
        if (fld.exists()) {
            if (!forceOverwrite && !this.app.getDialog().showConfirmDialog("ask.overwrite-file")) {
                return false;
            }
            Util.deleteContent((File)fld);
        }
        fld.mkdirs();
        ThemisFileFolderOutputter out = new ThemisFileFolderOutputter(fld);
        this.saveToFile(out, forceOverwrite);
        return true;
    }

    private boolean saveToFile(ThemisFileOutputter out, boolean forceOverwrite) throws FileNotFoundException, IOException {
        long planId2;
        CmsElement ele;
        ArrayList<String> newMD5s;
        Object e;
        if (this.ph == null) {
            this.ph = new DefaultProgressHandler();
        }
        this.ph.switchToDeterminate(100);
        this.ph.progress("Vorbereitungen ...", 0);
        ArrayList<String> md5s = new ArrayList<String>();
        switch (this.contentType) {
            case ARCHIVE: {
                out.write("archive", "true");
                this.withProject = true;
                this.withKeytables = true;
                this.withContacts = true;
                this.withTrash = false;
                this.withFilter = false;
                this.withForms = true;
                this.withSettings = false;
                this.withImages = true;
                this.withTemplates = true;
                this.withIcons = true;
                this.withReportTemplates = true;
                this.withDocuments = false;
                this.withRelevantDocuments = false;
                break;
            }
            case TRASH: {
                out.write("trash", "true");
                this.withProject = false;
                this.withKeytables = false;
                this.withContacts = false;
                this.withTrash = true;
                this.withFilter = false;
                this.withForms = false;
                this.withSettings = false;
                this.withImages = false;
                this.withTemplates = false;
                this.withIcons = false;
                this.withReportTemplates = false;
                this.withDocuments = false;
                this.withRelevantDocuments = false;
                break;
            }
            case REPORTTEMPLATE: {
                this.withProject = false;
                this.withKeytables = false;
                this.withContacts = false;
                this.withTrash = false;
                this.withFilter = false;
                this.withForms = false;
                this.withSettings = false;
                this.withImages = false;
                this.withTemplates = false;
                this.withIcons = false;
                this.withReportTemplates = true;
                this.withDocuments = false;
                this.withRelevantDocuments = false;
                break;
            }
            case CONTENT: {
                this.withProject = true;
                this.withKeytables = true;
                this.withContacts = true;
                this.withTrash = false;
                this.withFilter = false;
                this.withForms = true;
                this.withSettings = false;
                this.withImages = true;
                this.withTemplates = true;
                this.withIcons = true;
                this.withReportTemplates = true;
                this.withDocuments = false;
                this.withRelevantDocuments = false;
            }
            case PROJECT: {
                this.withProject = true;
                this.withKeytables = true;
                this.withContacts = true;
                this.withTrash = true;
                this.withFilter = true;
                this.withForms = true;
                this.withSettings = true;
                this.withImages = true;
                this.withTemplates = true;
                this.withIcons = true;
                this.withReportTemplates = true;
                this.withDocuments = true;
                this.withRelevantDocuments = false;
                this.setWithPlans();
                break;
            }
            case TEMPLATE: {
                out.write("template", "true");
                break;
            }
            case FORM: {
                this.withProject = false;
                this.withKeytables = false;
                this.withContacts = false;
                this.withTrash = false;
                this.withFilter = false;
                this.withForms = true;
                this.withSettings = false;
                this.withImages = false;
                this.withTemplates = false;
                this.withIcons = false;
                this.withReportTemplates = false;
                this.withDocuments = false;
                this.withRelevantDocuments = false;
                break;
            }
            case EVENT: {
                if (this.event == null) break;
                this.addContent(((CmsEvent)this.event).getModifiedElementIds());
                this.addContent(((CmsEvent)this.event).getObservationIds());
                break;
            }
            case SPECIFIC: {
                break;
            }
            case FILTER: {
                this.withProject = true;
                this.withKeytables = false;
                this.withContacts = false;
                this.withTrash = false;
                this.withFilter = true;
                this.withForms = false;
                this.withSettings = true;
                this.withImages = true;
                this.withTemplates = false;
                this.withIcons = false;
                this.withReportTemplates = false;
                this.withDocuments = false;
                this.withRelevantDocuments = true;
            }
        }
        ArrayList templateGroupIds = new ArrayList();
        ArrayList templateLocationIds = new ArrayList();
        ArrayList templateObservationIds = new ArrayList();
        ArrayList templateMeasureIds = new ArrayList();
        ArrayList templateIconIds = new ArrayList();
        ArrayList templateInfoLocationIds = new ArrayList();
        ArrayList templateInfoObservationIds = new ArrayList();
        ArrayList templateReportIds = new ArrayList();
        ArrayList<Object> reportTableIds = new ArrayList();
        if (this.ph.isCancelled()) {
            out.cancel();
            return false;
        }
        if (this.withTemplates) {
            templateGroupIds = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "locationgroup").search().getResultIds();
            templateLocationIds = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "locationtemplate").search().getResultIds();
            templateObservationIds = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "observationtemplate").search().getResultIds();
            templateMeasureIds = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "measuretemplate").search().getResultIds();
            templateIconIds = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "icon").search().getResultIds();
            templateInfoLocationIds = this.project.getDatastorage().getRelationIds((List)templateLocationIds, "locationtemplateinfo", true);
            templateInfoObservationIds = this.project.getDatastorage().getRelationIds((List)templateObservationIds, "observationtemplateinfo", true);
        }
        if (this.withIcons && !this.withTemplates) {
            templateIconIds = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "icon").search().getResultIds();
        }
        if (this.withReportTemplates) {
            templateReportIds = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "report").search().getResultIds();
            reportTableIds = this.project.getReportTableLayoutIds();
        }
        if (this.withFilter) {
            this.contentIds.addAll(new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "filter").search().getResultIds());
        }
        if (this.withForms) {
            this.contentIds.addAll(new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "form").search().getResultIds());
        }
        if (this.withDocuments && !this.withRelevantDocuments) {
            long id;
            this.documentIds = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "info").search().getResultIds();
            Iterator iterator = templateInfoLocationIds.iterator();
            while (iterator.hasNext()) {
                id = (Long)iterator.next();
                if (!this.documentIds.contains(id)) continue;
                this.documentIds.remove(id);
            }
            iterator = templateInfoObservationIds.iterator();
            while (iterator.hasNext()) {
                id = (Long)iterator.next();
                if (!this.documentIds.contains(id)) continue;
                this.documentIds.remove(id);
            }
        }
        int totalCounter = this.contentIds.size() + templateGroupIds.size() + templateLocationIds.size() + templateObservationIds.size() + templateMeasureIds.size() + templateIconIds.size() + templateReportIds.size() + reportTableIds.size() + templateInfoLocationIds.size() + templateInfoObservationIds.size() + this.documentIds.size() + this.planIds.size() + this.files.size();
        if (this.ph.isCancelled()) {
            out.cancel();
            return false;
        }
        this.ph.switchToDeterminate(totalCounter);
        int counter = 0;
        out.write("version", Integer.toString(3));
        if (this.withProject) {
            out.writeProject();
        }
        if (this.event != null) {
            out.write("event.xml", this.event.toXML());
            Iterator<File> filter = new ThemisFilter(this.app);
            ((ThemisFilter)((Object)filter)).getEventId().setItem(this.event.getId(), this);
            ((ThemisFilter)((Object)filter)).setEventOption(3, this);
            this.addContent(((ThemisFilter)((Object)filter)).getFilteredElementIds());
        }
        if (this.withSettings) {
            md5s.add(out.writeSettings());
        }
        if (this.withKeytables) {
            md5s.add(out.writeKeytables());
        }
        if (this.ph.isCancelled()) {
            out.cancel();
            return false;
        }
        if (this.withContacts) {
            for (CmsBasicElement be : this.project.getContacts()) {
                e = this.project.loadElement(be.getId(), this.project.getUser());
                md5s.add(e.getMD5());
                out.write((CmsElement)e, false, false, (CmsEvent)this.event);
                if (!this.ph.isCancelled()) continue;
                out.cancel();
                return false;
            }
        }
        if (this.withTemplates) {
            newMD5s = out.writeElements(templateGroupIds, false, this.ph, counter);
            newMD5s.addAll(out.writeElements(templateLocationIds, false, this.ph, counter + newMD5s.size()));
            if (this.ph.isCancelled()) {
                out.cancel();
                return false;
            }
            newMD5s.addAll(out.writeElements(templateObservationIds, false, this.ph, counter + newMD5s.size()));
            newMD5s.addAll(out.writeElements(templateMeasureIds, false, this.ph, counter + newMD5s.size()));
            if (this.ph.isCancelled()) {
                out.cancel();
                return false;
            }
            newMD5s.addAll(out.writeElements(templateIconIds, true, this.ph, counter + newMD5s.size()));
            newMD5s.addAll(out.writeElements(templateInfoLocationIds, true, this.ph, counter + newMD5s.size()));
            newMD5s.addAll(out.writeElements(templateInfoObservationIds, true, this.ph, counter + newMD5s.size()));
            counter += newMD5s.size();
            md5s.addAll(newMD5s);
            if (this.ph.isCancelled()) {
                out.cancel();
                return false;
            }
        }
        if (this.withIcons && !this.withTemplates) {
            newMD5s = out.writeElements(templateIconIds, true, this.ph, counter);
            counter += newMD5s.size();
            md5s.addAll(newMD5s);
        }
        if (this.withReportTemplates) {
            newMD5s = out.writeElements(templateReportIds, true, this.ph, counter);
            newMD5s.addAll(out.writeElements(reportTableIds, true, this.ph, counter + newMD5s.size()));
            counter += newMD5s.size();
            md5s.addAll(newMD5s);
        }
        if (this.withDocuments && !this.withRelevantDocuments) {
            newMD5s = out.writeElements(this.documentIds, true, this.ph, counter);
            counter += newMD5s.size();
            md5s.addAll(newMD5s);
        }
        if (this.ph.isCancelled()) {
            out.cancel();
            return false;
        }
        this.ph.progress("F\u00fcge zus\u00e4tzliche Dateien hinzu ...");
        for (File addFile : this.files) {
            this.ph.progress(counter);
            ++counter;
            out.write(addFile.getName(), addFile, "");
            if (!this.ph.isCancelled()) continue;
            out.cancel();
            return false;
        }
        this.ph.progress("F\u00fcge zus\u00e4tzliche Inhalte hinzu ...");
        this.strings.forEach((fn, s) -> out.write((String)fn, (String)s));
        if (this.ph.isCancelled()) {
            out.cancel();
            return false;
        }
        HashSet<Long> otherElementIds = new HashSet<Long>();
        this.ph.progress("F\u00fcge Datens\u00e4tze hinzu ...");
        e = this.contentIds.iterator();
        while (e.hasNext()) {
            long otherId;
            Iterator iterator;
            long id = (Long)e.next();
            this.ph.progress(counter);
            ++counter;
            ele = this.project.loadElement(id, this.project.getUser());
            if (!this.withTrash && ele.isTrash()) continue;
            if ("observation".equals(ele.getElementcode())) {
                long locId;
                CmsHistory hist;
                if (this.event != null && (hist = ((CmsObservation)ele).getHistory((CmsEvent)this.event)) != null) {
                    ((CmsObservation)ele).applyHistory(hist);
                    ((CmsObservation)ele).restrictToHistoryUploads(hist);
                }
                if ((locId = ele.getRelationAttribute("location").getFirstElementId()) >= 0L) {
                    otherElementIds.add(locId);
                    iterator = this.project.getDatastorage().getRelationIds(locId, "locationinfo", true, false).iterator();
                    while (iterator.hasNext()) {
                        otherId = (Long)iterator.next();
                        if (!this.withDocuments && !this.withRelevantDocuments || otherElementIds.contains(otherId)) continue;
                        otherElementIds.add(otherId);
                    }
                }
                iterator = ele.getRelationAttribute("infos").getElementIds(false).iterator();
                while (iterator.hasNext()) {
                    otherId = (Long)iterator.next();
                    if (!this.withDocuments && !this.withRelevantDocuments || otherElementIds.contains(otherId)) continue;
                    otherElementIds.add(otherId);
                }
            } else if ("location".equals(ele.getElementcode())) {
                planId2 = ((CmsLocation)ele).getPlanId();
                if (this.addPlansForLocations && planId2 > 0L && !this.planIds.contains(planId2)) {
                    this.planIds.add(planId2);
                }
                iterator = ele.getRelationAttribute("infos").getElementIds(false).iterator();
                while (iterator.hasNext()) {
                    otherId = (Long)iterator.next();
                    if (!this.withDocuments && !this.withRelevantDocuments || otherElementIds.contains(otherId)) continue;
                    otherElementIds.add(otherId);
                }
            } else if ("form".equals(ele.getElementcode()) && (this.isForm() || this.isProjectTemplate())) {
                ((CmsFormular)ele).removeHistories();
            }
            if (this.event == null || this.event.getId() != id) {
                md5s.add(out.write(ele, true, this.withImages, (CmsEvent)this.event));
            }
            if (!this.ph.isCancelled()) continue;
            out.cancel();
            return false;
        }
        e = otherElementIds.iterator();
        while (e.hasNext()) {
            long eleId = (Long)e.next();
            if (!this.contentIds.contains(eleId)) {
                ele = this.project.loadElement(eleId, this.project.getUser());
                if (ele.isTrash()) continue;
                if ("location".equals(ele.getElementcode())) {
                    planId2 = ((CmsLocation)ele).getPlanId();
                    if (this.addPlansForLocations && planId2 > 0L && !this.planIds.contains(planId2)) {
                        this.planIds.add(planId2);
                    }
                }
                md5s.add(out.write(ele, true, this.withImages, (CmsEvent)this.event));
            }
            if (!this.ph.isCancelled()) continue;
            out.cancel();
            return false;
        }
        ArrayList<Long> buildingIds = new ArrayList<Long>();
        for (long planId2 : this.planIds) {
            this.ph.progress(counter);
            ++counter;
            CmsElement plan = this.project.loadElement(planId2, this.project.getUser());
            md5s.add(out.write(plan, true, null));
            long buildingId = plan.getRelationAttribute("building").getFirstElementId();
            if (buildingId > 0L && !buildingIds.contains(buildingId)) {
                buildingIds.add(buildingId);
            }
            if (!this.ph.isCancelled()) continue;
            out.cancel();
            return false;
        }
        Iterator planId2 = buildingIds.iterator();
        while (planId2.hasNext()) {
            long buildingId = (Long)planId2.next();
            CmsElement building = this.project.loadElement(buildingId, this.project.getUser());
            md5s.add(out.write(building, true, null));
        }
        if (this.ph.isCancelled()) {
            out.cancel();
            return false;
        }
        Collections.sort(md5s);
        String md5sJoin = String.join((CharSequence)"\n", md5s);
        this.md5 = Util.md5((String)md5sJoin);
        out.write("md5", this.md5);
        out.close();
        if (!out.getErrors().isEmpty()) {
            String msg = this.project.getResourceText("error.zip.creation") + ":";
            for (String err : out.getErrors()) {
                msg = "\n- " + err;
            }
            this.app.getDialog().showErrorDialog(msg);
            return false;
        }
        this.ph.progress("Die Datei wird im Zielordner gespeichert ...");
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ThemisFile analyseThemisFile(File f) {
        Timer t;
        block57: {
            ZipEntry nextEntry;
            Enumeration<? extends ZipEntry> entries;
            Throwable throwable;
            ZipFile zip;
            int otherElements;
            block56: {
                t = Timer.start();
                this.withProject = false;
                this.withKeytables = false;
                this.withContacts = false;
                this.withTrash = false;
                this.withFilter = false;
                this.withForms = false;
                this.withSettings = false;
                this.withImages = false;
                this.withTemplates = false;
                this.withIcons = false;
                this.withDocuments = false;
                this.withRelevantDocuments = false;
                this.withReportTemplates = false;
                this.withEvent = false;
                this.countObservation = 0;
                this.countLocation = 0;
                this.countTemplate = 0;
                this.countPlan = 0;
                this.countForm = 0;
                this.countIcon = 0;
                this.countContact = 0;
                this.countDocument = 0;
                this.countReportTemplate = 0;
                this.countElements = 0;
                this.maxIdInFile = 0L;
                this.exceptions.clear();
                otherElements = 0;
                try {
                    zip = new ZipFile(f);
                    throwable = null;
                    try {
                        entries = zip.entries();
                        if (zip.getEntry("template") != null) {
                            this.setAsProjectTemplate();
                        }
                        if ((nextEntry = zip.getEntry("project.xml")) == null) {
                            ThemisApplication.getInstance().getProject().getLogger().info("no project element in ZIP file");
                            break block56;
                        }
                        try {
                            this.projectXml = new CmsElementXml(ThemisFile.getXmlDocument(zip, nextEntry).getRootElement(), (CmsApplication)this.project, this.project.getUser());
                        }
                        catch (JDOMException ex) {
                            ThemisApplication.getInstance().getProject().getLogger().severe("cannot read project element: " + ex.getMessage());
                            ex.printStackTrace();
                            ThemisFile themisFile = null;
                            if (zip == null) return themisFile;
                            if (throwable == null) {
                                zip.close();
                                return themisFile;
                            }
                            try {
                                zip.close();
                                return themisFile;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                                return themisFile;
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (Exception ex) {
                    ThemisApplication.getInstance().getDialog().showErrorDialog("error.zip.read", ex.getMessage());
                    ThemisApplication.getInstance().getProject().getLogger().severe("Error reading ZIP: " + ex.getMessage());
                    this.setError(this.project.getResourceText("error.zip.read") + ": " + ex.getLocalizedMessage());
                    break block57;
                }
            }
            while (entries.hasMoreElements()) {
                nextEntry = entries.nextElement();
                String nextEntryName = nextEntry.getName().toLowerCase();
                if (nextEntryName != null) {
                    if (nextEntryName.contains("template")) {
                        this.withTemplates = true;
                        ++this.countTemplate;
                    } else if (nextEntryName.equals("event.xml")) {
                        this.withEvent = true;
                    } else if (nextEntryName.equals("settings.xml")) {
                        this.withSettings = true;
                    } else if (nextEntryName.equals("keytables.xml")) {
                        this.withKeytables = true;
                    } else if (nextEntryName.equals("project.xml")) {
                        this.withProject = true;
                    } else if (nextEntryName.endsWith(".xml")) {
                        if (nextEntryName.startsWith("observation_")) {
                            ++this.countObservation;
                        } else if (nextEntryName.startsWith("location_")) {
                            ++this.countLocation;
                        } else if (nextEntryName.startsWith("plan_")) {
                            ++this.countPlan;
                        } else if (nextEntryName.startsWith("filter_")) {
                            this.withFilter = true;
                        } else if (nextEntryName.startsWith("form_")) {
                            this.withForms = true;
                            ++this.countForm;
                        } else if (nextEntryName.startsWith("icon_")) {
                            this.withIcons = true;
                            ++this.countIcon;
                        } else if (nextEntryName.startsWith("info_")) {
                            this.withDocuments = true;
                            ++this.countDocument;
                        } else if (nextEntryName.startsWith("company_")) {
                            this.withContacts = true;
                            ++this.countContact;
                        } else if (nextEntryName.startsWith("reporttable_")) {
                            this.withReportTemplates = true;
                            ++this.countReportTemplate;
                        } else if (nextEntryName.startsWith("report_")) {
                            this.withReportTemplates = true;
                            ++this.countReportTemplate;
                        } else if (nextEntryName.toLowerCase().endsWith("_element.xml")) {
                            ++otherElements;
                        }
                    }
                }
                if (!nextEntryName.toLowerCase().endsWith("_element.xml")) continue;
                String[] split = nextEntryName.split("_");
                String id = split.length > 1 ? split[1] : "0";
                this.maxIdInFile = Math.max(this.maxIdInFile, Util.parseLong((String)id, (long)0L));
            }
            this.countElements = this.countTemplate + this.countObservation + this.countLocation + this.countPlan + this.countForm + this.countIcon + this.countDocument + this.countContact + this.countReportTemplate + otherElements;
            this.analysedFile = f;
            break block57;
            finally {
                if (zip != null) {
                    if (throwable != null) {
                        try {
                            zip.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        zip.close();
                    }
                }
            }
        }
        ThemisApplication.getLogger().info("analysed *.themis file '" + f.getName() + "' in " + t.end() / 1000L + " seconds");
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ThemisFileImportSummary loadFromFile(File themisfile, boolean trigger) throws IOException, JDOMException {
        Document doc;
        ArrayList<CmsElementXml> zipElements = new ArrayList<CmsElementXml>();
        HashMap<Long, Long> mapElementIdFromFileToDatabase = new HashMap<Long, Long>();
        Timer t = Timer.start();
        ThemisFileImportSummary result = new ThemisFileImportSummary();
        if (this.ph == null) {
            this.ph = new DefaultProgressHandler();
        }
        if (this.analysedFile == null || !this.analysedFile.getAbsolutePath().equals(themisfile.getAbsolutePath())) {
            this.analyseThemisFile(themisfile);
        }
        if (this.hasError()) {
            result.setError(this.getExceptions().get(0));
            return result;
        }
        int progressCounter = 0;
        this.ph.switchToDeterminate(this.countElements * 3 + 7);
        boolean keepElementIds = false;
        boolean applyProjectSettings = false;
        boolean strictProjectUUID = false;
        boolean eventRequired = this.isEventRequired() || this.countObservation > 0;
        boolean groupUpdateRequired = false;
        boolean isProjectCreated = false;
        if (!this.project.isOpen()) {
            this.ph.progress("Projekt wird vorbereitet...");
            UUID projectUUID = this.projectXml == null ? UUID.randomUUID() : this.projectXml.getUUID();
            File folder = new File(this.app.getApplicationDataTempFolder(), projectUUID.toString());
            this.project.setThemisFileDirectAccess(themisfile);
            this.project.createProject(new ThemisFolder(folder), null);
            this.setAsFullProject();
            applyProjectSettings = true;
            isProjectCreated = true;
            keepElementIds = true;
            strictProjectUUID = false;
        }
        this.ph.progress(++progressCounter);
        int templateItemMaxSort = this.project.getDatastorage().getTemplateItemSortMax();
        boolean templateItemCount = false;
        this.project.getLogger().info("Current max itemsort for templates is " + templateItemMaxSort);
        long maxIdInProject = this.project.getDatastorage().createId("idelement");
        if (this.maxIdInFile >= maxIdInProject) {
            this.project.getDatastorage().setSequenceValue("idelement", this.maxIdInFile + 1L);
        }
        this.app.getProject().getLogger().info("importing from *.themis file '" + themisfile.getAbsolutePath() + "'");
        ZipFile zip = new ZipFile(themisfile, StandardCharsets.UTF_8);
        this.project.clearTempfileLocation();
        this.project.createTempFolderProcess();
        Enumeration<? extends ZipEntry> entries = zip.entries();
        ZipEntry entry = zip.getEntry("version");
        int zipVersion = Util.parseInt((String)ThemisFile.getStringFromZip(zip, entry), (int)1);
        if (zipVersion > 3) {
            zip.close();
            return result.setError("error.zip-version-not-supported");
        }
        this.ph.progress(++progressCounter);
        if (zip.getEntry("template") == null) {
            if (zip.getEntry("archive") != null) {
                this.setAsArchive();
            } else if (zip.getEntry("trash") != null) {
                this.setAsTrash();
            }
        }
        if (this.isProjectTemplate()) {
            keepElementIds = false;
            applyProjectSettings = true;
        } else if (this.isArchive()) {
            keepElementIds = true;
            strictProjectUUID = true;
            applyProjectSettings = false;
        } else if (this.isTrash()) {
            keepElementIds = true;
            strictProjectUUID = true;
            applyProjectSettings = false;
        }
        this.ph.progress(++progressCounter);
        if (this.doReadProject()) {
            entry = zip.getEntry("project.xml");
            if (entry == null) {
                this.app.getProject().getLogger().info("... no project element in ZIP file");
            } else {
                doc = ThemisFile.getXmlDocument(zip, entry);
                CmsElementXml proj = new CmsElementXml(doc.getRootElement(), (CmsApplication)this.project, this.project.getUser());
                if (strictProjectUUID) {
                    if (this.projectXml == null) {
                        return result.setError("archive-with-no-project-element");
                    }
                    if (!this.project.getProjectElement().getUUID().equals(this.projectXml.getUUID())) {
                        return result.setError("archive-project-uuid-mismatch");
                    }
                } else if (isProjectCreated || this.applyProjectAttributes || proj.isModified()) {
                    this.app.getProject().getLogger().info("updating project element");
                    this.project.getProjectElement().update(doc.getRootElement(), zip, null, false);
                    this.project.getProjectElement().storeOriginalMD5();
                    this.project.getProjectElement().save();
                }
            }
        }
        this.ph.progress(++progressCounter);
        if ((this.doReadSettings() || this.doReadElementtype("report")) && (entry = zip.getEntry("settings.xml")) != null && applyProjectSettings) {
            this.app.getProject().getLogger().info("updateing settings from xml");
            String themisServerCode = this.app.getSettings().getThemisServerCode();
            boolean autoExportFullProject = this.app.getSettings().getAutoExportFullProject();
            boolean autoImportFromServer = this.app.getSettings().getAutoImportFromServer();
            Document settingsDoc = ThemisFile.getXmlDocument(zip, entry);
            Element xmlProject = settingsDoc.getRootElement().getChild("project");
            if (this.doReadSettings()) {
                this.app.getSettings().applyProjectSettings(settingsDoc);
                this.app.getSettings().setThemisServerCode(themisServerCode);
                this.app.getSettings().setAutoExportFullProject(autoExportFullProject);
                this.app.getSettings().setAutoImportFromServer(autoImportFromServer);
            }
            if (this.doReadElementtype("report")) {
                Element xmlTables;
                Element xml = xmlProject.getChild("report");
                if (xml == null) {
                    xml = xmlProject.getChild("reportspec");
                    xmlTables = xml == null ? null : xml.getChild("layout");
                    xmlTables = xmlTables == null ? null : xmlTables.getChild("tables");
                } else {
                    xmlTables = xml.getChild("tables");
                }
                if (xmlTables != null) {
                    CmsReport rep = (CmsReport)this.project.createElement("report");
                    List list = xmlTables.getChildren();
                    for (Element table : list) {
                        ReportTableLayout rtl = (ReportTableLayout)this.project.createElement("reporttable");
                        rtl.fromXML(table);
                        if (this.project.hasReportTableLayout(rtl.getName())) continue;
                        rtl.save();
                    }
                    rep.setReportFromXml((Element)xml.detach());
                    rep.setLayoutName(this.project.getNewReportTemplateName("Eigene Protokollvorlage"));
                    rep.save();
                    this.app.getSettings().setLastReportLayoutId(rep.getId());
                }
            }
        }
        this.ph.progress(++progressCounter);
        if (this.doReadKeytables()) {
            HashMap<String, HashMap> keytableMapping = new HashMap<String, HashMap>();
            entry = zip.getEntry("keytables.xml");
            if (entry != null) {
                doc = ThemisFile.getXmlDocument(zip, entry);
                List elements = doc.getRootElement().getChildren();
                for (Element e : elements) {
                    this.app.getProject().getLogger().info("updating keytable '" + e.getAttributeValue("table") + "'");
                    String tbl = e.getAttributeValue("table");
                    Keytable keytable = this.project.getKeytable(tbl);
                    if ("obstype".equalsIgnoreCase(tbl)) {
                        keytable.update(e);
                    } else {
                        keytableMapping.put(tbl, keytable.extend(e));
                    }
                    keytable.save();
                }
            }
        }
        this.ph.progress(++progressCounter);
        CmsEvent activeEvent = this.project.getSelectionManager().getCurrentEvent();
        boolean eventInThemisFile = false;
        CmsEvent importEvent = null;
        if (this.doReadEvent() && (entry = zip.getEntry("event.xml")) != null) {
            doc = ThemisFile.getXmlDocument(zip, entry);
            CmsElementXml eventXml = new CmsElementXml(doc.getRootElement(), (CmsApplication)this.project, this.project.getUser());
            importEvent = (CmsEvent)eventXml.getElement();
            mapElementIdFromFileToDatabase.put(eventXml.getOriginalId(), eventXml.getId());
            if (importEvent == null) {
                return result.setError("error.cannot-create-or-load-event");
            }
            eventInThemisFile = true;
            if (importEvent.isNew()) {
                eventXml.updateElement(zip);
                importEvent.save();
            } else {
                Date dtInProject = importEvent.getDateAttribute("date").getDate();
                String dtInXmlAsString = eventXml.getDataValue("date");
                Date dtInXml = Util.parseDate((String)dtInXmlAsString, (String)Util.DATE_READ, (TimeZone)this.project.getTimeZone(), null);
                if (importEvent.isSigned()) {
                    if (!Dialogs.showConfirmDialog((String)("Das in der *.themis Datei enthaltene Ereignis '" + importEvent.getTitle() + "' ist im Projekt versiegelt und kann nicht erweitert werden. Es wird ein neues Import-Ereignis angelegt."))) {
                        return result;
                    }
                    this.project.getLogger().info("Event found [#" + importEvent.getId() + "], but this event is sealed ... creating a new event for import");
                    importEvent = null;
                } else if (dtInXml == null || !dtInXml.equals(dtInProject)) {
                    if (!Dialogs.showConfirmDialog((String)("Das in der *.themis Datei enthaltene Ereignis '" + importEvent.getTitle() + "' hat im Projekt ein anderes Datum. Es wird ein neues Import-Ereignis angelegt."))) {
                        return result;
                    }
                    this.project.getLogger().info("Event found [#" + importEvent.getId() + "], but this event has a different date ... creating a new event for import");
                    importEvent = null;
                }
            }
        }
        boolean signEventAfterImport = false;
        if (importEvent != null) {
            this.project.getLogger().info("Event found, using [#" + importEvent.getId() + "] " + importEvent.getTitle());
            this.event = importEvent;
        } else if (this.useCurrentEvent && activeEvent != null) {
            this.event = activeEvent;
        } else if (!eventRequired) {
            this.event = null;
        } else {
            this.event = (CmsEvent)this.project.createElement("event");
            this.event.setAttributeValue("title", "Import");
            this.event.getDateAttribute("date").setDate(Util.toDateOnly((Date)new Date()));
            this.project.getLogger().info("No event found, creating [#" + this.event.getId() + "] " + this.event.getTitle());
            this.event.save(true, true);
            signEventAfterImport = true;
        }
        if (this.event != null) {
            this.project.getSelectionManager().setCurrentEvent((CmsEvent)this.event, false, true, this);
        }
        this.ph.progress(++progressCounter);
        ArrayList<String> tableLayoutNames = this.project.getReportTableNames();
        this.app.getProject().getLogger().info("Start reading entries from *.themis file");
        while (entries.hasMoreElements()) {
            Object newLayout;
            ZipEntry nextEntry = entries.nextElement();
            String nextEntryName = nextEntry.getName();
            if (nextEntryName.toLowerCase().endsWith(".layout") && this.doReadElementtype("report")) {
                doc = ThemisFile.getXmlDocument(zip, nextEntry);
                Element layout = (Element)doc.getRootElement().detach();
                newLayout = (ReportTableLayout)this.project.createElement("reporttable");
                if (layout.getChild("tables") != null) {
                    ((ReportTableLayout)((Object)newLayout)).fromXML(layout.getChild("tables").getChild("layout"));
                } else {
                    ((ReportTableLayout)((Object)newLayout)).fromXML(layout);
                }
                if (!tableLayoutNames.contains(((ReportTableLayout)((Object)newLayout)).getName())) {
                    newLayout.save();
                }
            }
            if (!nextEntryName.toLowerCase().endsWith("_element.xml")) continue;
            this.ph.progress(nextEntryName, ++progressCounter);
            doc = ThemisFile.getXmlDocument(zip, nextEntry);
            CmsElementXml xml = new CmsElementXml(doc.getRootElement(), (CmsApplication)this.project, this.project.getUser());
            if (!xml.isValid() || !this.doReadElementtype(xml.getElementCode())) continue;
            if (this.isProjectTemplate()) {
                void var32_50;
                newLayout = xml.getElementCode();
                int n = -1;
                switch (((String)newLayout).hashCode()) {
                    case -1789272086: {
                        if (!((String)newLayout).equals("locationgroup")) break;
                        boolean bl = false;
                        break;
                    }
                    case 133216422: {
                        if (!((String)newLayout).equals("observationtemplate")) break;
                        boolean bl = true;
                        break;
                    }
                    case -1193416913: {
                        if (!((String)newLayout).equals("locationtemplate")) break;
                        int n2 = 2;
                        break;
                    }
                    case 953431000: {
                        if (!((String)newLayout).equals("measuretemplate")) break;
                        int n3 = 3;
                        break;
                    }
                    case -934521548: {
                        if (!((String)newLayout).equals("report")) break;
                        int n4 = 4;
                        break;
                    }
                    case 950484093: {
                        if (!((String)newLayout).equals("company")) break;
                        int n5 = 5;
                        break;
                    }
                    case 3237038: {
                        if (!((String)newLayout).equals("info")) break;
                        int n6 = 6;
                        break;
                    }
                    case 3148996: {
                        if (!((String)newLayout).equals("form")) break;
                        int n7 = 7;
                        break;
                    }
                    case 3226745: {
                        if (!((String)newLayout).equals("icon")) break;
                        int n8 = 8;
                    }
                }
                switch (var32_50) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    default: {
                        xml.createNewUUID();
                    }
                }
            }
            if (!xml.isModified() && xml.isElementUUIDInDatabase() && eventInThemisFile) continue;
            xml.getElement();
            mapElementIdFromFileToDatabase.put(xml.getOriginalId(), xml.getId());
            zipElements.add(xml);
        }
        Collections.sort(zipElements, (xml1, xml2) -> {
            Long id1 = xml1.getOriginalId();
            Long id2 = xml2.getOriginalId();
            return id1.compareTo(id2);
        });
        int countInvalidElements = Math.max(0, this.countElements - zipElements.size());
        float timeLoading = (float)t.getActiveTime() / 1000.0f;
        ThemisApplication.getLogger().info("loading " + zipElements.size() + " entries took " + timeLoading + " seconds");
        progressCounter += countInvalidElements;
        this.ph.progress("Inhalt wird analysiert (" + zipElements.size() + ")...");
        for (CmsElementXml cmsElementXml : zipElements) {
            this.ph.progress(++progressCounter);
            CmsElement ele = cmsElementXml.getElement();
            CmsUser xmlUser = this.project.createUser(cmsElementXml.getUsername());
            String locationEleNumber = null;
            int currentItemplateItemSort = -1;
            int newItemplateItemSort = -1;
            switch (ele.getElementcode()) {
                case "location": {
                    if (ele.isNew() && !this.keepLocationNumbers) break;
                    locationEleNumber = cmsElementXml.getElement().getAttributeValue("number");
                    break;
                }
                case "locationgroup": 
                case "locationtemplate": 
                case "measuretemplate": 
                case "observationtemplate": {
                    currentItemplateItemSort = ele.getIntegerAttribute("itemsort").getIntValue();
                    break;
                }
                case "form": {
                    if (!this.isProjectTemplate()) break;
                    cmsElementXml.setIgnoreAttributeForUpdate("histories");
                }
            }
            cmsElementXml.updateElement(zip);
            mapElementIdFromFileToDatabase.putAll(cmsElementXml.getSubelementIdMapping());
            cmsElementXml.getElement().setCurrentUser(xmlUser);
            switch (ele.getElementcode()) {
                case "observation": {
                    ((CmsObservation)ele).updateUploads(cmsElementXml.getData(), zip);
                    ((CmsObservation)ele).setAttributeValue("editor", cmsElementXml.getUsername());
                    ((CmsObservation)ele).setKeepEditor(true);
                    long idtype = ele.getKeyAttribute("type").getId();
                    boolean debug = true;
                    if (idtype > 0L) break;
                    boolean bl = true;
                    break;
                }
                case "location": {
                    if (locationEleNumber != null) {
                        ele.setAttributeValue("number", locationEleNumber);
                    }
                    if (!ele.isNew() || !((CmsLocation)ele).checkIfNumberExists() || this.keepLocationNumbers) break;
                    ((CmsLocation)ele).createNewNumber();
                    break;
                }
                case "locationgroup": {
                    groupUpdateRequired = true;
                }
                case "locationtemplate": 
                case "observationtemplate": 
                case "measuretemplate": {
                    newItemplateItemSort = ele.getIntegerAttribute("itemsort").getIntValue();
                    if (ele.isNew()) {
                        ele.getIntegerAttribute("itemsort").setValue(newItemplateItemSort + templateItemMaxSort);
                        this.project.getLogger().info("template update item sort for '" + ele.getTitle() + "' to " + (newItemplateItemSort + templateItemMaxSort));
                        break;
                    }
                    this.project.getLogger().info("template keeping item sort for '" + ele.getTitle() + "' at " + currentItemplateItemSort);
                    break;
                }
                case "filter": {
                    if (this.isArchive() || this.isTrash() || !ele.isNew()) {
                        cmsElementXml.setIgnored();
                        break;
                    }
                    String filtername = cmsElementXml.getTitle();
                    if (this.project.getFilterByName(filtername) == null) break;
                    cmsElementXml.setIgnored();
                }
            }
            result.addElement(cmsElementXml.getElementCode(), cmsElementXml.getId());
            cmsElementXml.saveElementWithoutRelations();
        }
        float timeAnalysing = (float)t.getActiveTime() / 1000.0f - timeLoading;
        ThemisApplication.getLogger().info("analysing " + zipElements.size() + " entries took " + timeAnalysing + " seconds");
        progressCounter += countInvalidElements;
        this.ph.progress("Daten werden gespeichert...");
        for (CmsElementXml xml : zipElements) {
            this.ph.progress(++progressCounter);
            if (xml.isIgnored()) continue;
            xml.applyIdMapping(mapElementIdFromFileToDatabase);
            xml.getElement().save();
        }
        if (groupUpdateRequired) {
            this.project.getTemplateManger().updateLocationGroupFullIds();
        }
        if (this.event != null) {
            this.event.reload();
        }
        if (signEventAfterImport && this.event != null) {
            ((CmsEvent)this.event).sign(null);
        }
        if (activeEvent != null) {
            this.project.getSelectionManager().setCurrentEvent(activeEvent, false, true, this);
        } else if (this.event != null) {
            this.project.getSelectionManager().clearCurrentEvent();
        }
        zip.close();
        float f = (float)t.getActiveTime() / 1000.0f - timeLoading - timeAnalysing;
        ThemisApplication.getLogger().info("saving " + zipElements.size() + " entries took " + f + " seconds");
        ThemisApplication.getLogger().info("loaded *.themis file '" + themisfile.getName() + "' in " + t.end() / 1000L + " seconds");
        return result;
    }

    public static Properties getPropertiesFromZip(ZipFile zip, ZipEntry entry) throws IOException {
        InputStream inputStream = zip.getInputStream(entry);
        Properties props = new Properties();
        props.load(inputStream);
        Util.closeStream((Closeable)inputStream);
        return props;
    }

    public static Document getXmlDocument(ZipFile zip, ZipEntry entry) throws IOException, JDOMException {
        InputStream inputStream = zip.getInputStream(entry);
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(inputStream);
        Util.closeStream((Closeable)inputStream);
        return doc;
    }

    public static String getStringFromZip(ZipFile zip, ZipEntry entry) throws IOException {
        if (entry == null) {
            return null;
        }
        InputStream is = zip.getInputStream(entry);
        if (is == null) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        byte[] buffer = new byte[1024];
        int read = 0;
        while ((read = is.read(buffer, 0, 1024)) >= 0) {
            s.append(new String(buffer, 0, read));
        }
        Util.closeStream((Closeable)is);
        return s.toString();
    }

    public static String createFilename() {
        ThemisProject p = ThemisApplication.getInstance().getProject();
        if (p.isOpen()) {
            return p.getProjectFolder().getName() + "_" + Util.formatDate((Date)new Date(), (String)Util.DATE_FILE, (TimeZone)p.getTimeZone()) + ".themis";
        }
        return Util.formatDate((Date)new Date(), (String)Util.DATE_FILE, (TimeZone)p.getTimeZone()) + ".themis";
    }

    public static void exportProject(File folder, Date fromdate, ProgressHandler ph) {
        ThemisProject project = ThemisApplication.getInstance().getProject();
        if (!project.isOpen()) {
            return;
        }
        File fld = new File(folder, project.getThemisFile().getFolderName());
        fld.mkdirs();
        ph.progress("Hole Ereignisse ...");
        ArrayList recs = project.getEventSearchResult(fromdate, null).getResultAsBasicElements();
        int countSteps = 0;
        ph.switchToDeterminate(recs.size() + 3);
        ph.progress("Speichere Pl\u00e4ne ...", ++countSteps);
        ThemisFile tf = ProjectExport.getPlansThemisFile(project);
        try {
            tf.saveToFile(new File(fld, "plans.themis"), true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (ph.isCancelled()) {
            return;
        }
        ph.progress("Speichere Vorlagen ...", ++countSteps);
        tf = ProjectExport.getTemplatesThemisFile(project);
        try {
            tf.saveToFile(new File(fld, "templates.themis"), true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (ph.isCancelled()) {
            return;
        }
        ph.progress("Speichere Projekt Ausgangsdaten ...", ++countSteps);
        tf = ProjectExport.getContentThemisFile(project);
        try {
            tf.saveToFile(new File(fld, "project_" + Util.formatDate((Date)fromdate, (String)Util.DATE_ISO, (TimeZone)TimeZone.getDefault()) + ".themis"), true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (ph.isCancelled()) {
            return;
        }
        for (CmsBasicElement be : recs) {
            CmsEvent ev = (CmsEvent)project.loadElement(be.getId(), project.getUser());
            ph.progress("Speichere Ereignis '" + ev.getTitle() + "' ...", ++countSteps);
            tf = ProjectExport.getEventThemisFile(project, ev);
            Date eventdate = ev.getEventDate();
            String eventtitle = ev.getEventTitle();
            try {
                String eventDate = Util.formatDate((Date)eventdate, (String)Util.DATE_ISO, (TimeZone)TimeZone.getDefault());
                int counter = 0;
                File f = null;
                while (f == null) {
                    f = new File(fld, "event_" + eventDate + (counter > 0 ? "_" + counter : "") + ".themis");
                    if (!f.exists()) continue;
                    ++counter;
                    f = null;
                }
                tf.saveToFile(f, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!ph.isCancelled()) continue;
            return;
        }
    }

    public static ThemisFile getPlansThemisFile(ThemisProject project) {
        if (!project.isOpen()) {
            return null;
        }
        ThemisFile tf = new ThemisFile();
        ArrayList<CmsElementSummary> buildings = project.getBuildings();
        for (CmsElementSummary ele : buildings) {
            tf.addContent(ele.getId());
        }
        ArrayList<CmsElementSummary> plans = project.getPlans();
        for (CmsElementSummary ele : plans) {
            tf.addPlan(ele.getId());
        }
        return tf;
    }

    public static ThemisFile getContentThemisFile(ThemisProject project) {
        if (!project.isOpen()) {
            return null;
        }
        ThemisFile tf = new ThemisFile();
        tf.setWithAllImages();
        ThemisFilter filter = ThemisApplication.getInstance().getFilter().getCopy();
        filter.setTriggerEnabled(false);
        filter.clearAll(false, null);
        tf.addContent(filter.getFilteredElementIds());
        return tf;
    }

    public static ThemisFile getEventThemisFile(ThemisProject project, CmsEvent ev) {
        if (!project.isOpen()) {
            return null;
        }
        ThemisFile tf = new ThemisFile();
        tf.setWithRelevantImages();
        tf.setEvent(ev);
        tf.setContentType(ContentType.EVENT);
        return tf;
    }

    public static ThemisFile getTemplatesThemisFile(ThemisProject project) {
        if (!project.isOpen()) {
            return null;
        }
        return new ThemisFile().setContentType(ContentType.TEMPLATE);
    }

    public static void importProject(File sourceFolder, File targetFolder, String filename) {
        String result;
        DefaultProgressHandler ph = new DefaultProgressHandler();
        ThemisFolder projectfolder = new ThemisFolder(new File(targetFolder, filename));
        if (ThemisApplication.getInstance().getProject().isOpen()) {
            ThemisApplication.getInstance().getProject().close(new Closing(), (ProgressHandler)ph);
        }
        if ((result = ThemisApplication.getInstance().getProject().createProject(projectfolder, (ProgressHandler)ph)) != null) {
            ThemisApplication.getInstance().getDialog().showErrorDialog(result);
            return;
        }
        ThemisFile.importProject(sourceFolder, (ProgressHandler)ph);
    }

    public static void importProject(File sourceFolder, ProgressHandler ph) {
        Object object;
        ThemisFile tf;
        File projectFile = null;
        Date projectDate = null;
        ArrayList<File> eventFiles = new ArrayList<File>();
        for (File file : sourceFolder.listFiles()) {
            String fn = file.getName();
            if (fn.startsWith("project_")) {
                projectFile = file;
                String dateString = fn.substring(8, fn.length() - 7);
                projectDate = Util.parseDate((String)dateString, (String)Util.DATE_ISO, (TimeZone)TimeZone.getDefault(), null);
                continue;
            }
            if (!file.getName().startsWith("event_")) continue;
            eventFiles.add(file);
        }
        if (ph.isCancelled()) {
            return;
        }
        int totalCount = eventFiles.size() + 3;
        int counter = 0;
        if (projectDate != null) {
            CmsEvent ev = (CmsEvent)ThemisApplication.getInstance().getProject().createElement("event");
            ev.setAttributeValue("title", "\u00dcbernahme");
            ev.getDateAttribute("date").setDate(Util.toDateOnly((Date)projectDate));
            ThemisApplication.getLogger().info("Creating event [#" + ev.getId() + "] " + ev.getTitle());
            ev.save();
            ThemisApplication.getInstance().getProject().getSelectionManager().setCurrentEvent(ev, false, null);
        }
        if (ph.isCancelled()) {
            return;
        }
        ph.progress("Lade Vorlagen ..." + " (" + ++counter + "/" + totalCount + ")");
        File templateFile = new File(sourceFolder, "templates.themis");
        if (templateFile.isFile()) {
            tf = new ThemisFile(ph).setContentType(ContentType.TEMPLATE);
            try {
                ThemisFileImportSummary themisFileImportSummary = tf.loadFromFile(templateFile, true);
            }
            catch (IOException | JDOMException throwable) {
                // empty catch block
            }
        }
        if (ph.isCancelled()) {
            return;
        }
        ph.progress("Lade Pl\u00e4ne ..." + " (" + ++counter + "/" + totalCount + ")");
        File file = new File(sourceFolder, "plans.themis");
        if (file.isFile()) {
            tf = new ThemisFile(ph).setContentType(ContentType.CONTENT);
            tf.setUseCurrentEvent();
            try {
                object = tf.loadFromFile(file, true);
            }
            catch (IOException | JDOMException throwable) {
                // empty catch block
            }
        }
        if (ph.isCancelled()) {
            return;
        }
        ph.progress("Lade Projekt ..." + " (" + ++counter + "/" + totalCount + ")");
        if (projectFile != null) {
            tf = new ThemisFile(ph).setContentType(ContentType.CONTENT);
            tf.setApplyProjectUUID();
            tf.setApplyProjectAttributes();
            tf.setUseCurrentEvent();
            try {
                object = tf.loadFromFile(projectFile, true);
            }
            catch (IOException | JDOMException throwable) {
                // empty catch block
            }
        }
        if (ph.isCancelled()) {
            return;
        }
        for (File f : eventFiles) {
            ph.progress("Lade Ereignis '" + f.getName() + "' ..." + " (" + ++counter + "/" + totalCount + ")");
            tf = new ThemisFile(ph).setContentType(ContentType.EVENT);
            try {
                ThemisFileImportSummary themisFileImportSummary = tf.loadFromFile(f, true);
            }
            catch (IOException | JDOMException throwable) {
                // empty catch block
            }
            if (!ph.isCancelled()) continue;
            return;
        }
    }

    public static enum ContentType {
        TEMPLATE,
        ARCHIVE,
        TRASH,
        PROJECT,
        CONTENT,
        EVENT,
        PLANNEDEVENT,
        FILTER,
        REPORTTEMPLATE,
        FORM,
        SPECIFIC;

    }
}

