/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology;

import at.grid.cms.attribute.UploadAttribute;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public abstract class ThemisFileOutputter {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    protected ArrayList<String> errors = new ArrayList();
    protected ArrayList<String> entries = new ArrayList();

    public ArrayList<String> getErrors() {
        return this.errors;
    }

    public ArrayList<String> getEntries() {
        return this.entries;
    }

    public String writeKeytables() {
        Element keytablesElement = new Element("keytables");
        List keytableNames = this.project.getKeytableNames();
        for (String keytablename : keytableNames) {
            keytablesElement.addContent((Content)this.project.getKeytable(keytablename).toXMLElement());
        }
        String xml = Util.toXml((Element)keytablesElement);
        this.write("keytables.xml", xml);
        return Util.md5((String)xml);
    }

    public void writeProject() {
        UploadItem projectLogo;
        this.write("project.xml", this.project.getProjectElement().toXML());
        UploadItem projectImage = this.project.getProjectElement().getUploadAttribute("projectimage").getFirstUploadItem();
        if (projectImage != null) {
            this.write(projectImage.getFile().getName(), projectImage.getFile(), "project");
        }
        if ((projectLogo = this.project.getProjectElement().getUploadAttribute("projectlogo").getFirstUploadItem()) != null) {
            this.write(projectLogo.getFile().getName(), projectLogo.getFile(), "project");
        }
    }

    public String writeSettings() {
        String s1 = this.project.getProjectPropertiesAsString();
        this.write("settings.properties", s1);
        Document doc = this.app.getSettings().getSettingsAsCopy();
        if (doc.getRootElement().getChild("project") != null && doc.getRootElement().getChild("project").getChild("server") != null) {
            doc.getRootElement().getChild("project").removeChild("server");
        }
        doc.getRootElement().getChild("project").removeChild("report");
        doc.getRootElement().getChild("project").removeChild("reportspec");
        this.write("settings.xml", Util.toXml((Document)doc));
        return this.app.getSettings().getProjectSettingsMD5();
    }

    public ArrayList<String> writeElements(ArrayList<Long> ids, boolean withUpload, ProgressHandler ph, int counter) {
        ArrayList<String> md5s = new ArrayList<String>();
        for (long id : ids) {
            if (ph != null) {
                ph.progress(counter);
                ++counter;
            }
            CmsElement ele = this.project.loadElement(id, this.project.getUser());
            md5s.add(ele.getMD5());
            this.write(ele, withUpload, false, null);
            if (!ph.isCancelled()) continue;
            return md5s;
        }
        return md5s;
    }

    public String write(CmsElement ele, boolean withUpload, CmsEvent ev) {
        this.write(ele, withUpload, false, ev);
        return ele.getMD5();
    }

    public String write(CmsElement ele, boolean withUpload, boolean withImages, CmsEvent ev) {
        boolean modified;
        if (ele == null) {
            return null;
        }
        boolean resetUploadAttributeVirtual = false;
        boolean bl = modified = ev != null && ev.isModifiedWithinEvent(ele.getId());
        if (ele instanceof CmsObservation && !modified) {
            modified = ((CmsObservation)ele).isControlledInEvent(ev == null ? -1L : ev.getId());
        }
        if (withImages && (this.app.getSettings().getImageForObservation() && "observation".equals(ele.getElementcode()) || this.app.getSettings().getImageForLocation() && "location".equals(ele.getElementcode()))) {
            ele.getAttribute("files").setVirtual(false);
            resetUploadAttributeVirtual = true;
            ArrayList<Object> uploads = ele instanceof CmsObservation ? ((CmsObservation)ele).getUploads(false) : (ele instanceof CmsLocation ? ((CmsLocation)ele).getUploads() : new ArrayList());
            for (UploadItem item : uploads) {
                if (item.getFile().isFile()) {
                    this.write(item.getFile().getName(), item.getFile(), ele.getElementcode());
                    if (ele.getUploadAttribute("files").getUploadItemById(item.getId()) != null) continue;
                    ele.getUploadAttribute("files").addUpload(item);
                    continue;
                }
                this.errors.add(this.project.getResourceText("error.zip.file-not-found") + ": " + item.getFile().getAbsolutePath());
            }
        }
        Element xmlElement = ele.toJDOMElement();
        if (modified) {
            xmlElement.setAttribute("modified", "true");
        }
        this.write(ele.getElementcode() + "_" + ele.getId() + "_element.xml", Util.toXml((Element)xmlElement));
        if ("observation".equals(ele.getElementcode()) || "location".equals(ele.getElementcode())) {
            ele.getAttribute("files").setVirtual(true);
        }
        if (withUpload) {
            for (UploadAttribute att : ele.getUploadAttributes()) {
                if (att.isVirtual()) continue;
                for (UploadItem item : att.getUploadItems()) {
                    if (item.getFile().isFile()) {
                        this.write(item.getFile().getName(), item.getFile(), ele.getElementcode());
                        continue;
                    }
                    this.errors.add(this.project.getResourceText("error.zip.file-not-found") + ": " + item.getFile().getAbsolutePath());
                }
            }
            for (UploadAttribute att : ele.getRelationAttributes()) {
                if (!att.isSubelement()) continue;
                for (CmsElement ele2 : att.getFullElements()) {
                    for (UploadAttribute att2 : ele2.getUploadAttributes()) {
                        for (UploadItem item2 : att2.getUploadItems()) {
                            if (item2.getFile().isFile()) {
                                this.write(item2.getFile().getName(), item2.getFile(), ele2.getElementcode());
                                continue;
                            }
                            this.errors.add(this.project.getResourceText("error.zip.file-not-found") + ": " + item2.getFile().getAbsolutePath());
                        }
                    }
                }
            }
        }
        return ele.getMD5();
    }

    public abstract void close();

    public abstract void cancel();

    public abstract void write(String var1, String var2);

    public abstract void write(String var1, File var2, String var3);
}

