/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology;

import at.grid.themis.ontology.ThemisFileOutputter;
import at.grid.themis.ontology.ThemisProject;
import at.grid.util.Util;
import at.grid.webdav.NextCloudWebDAV;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ThemisFileServerOutputter
extends ThemisFileOutputter {
    FileOutputStream fOut;
    ZipOutputStream out;
    NextCloudWebDAV webdav;
    File themisfile;
    String webdavProjectfolder;
    ArrayList<String> filesOnServer = new ArrayList();

    public ThemisFileServerOutputter(NextCloudWebDAV webdav, String filename) throws FileNotFoundException {
        this.webdav = webdav;
        this.webdavProjectfolder = "projects/" + this.project.getProjectElement().getUUIDasString();
        this.themisfile = new File(this.app.getApplicationDataTempFolder(), filename);
        if (this.themisfile.exists()) {
            this.themisfile.delete();
        }
        this.themisfile.getAbsoluteFile().getParentFile().mkdirs();
        this.fOut = new FileOutputStream(this.themisfile);
        this.out = new ZipOutputStream(this.fOut);
        for (String elementtype : new String[]{"history", "location", "planfile", "info"}) {
            try {
                ArrayList filenames = webdav.getFilenames(this.webdavProjectfolder + "/data/" + elementtype);
                this.filesOnServer.addAll(filenames);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void cancel() {
        Util.closeStream((Closeable)this.out);
        Util.closeStream((Closeable)this.fOut);
        if (this.themisfile.exists()) {
            this.themisfile.delete();
        }
    }

    @Override
    public void close() {
        Util.closeStream((Closeable)this.out);
        Util.closeStream((Closeable)this.fOut);
        if (this.webdav != null) {
            try {
                this.webdav.putFile(this.webdavProjectfolder, this.themisfile);
            }
            catch (IOException ex) {
                this.project.getLogger().severe("Cannot write to WEBDAV: " + ex.getMessage());
            }
        }
    }

    @Override
    public void write(String title, String content) {
        try {
            if (this.entries.contains(title)) {
                return;
            }
            ZipEntry e = new ZipEntry(title);
            this.entries.add(title);
            this.out.putNextEntry(e);
            byte[] data = content.getBytes(StandardCharsets.UTF_8);
            this.out.write(data, 0, data.length);
            this.out.closeEntry();
        }
        catch (IOException ex) {
            Logger.getLogger(ThemisProject.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void write(String title, File f, String elementtype) {
        try {
            if (!this.filesOnServer.contains(f.getName())) {
                this.webdav.putFile(this.webdavProjectfolder + "/data/" + elementtype, f);
            }
        }
        catch (IOException ex) {
            this.project.getLogger().severe("Cannot write to WEBDAV: " + ex.getMessage());
        }
    }
}

