/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology;

import at.grid.themis.ontology.ThemisFileOutputter;
import at.grid.themis.ontology.ThemisProject;
import at.grid.util.Util;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ThemisFileZipOutputter
extends ThemisFileOutputter {
    FileOutputStream fOut;
    ZipOutputStream out;
    File themisfile;

    public ThemisFileZipOutputter(File f) throws FileNotFoundException {
        this.themisfile = f;
        if (this.themisfile.exists()) {
            this.themisfile.delete();
        }
        this.themisfile.getAbsoluteFile().getParentFile().mkdirs();
        this.fOut = new FileOutputStream(this.themisfile);
        this.out = new ZipOutputStream(this.fOut);
    }

    @Override
    public void close() {
        Util.closeStream((Closeable)this.out);
        Util.closeStream((Closeable)this.fOut);
    }

    @Override
    public void cancel() {
        this.close();
        if (this.themisfile != null) {
            this.themisfile.delete();
        }
    }

    @Override
    public void write(String title, String content) {
        try {
            if (this.entries.contains(title)) {
                return;
            }
            ZipEntry e = new ZipEntry(title);
            this.entries.add(title);
            this.out.putNextEntry(e);
            byte[] data = content.getBytes(StandardCharsets.UTF_8);
            this.out.write(data, 0, data.length);
            this.out.closeEntry();
        }
        catch (IOException ex) {
            Logger.getLogger(ThemisProject.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void write(String title, File f, String elementtype) {
        if (this.entries.contains(title)) {
            return;
        }
        if (!f.isFile()) {
            this.project.getLogger().severe("Cannot create ZIP entry for file '" + f.getAbsolutePath() + "', file not found");
            return;
        }
        FileInputStream fis = null;
        try {
            int length;
            fis = new FileInputStream(f);
            this.entries.add(title);
            ZipEntry zipEntry = new ZipEntry(title);
            this.out.putNextEntry(zipEntry);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                this.out.write(bytes, 0, length);
            }
            this.out.closeEntry();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ThemisProject.class.getName()).log(Level.SEVERE, null, ex);
            Util.closeStream((Closeable)fis);
        }
        catch (IOException ex2) {
            Logger.getLogger(ThemisProject.class.getName()).log(Level.SEVERE, null, ex2);
            {
                catch (Throwable throwable) {
                    Util.closeStream(fis);
                    throw throwable;
                }
            }
            Util.closeStream((Closeable)fis);
        }
        Util.closeStream((Closeable)fis);
    }
}

