/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisLock;
import at.grid.themis.ontology.ThemisLogger;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class ThemisFolder
implements Comparable<ThemisFolder> {
    private String title;
    private File projectfolder;
    private boolean project;
    private Properties props = null;
    private boolean showTitleWithDate = false;
    private String uuidString = null;

    public void setUUID(String uuid) {
        this.uuidString = uuid;
    }

    public ThemisFolder(File f) {
        this.projectfolder = f;
        this.title = f.getName();
        this.project = ThemisProject.isProjectFolder(f);
    }

    public ThemisFolder(File f, String title, String uuid) {
        this.projectfolder = f;
        this.title = title;
        this.project = uuid != null;
        this.uuidString = uuid;
    }

    public ThemisFolder(File f, String title) {
        this.projectfolder = f;
        this.title = title;
        this.project = ThemisProject.isProjectFolder(f);
    }

    public ThemisFolder(File f, String title, boolean isProject) {
        this.projectfolder = f;
        this.title = title;
        this.project = isProject;
    }

    public static ThemisFolder fromLockFile(File f) {
        ThemisLock lock = new ThemisLock(f);
        return new ThemisFolder(lock.getProjectFolder());
    }

    public static ThemisFolder fromLocalProject(File f) {
        ThemisLock lock = new ThemisLock(f);
        if (lock.isValid()) {
            String title = f.getName();
            title = title.substring(0, title.lastIndexOf("_"));
            ThemisFolder tf = new ThemisFolder(lock.getProjectFolder(), title, true);
            String fn = f.getName();
            if (!fn.toLowerCase().endsWith("_null")) {
                tf.uuidString = fn.substring(fn.length() - 36);
            }
            return tf;
        }
        ThemisApplication.getInstance().getProject().getFileAccess().delete(f);
        return null;
    }

    public boolean isLocal() {
        File fld = this.getLocalProjectFolder();
        return fld.isDirectory();
    }

    public boolean isOnNetwork() {
        return ThemisUtil.isOnNetworkDrive(this.getProjectFolder());
    }

    public ThemisFolder withDateInTitle() {
        this.showTitleWithDate = true;
        return this;
    }

    public boolean isProject() {
        return this.project;
    }

    public boolean isThemisFile() {
        return this.projectfolder.isFile() && this.projectfolder.getName().toLowerCase().endsWith(".themis");
    }

    public File getProjectFolder() {
        return this.projectfolder;
    }

    public File getLocalProjectFolder() {
        return new File(ThemisApplication.getInstance().getApplicationDataLocalProjectsFolder(), this.getFolderName() + "_" + this.getUUID());
    }

    public File getLocalDataFolder() {
        return new File(this.getLocalProjectFolder(), "data");
    }

    public File getProjectDataFolder() {
        return new File(this.getProjectFolder(), "data");
    }

    public File getLocalTempFolder() {
        return new File(this.getLocalProjectFolder(), "temp");
    }

    public File getProjectTempFolder() {
        return new File(this.getProjectFolder(), "temp");
    }

    public String getFolderName() {
        return this.projectfolder.getName();
    }

    public ThemisLock getProjectLock() {
        return new ThemisLock(new File(this.getDatabaseFile().getParentFile(), "themis.lock"), this);
    }

    public ThemisLock getLocalLock() {
        return new ThemisLock(new File(this.getLocalDatabaseFile().getParentFile(), "themis.lock"), this);
    }

    public File getDatabaseFile() {
        return new File(this.getProjectFolder(), "db/themis.h2.db");
    }

    public File getLocalDatabaseFile() {
        new File(this.getLocalProjectFolder(), "db").mkdirs();
        return new File(this.getLocalProjectFolder(), "db/themis.h2.db");
    }

    public File getDatabaseBackupFolder() {
        return new File(this.getProjectFolder(), "dbbackup");
    }

    public ArrayList<File> getDatabaseBackupFileList() {
        File folder = this.getDatabaseBackupFolder();
        folder.mkdirs();
        File[] listFiles = folder.listFiles();
        ArrayList<File> files = new ArrayList<File>();
        if (listFiles != null) {
            for (File f : listFiles) {
                if (!f.getName().endsWith("themis.h2.db") && !f.getName().endsWith("themis.h2.zip") && !f.getName().endsWith("themis.h2.bak")) continue;
                files.add(f);
            }
        }
        Collections.sort(files);
        return files;
    }

    public void deleteProjectLock() {
        this.deleteLockFile(this.getProjectLock().getLockFile());
    }

    public void deleteLocalLock() {
        this.deleteLockFile(this.getLocalLock().getLockFile());
    }

    private void deleteLockFile(File f) {
        try {
            ThemisApplication.getInstance().getProject().getFileAccess().delete(f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (f.exists()) {
            try {
                Thread.sleep(100L);
                ThemisApplication.getInstance().getProject().getFileAccess().delete(f);
            }
            catch (Exception e) {
                ThemisLogger.logger.warning("Could not delete lock file '" + f.getAbsolutePath() + "'");
            }
        }
    }

    public void deleteLocal() {
        ThemisApplication.getInstance().getProject().getFileAccess().delete(this.getLocalProjectFolder());
    }

    @Deprecated
    public String loadTitle() {
        return this.getProjectTitle();
    }

    public String getProjectTitle() {
        if (this.isThemisFile()) {
            return "";
        }
        this.loadProperties();
        String t = this.props.getProperty("project.title", this.projectfolder.getName());
        if ("".equals(t)) {
            t = this.projectfolder.getName();
        }
        return t;
    }

    public String getProjectImageName() {
        this.loadProperties();
        return this.props == null ? null : this.props.getProperty("project.image");
    }

    public File getProjectImageFile() {
        File dataFolder = new File(this.projectfolder, "data");
        return new File(dataFolder, this.getProjectImageName());
    }

    public String getUUID() {
        if (this.uuidString == null) {
            this.loadProperties();
            this.uuidString = this.props.getProperty("project.uuid", null);
        }
        return this.uuidString;
    }

    public Properties getStatistics() {
        File propsfile = new File(this.projectfolder, "statistics.properties");
        Properties p = new Properties();
        if (propsfile.isFile()) {
            try (FileReader reader = new FileReader(propsfile);){
                p.load(reader);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(ThemisFolder.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(ThemisFolder.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return p;
    }

    public Properties loadProperties() {
        if (this.props != null && !this.props.isEmpty()) {
            return this.props;
        }
        File propsfile = new File(this.projectfolder, "statistics.properties");
        this.props = new Properties();
        if (propsfile.isFile()) {
            try (FileReader reader = new FileReader(propsfile);){
                this.props.load(reader);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(ThemisFolder.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(ThemisFolder.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.props;
    }

    public Properties getProperties() {
        return this.props;
    }

    public void logStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append("THEMIS project status:").append("\nProject folder: " + this.getProjectFolder().getAbsolutePath()).append(this.isProject() ? "" : " (NOT A PROJECT)").append("\nProject folder: " + this.getProjectFolder().getAbsolutePath());
    }

    public File getServerConfigFile() {
        return new File(this.getDatabaseFile().getParentFile(), "server.properties");
    }

    public Properties getServerConfig() {
        File f = this.getServerConfigFile();
        if (!f.isFile()) {
            return null;
        }
        try {
            Properties p = new Properties();
            p.load(new FileReader(this.getServerConfigFile()));
            return p;
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public boolean isServerAccess() {
        return this.getServerConfigFile().isFile();
    }

    public File getServerDatabaseFile() {
        new File(this.getLocalProjectFolder(), "db").mkdirs();
        return new File(this.getLocalProjectFolder(), "db/themisserver.h2.db");
    }

    public void createServerConfig(String host, String port, String pathToProject) {
        try {
            Properties p = new Properties();
            p.setProperty("host", host);
            p.setProperty("port", port);
            p.setProperty("path", pathToProject);
            FileWriter fw = new FileWriter(this.getServerConfigFile());
            p.store(fw, port);
            fw.close();
            File dbfile = this.getDatabaseFile();
            File dbfileServer = new File(dbfile.getParentFile(), "themisserver.h2.db");
            dbfile.renameTo(dbfileServer);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void deleteServerConfig() {
        if (!this.getServerConfigFile().isFile()) {
            return;
        }
        File dbfile = this.getDatabaseFile();
        File dbfileServer = new File(dbfile.getParentFile(), "themisserver.h2.db");
        boolean success = dbfileServer.renameTo(dbfile);
        if (success) {
            this.getServerConfigFile().delete();
        }
    }

    public String toString() {
        String t = this.title;
        if (this.isServerAccess()) {
            t = t + " [S]";
        }
        if (this.showTitleWithDate) {
            String dt = "";
            ThemisLock localLock = this.getLocalLock();
            if (localLock != null) {
                dt = Util.formatDate((Date)localLock.getLockTime(), (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone());
            }
            return t + " [" + dt + "]";
        }
        return t;
    }

    @Override
    public int compareTo(ThemisFolder o) {
        return this.projectfolder.compareTo(o.projectfolder);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ThemisFolder tf = (ThemisFolder)o;
        if (this.projectfolder == tf.projectfolder) {
            return true;
        }
        if (this.projectfolder == null || tf.projectfolder == null) {
            return false;
        }
        return this.projectfolder.getAbsolutePath().equals(tf.projectfolder.getAbsolutePath());
    }

    public boolean isEmpty() {
        return this.projectfolder == null || this.projectfolder.isDirectory() && this.projectfolder.list().length == 0;
    }

    public static enum Column {
        SELECT("Auswahl", 20),
        TITLE("Projekttitel", 300),
        FILENAME("Dateiname", 300),
        LASTACCESS("Letzter Zugriff", 120),
        LASTUSER("Anwender", 80),
        DEFECTS("Offen", 80),
        NEXTDATE("Termin", 120);

        String title;
        int width;

        private Column(String c, int w) {
            this.title = c;
            this.width = w;
        }

        public int getWidth() {
            return this.width;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

