/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.util.Util;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import org.openide.util.Exceptions;

public class ThemisLock {
    private Properties props = null;
    private ThemisFolder themisfile = null;
    private File file = null;

    public ThemisLock(File f, ThemisFolder tf) {
        this.file = f;
        this.themisfile = tf;
        this.loadProperties(f);
    }

    public ThemisLock(ThemisFolder f) {
        this.themisfile = f;
        this.loadProperties(new File(f.getProjectFolder(), "db/themis.lock"));
    }

    public ThemisLock(File f) {
        this.themisfile = null;
        this.loadProperties(new File(f, "db/themis.lock"));
    }

    public File getLockFile() {
        return this.file;
    }

    public void create() {
        if (this.file == null && this.themisfile != null) {
            this.file = new File(this.themisfile.getProjectFolder(), "db/themis.lock");
        }
        if (this.file != null) {
            ThemisApplication.getInstance().getProject().getFileAccess().mkdirs(this.file.getParentFile());
            OutputStream os = null;
            try {
                os = new FileOutputStream(this.file);
                this.props = new Properties();
                this.props.setProperty("user", System.getProperty("user.name", "admin"));
                this.props.setProperty("locktime", Util.formatDate((Date)Calendar.getInstance().getTime(), (String)Util.DATETIME_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone()));
                this.props.setProperty("computer", ThemisApplication.getInstance().getLicense().getHostname());
                this.props.setProperty("source", this.themisfile.getProjectFolder().getAbsolutePath());
                this.props.store(os, null);
                Util.closeStream((Closeable)os);
            }
            catch (FileNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                try {
                    os.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            File fParent = this.file.getParentFile();
            this.file.setReadable(fParent.canRead());
            this.file.setWritable(fParent.canWrite());
            this.file.setExecutable(fParent.canExecute());
        }
    }

    public boolean isValid() {
        return this.props != null;
    }

    public boolean isInUse() {
        return this.isLocked() && !this.isUsedOnSameComputerAndUser();
    }

    public boolean isLocked() {
        return this.file != null && this.file.isFile() && this.props != null;
    }

    public boolean isUsedOnSameComputerAndUser() {
        String u = this.getUserName();
        String c = this.getUserComputer();
        boolean sameUserAndComputer = u != null && u.equals(System.getProperty("user.name", "admin")) && c != null && c.equals(ThemisApplication.getInstance().getLicense().getHostname());
        return sameUserAndComputer;
    }

    public void deleteLockFile() {
        if (this.file != null) {
            ThemisApplication.getInstance().getProject().getFileAccess().delete(this.file);
        }
    }

    public String getUserName() {
        return this.props == null ? null : this.props.getProperty("user", "(unknown)");
    }

    public String getUserComputer() {
        return this.props == null ? null : this.props.getProperty("computer", "(unknown)");
    }

    public File getProjectFolder() {
        String fn = this.props == null ? null : this.props.getProperty("source");
        return fn == null ? null : new File(fn);
    }

    public Date getLockTime() {
        String dt = this.props == null ? null : this.props.getProperty("locktime");
        try {
            return dt == null ? null : Util.parseDate((String)dt, (String)Util.DATETIME_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone());
        }
        catch (ParseException ex) {
            ThemisApplication.getInstance().getProject().getLogger().severe(ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    public String getLockTimeAsString() {
        return this.props == null ? "<unbekannt>" : this.props.getProperty("locktime", "<unbekannt>");
    }

    public String toString() {
        if (this.isLocked()) {
            return MessageFormat.format(ThemisApplication.getInstance().getProject().getResourceText("error.project-locked"), this.getUserName(), this.getLockTimeAsString(), this.getUserComputer());
        }
        return ThemisApplication.getInstance().getProject().getResourceText("info.project-not-locked");
    }

    private void loadProperties(File f) {
        this.file = f;
        if (f.isFile()) {
            this.props = new Properties();
            try (FileReader reader = new FileReader(f);){
                this.props.load(reader);
                reader.close();
            }
            catch (FileNotFoundException ex) {
                ThemisApplication.getInstance().getProject().getLogger().severe(ex.getMessage());
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ThemisApplication.getInstance().getProject().getLogger().severe(ex.getMessage());
                ex.printStackTrace();
            }
        } else {
            this.props = null;
        }
    }
}

