/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.content.ElementCache;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.element.CmsGroup;
import at.grid.cms.element.CmsUser;
import at.grid.cms.search.CmsBasicSearch;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.storage.SearchResult;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.cms.util.Pair;
import at.grid.gui.ImagePanel;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.ontology.Closing;
import at.grid.themis.ontology.PlanManager;
import at.grid.themis.ontology.SelectionManager;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFile;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisLock;
import at.grid.themis.ontology.ThemisLogger;
import at.grid.themis.ontology.ThemisProjectProperties;
import at.grid.themis.ontology.ThemisProjectUpdater;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.compat.MapCompat;
import at.grid.themis.ontology.element.CmsAction;
import at.grid.themis.ontology.element.CmsCompany;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsFilter;
import at.grid.themis.ontology.element.CmsFormular;
import at.grid.themis.ontology.element.CmsFormularHistory;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsIcon;
import at.grid.themis.ontology.element.CmsInfo;
import at.grid.themis.ontology.element.CmsJobTemplate;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsLocationTemplate;
import at.grid.themis.ontology.element.CmsLocationgroup;
import at.grid.themis.ontology.element.CmsMeasureTemplate;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsObservationTemplate;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.element.CmsPlanfile;
import at.grid.themis.ontology.element.CmsProject;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.element.ThemisElement;
import at.grid.themis.ontology.element.ThemisElementCache;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.report.ReportTableLayout;
import at.grid.themis.ontology.server.ThemisCloudServer;
import at.grid.themis.ontology.server.ThemisJob;
import at.grid.themis.ontology.settings.ThemisSettingsFileElement;
import at.grid.themis.ontology.template.TemplateManager;
import at.grid.util.DefaultProgressHandler;
import at.grid.util.ImageHelper;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.geotools.util.LRULinkedHashMap;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openide.util.Exceptions;

public final class ThemisProject
extends CmsApplication {
    public static final int BUILD_NUMBER = 2146;
    public static final String VERSIONDATE = "18.06.2024";
    public static final String VERSION_SUBNUMBER = "2";
    public static final String VERSION_BETA = "";
    public static final String VERSION = 6.1f + ("".equals("2") ? "" : ".2") + ("".equals("") ? "" : ".beta") + "-" + 2146;
    public static final String STATISTICS_VERSION = "2";
    public static final String CMS_REPORT = "report";
    public static final String CMS_REPORTTABLE = "reporttable";
    public static final String CMS_JOBTEMPLATE = "jobtemplate";
    public static final String CMS_PLAN = "plan";
    public static final String CMS_PLANFILE = "planfile";
    public static final String CMS_ICON = "icon";
    public static final String CMS_INFO = "info";
    public static final String CMS_ACTION = "action";
    public static final String CMS_COMPANY = "company";
    public static final String CMS_EVENT = "event";
    public static final String CMS_LOCATION = "location";
    public static final String CMS_LOCATIONGROUP = "locationgroup";
    public static final String CMS_OBSERVATION = "observation";
    public static final String CMS_LOG = "log";
    public static final String CMS_HISTORY = "history";
    public static final String CMS_LOCATIONTEMPLATE = "locationtemplate";
    public static final String CMS_PROJECT = "project";
    public static final String CMS_FILTER = "filter";
    public static final String CMS_OBSERVATIONTEMPLATE = "observationtemplate";
    public static final String CMS_MEASURETEMPLATE = "measuretemplate";
    public static final String CMS_FORMULAR = "form";
    public static final String CMS_FORMULARHISTORY = "formhistory";
    public static Object[] OPTIONS_YES_NO_DONTSHOW;
    public static Object[] OPTIONS_OK_DONTSHOW;
    private boolean localProjectCopyRenamed = false;
    public static final String CONF_DB_PWD_3 = "oE93ly-2oq";
    public static final String CONF_DB_PWD_42 = "wNd92c-56dx";
    public static final String ACTION_PROJECT_CREATE = "project_create";
    public static final String ACTION_PROJECT_OPEN = "project_open";
    public static final String ACTION_PROJECT_CLOSE = "project_close";
    public static final String ACTION_LICENSE_REDUCED = "license_reduced";
    public static final String ACTION_SYSTEMSETTING_APPLY = "systemsetting_save";
    public static final String ACTION_PROJECTSETTING_APPLY = "projectsetting_apply";
    public static final String ACTION_PROJECTSETTING_EXPORT = "projectsetting_export";
    public static final String ACTION_PROJECTSETTING_LOAD = "projectsetting_load";
    public static final String ACTION_PROJECT_SAVE = "project_save";
    public static final String ACTION_PROJECT_SYNC = "project_sync";
    public static final String ACTION_EVENT_CREATE = "event_create";
    public static final String ACTION_EVENT_EDIT = "event_edit";
    public static final String ACTION_EVENT_DELETE = "event_delete";
    public static final String ACTION_EVENT_LOCK = "event_lock";
    public static final String ACTION_EVENT_UNLOCK = "event_unlock";
    public static final String ACTION_EVENT_SIGN = "event_sign";
    public static final String ACTION_EVENT_PLAN = "event_plan";
    public static final String ACTION_EVENT_UNPLAN = "event_unplan";
    public static final String ACTION_EVENT_SETACTIVE = "event_setactive";
    public static final String ACTION_EVENT_SETINACTIVE = "event_setinactive";
    public static final String ACTION_PLAN_CREATE = "plan_create";
    public static final String ACTION_PLAN_EDIT = "plan_edit";
    public static final String ACTION_PLAN_DELETE = "plan_delete";
    public static final String ACTION_PLAN_SORT = "plan_sort";
    public static final String ACTION_PLAN_ROTATE = "plan_rotate";
    public static final String ACTION_PLAN_NEWVERSION = "plan_newversion";
    public static final String ACTION_PLAN_CALIBRATED = "plan_calibrated";
    public static final String ACTION_PLAN_CALIBRATIONREMOVED = "plan_calibrationremoved";
    public static final String ACTION_BUILDING_CREATE = "building_create";
    public static final String ACTION_BUILDING_EDIT = "building_edit";
    public static final String ACTION_CONTACT_CREATE = "contact_create";
    public static final String ACTION_CONTACT_EDIT = "contact_edit";
    public static final String ACTION_CONTACT_DELETE = "contact_delete";
    public static final String ACTION_DOCUMENT_CREATE = "document_create";
    public static final String ACTION_DOCUMENT_EDIT = "document_edit";
    public static final String ACTION_DOCUMENT_DELETE = "document_delete";
    public static final String ACTION_LOCATION_CREATE = "location_create";
    public static final String ACTION_LOCATION_EDIT = "location_edit";
    public static final String ACTION_LOCATION_MULTIEDIT = "location_multiedit";
    public static final String ACTION_LOCATION_DELETE = "location_delete";
    public static final String ACTION_LOCATION_MOVE = "location_move";
    public static final String ACTION_LOCATION_MOVELABEL = "location_movelabel";
    public static final String ACTION_OBSERVATION_CREATE = "observation_create";
    public static final String ACTION_OBSERVATION_EDIT = "observation_edit";
    public static final String ACTION_OBSERVATION_MULTIEDIT = "observation_multiedit";
    public static final String ACTION_OBSERVATION_DELETE = "observation_delete";
    public static final String ACTION_OBSERVATION_CONTROLLED = "observation_controlled";
    public static final String ACTION_OBSERVATION_DONE = "observation_done";
    public static final String ACTION_OBSERVATION_NOTCONTROLLED = "observation_notcontrolled";
    public static final String ACTION_PHOTO_IMPORT = "photo_import";
    public static final String ACTION_PHOTO_INTERN = "photo_intern";
    public static final String ACTION_PHOTO_ROTATE = "photo_rotate";
    public static final String ACTION_PHOTO_DRAW = "photo_draw";
    public static final String ACTION_PHOTO_TITLE = "photo_title";
    public static final String ACTION_IMPORT_CSV = "import_csv";
    public static final String ACTION_EMAIL_OBSERVATION = "email_observation";
    public static final String ACTION_EXPORT_REPORT = "export_report";
    public static final String ACTION_FILE_DELETE = "file_delete";
    public static final String ACTION_FILE_MOVED = "file_moved";
    public static final String CONF_LAST_LOCATIONTEMPLATE_ID = "lastlocationtemplateid";
    public static final String CONF_CLIENT = "project.client";
    public static final String CONF_TITLE = "project.title";
    public static final String CONF_NUMBER = "project.number";
    public static final String CONF_INFO = "project.info";
    public static final String CONF_PLAN = "project.plan";
    public static final String CONF_PLAN_LABEL = "project.plan.label";
    public static final String CONF_PLAN_LABELNUMBER = "project.plan.label-number";
    public static final String CONF_LOCATION = "project.location";
    public static final String CONF_PLAN_LOADED = "project.plan.loaded";
    public static final String CONF_COLOR_DEFAULT = "display.color.default";
    public static final String CONF_COLOR_SEL = "display.color.sel";
    public static final String CONF_DISPLAY_POINTSIZE = "display.point.size";
    public static final String CONF_MAPSNIPPET_SIZE = "export.plansize";
    public static final String CONF_MAPSNIPPET_WITH_LABEL = "export.mapsnippet.withlabel";
    public static final String CONF_EXPORT_ALL_IMAGES = "export.allimages";
    public static final String CONF_EXPORT_FILE_TYPE = "export.filetype";
    public static final String CONF_EXPORT_PDF_COMPRESSION = "export.pdf.compression";
    public static final String CONF_SHOW_PANEL = "display.loc-obs-dialog.panel.";
    public static final String CONF_LOCOBS_PANEL_DIVIDER = "display.loc-obs-dialog.divider";
    public static final String CONF_FILTER_OPENED = "display.filter";
    public static final String CONF_LICENSE = "license.level";
    public static final String CONF_AVOID_MOVING_LABEL = "display.avoid-moving-of-label";
    public static final String CONF_PROJECTVERSION = "project.version";
    public static final String CONF_ATT_LOCNUMBERINDIVIDUAL = "attribute.locnumber.individual";
    public static final String CONF_ATT_LOCNUMBERSCHEME = "attribute.locnumber.scheme";
    public static final String CONF_ATT_LOCNUMBERSCHEME_CONSECUTIVE = "attribute.locnumber.consecutive";
    public static final int PHOTO_INTERNAL = 2;
    public static final int LOCATION_NUMBER_PROJECT = 0;
    public static final int LOCATION_NUMBER_BUILDING = 1;
    public static final int LOCATION_NUMBER_PLAN = 2;
    ThemisApplication app = ThemisApplication.getInstance();
    boolean useLocalDatabaseCopy = false;
    public static final float VERSIONNUMBER = 6.1f;
    public static final String FOLDER_DATA = "data";
    public static final String FOLDER_DB = "db";
    public static final String FOLDER_DB_BACKUP = "dbbackup";
    public static final String FOLDER_TEMP = "temp";
    public static final String FOLDER_CONF = "conf";
    public static final String FOLDER_IMAGES = "images";
    public static final String FOLDER_EMAILS = "emails";
    public static final String FOLDER_PLANSNIPPET = "plansnippet";
    public static final String DB_NAME = "themis";
    public static final String DB_NAME_SERVER = "themisserver";
    public static final String DB_OPTIONS = ";MV_STORE=FALSE;MVCC=FALSE";
    public static final String PROJECT_LOCK_FILE = "themis.lock";
    public static final String PROJECT_PROPERTIES_FILE = "themis.properties";
    public static final String PROJECT_DATABASE_FILE = "themis.h2.db";
    public static final String PROJECT_DATABASE_SERVER_FILE = "themisserver.h2.db";
    public static final String PROJECT_DATABASE_FILE_ANDROID_REPLACEMENT = "themis.h2.db.android";
    private File projectFolder;
    private Properties themisProperties;
    private CmsProject project = null;
    private String projectError = null;
    private CmsUser currentUser = null;
    private ThemisProject masterProject = null;
    private long copiedLocationId;
    private long editLocGeometryId;
    private long mapRefToLocId;
    private CmsLocation mapRefToLoc;
    ArrayList<Long> recentLocTemplates = new ArrayList();
    final int maxCountRecentLocTemplates = 10;
    private TemplateManager templateManager;
    private SelectionManager selectionManager;
    private PlanManager planManager;
    private boolean isOpening = false;
    private ArrayList<String> zipEntries = new ArrayList();
    private ArrayList<String> zipErrors = new ArrayList();
    public ArrayList<Integer> yearsForStatistics = new ArrayList();
    private String tempSubfolderName = null;
    private static ArrayList<String> notAccessableFiles;
    public static HashMap<String, Image> icons;
    private static HashMap<String, BufferedImage> icons35px;
    ThemisElementCache themiscache = new ThemisElementCache(this);
    private File themisFileDirectAccess = null;
    ThemisCloudServer server = null;

    public ThemisProject(ThemisApplication app) {
        this.setLogger(ThemisLogger.logger);
        ThemisLogger.logger.setLevel(Level.FINE);
        this.getLogger().info("==================================================");
        this.getLogger().info("Initialising THEMIS Version " + this.getVersion());
        this.getLogger().info("==================================================");
        this.app = app;
        OPTIONS_YES_NO_DONTSHOW = new Object[]{this.getResourceText("app.core.text.yes", this.app.getLocale()), this.getResourceText("app.core.text.no", this.app.getLocale()), this.getResourceText("app.core.text.dontshow", this.app.getLocale())};
        OPTIONS_OK_DONTSHOW = new Object[]{this.getResourceText("app.core.text.ok", this.app.getLocale()), this.getResourceText("app.core.text.dontshow", this.app.getLocale())};
        this.addElementtype(CMS_COMPANY, new CmsCompany());
        this.addElementtype(CMS_EVENT, new CmsEvent());
        this.addElementtype(CMS_LOCATION, new CmsLocation());
        this.addElementtype(CMS_OBSERVATION, new CmsObservation());
        this.addElementtype(CMS_PLAN, new CmsPlan());
        this.addElementtype(CMS_PLANFILE, new CmsPlanfile());
        this.addElementtype(CMS_INFO, new CmsInfo());
        this.addElementtype(CMS_ICON, new CmsIcon());
        this.addElementtype(CMS_HISTORY, new CmsHistory());
        this.addElementtype(CMS_LOCATIONTEMPLATE, new CmsLocationTemplate());
        this.addElementtype(CMS_OBSERVATIONTEMPLATE, new CmsObservationTemplate());
        this.addElementtype(CMS_LOCATIONGROUP, new CmsLocationgroup());
        this.addElementtype(CMS_MEASURETEMPLATE, new CmsMeasureTemplate());
        this.addElementtype(CMS_PROJECT, new CmsProject());
        this.addElementtype(CMS_ACTION, new CmsAction());
        this.addElementtype(CMS_FILTER, new CmsFilter());
        this.addElementtype(CMS_JOBTEMPLATE, new CmsJobTemplate());
        this.addElementtype(CMS_REPORT, new CmsReport(false));
        this.addElementtype(CMS_REPORTTABLE, new ReportTableLayout());
        this.addElementtype(CMS_FORMULAR, new CmsFormular());
        this.addElementtype(CMS_FORMULARHISTORY, new CmsFormularHistory());
        ThemisLogger.logger.info("Elementtypes registered");
        this.templateManager = new TemplateManager(app, this);
        this.selectionManager = new SelectionManager(app, this);
        this.planManager = new PlanManager(app, this);
        this.reset();
    }

    public Element getElementtypesRoot() {
        SAXBuilder builder = new SAXBuilder();
        try {
            return builder.build(this.getConfigurationInputStream("/at/grid/themis/ontology/elementtypes.xml")).getRootElement();
        }
        catch (JDOMException jDOMException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    protected Properties createProperties() {
        Properties props = new Properties();
        props.setProperty("db.user", DB_NAME);
        props.setProperty("db.password", CONF_DB_PWD_42);
        if (this.getProjectFolder() != null) {
            props.setProperty("db.uri", "jdbc:h2:" + this.getProjectFolder().getAbsolutePath().replaceAll("\\\\", "/") + "/" + FOLDER_DB + "/" + DB_NAME + DB_OPTIONS);
        }
        props.setProperty("db.storageclass", "at.grid.cms.storage.H2Datastorage");
        props.setProperty("conf.elementtypes", "/at/grid/themis/ontology/elementtypes.xml");
        props.setProperty("conf.projectcode", DB_NAME);
        props.setProperty("conf.applicationversion", Integer.toString(ThemisProjectUpdater.getLastVersion()));
        props.setProperty("conf.databaseversion", Integer.toString(ThemisProjectUpdater.getLastDatabaseVersion()));
        props.setProperty("conf.primarylang", "de");
        props.setProperty("conf.multilingual", "false");
        props.setProperty("conf.workflow", "false");
        props.setProperty("conf.showmeta", "false");
        props.setProperty("conf.timezone", "CET");
        props.setProperty("conf.elementhistory", "true");
        props.setProperty("conf.default.writeaccess", "owner");
        props.setProperty("conf.default.readaccess", "owner");
        props.setProperty("conf.bundle", "at.grid.themis.ontology.resourcebundle");
        props.setProperty("user.language", "DE");
        props.setProperty("user.country", "AT");
        props.setProperty("user.dateformat", "dd.MM.yyyy");
        props.setProperty("mail.smtp", "smtp.uibk.ac.at");
        props.setProperty("geo.srs", VERSION_BETA);
        return props;
    }

    public boolean isShowMetadata() {
        return false;
    }

    public TimeZone getTimeZone() {
        if (this.isOpen()) {
            return TimeZone.getTimeZone(this.getProperty("conf.timezone", "CET"));
        }
        return this.app.getTimeZone();
    }

    public Date getVersionDate() {
        try {
            return Util.parseDate((String)VERSIONDATE, (String)Util.DATE_READ, (TimeZone)this.app.getTimeZone());
        }
        catch (ParseException ex) {
            return null;
        }
    }

    protected ResourceBundle getApplicationResourceBundle(Locale loc) {
        String name = "at.grid.themis.ontology.BundleThemis";
        return ResourceBundle.getBundle(name, loc);
    }

    public void reset() {
        this.getSelectionManager().reset(false, (Object)this);
        this.copiedLocationId = -1L;
        this.editLocGeometryId = -1L;
        this.mapRefToLocId = -1L;
        this.recentLocTemplates.clear();
        icons.clear();
        icons35px.clear();
        this.getCache().clear();
        if (this.app.getFilter() != null) {
            this.app.getFilter().clearAll();
        }
        this.projectFolder = null;
        this.yearsForStatistics.clear();
        this.currentUser = null;
        this.project = null;
        this.server = null;
        this.themisFileDirectAccess = null;
        this.isOpening = false;
    }

    public void open(File folder, Properties props, boolean trigger) {
        this.open(folder, null, props, trigger, false, true, null);
    }

    public void open(File folder, String androidRoot) {
        this.open(folder, androidRoot, null, false, false, true, null);
    }

    public void open(File folder, String androidRoot, Properties props, boolean trigger, ProgressHandler ph) {
        this.open(folder, androidRoot, props, trigger, false, true, ph);
    }

    public void open(File folder, String androidRoot, Properties props, boolean trigger, boolean networkDrive, boolean create, ProgressHandler ph) {
        this.open(folder, androidRoot, props, trigger, networkDrive, create, false, false, ph);
    }

    public void open(File folder, String androidRoot, Properties props, boolean trigger, boolean networkDrive, boolean create, boolean openLocal, boolean checkout, ProgressHandler ph) {
        ThemisFolder themisFile = new ThemisFolder(folder);
        this.open(themisFile, androidRoot, props, trigger, networkDrive, create, openLocal, checkout, ph);
    }

    public void open(ThemisFolder tf, String androidRoot, Properties props, boolean trigger, boolean networkDrive, boolean create, boolean openLocal, boolean checkout, ProgressHandler ph) {
        ThemisSettingsFileElement autoImportFolder;
        Object targetFolder;
        Object dbProps;
        File dbFile;
        File backupFolder;
        String lockComputer;
        File origLocalFolder;
        boolean projectfolderAvailable;
        boolean serverAccess;
        Properties serverConfig;
        this.isOpening = true;
        ThemisProjectUpdater.getInstance().reset();
        File folder = tf.getProjectFolder();
        File directAccessFile = this.getThemisFileDirectAccess();
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        String serverHost = (serverConfig = tf.getServerConfig()) == null ? null : serverConfig.getProperty("host");
        String serverPort = serverConfig == null ? null : serverConfig.getProperty("port");
        String serverPath = serverConfig == null ? null : serverConfig.getProperty("path");
        boolean bl = serverAccess = tf.isServerAccess() && serverConfig != null;
        if (serverAccess) {
            networkDrive = false;
            create = false;
            openLocal = false;
            checkout = false;
        }
        this.projectError = null;
        if (!trigger) {
            this.app.getActionProvider().setActive(false);
        }
        Date dt0 = new Date();
        long interaction = 0L;
        this.getLogger().fine("OPENPROJECT: " + (new Date().getTime() - dt0.getTime() - interaction) + " ms, Start of open project");
        int progress = 2;
        ph.progress(this.app.getProject().getResourceText("ThemisProject.prepareProject.text", this.app.getLocale()), progress++);
        this.reset();
        boolean newProject = !serverAccess && !openLocal && !ThemisProject.isProjectFolder(folder);
        this.copiedLocationId = -1L;
        this.editLocGeometryId = -1L;
        this.mapRefToLocId = -1L;
        this.projectFolder = folder;
        icons.clear();
        icons35px.clear();
        this.getCache().clear();
        if (!this.projectFolder.exists()) {
            if (openLocal || checkout) {
                this.app.getDialog().showInfoDialog("Das Netzwerk-Laufwerk ist zur Zeit nicht verf\u00fcgbar, es wird nur mit den lokal zwischengespeicherten Daten gearbeitet.");
            } else {
                this.getLogger().info("creating project folder '" + this.projectFolder.getAbsolutePath() + "' ...");
            }
        }
        if ((projectfolderAvailable = this.getFileAccess().mkdirs(this.projectFolder)) || create) {
            this.getFileAccess().mkdirs(new File(this.projectFolder, FOLDER_DB));
            this.getFileAccess().setHidden(new File(this.projectFolder, FOLDER_DB), true);
            this.getFileAccess().mkdirs(new File(this.projectFolder, FOLDER_DB_BACKUP));
            this.getFileAccess().setHidden(new File(this.projectFolder, FOLDER_DB_BACKUP), true);
            this.getFileAccess().mkdirs(new File(this.projectFolder, FOLDER_DATA));
            this.getFileAccess().setHidden(new File(this.projectFolder, FOLDER_DATA), true);
            this.getFileAccess().mkdirs(new File(this.projectFolder, FOLDER_TEMP));
            this.getFileAccess().setHidden(new File(this.projectFolder, FOLDER_TEMP), true);
            this.getFileAccess().mkdirs(new File(this.projectFolder, FOLDER_PLANSNIPPET));
            this.getFileAccess().setHidden(new File(this.projectFolder, FOLDER_PLANSNIPPET), true);
        }
        if (!openLocal && !this.getFileAccess().checkWriteAccess(this.projectFolder)) {
            this.getLogger().severe("No WRITE permission in project folder " + this.projectFolder.getAbsolutePath());
            this.app.getDialog().showErrorDialog("error.no-write-permission", this.projectFolder.getAbsolutePath());
            this.reset();
            return;
        }
        this.getLogger().info("creating system properties ...");
        this.themisProperties = this.createProperties();
        File traceFile = null;
        File dbfile_project = this.getDatabaseFile();
        File dbfile_renamed = new File(dbfile_project.getAbsolutePath() + "_orig");
        if (create) {
            this.getLogger().info("creating and initialising database ...");
            this.initialiseProjectDatabase(this.getDatabaseFile(), null, ph, progress);
            tf.setUUID(this.project.getUUIDasString());
            try {
                this.getDatastorage().close();
            }
            catch (Exception ex) {
                ThemisLogger.logger.log(Level.SEVERE, "Cannot close project: " + ex.getLocalizedMessage(), ex);
            }
            this.getDatastorage().closeTraceFile();
        }
        boolean deleteRemoteLock = false;
        ThemisLock themisProjectLock = tf.getProjectLock();
        this.getLogger().info("checking locally stored data ...");
        if (openLocal && ((origLocalFolder = tf.getLocalLock().getProjectFolder()) == null || !origLocalFolder.getAbsolutePath().equals(tf.getProjectFolder().getAbsolutePath()))) {
            this.app.getDialog().showErrorDialog("error.project-mismatch-local-remote");
            this.reset();
            return;
        }
        String lockUsername = themisProjectLock.getUserName();
        if (lockUsername == null) {
            lockUsername = "keine Angabe";
        }
        if ((lockComputer = themisProjectLock.getUserComputer()) == null) {
            lockComputer = "keine Angabe";
        }
        if (!openLocal && themisProjectLock.isLocked() && !serverAccess) {
            if (themisProjectLock.isUsedOnSameComputerAndUser()) {
                deleteRemoteLock = true;
            } else {
                this.projectError = this.getResourceText("project-error-other-user");
                boolean result = this.app.getDialog().showOpenLockedProjectDialog(lockUsername, themisProjectLock.getLockTimeAsString(), lockComputer);
                if (!result) {
                    if (!trigger) {
                        this.app.getActionProvider().setActive(true);
                    }
                    this.reset();
                    return;
                }
                String fn = tf.getFolderName();
                int copyCount = 1;
                File newFolder = null;
                while (newFolder == null || newFolder.exists()) {
                    newFolder = new File(tf.getProjectFolder().getAbsoluteFile().getParentFile(), fn + " Kopie " + copyCount);
                    ++copyCount;
                }
                try {
                    newFolder.mkdirs();
                    FileUtils.copyDirectory((File)tf.getProjectFolder(), (File)newFolder);
                    File delFile = new File(newFolder, "db/themis.lock");
                    delFile.delete();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                this.open(newFolder, androidRoot, props, trigger, networkDrive, create, openLocal, checkout, null);
                return;
            }
        }
        this.useLocalDatabaseCopy = openLocal;
        File localProjectFolder = null;
        boolean copyPlanFiles = false;
        boolean copyFotoFiles = false;
        boolean copyIconsFiles = false;
        boolean copyDocumentFiles = false;
        if (networkDrive && !openLocal && !serverAccess) {
            boolean renameSuccess;
            ThemisLock themisLocalLock = tf.getLocalLock();
            boolean copyDatabase = true;
            if (themisLocalLock.isLocked()) {
                this.projectError = this.getResourceText("project-error-existing-tempdb");
                String msg = themisLocalLock.toString();
                int result = this.app.getDialog().showInfoOptionDialog("dialog.network.use-local-copy-ask", "dialog.network.title", new Object[]{this.getResourceText("text.cancel"), this.getResourceText("dialog.network.use-local-copy"), this.getResourceText("dialog.network.delete-local-copy"), this.getResourceText("dialog.network.use-remote")});
                switch (result) {
                    case 0: {
                        if (!trigger) {
                            this.app.getActionProvider().setActive(true);
                        }
                        this.reset();
                        return;
                    }
                    case 1: {
                        tf.deleteLocalLock();
                        copyDatabase = false;
                        break;
                    }
                    case 2: {
                        tf.deleteLocal();
                        this.getFileAccess().rename(dbfile_renamed, dbfile_project);
                        break;
                    }
                    case 3: {
                        this.getFileAccess().rename(tf.getLocalProjectFolder(), new File(tf.getLocalProjectFolder().getParentFile(), tf.getLocalProjectFolder().getName() + "_copy"));
                        this.localProjectCopyRenamed = true;
                        this.getFileAccess().rename(dbfile_renamed, dbfile_project);
                    }
                }
            } else {
                this.getFileAccess().rename(dbfile_renamed, dbfile_project);
            }
            if (deleteRemoteLock) {
                tf.deleteProjectLock();
                if (!dbfile_project.isFile()) {
                    this.getFileAccess().rename(dbfile_renamed, dbfile_project);
                }
            }
            localProjectFolder = tf.getLocalProjectFolder();
            localProjectFolder.mkdirs();
            if (dbfile_renamed.isFile()) {
                int renamecounter = 1;
                String renamebase = dbfile_renamed.getName();
                File dbfile_renamed_bak = new File(dbfile_renamed.getParentFile(), renamebase + renamecounter);
                while (dbfile_renamed_bak.isFile() && renamecounter < 10) {
                    dbfile_renamed_bak = new File(dbfile_renamed.getParentFile(), renamebase + ++renamecounter);
                }
                if (dbfile_renamed_bak.isFile()) {
                    dbfile_renamed_bak = new File(dbfile_renamed.getParentFile(), renamebase + "0");
                    dbfile_renamed_bak.delete();
                }
                this.getFileAccess().rename(dbfile_renamed, dbfile_renamed_bak);
            }
            if (!(renameSuccess = this.getFileAccess().rename(dbfile_project, dbfile_renamed)) && !create) {
                this.app.getDialog().showErrorDialog("error.network.cannot-rename-db");
                if (!trigger) {
                    this.app.getActionProvider().setActive(true);
                }
                this.reset();
                return;
            }
            if (copyDatabase) {
                this.getLogger().fine("Copying database to a local folder: '" + localProjectFolder.getAbsolutePath() + "'");
                this.useLocalDatabaseCopy = this.getFileAccess().copy(dbfile_renamed, tf.getLocalDatabaseFile());
                if (this.useLocalDatabaseCopy && !create && checkout) {
                    copyPlanFiles = true;
                    copyFotoFiles = true;
                    copyIconsFiles = true;
                    copyDocumentFiles = true;
                }
            } else {
                this.useLocalDatabaseCopy = true;
            }
            if (this.useLocalDatabaseCopy) {
                themisLocalLock.create();
            } else {
                this.getFileAccess().rename(dbfile_renamed, dbfile_project);
            }
        }
        this.getLogger().fine("OPENPROJECT: " + (new Date().getTime() - dt0.getTime() - interaction) + " ms, Finished variable init and project folder creation");
        if (!openLocal && !serverAccess) {
            themisProjectLock.create();
        }
        this.getLogger().fine("OPENPROJECT: " + (new Date().getTime() - dt0.getTime() - interaction) + " ms, Finished " + PROJECT_LOCK_FILE + " creation for locking access");
        File dbfile = this.getDatabaseFile();
        if (this.useLocalDatabaseCopy) {
            this.themisProperties.setProperty("cms.upload.1.location", tf.getLocalDataFolder().getAbsolutePath());
            this.themisProperties.setProperty("db.uri", "jdbc:h2:" + tf.getLocalDatabaseFile().getParentFile().getAbsolutePath().replaceAll("\\\\", "/") + "/" + DB_NAME + DB_OPTIONS);
            dbfile = tf.getLocalDatabaseFile();
        } else {
            this.themisProperties.setProperty("cms.upload.1.location", new File(this.projectFolder, FOLDER_DATA).getAbsolutePath());
            if (serverAccess) {
                dbfile = tf.getServerDatabaseFile();
                this.themisProperties.setProperty("db.uri", "jdbc:h2:tcp://" + serverHost + ":" + serverPort + "/" + serverPath.replaceAll("\\\\", "/") + "/db/" + DB_NAME_SERVER + DB_OPTIONS);
            } else {
                this.themisProperties.setProperty("db.uri", "jdbc:h2:" + dbfile.getParentFile().getAbsolutePath().replaceAll("\\\\", "/") + "/" + DB_NAME + DB_OPTIONS);
            }
        }
        ph.progress(this.getResourceText("ThemisProject.open.createDump", this.app.getLocale()), 9);
        boolean moveForBackup = false;
        if (networkDrive && !serverAccess) {
            if (dbfile_renamed != null && dbfile_renamed.isFile()) {
                backupFolder = tf.getDatabaseBackupFolder();
                dbFile = dbfile_renamed;
                moveForBackup = true;
            } else {
                backupFolder = this.getTempfileLocation();
                dbFile = tf.getLocalDatabaseFile();
            }
        } else {
            backupFolder = tf.getDatabaseBackupFolder();
            dbFile = tf.getDatabaseFile();
        }
        Date dbFileLastModified = new Date(dbFile.lastModified());
        String dbFileLastModifiedString = Util.formatDate((Date)dbFileLastModified, (String)Util.DATETIME_FILE, (TimeZone)this.getTimeZone());
        File dbFileBackup = new File(backupFolder, dbFileLastModifiedString + "_themis.h2.bak");
        try {
            if (moveForBackup) {
                Util.move((File)dbFile, (File)dbFileBackup);
            } else {
                Util.copy((File)dbFile, (File)dbFileBackup);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (this.app.getSettings().getDoMonthlyDatabaseBackup()) {
            String dbFileLastModifiedMonthString = Util.formatDate((Date)dbFileLastModified, (String)Util.DATE_FILE_YEAR_MONTH, (TimeZone)this.getTimeZone());
            File dbFileBackupMonth = new File(backupFolder, dbFileLastModifiedMonthString + "_themis-monthly.h2.zip");
            if (!(newProject || serverAccess || dbFileBackupMonth.exists())) {
                try {
                    Util.copyToZip((File)dbFile, (File)dbFileBackupMonth, (boolean)true);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.getLogger().fine("OPENPROJECT: " + (new Date().getTime() - dt0.getTime() - interaction) + " ms, Finished db dump");
        int appLicenseLevel = this.app.getLicense().getLicenseDetails().getApplicationLicenseLevelValue();
        int projectLicenseLevel = 0;
        if (!checkout) {
            boolean dbOk = this.initialiseProjectDatabase(dbfile, traceFile, ph, progress);
            if (!dbOk) {
                boolean success;
                tf.deleteLocal();
                if (this.useLocalDatabaseCopy && !(success = this.getFileAccess().rename(dbfile_renamed, dbfile_project))) {
                    tf.deleteLocal();
                    this.app.getDialog().showErrorDialog("error.network.cannot-save-back");
                }
                if (this.projectError == null) {
                    this.projectError = this.getResourceText("project.error-general");
                }
                this.app.getDialog().showErrorDialog(this.projectError);
                if (!trigger) {
                    this.app.getActionProvider().setActive(true);
                }
                dbFileBackup.delete();
                this.reset();
                return;
            }
            try {
                int dbVersionApp;
                if (!this.isOpen()) {
                    boolean success;
                    tf.deleteLocal();
                    if (this.useLocalDatabaseCopy && !(success = this.getFileAccess().rename(dbfile_renamed, dbfile_project))) {
                        this.app.getDialog().showErrorDialog("error.network.cannot-save-back");
                    }
                    this.createActionLog(ACTION_PROJECT_OPEN, 0L, "failed");
                    this.projectError = this.getResourceText("project.error-general");
                    if (!trigger) {
                        this.app.getActionProvider().setActive(true);
                    }
                    dbFileBackup.delete();
                    this.reset();
                    return;
                }
                projectLicenseLevel = this.getLicenseLevel();
                if (newProject) {
                    this.setLicenseLevel(appLicenseLevel);
                    projectLicenseLevel = appLicenseLevel;
                }
                if (projectLicenseLevel > appLicenseLevel) {
                    this.app.getDialog().showErrorDialog("license.insufficient-for-project");
                    this.createActionLog(ACTION_PROJECT_OPEN, 0L, "failed, insufficient license");
                }
                if ((dbVersionApp = this.getDatastorage().getDatabaseApplicationVersion(DB_NAME)) == 53) {
                    dbVersionApp = 52;
                    this.getDatastorage().setDatabaseApplicationVersion(DB_NAME, 52);
                }
                int dbVersionOnt = this.getDatastorage().getDatabaseVersion();
                if (dbVersionApp > ThemisProjectUpdater.getLastVersion() || dbVersionOnt > 21) {
                    this.app.getDialog().showInfoDialog("project.error-version");
                    this.close(new Closing().withoutExport(), ph);
                    this.projectError = this.getResourceText("project.error-version");
                    if (!trigger) {
                        this.app.getActionProvider().setActive(true);
                    }
                    dbFileBackup.delete();
                    this.reset();
                    themisProjectLock.deleteLockFile();
                    return;
                }
                this.setProjectProperty(CONF_PROJECTVERSION, Integer.toString(ThemisProject.getSoftwareVersion()));
                this.getLogger().fine("OPENPROJECT: " + (new Date().getTime() - dt0.getTime() - interaction) + " ms, Begin init themis attributes");
                this.app.getSettings().initialiseAttributes(this.app);
                this.getLogger().fine("OPENPROJECT: " + (new Date().getTime() - dt0.getTime() - interaction) + " ms, Finished init themis attributes");
                if (newProject) {
                    this.app.getSettings().applyProjectDefaultSettings();
                } else {
                    this.app.getSettings().applyProjectSettings();
                }
                ThemisProjectUpdater.getInstance().update(ThemisProjectUpdater.Phase.OPEN, ph);
                this.getLogger().fine("OPENPROJECT: " + (new Date().getTime() - dt0.getTime() - interaction) + " ms, Finished apply settings");
                if (newProject) {
                    this.createActionLog(ACTION_PROJECT_CREATE, 0L, VERSION_BETA);
                } else {
                    this.createActionLog(ACTION_PROJECT_OPEN, 0L, VERSION_BETA);
                }
                if (trigger) {
                    this.getLogger().info("triggering opened project ...");
                    this.app.getActionProvider().invokeAction(ThemisAction.PROJECT_OPENED.from((Object)this, "project loaded"));
                }
            }
            catch (Exception e) {
                this.app.getDialog().showErrorDialog(this.getResourceText("ThemisProject.errorInitialisingProject.text", this.app.getLocale()), e);
                this.close(new Closing().withoutExport(), ph);
                if (!trigger) {
                    this.app.getActionProvider().setActive(true);
                }
                dbFileBackup.delete();
                this.reset();
                return;
            }
            ArrayList<File> fileList = tf.getDatabaseBackupFileList();
            while (fileList.size() > 3) {
                this.getFileAccess().delete(fileList.remove(0));
            }
            this.getLogger().info("updating database properties ...");
            dbProps = this.getDatastorage().getConfig();
            for (String k : ((Properties)dbProps).stringPropertyNames()) {
                this.themisProperties.setProperty(k, ((Properties)dbProps).getProperty(k));
            }
            if (props != null) {
                this.setProjectProperties(props);
            }
            if (this.getProjectProperty(CONF_TITLE) == null) {
                this.setProjectProperty(CONF_TITLE, this.getResourceText("ThemisProject.Project.text", this.app.getLocale()));
            }
            this.getLogger().info("clearing filter ...");
            this.app.getFilter().clearAll();
            this.getLogger().fine("OPENPROJECT: " + (new Date().getTime() - dt0.getTime() - interaction) + " ms, Finished clear filter");
        }
        if (copyPlanFiles || checkout) {
            if (this.isOpen()) {
                for (CmsElementSummary plan : this.getPlans()) {
                    dbProps = (CmsPlan)this.loadElement(plan.getId(), this.getUser());
                }
            } else {
                targetFolder = new File(tf.getLocalDataFolder(), CMS_PLANFILE);
                this.getFileAccess().copy(new File(tf.getProjectDataFolder(), CMS_PLANFILE), (File)targetFolder);
            }
        }
        if (copyIconsFiles || checkout) {
            if (this.isOpen()) {
                for (CmsBasicElement icon : this.getIcons()) {
                    dbProps = (CmsIcon)this.loadElement(icon.getId(), this.getUser());
                }
            } else {
                targetFolder = new File(tf.getLocalDataFolder(), CMS_ICON);
                this.getFileAccess().copy(new File(tf.getProjectDataFolder(), CMS_ICON), (File)targetFolder);
            }
        }
        if (copyDocumentFiles || checkout) {
            if (this.isOpen()) {
                for (CmsElementSummary doc : this.getDocuments()) {
                    dbProps = (CmsInfo)this.loadElement(doc.getId(), this.getUser());
                }
            } else {
                targetFolder = new File(tf.getLocalDataFolder(), CMS_INFO);
                this.getFileAccess().copy(new File(tf.getProjectDataFolder(), CMS_INFO), (File)targetFolder);
            }
        }
        if (copyFotoFiles || checkout) {
            targetFolder = new File(tf.getLocalDataFolder(), CMS_HISTORY);
            if (this.isOpen()) {
                String sql = "select f.idfileupload, f.path, r.elementfrom AS idhistory, r.elementto AS idobservation, h.eventdate, h.timehours\nfrom tdtafileupload AS f INNER JOIN tdtaRelation AS r ON (f.idelement=r.elementfrom AND r.relationcode='historyobservation') INNER JOIN tdtaEleHistory AS h ON (f.idelement=h.idelement)\norder by idobservation,eventdate desc, timehours desc";
                List recs = this.getDatastorage().executeQuery(sql, true).getResult();
                ArrayList filenames = new ArrayList();
                long prevObs = -1L;
                long prevHist = -1L;
                for (DataRecord rec : recs) {
                    long idobs = rec.getLong("idobservation");
                    long idhist = rec.getLong("idhistory");
                    String filename = rec.getString("path");
                    if (idobs != prevObs) {
                        filenames.add(filename);
                        prevObs = idobs;
                        prevHist = idhist;
                        continue;
                    }
                    if (idhist != prevHist) continue;
                    filenames.add(filename);
                }
                Iterator iterator = filenames.iterator();
                while (iterator.hasNext()) {
                    String fn = (String)iterator.next();
                    this.getFileAccess().copy(new File(tf.getProjectDataFolder(), "history/" + fn), new File((File)targetFolder, fn));
                }
            } else {
                this.getFileAccess().copy(new File(tf.getProjectDataFolder(), CMS_HISTORY), (File)targetFolder);
            }
        }
        ThemisUtil.setProjectIcon(folder);
        this.isOpening = false;
        if (projectLicenseLevel < appLicenseLevel) {
            this.app.getGUImanager().setTitle();
        }
        if (this.app.getSettings().getAutoImportFromServer() && this.app.getSettings().hasThemisServerCode()) {
            try {
                ph.progress("Pr\u00fcfe Server Verbindung");
                ThemisCloudServer server = this.getThemisServer();
                if (server != null && server.isServerAvailable()) {
                    ph.progress("Pr\u00fcfe Server auf abgeschlossene Auftr\u00e4ge");
                    ArrayList<ThemisJob> doneJobs = server.getDoneJobs(this.getProjectElement().getUUIDasString());
                    if (!doneJobs.isEmpty()) {
                        ArrayList<String> doneJobTitles = new ArrayList<String>();
                        for (ThemisJob j : doneJobs) {
                            doneJobTitles.add(j.toString());
                        }
                        if (this.app.getDialog().showConfirmDialog("server.autoimport.text", "server.autoimport.title", new String[]{"\n- " + String.join((CharSequence)"\n- ", doneJobTitles)})) {
                            ph.progress("Lade abgeschlossene Auftr\u00e4ge vom Server");
                            this.importDoneJobs(server, doneJobs, ph);
                        }
                    }
                }
            }
            catch (IOException server) {
                // empty catch block
            }
            if (trigger) {
                this.app.getActionProvider().invokeAction(ThemisAction.EVENT_SAVED.from((Object)this, "after import of a job as *.themis"));
                this.app.getActionProvider().invokeAction(ThemisAction.PLAN_SAVED.from((Object)this, "after import of a job as *.themis"));
                this.app.getActionProvider().invokeAction(ThemisAction.EVENT_SET_AS_CURRENT.from((Object)this, "after import of a job as *.themis"));
                this.app.getActionProvider().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.from((Object)this, "after import of a job as *.themis"));
            }
        }
        if ((autoImportFolder = this.app.getSettings().getAutoImportFolder()).hasValue()) {
            File importFolder = autoImportFolder.getValue(true);
            ArrayList files = Util.getFiles((File)importFolder, (String)DB_NAME, (boolean)true);
            int counter = 1;
            ArrayList<File> errors = new ArrayList<File>();
            ThemisFile tfImport = new ThemisFile();
            for (File f : files) {
                ph.progress("Lade abgeschlossene Auftr\u00e4ge aus Verzeichnis - " + counter + " von " + files.size());
                try {
                    tfImport.loadFromFile(f, false);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    errors.add(f);
                }
            }
        }
        if (!checkout && trigger && this.app.getSettings().getNotificationDueTasks()) {
            if (ph != null) {
                ph.progress(this.getResourceText("ThemisProject.open.checkNotification", this.app.getLocale()), 10);
            }
            this.getLogger().info("checking dates for reminders ...");
            ThemisFilter tempFilter = new ThemisFilter(this.app);
            tempFilter.setTriggerEnabled(false);
            String[] appointmentInfo = this.app.getAppointmentInfo();
            Date appointment = ThemisApplication.applyPeriodToDate(new Date(), Integer.parseInt(appointmentInfo[1]), Integer.parseInt(appointmentInfo[0]));
            tempFilter.setDuedate(appointment, (Object)this);
            tempFilter.setStatus(3, (Object)this);
            List<DataRecord> recs = tempFilter.getFilteredObservations();
            this.getLogger().info("found " + recs.size() + " records for reminder ...");
            if (!recs.isEmpty()) {
                this.getLogger().info("showing reminder dialog ...");
                Date dtInteraction = new Date();
                int response = this.app.getDialog().showInfoOptionDialog(ResourceBundle.getBundle("at/grid/themis/ontology/BundleThemis").getString("ThemisProject.duedatesfound.text"), ResourceBundle.getBundle("at/grid/themis/ontology/BundleThemis").getString("ThemisProject.duedatenotif.text"), OPTIONS_YES_NO_DONTSHOW);
                interaction += new Date().getTime() - dtInteraction.getTime();
                switch (response) {
                    case 0: {
                        this.getLogger().info("Applying filter ...");
                        this.app.getFilter().setTriggerEnabled(false);
                        this.app.getFilter().setDuedate(appointment, (Object)this);
                        this.app.getFilter().setStatus(3, (Object)this);
                        this.app.getFilter().setTriggerEnabled(true);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.app.getSettings().setNotificationDueTasks(false);
                    }
                }
            }
            this.getLogger().fine("OPENPROJECT: " + (new Date().getTime() - dt0.getTime() - interaction) + " ms, Finished checking duedate");
        }
        this.getLogger().fine("OPENPROJECT: " + (new Date().getTime() - dt0.getTime() - interaction) + " ms, Finished open project");
        if (ph != null) {
            ph.progress(this.getResourceText("ThemisProject.open.done", this.app.getLocale()), 11);
        }
        notAccessableFiles.remove(tf.getProjectFolder().getAbsolutePath());
        tf.logStatus();
        if (directAccessFile != null) {
            this.setThemisFileDirectAccess(directAccessFile);
        }
        this.app.updateRecentProjectList();
        this.app.getGUImanager().setTitle();
        if (!trigger) {
            this.app.getActionProvider().setActive(true);
        }
    }

    protected boolean initialiseProjectDatabase(File dbfile, File traceFile, ProgressHandler ph, int progress) {
        this.getKeytables().clear();
        boolean dbOk = false;
        boolean changePassword = false;
        if (dbfile.isFile()) {
            try {
                progress = 3;
                dbOk = this.initialise(this.themisProperties, this.getConfigurationInputStream(this.themisProperties), true, traceFile, ph, progress);
            }
            catch (SQLException ex) {
                this.projectError = ex.getLocalizedMessage();
            }
            if (!dbOk) {
                this.themisProperties.setProperty("db.password", CONF_DB_PWD_3);
                changePassword = true;
                try {
                    progress = 3;
                    dbOk = this.initialise(this.themisProperties, this.getConfigurationInputStream(this.themisProperties), true, traceFile, ph, progress);
                }
                catch (SQLException ex) {
                    this.projectError = ex.getLocalizedMessage();
                }
                if (!dbOk) {
                    this.themisProperties.remove("db.password");
                    changePassword = true;
                    try {
                        progress = 3;
                        dbOk = this.initialise(this.themisProperties, this.getConfigurationInputStream(this.themisProperties), true, traceFile, ph, progress);
                    }
                    catch (SQLException ex) {
                        this.projectError = ex.getLocalizedMessage();
                    }
                }
            }
        } else {
            try {
                progress = 3;
                dbOk = this.initialise(this.themisProperties, this.getConfigurationInputStream(this.themisProperties), true, traceFile, ph, progress);
            }
            catch (SQLException ex) {
                this.projectError = ex.getLocalizedMessage();
            }
        }
        if (!dbOk) {
            return false;
        }
        this.getDatastorage().removeConfig("db.uri");
        if (changePassword) {
            this.getDatastorage().executeUpdate("ALTER USER themis SET PASSWORD 'wNd92c-56dx'", true);
        }
        if (ph != null) {
            ph.progress(this.getResourceText("ThemisProject.open.loadElement", this.app.getLocale()), 8);
        }
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this, this.getUser(), CMS_PROJECT);
        s.setSort("e.idelement");
        List recs = s.search().getResult();
        String sql = s.getSql();
        DataRecord rec = null;
        if (recs.size() == 1) {
            rec = (DataRecord)recs.get(0);
        }
        if (recs.size() > 1) {
            this.app.getDialog().showErrorDialog("warning.corrupt-project");
            CmsElement e = null;
            for (int ii = 0; !(ii >= recs.size() || (e = this.loadElement((rec = (DataRecord)recs.get(ii)).getLong("meta_id"), this.getUser())) != null && e.getElementcode().equals(CMS_PROJECT)); ++ii) {
            }
            if (e == null || !e.getElementcode().equals(CMS_PROJECT)) {
                this.app.getDialog().showErrorDialog("warning.corrupt-project-abort");
            }
        }
        if (rec != null) {
            this.getLogger().info("loading project element ...");
            this.project = (CmsProject)this.loadElement(rec.getLong("meta_id"), this.getUser());
            if (this.project.getId() < 0L) {
                this.app.getDialog().showErrorDialog("warning.corrupt-project-abort");
            }
            if (this.project.getLongAttribute("projectid").getLong() == 0L) {
                this.project.getLongAttribute("projectid").setValue(new Date().getTime());
                this.project.save();
            }
        } else {
            this.getLogger().info("creating project element ...");
            this.project = (CmsProject)this.createElement(CMS_PROJECT);
            this.project.getLongAttribute("projectid").setValue(new Date().getTime());
            this.project.setAttributeValue("projecttitle", this.getProjectProperty(CONF_TITLE, "(kein Titel)"));
            this.project.setAttributeValue("projectlocation", this.getProjectProperty(CONF_LOCATION, VERSION_BETA));
            this.project.setAttributeValue("customer", this.getProjectProperty(CONF_CLIENT, VERSION_BETA));
            this.project.setAttributeValue("projectnumber", this.getProjectProperty(CONF_NUMBER, VERSION_BETA));
            this.project.setAttributeValue(CMS_INFO, this.getProjectProperty(CONF_INFO, VERSION_BETA));
            this.project.save();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Properties readProjectLockFile(File f) {
        Properties p = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            p.load(is);
        }
        catch (Exception exception) {
            Util.closeStream((Closeable)is);
            catch (Throwable throwable) {
                Util.closeStream(is);
                throw throwable;
            }
        }
        Util.closeStream((Closeable)is);
        return p;
    }

    public boolean close(Closing closing, ProgressHandler ph) {
        if (!this.isOpen()) {
            this.getLogger().warning("trying to close project, but no project open");
            return true;
        }
        if (closing.dontClose) {
            this.getLogger().warning("closing cancelled by user");
            return false;
        }
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        Object exportFolder = null;
        File currentProjectFolder = new File(this.getProjectFolder().getAbsolutePath());
        if (closing.withExport && this.app.getSettings().hasThemisServerCode()) {
            this.getLogger().info("checking THEMIS server for auto export");
            ph.progress("progress.close-project.load-jobs");
        }
        boolean doDeleteTempProject = false;
        if (this.isThemisFileDirectAccess()) {
            if (closing.withSave) {
                ThemisFile tf = this.getProjectAsThemisFile();
                tf.setEvent(this.getSelectionManager().getCurrentEvent());
                try {
                    tf.saveToFile(this.getThemisFileDirectAccess(), true);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    this.app.getDialog().showErrorDialog("Fehler beim Schreiben der *.themis Datei", ex);
                    return false;
                }
            }
            doDeleteTempProject = true;
        }
        CmsEvent currentEvent = this.getSelectionManager().getCurrentEvent();
        String result = this.app.getSettings().save();
        if (result != null && closing.askUser) {
            this.app.getDialog().showErrorDialog("warning.cannot-save-settings", this.app.getSettings().getSettingsFile().getParent(), result);
        }
        File tempFolder = this.getTempfileLocationBase();
        if (closing.withExport && this.app.getSettings().getAutoExportFullProject()) {
            this.getLogger().info("Auto-export of jobs to THEMIS server");
            ph.progress("progress.close-project.connect-server");
            this.server = this.getThemisServer();
            exportFolder = null;
            if (this.server != null && this.server.isServerAvailable()) {
                ph.progress("progress.close-project.export-project");
                try {
                    this.server.uploadProject(this, ph);
                }
                catch (IOException | JDOMException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        this.getLogger().info("clearing cache and other settings");
        this.getCache().clear();
        String localUser = this.getUser().getUsername();
        this.app.getFilter().clearAll(false, (Object)this);
        ThemisFolder tf = new ThemisFolder(this.getProjectFolder());
        Properties stats = this.getProjectStatistics(false, true);
        this.getLogger().info("resetting project");
        this.reset();
        this.createActionLog(ACTION_PROJECT_CLOSE, 0L, VERSION_BETA);
        try {
            this.getLogger().info("closing database connection");
            this.getDatastorage().close();
        }
        catch (Exception ex) {
            ThemisLogger.logger.log(Level.SEVERE, "Cannot close project: " + ex.getLocalizedMessage(), ex);
        }
        this.getLogger().info("closing database trace file");
        this.getDatastorage().closeTraceFile();
        if (this.useLocalDatabaseCopy) {
            boolean keepLocal = false;
            boolean localCopyIsDifferentProject = false;
            File origLocalFolder = tf.getLocalLock().getProjectFolder();
            if (origLocalFolder == null || !origLocalFolder.getAbsolutePath().equals(tf.getProjectFolder().getAbsolutePath())) {
                keepLocal = true;
                localCopyIsDifferentProject = true;
            }
            if (!localCopyIsDifferentProject) {
                String remoteUser = tf.getProjectLock().getUserName();
                if (!tf.getProjectFolder().exists() && !this.getFileAccess().mkdirs(tf.getProjectFolder())) {
                    this.app.getDialog().showErrorDialog("error.network.cannot-save-back");
                    keepLocal = true;
                } else if (!tf.getProjectLock().isLocked()) {
                    this.app.getDialog().showErrorDialog("error.network.already-edited-remain");
                    keepLocal = true;
                } else if (!localUser.equals(remoteUser)) {
                    this.app.getDialog().showErrorDialog("error.network.currently-edited-remain", tf.getProjectLock().getUserName());
                    keepLocal = true;
                } else {
                    this.getLogger().fine("Copying database back to project folder");
                    boolean success = this.restoreFromLocalToProject(tf);
                    if (!success) {
                        this.app.getDialog().showErrorDialog("error.network.cannot-save-back");
                        keepLocal = true;
                    }
                }
            }
            if (!keepLocal && !localCopyIsDifferentProject) {
                tf.deleteProjectLock();
                tf.deleteLocal();
            }
            if (this.localProjectCopyRenamed && !localCopyIsDifferentProject) {
                int choice = this.app.getDialog().showConfirmDialogWithOptions("dialog.network.local-copy-backup-action", "dialog.network.title", new Object[0], new String[]{this.getResourceText("dialog.network.local-copy-backup-action.rename"), this.getResourceText("dialog.network.local-copy-backup-action.delete")});
                switch (choice) {
                    case 0: {
                        this.getFileAccess().rename(new File(tf.getLocalProjectFolder().getParentFile(), tf.getLocalProjectFolder().getName() + "_copy"), tf.getLocalProjectFolder());
                        break;
                    }
                    case 1: {
                        this.getFileAccess().delete(new File(tf.getLocalProjectFolder().getParentFile(), tf.getLocalProjectFolder().getName() + "_copy"));
                    }
                }
            }
            this.localProjectCopyRenamed = false;
        } else {
            tf.deleteProjectLock();
        }
        if (tempFolder != null && tempFolder.canWrite()) {
            this.getFileAccess().delete(tempFolder);
        }
        this.getSelectionManager().reset(closing.withTrigger, (Object)this);
        icons35px.clear();
        if (doDeleteTempProject) {
            Util.delete((File)currentProjectFolder);
        }
        if (closing.withTrigger) {
            if (closing.waitForTrigger) {
                this.app.getActionProvider().invokeAction(ThemisAction.PROJECT_CLOSED.from((Object)this, "project closed").setWaitForExecution(), true);
            } else {
                this.app.getActionProvider().invokeAction(ThemisAction.PROJECT_CLOSED.from((Object)this, "project closed"), true);
            }
        }
        this.app.getGUImanager().setTitle();
        this.app.getActionProvider().setActive(true);
        return true;
    }

    public ThemisFile getProjectAsThemisFile() {
        ThemisFile tf = new ThemisFile();
        tf.setAsFullProject();
        ThemisFilter currentFilter = this.app.getFilter().getCopy();
        this.app.getFilter().clearAll(false, (Object)this);
        tf.addContent(this.app.getFilter().getFilteredObservationIds());
        this.app.getFilter().setFilter(currentFilter);
        return tf;
    }

    public boolean restoreDatabase(File dumpFile, File projectfolder) {
        if (!dumpFile.isFile()) {
            return false;
        }
        if (this.isOpen()) {
            return false;
        }
        if (!ThemisProject.isProjectFolder(projectfolder)) {
            return false;
        }
        if (dumpFile.getName().toLowerCase().endsWith(".zip")) {
            try {
                File folder = new File(this.app.getApplicationDataTempFolder(), Util.getFileNameWithoutExtension((File)dumpFile));
                folder.mkdirs();
                Util.unzip((File)dumpFile, (File)folder);
                if (folder.listFiles().length != 1) {
                    return false;
                }
                dumpFile = folder.listFiles()[0];
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return false;
            }
        }
        File dbFile = new File(projectfolder, "db/themis.h2.db");
        File dbFileBackup = new File(dbFile.getParentFile(), dbFile.getName() + "_backup");
        int counter = 2;
        while (dbFileBackup.isFile()) {
            dbFileBackup = new File(dbFile.getParentFile(), dbFile.getName() + "_backup" + counter);
            ++counter;
        }
        dbFile.renameTo(dbFileBackup);
        String dbfileuri = dbFile.getAbsolutePath();
        dbfileuri = dbfileuri.replaceAll(".h2.db", VERSION_BETA);
        String dburi = "jdbc:h2:" + dbfileuri + DB_OPTIONS;
        Properties connectionProperties = new Properties();
        connectionProperties.setProperty("user", DB_NAME);
        connectionProperties.setProperty("password", CONF_DB_PWD_42);
        try {
            Connection conn = DriverManager.getConnection(dburi, connectionProperties);
            Statement stmt = conn.createStatement();
            stmt.executeUpdate("runscript from '" + dumpFile.getAbsolutePath() + "'");
            conn.close();
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean restoreFromLocalToProject(ThemisFolder themisFile) {
        File dbfile_project = themisFile.getDatabaseFile();
        File dbfile_local = themisFile.getLocalDatabaseFile();
        boolean success = this.getFileAccess().copy(dbfile_local, dbfile_project);
        if (success) {
            ThemisProject.removeNotAccessableFile(themisFile.getProjectFolder());
            this.getLogger().info("... database file successfully copied back to network project folder");
            this.getFileAccess().delete(new File(dbfile_project.getAbsolutePath() + "_orig"));
            File[] folders = themisFile.getLocalDataFolder().listFiles();
            if (folders != null) {
                for (File folder : folders) {
                    if (!folder.isDirectory()) continue;
                    File targetFolder = new File(themisFile.getProjectDataFolder(), folder.getName());
                    targetFolder.mkdirs();
                    File[] files = folder.listFiles();
                    if (files == null) continue;
                    for (File f : files) {
                        File targetFile = new File(targetFolder, f.getName());
                        boolean doWriteBack = true;
                        if (targetFile.exists()) {
                            try {
                                BasicFileAttributes atts = Files.readAttributes(f.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                                long lastModified = atts.lastModifiedTime().toMillis();
                                long created = atts.creationTime().toMillis();
                                if (lastModified - created < 1000L) {
                                    doWriteBack = false;
                                }
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                        if (doWriteBack) {
                            boolean fileSuccess = this.getFileAccess().copy(f, targetFile);
                            boolean bl = success = success && fileSuccess;
                            if (fileSuccess) {
                                this.getLogger().info("... file '" + f.getName() + "' successfully copied back to network project folder");
                                continue;
                            }
                            this.getLogger().severe("Error while copying back file '" + f.getName() + "' to network project folder");
                            continue;
                        }
                        this.getLogger().info("... file '" + f.getName() + "' does not need to be copied back to network project folder");
                    }
                }
            }
            if (success) {
                themisFile.deleteLocal();
            }
        }
        return success;
    }

    public String saveLocalAsNewProject(ThemisFolder themisFile, File folder) {
        String fn = themisFile.getFolderName();
        File localFolder = themisFile.getLocalProjectFolder();
        if (!localFolder.isDirectory()) {
            return "Das lokale Verzeichnis existiert nicht: '" + localFolder.getAbsolutePath() + "'";
        }
        folder.mkdirs();
        File projectFolder = new File(folder, fn);
        if (projectFolder.exists()) {
            return "In dem ausgew\u00e4hlten Ordner existiert bereits eine gleichnamige Datei: '" + fn + "'";
        }
        projectFolder.mkdirs();
        try {
            Util.copy((File)localFolder, (File)projectFolder);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return "Fehler beim Kopieren: " + ex.getMessage();
        }
        Util.delete((File)localFolder);
        return null;
    }

    public boolean isOpen() {
        boolean b1 = this.projectFolder != null;
        boolean b2 = this.getDatastorage() != null && this.getDatastorage().isConnected();
        return b1 && b2 && !this.isOpening;
    }

    public ArrayList<ThemisFolder> checkLocalProjects() {
        ArrayList<ThemisFolder> themisfiles = new ArrayList<ThemisFolder>();
        File fld = this.app.getApplicationDataLocalProjectsFolder();
        File[] files = fld.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.getName().endsWith("_null")) {
                    this.getFileAccess().delete(f);
                    continue;
                }
                ThemisFolder tf = ThemisFolder.fromLocalProject(f);
                if (tf == null) continue;
                themisfiles.add(tf);
            }
        }
        return themisfiles;
    }

    public CmsProject getProjectElement() {
        return this.project;
    }

    public long getLastElementId() {
        if (!this.isOpen()) {
            return -1L;
        }
        DataRecord rec = this.getDatastorage().executeQuery("SELECT max(idelement) AS maxid FROM tdtaElement", true).firstRow();
        if (rec != null) {
            return rec.getLong("maxid");
        }
        return 0L;
    }

    public long getLastUploadId() {
        if (!this.isOpen()) {
            return -1L;
        }
        DataRecord rec = this.getDatastorage().executeQuery("SELECT max(idfileupload) AS maxid FROM tdtaFileUpload", true).firstRow();
        if (rec != null) {
            return rec.getLong("maxid");
        }
        return 0L;
    }

    public Date getLastAccessDate() {
        if (!this.isOpen()) {
            return null;
        }
        DataRecord rec = this.getDatastorage().executeQuery("SELECT max(metalastedit) AS maxdate FROM tdtaElementLng", true).firstRow();
        if (rec != null) {
            return rec.getDate("maxdate", this.getTimeZone());
        }
        return null;
    }

    public Date getFirstAccessDate() {
        if (!this.isOpen()) {
            return null;
        }
        DataRecord rec = this.getDatastorage().executeQuery("SELECT min(metalastedit) AS mindate FROM tdtaElementLng", true).firstRow();
        if (rec != null) {
            return rec.getDate("mindate", this.getTimeZone());
        }
        return null;
    }

    public int countElementsSince(Date dt, String elementtype) {
        if (!this.isOpen()) {
            return 0;
        }
        String where = " true ";
        where = where + (elementtype == null ? VERSION_BETA : " AND elementtype=" + Util.toSqlString((String)elementtype));
        where = where + (dt == null ? VERSION_BETA : " AND el.metacreated > " + Util.toSqlString((Date)dt, (TimeZone)this.getTimeZone()));
        DataRecord rec = this.getDatastorage().executeQuery("SELECT count(e.idelement) AS count FROM tdtaElement AS e INNER JOIN tdtaelementlng AS el ON (e.idelement=el.idelement) WHERE " + where, true).firstRow();
        if (rec != null) {
            return rec.getInt("count");
        }
        return 0;
    }

    public String getProjectPropertiesAsString() {
        StringWriter writer = new StringWriter();
        try {
            this.getDatastorage().getConfig().store(writer, VERSION_BETA);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.getBuffer().toString();
    }

    public final String getProjectProperty(String key) {
        if (this.isOpen()) {
            return this.getDatastorage().getConfig(key);
        }
        return null;
    }

    public final String getProjectProperty(String key, String defaultvalue) {
        String result = this.getProjectProperty(key);
        return result == null ? defaultvalue : result;
    }

    public final void setProjectProperties(Properties props) {
        for (String k : props.stringPropertyNames()) {
            if (this.getProjectCode().equals(k) || "ontologyversion".equals(k)) continue;
            this.setProjectProperty(k, props.getProperty(k));
        }
    }

    public final void setProjectProperty(String key, String value) {
        this.setProjectProperty(key, value, true);
    }

    public final void setProjectProperty(String key, String value, boolean save) {
        if (this.isOpen()) {
            this.getDatastorage().setConfig(key, value);
        } else {
            this.app.getDialog().showErrorDialog("error.cannot-write-properites-without-project");
        }
    }

    public ArrayList<String> getAttributes() {
        ArrayList<String> atts = new ArrayList<String>();
        for (CmsAttribute att : this.getDefaultElement(CMS_OBSERVATION).getDataAttributes()) {
            if (att.isOfType(18) || att.isOfType(17) || att.isHidden()) continue;
            atts.add("observation." + att.getCode());
        }
        for (CmsAttribute att : this.getDefaultElement(CMS_LOCATION).getDataAttributes()) {
            if (att.isOfType(18) || att.isOfType(17) || att.isHidden()) continue;
            atts.add("location." + att.getCode());
        }
        return atts;
    }

    public void createActionLog(String action, long idelement, String actiontext) {
        if (this.isOpen()) {
            CmsElement ele = this.createElement(CMS_ACTION);
            ele.setAttributeValue("username", this.getUser().getUsername());
            ele.setAttributeValue(CMS_ACTION, action);
            ele.setAttributeValue("actiontext", actiontext);
            ele.getLongAttribute("elementid").setValue(idelement);
            ele.setAttributeValue("hardwareid", this.app.getLicense().getHardwareId());
            ele.setAttributeValue("product", this.app.getLicense().getProductEdition());
            ele.save();
        }
    }

    public File getProjectFolder() {
        return this.projectFolder;
    }

    public ThemisFolder getThemisFile() {
        ThemisFolder tf = null;
        CmsProject ele = this.getProjectElement();
        if (this.projectFolder != null && ele != null) {
            tf = new ThemisFolder(this.getProjectFolder(), this.getProjectElement().getAttributeValue("title"), this.getProjectElement().getUUIDasString());
        }
        return tf;
    }

    public File getDatabaseFile() {
        return new File(this.getProjectFolder().getAbsolutePath() + "/" + FOLDER_DB + "/" + DB_NAME + ".h2.db");
    }

    public File getFileLocation() {
        if (this.useLocalDatabaseCopy) {
            ThemisFolder tf = this.getThemisFile();
            if (tf == null) {
                return null;
            }
            return tf.getLocalDataFolder();
        }
        if (this.getProjectFolder() == null) {
            return null;
        }
        return new File(this.getProjectFolder(), FOLDER_DATA);
    }

    public File getUploadFile(String elementtype, String filename) throws IOException {
        File fld = this.getProjectFolder();
        if (fld == null) {
            return null;
        }
        ThemisFolder tf = this.getThemisFile();
        if (tf == null) {
            File folder = new File(this.getProjectFolder(), FOLDER_DATA);
            return new File(folder, elementtype + "/" + filename);
        }
        File fLocal = new File(tf.getLocalDataFolder(), elementtype + "/" + filename);
        File fRemote = new File(tf.getProjectDataFolder(), elementtype + "/" + filename);
        if (this.useLocalDatabaseCopy) {
            if (fLocal.isFile()) {
                return fLocal;
            }
            if (fRemote.isFile()) {
                this.getFileAccess().copy(fRemote, fLocal);
            }
            return fLocal;
        }
        return fRemote;
    }

    public File getFileRemoteLocation() {
        return new File(this.getProjectFolder(), FOLDER_DATA);
    }

    public File getTempfileLocationBase() {
        File fld = this.getProjectFolder();
        if (fld == null) {
            return null;
        }
        ThemisFolder tf = this.getThemisFile();
        if (tf == null) {
            return this.app.getApplicationDataTempFolder();
        }
        if (this.useLocalDatabaseCopy) {
            tf.getLocalTempFolder().mkdirs();
            return tf.getLocalTempFolder();
        }
        tf.getProjectTempFolder().mkdirs();
        return tf.getProjectTempFolder();
    }

    public File getTempfileLocation() {
        File f = this.getTempfileLocationBase();
        if (this.tempSubfolderName == null) {
            this.createTempFolderProcess();
        }
        File fTemp = new File(f, this.tempSubfolderName);
        fTemp.mkdirs();
        return fTemp;
    }

    public void createTempFolderProcess() {
        this.tempSubfolderName = Long.toString(new Date().getTime());
    }

    public void clearTempfileLocation() {
        File[] files = this.getTempfileLocationBase().listFiles();
        if (files != null) {
            for (File f : files) {
                this.getFileAccess().delete(f);
            }
        }
    }

    public File getImagefileLocation() {
        File f = new File(this.getProjectFolder(), FOLDER_IMAGES);
        this.getFileAccess().mkdirs(f);
        return f;
    }

    public File getEmailsfileLocation() {
        File f = new File(this.getProjectFolder(), FOLDER_EMAILS);
        this.getFileAccess().mkdirs(f);
        return f;
    }

    public File getPlansnippetLocation() {
        File f = new File(this.getProjectFolder(), FOLDER_PLANSNIPPET);
        this.getFileAccess().mkdirs(f);
        return f;
    }

    public CmsUser getUser() {
        if (this.currentUser != null) {
            return this.currentUser;
        }
        String username = System.getProperty("user.name");
        if (username == null || VERSION_BETA.equals(username)) {
            this.currentUser = this.getAdminUser();
        } else if (this.isOpen()) {
            this.setUser(username);
        }
        return this.currentUser;
    }

    public void setUser(String username) {
        this.currentUser = this.createUser(username);
    }

    public CmsUser createUser(String username) {
        CmsUser newUser = null;
        long iduser = this.getDatastorage().checkUser(username);
        if (iduser < 0L) {
            long idgroup = this.getDatastorage().checkGroup(DB_NAME);
            if (idgroup < 0L) {
                CmsGroup g = (CmsGroup)this.createElement("group", this.getAdminUser());
                g.setAttributeValue("groupname", DB_NAME);
                g.save();
                idgroup = g.getId();
            }
            newUser = (CmsUser)this.createElement("user", this.getAdminUser());
            newUser.setAttributeValue("username", username);
            newUser.setAttributeValue("email", "no-email");
            newUser.setAttributeValue("sirname", "THEMIS");
            newUser.setMainGroup(idgroup, this.getAdminUser());
            newUser.addGroup(idgroup, 4L);
            newUser.save();
            newUser.setAuthenticated(true);
        } else {
            newUser = (CmsUser)this.loadElement(iduser, this.getAdminUser());
            newUser.setAuthenticated(true);
        }
        return newUser;
    }

    public ArrayList<String> getUsernames() {
        return this.getDatastorage().getUsernames();
    }

    @Deprecated
    public CmsEvent getCurrentEvent() {
        return this.getSelectionManager().getCurrentEvent();
    }

    @Deprecated
    public void updateCurrentEvent() {
        this.getSelectionManager().updateCurrentEvent();
    }

    @Deprecated
    public long getCurrentEventId() {
        return this.getSelectionManager().getCurrentEventId();
    }

    public boolean checkForCurrentEvent() {
        return this.checkForCurrentEvent(true);
    }

    public boolean checkForCurrentEvent(boolean showInfo) {
        if (this.getSelectionManager().getCurrentEvent() == null) {
            if (showInfo) {
                this.app.getDialog().showWarningDialog(this.app.getProject().getResourceText("app.core.text.noevent", this.app.getLocale()));
            }
            return false;
        }
        return true;
    }

    public boolean checkAndCreateEvent() {
        if (this.getCurrentEventId() > 0L) {
            return true;
        }
        boolean autoGenerate = this.app.getSettings().getDoAutoGenerateEvent();
        if (autoGenerate || this.app.getDialog().showOptionDialog(this.app.getProject().getResourceText("app.core.text.noevent.create", this.app.getLocale()), VERSION_BETA, new Object[]{this.app.getProject().getResourceText("event.buttoncreatenew", this.app.getLocale()), this.app.getProject().getResourceText("core.text.cancel", this.app.getLocale())})) {
            CmsEvent event = (CmsEvent)this.createElement(CMS_EVENT);
            event.setAttributeValue("title", this.app.getProject().getResourceText("app.core.text.event.auto", this.app.getLocale()));
            event.getDateAttribute("date").setDate(new Date());
            event.setAttributeValue("time", Util.formatDate((Date)new Date(), (String)"HH:mm:ss", (TimeZone)this.app.getTimeZone()));
            event.save();
            this.app.getActionProvider().invokeAction(ThemisAction.EVENT_SAVED.setId(event.getId()));
            this.setCurrentEvent(event);
            return true;
        }
        return false;
    }

    public void setCurrentEvent(CmsEvent e) {
        this.setCurrentEvent(e, true);
    }

    public void setCurrentEvent(CmsEvent e, boolean trigger) {
        this.getSelectionManager().setCurrentEvent(e, trigger, null);
    }

    @Deprecated
    public long getCurrentPlanId() {
        return this.getSelectionManager().getCurrentPlanId();
    }

    @Deprecated
    public void setCurrentPlanId(long id) {
        this.getSelectionManager().setCurrentPlan(id, true, null);
    }

    @Deprecated
    public void clearCurrentPlanId() {
        this.getSelectionManager().clearCurrentPlan();
    }

    public void setCopiedLocationId(long id) {
        this.copiedLocationId = id;
    }

    public long getCopiedLocationId() {
        return this.copiedLocationId;
    }

    public boolean hasCopiedLocationId() {
        return this.copiedLocationId > 0L;
    }

    public void clearCopiedLocationId() {
        this.copiedLocationId = -1L;
    }

    public void setEditLocGeometryId(long id) {
        this.editLocGeometryId = id;
    }

    public long getEditLocGeometryId() {
        return this.editLocGeometryId;
    }

    public boolean hasEditLocGeometryId() {
        return this.editLocGeometryId > 0L;
    }

    public void clearEditLocGeometryId() {
        this.editLocGeometryId = -1L;
    }

    public void setAddMapRefToLocId(long id) {
        this.mapRefToLocId = id;
    }

    public void setAddMapRefToLoc(CmsLocation loc) {
        this.mapRefToLoc = loc;
    }

    public long getAddMapRefToLocId() {
        return this.mapRefToLocId;
    }

    public CmsLocation getAddMapRefToLoc() {
        return this.mapRefToLoc;
    }

    public boolean hasAddMapRefToLocId() {
        return this.mapRefToLocId > 0L || this.mapRefToLoc != null;
    }

    public void clearAddMapRefToLocId() {
        this.mapRefToLocId = -1L;
        this.mapRefToLoc = null;
    }

    public void updateRecentLocTemplatesList(Long metaid, boolean remove) {
        this.recentLocTemplates.remove(metaid);
        if (!remove) {
            this.recentLocTemplates.add(0, metaid);
        }
        if (this.recentLocTemplates.size() > this.maxCountRecentLocTemplates) {
            this.recentLocTemplates.remove(this.recentLocTemplates.size() - 1);
        }
        for (int ii = 0; ii < this.recentLocTemplates.size(); ++ii) {
            this.setProjectProperty("lastlocationtemplateid." + ii, this.recentLocTemplates.get(ii).toString());
        }
    }

    public ArrayList<Long> getRecentLocTemplatesList() {
        return this.recentLocTemplates;
    }

    public void loadRecentLocTemplates() {
        if (this.isOpen()) {
            this.recentLocTemplates.clear();
            for (int ii = 0; ii < this.maxCountRecentLocTemplates; ++ii) {
                String metaid = this.getProjectProperty("lastlocationtemplateid." + ii, VERSION_BETA);
                if (metaid == null || VERSION_BETA.equals(metaid)) continue;
                this.recentLocTemplates.add(Long.parseLong(metaid));
            }
        }
    }

    public CmsElement createElement(String elementtype) {
        return this.createElement(elementtype, this.getUser());
    }

    public CmsHistory getHistoryElement(CmsEvent event, CmsObservation obs) {
        CmsHistory hist = (CmsHistory)this.getDefaultElement(CMS_HISTORY);
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this, this.getUser(), false);
        s.setElementtypes(CMS_HISTORY);
        s.addWhereRelationId(hist.getAttribute(CMS_EVENT), "=", Long.toString(event.getId()));
        s.addWhereRelationId(hist.getAttribute(CMS_OBSERVATION), "=", Long.toString(obs.getId()));
        SearchResult result = s.search();
        if (!result.isEmpty()) {
            return (CmsHistory)this.loadElement((Long)result.getResultIds().get(0), this.getUser());
        }
        return this.createHistoryElement(event, obs);
    }

    public CmsHistory createHistoryElement(CmsEvent event, CmsObservation obs) {
        CmsHistory hist = (CmsHistory)this.createElement(CMS_HISTORY);
        hist.setEventAndObservation(event, obs);
        return hist;
    }

    public void setObservationAsDoneNotDone(long observationId, boolean done) {
        this.setObservationAsDoneNotDone((CmsObservation)this.loadElement(observationId, this.getUser()), done, true);
    }

    public void setObservationAsDoneNotDone(CmsObservation obs, boolean done) {
        this.setObservationAsDoneNotDone(obs, done, true);
    }

    public void setObservationAsDoneNotDone(long observationId, boolean done, boolean trigger) {
        this.setObservationAsDoneNotDone((CmsObservation)this.loadElement(observationId, this.getUser()), done, trigger);
    }

    public void setObservationAsDoneNotDone(CmsObservation obs, boolean done, boolean trigger) {
        if (this.getCurrentEvent() == null) {
            return;
        }
        if (obs.isOfType(1) || obs.isOfType(4)) {
            obs.setDone(done);
            obs.save();
            if (trigger) {
                this.app.getFilter().resetSearchResult();
                this.app.getActionProvider().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setId(obs.getId()).from((Object)this, "observation set as " + (done ? "DONE" : "NOT DONE")));
            }
        }
    }

    public void setObservationAsReviewed(long observationId, boolean trigger) {
        this.setObservationAsReviewed((CmsObservation)this.loadElement(observationId, this.getUser()), trigger);
    }

    public void setObservationAsReviewed(CmsObservation obs, boolean trigger) {
        if (this.getCurrentEvent() == null) {
            return;
        }
        if (obs.isOfType(2)) {
            int n = obs.applyRepeatPeriod();
        }
        obs.save();
        if (trigger) {
            this.app.getFilter().resetSearchResult();
            this.app.getActionProvider().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setElementtype(CMS_OBSERVATION).setId(obs.getId()).from((Object)this, "observation set as reviewd"));
        }
    }

    public boolean setObservationAsNotReviewed(long observationId) {
        return this.setObservationAsNotReviewed((CmsObservation)this.loadElement(observationId, this.getUser()));
    }

    public boolean setObservationAsNotReviewed(long observationId, boolean trigger) {
        return this.setObservationAsNotReviewed((CmsObservation)this.loadElement(observationId, this.getUser()), trigger);
    }

    public boolean setObservationAsNotReviewed(CmsObservation obs) {
        return this.setObservationAsNotReviewed(obs, true);
    }

    public boolean setObservationAsNotReviewed(CmsObservation obs, boolean trigger) {
        if (this.getCurrentEvent() == null) {
            return false;
        }
        CmsHistory hist = this.getHistoryElement(this.getSelectionManager().getCurrentEvent(), obs);
        if (!hist.isNew() && obs.getRelationAttribute("histories").size() > 1) {
            obs.removeHistory(hist.getId());
            if (trigger) {
                this.app.getFilter().resetSearchResult();
                this.app.getActionProvider().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setElementtype(CMS_OBSERVATION).setId(obs.getId()).from((Object)this, "observation set as NOT_REVIEWD"));
            }
            return true;
        }
        return false;
    }

    public ArrayList<CmsElementSummary> getEvents() {
        return this.getEventSearchResult().getResultAsElementSummary();
    }

    public ArrayList<CmsElementSummary> getEventsSigned() {
        return this.getEventSearchResult(-1, -1, true).getResultAsElementSummary();
    }

    public boolean isObservationInSignedEvent(long observationId) {
        String sql = "SELECT e.idelement FROM tdtaEleEvent AS e INNER JOIN tdtaRelation AS r1 ON (e.idelement=r1.elementto AND r1.relationcode='historyevent') INNER JOIN tdtaRelation AS r2 ON (r1.elementfrom=r2.elementfrom AND r2.relationcode='historyobservation') INNER JOIN tdtaFileUpload AS f ON (f.idelement=r1.elementto AND f.code='signature') WHERE r2.elementto=" + observationId;
        return !this.getDatastorage().executeQuery(sql, true).isEmpty();
    }

    public boolean isEventSigned(long idElement) {
        String sql = "SELECT idfileupload FROM tdtaFileUpload WHERE code='signature' AND idelement=" + idElement;
        DataRecord rec = this.getDatastorage().executeQuery(sql, true).firstRow();
        return rec != null;
    }

    public boolean isEventStarted(long idElement) {
        String sql = "SELECT idelement FROM tdtaElement AS h INNER JOIN tdtaRelation AS r ON (h.idelement=r.elementfrom AND r.relationcode='historyevent') WHERE NOT h.deleted AND r.elementto=" + idElement;
        return this.getDatastorage().executeQuery(sql, true).size() > 0;
    }

    public Date getEventDate(long idElement) {
        String sql = "SELECT date AS dt FROM tdtaEleEvent AS e WHERE e.idelement=" + idElement;
        DataRecord rec = this.getDatastorage().executeQuery(sql, true).firstRow();
        return rec == null ? null : rec.getDate("dt", TimeZone.getDefault());
    }

    public SearchResult getEventSearchResult() {
        return this.getEventSearchResult(-1, -1, false);
    }

    public SearchResult getEventSearchResult(int year) {
        return this.getEventSearchResult(year, false);
    }

    public SearchResult getEventSearchResult(int year, boolean locked) {
        return this.getEventSearchResult(year, -1, locked);
    }

    public SearchResult getEventSearchResult(int year, int month, boolean locked) {
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this, this.getUser(), false);
        s.setElementtypes(CMS_EVENT);
        s.addSelectMeta();
        s.addSelectAttribute(this.getDefaultElement(CMS_EVENT).getAttribute("date"));
        s.addSelectAttribute(this.getDefaultElement(CMS_EVENT).getAttribute("timehours"));
        s.addSelectAttribute(this.getDefaultElement(CMS_EVENT).getAttribute("time"));
        s.addSelectAttribute(this.getDefaultElement(CMS_EVENT).getAttribute("place"));
        s.addSelectUploadItem(this.getDefaultElement(CMS_EVENT).getAttribute("signature"));
        if (year > 0) {
            s.addWhere("year(ele.date)=" + year);
        }
        if (month > 0) {
            s.addWhere("month(ele.date)=" + month);
        }
        if (locked) {
            s.addWhere("signaturetbl.idfileupload IS NOT NULL");
        }
        s.setSort("ele.date desc,ele.timehours desc,e.idelement desc");
        SearchResult search = s.search();
        return search;
    }

    public SearchResult getEventSearchResult(Date fromDate, Date untilDate) {
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this, this.getUser(), false);
        s.setElementtypes(CMS_EVENT);
        s.addSelectMeta();
        s.addSelectAttribute(this.getDefaultElement(CMS_EVENT).getAttribute("date"));
        s.addSelectAttribute(this.getDefaultElement(CMS_EVENT).getAttribute("timehours"));
        s.addSelectAttribute(this.getDefaultElement(CMS_EVENT).getAttribute("time"));
        s.addSelectAttribute(this.getDefaultElement(CMS_EVENT).getAttribute("place"));
        s.addSelectUploadItem(this.getDefaultElement(CMS_EVENT).getAttribute("signature"));
        if (fromDate != null) {
            s.addWhere("ele.date >= " + Util.toSqlString((Date)fromDate, (TimeZone)this.app.getTimeZone()));
        }
        if (untilDate != null) {
            s.addWhere("ele.date <= " + Util.toSqlString((Date)untilDate, (TimeZone)this.app.getTimeZone()));
        }
        s.setSort("ele.date,ele.timehours,e.idelement");
        SearchResult r = s.search();
        String sql = r.getSql();
        return r;
    }

    public ArrayList<CmsBasicElement> getEventsForToday() {
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this, this.getUser(), false);
        s.setElementtypes(CMS_EVENT);
        s.addSelectMeta();
        s.addSelectAttribute(this.getDefaultElement(CMS_EVENT).getAttribute("date"));
        s.addSelectAttribute(this.getDefaultElement(CMS_EVENT).getAttribute("timehours"));
        s.addWhere("cast(ele.date as date)=" + Util.toSqlString((String)Util.formatDate((Date)new Date(), (String)Util.DATE_SQL, (TimeZone)this.getTimeZone())));
        s.setSort("ele.timehours desc,e.idelement desc");
        return s.search().getResultAsBasicElements();
    }

    public Pair<Date, Date> getEventDateRange() {
        DataRecord rec = this.getDatastorage().executeQuery("SELECT min(ev.date) AS mindate, max(ev.date) AS maxdate FROM tdtaEleEvent AS ev INNER JOIN tdtaElement AS e ON (ev.idelement=e.idelement) WHERE NOT e.deleted", true).firstRow();
        Date dt1 = null;
        Date dt2 = null;
        if (rec != null) {
            dt1 = rec.getDate("mindate", this.getTimeZone());
            dt2 = rec.getDate("maxdate", this.getTimeZone());
        }
        return new Pair(dt1, dt2);
    }

    public ArrayList<CmsBasicElement> getContacts() {
        if (!this.isOpen()) {
            return new ArrayList<CmsBasicElement>();
        }
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this, this.getUser(), CMS_COMPANY);
        s.addSelectMeta();
        return s.search().getResultAsBasicElements();
    }

    public CmsFormular getFormByAlias(String name) {
        if (name == null) {
            return null;
        }
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this, this.getUser(), CMS_FORMULAR);
        s.addWhereAttribute(this.getDefaultElement(CMS_FORMULAR).getAttribute("alias"), "=", name);
        ArrayList ids = s.search().getResultIds();
        if (ids.isEmpty()) {
            return null;
        }
        return (CmsFormular)this.loadElement((Long)ids.get(0), this.getUser());
    }

    public CmsFormular getFormById(long id) {
        CmsElement e = this.loadElement(id, this.getUser());
        if (e == null || !(e instanceof CmsFormular)) {
            return null;
        }
        return (CmsFormular)e;
    }

    public ArrayList<CmsBasicElement> getReportTemplates() {
        if (!this.isOpen()) {
            return new ArrayList<CmsBasicElement>();
        }
        ArrayList<CmsBasicElement> layouts = new ArrayList<CmsBasicElement>();
        if (ThemisLicense.isLicenseLevelExact(ThemisLicense.LicenseLevel.FULL)) {
            CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this, this.getUser(), CMS_REPORT);
            s.addSelectMeta();
            s.setSort("upper(el.title)");
            layouts.addAll(s.search().getResultAsBasicElements());
            if (layouts.isEmpty()) {
                CmsReport rep = (CmsReport)this.loadElement(CmsReport.DEFAULT_UUID, this.getUser());
                if (rep == null) {
                    rep = (CmsReport)this.createElement(CMS_REPORT);
                    rep.setReportFromXml(this.app.getSettings().getDefaultReportLayout());
                    rep.setLayoutName("Standard-Tabelle");
                    rep.save();
                } else {
                    rep.restoreFromTrash();
                }
                layouts.add(new CmsBasicElement((CmsElement)rep));
            }
        }
        return layouts;
    }

    public String getNewReportTemplateName(String name) {
        ArrayList<CmsBasicElement> templates = this.getReportTemplates();
        ArrayList<String> usedNames = new ArrayList<String>();
        for (CmsBasicElement be : templates) {
            usedNames.add(be.getTitle().substring(6).toLowerCase());
        }
        int counter = 1;
        String newName = name;
        while (usedNames.contains(newName.toLowerCase())) {
            newName = name + " (" + ++counter + ")";
        }
        return newName;
    }

    public void clearReportTableLayouts() {
        this.getDatastorage().executeUpdate("DELETE FROM tdtaElement WHERE idElement IN (SELECT idElement FROM tdtaEleReporttable)", true);
    }

    public ReportTableLayout getReportTableLayout(String name) {
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this, this.getUser(), CMS_REPORTTABLE);
        s.addSelectMeta();
        s.setSort("upper(el.title)");
        s.addWhere("el.title", "=", Util.toSqlString((String)name));
        ArrayList ids = s.search().getResultIds();
        return ids.isEmpty() ? null : (ReportTableLayout)this.loadElement((Long)ids.get(0), this.getUser());
    }

    public boolean hasReportTableLayout(String name) {
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this, this.getUser(), CMS_REPORTTABLE);
        s.addSelectMeta();
        s.setSort("upper(el.title)");
        s.addWhere("el.title", "=", Util.toSqlString((String)name));
        ArrayList ids = s.search().getResultIds();
        return !ids.isEmpty();
    }

    public ArrayList<ReportTableLayout> getReportTableLayouts() {
        if (!this.isOpen()) {
            return new ArrayList<ReportTableLayout>();
        }
        ArrayList<ReportTableLayout> layouts = new ArrayList<ReportTableLayout>();
        if (ThemisLicense.isLicenseLevelExact(ThemisLicense.LicenseLevel.FULL)) {
            CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this, this.getUser(), CMS_REPORTTABLE);
            s.addSelectMeta();
            s.setSort("upper(el.title)");
            Iterator iterator = s.search().getResultIds().iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                layouts.add((ReportTableLayout)this.loadElement(id, this.getUser()));
            }
        }
        return layouts;
    }

    public ArrayList<Long> getReportTableLayoutIds() {
        if (!this.isOpen()) {
            return new ArrayList<Long>();
        }
        return new CmsBasicSearch((CmsApplication)this, this.getUser(), CMS_REPORTTABLE).search().getResultIds();
    }

    public void addReportTableLayout(ReportTableLayout rtl) {
        ReportTableLayout rtlNew = (ReportTableLayout)this.createElement(CMS_REPORTTABLE);
        rtlNew.fromXML(rtl.getXml());
        rtlNew.setName(rtl.getName());
        rtlNew.save();
    }

    public ArrayList<String> getReportTableNames() {
        ArrayList<String> usedNames = new ArrayList<String>();
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this, this.getUser(), CMS_REPORTTABLE);
        s.addSelectMeta();
        s.setSort("upper(el.title)");
        for (CmsBasicElement be : s.search().getResultAsBasicElements()) {
            usedNames.add(be.getTitle());
        }
        return usedNames;
    }

    public String getNewReportTableName(String name) {
        ArrayList<String> usedNames = this.getReportTableNames();
        int counter = 1;
        String newName = name;
        while (usedNames.contains(newName)) {
            newName = name + " (" + ++counter + ")";
        }
        return newName;
    }

    public ArrayList<CmsElementSummary> getDocuments() {
        if (!this.isOpen()) {
            return new ArrayList<CmsElementSummary>();
        }
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this, this.getUser(), CMS_INFO);
        s.addSelectMeta();
        return s.search().getResultAsElementSummary();
    }

    public ArrayList<CmsElementSummary> getPlans() {
        if (!this.isOpen()) {
            return new ArrayList<CmsElementSummary>();
        }
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this, this.getUser(), CMS_PLAN);
        s.addSelectMeta();
        s.addElementJoin(CMS_PLAN, CMS_PLAN);
        s.addSelect("plan.sort", "sort");
        s.setSort("plan.sort");
        s.addSelect("plan.currentplanfile", "currentplanfile");
        return s.search().getResultAsElementSummary();
    }

    public ArrayList<CmsBasicElement> getPlansWithBuildings() {
        ArrayList<CmsBasicElement> result = new ArrayList<CmsBasicElement>();
        if (!this.isOpen()) {
            return result;
        }
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this, this.getUser(), CMS_PLAN);
        s.addSelectMeta();
        s.addElementJoin(CMS_PLAN, CMS_PLAN);
        s.addSelect("plan.sort", "sort");
        s.addSelect("plan.currentplanfile", "currentplanfile");
        CmsAttribute att = this.getDefaultElement(CMS_PLAN).getAttribute("building");
        s.addSelectRelationTerm(att);
        s.setSort("planbuilding,sort");
        for (DataRecord rec : s.search().getResult()) {
            CmsBasicElement be = new CmsBasicElement(rec);
            String b = rec.getString("planbuilding");
            if (b == null) {
                b = VERSION_BETA;
            }
            if (!VERSION_BETA.equals(b)) {
                b = "[" + b + "] ";
            }
            be.setTitle(b + be.getTitle());
            result.add(be);
        }
        return result;
    }

    public ArrayList<Long> getBuildingForPlan(long idPlan) {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(idPlan);
        return this.getBuildingForPlan(ids);
    }

    public ArrayList<Long> getBuildingForPlan(ArrayList<Long> idPlans) {
        CmsElement building = this.getApplication().getDefaultElement(CMS_LOCATION);
        CmsAttribute attBuilding = building.getAttribute("building");
        CmsAttribute attPlan = building.getAttribute("buildingplans");
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this, this.getUser(), CMS_LOCATION);
        s.addSelectMeta();
        s.addSelectAttribute(attBuilding);
        s.addWhereRelationId(attPlan, "IN", Util.toSqlString(idPlans, (boolean)false));
        s.addWhereBoolean("ele." + attBuilding.getField(), true);
        return s.search().getResultIds();
    }

    public ArrayList<CmsElementSummary> getPlansForBuilding(long idBuilding) {
        CmsElement plan = this.getApplication().getDefaultElement(CMS_PLAN);
        CmsAttribute att = plan.getAttribute("building");
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this, this.getUser(), CMS_PLAN);
        s.addSelectMeta();
        s.addSelectAttribute(plan.getAttribute("sort"));
        s.addSelectRelationId(att);
        if (idBuilding >= 0L) {
            s.addWhereRelationId(att, "=", Long.toString(idBuilding));
        } else {
            s.addWhereRelationNone(att);
        }
        s.addElementJoin(CMS_PLAN, CMS_PLAN);
        s.addSelect("plan.sort", "sort");
        s.setSort("plan.sort");
        return s.search().getResultAsElementSummary();
    }

    public CmsPlan createPlan(long idBuilding) {
        if (ThemisLicense.isLicenseLevelExact(ThemisLicense.LicenseLevel.NONE) || ThemisLicense.isLicenseLevelLessThan(ThemisLicense.LicenseLevel.FULL) && this.getPlans().size() >= 15) {
            return null;
        }
        CmsPlan ele = (CmsPlan)this.createElement(CMS_PLAN);
        if (idBuilding > 0L) {
            ele.getRelationAttribute("building").add(idBuilding);
        }
        return ele;
    }

    public CmsLocation createLocation(long templateId) {
        CmsLocation location = (CmsLocation)this.createElement(CMS_LOCATION);
        if (templateId > 0L) {
            CmsLocationTemplate template = (CmsLocationTemplate)this.loadElement(templateId, this.getUser());
            template.applyTo(location);
            location.getLongAttribute("templateid").setValue(template.getId());
            this.setProjectProperty(CONF_LAST_LOCATIONTEMPLATE_ID, template.getId() + VERSION_BETA);
            this.updateRecentLocTemplatesList(template.getId(), false);
        }
        return location;
    }

    public CmsObservation createObservation(CmsLocation location) {
        CmsObservation obs = (CmsObservation)this.createElement(CMS_OBSERVATION);
        obs.setLocation(location);
        obs.setNumber(location.getNextObservationNumber());
        location.updateMD5();
        return obs;
    }

    public ArrayList<CmsElementSummary> getLocations() {
        CmsElement loc = this.getApplication().getDefaultElement(CMS_LOCATION);
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this, this.getUser(), CMS_LOCATION);
        s.addSelectMeta();
        s.addSelectAttribute(loc.getAttribute("number"));
        s.setSort(loc.getAttribute("number"));
        return s.search().getResultAsElementSummary();
    }

    public CmsLocation getLocationForObservation(long obsId) {
        CmsElement loc = this.getApplication().getDefaultElement(CMS_LOCATION);
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this, this.getUser(), CMS_LOCATION);
        s.addSelectMeta();
        s.addWhereRelationId(loc.getAttribute("observations"), "=", Long.toString(obsId));
        ArrayList ids = s.search().getResultIds();
        if (ids.isEmpty()) {
            return null;
        }
        return (CmsLocation)this.loadElement((Long)ids.get(0), this.getUser());
    }

    public ArrayList<CmsElementSummary> getLocationsInPlan(long idPlan) {
        CmsElement loc = this.getApplication().getDefaultElement(CMS_LOCATION);
        CmsAttribute att = loc.getAttribute(CMS_PLAN);
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this, this.getUser(), CMS_LOCATION);
        s.addSelectMeta();
        s.addSelectAttribute(loc.getAttribute("number"));
        s.addSelectRelationId(att);
        s.addWhereAttribute(att, "=", Long.toString(idPlan));
        CmsLocation l = new CmsLocation();
        l.getRelationAttribute(CMS_OBSERVATION).getElements();
        s.setSort(loc.getAttribute("number"));
        return s.search().getResultAsElementSummary();
    }

    public void updateAllLocationNumbers(int startnumber, String sort, ProgressHandler ph) {
        if (sort == null) {
            sort = "b.title,p.sort,l.idelement";
        }
        ArrayList locationids = this.getDatastorage().executeQuery("SELECT l.idelement AS meta_id, l.number AS number, p.buildingtitle AS building, p.sort AS plansort FROM tdtaelelocation AS l LEFT JOIN tdtarelation AS r on (l.idelement=r.elementfrom AND r.relationcode='locationplan') LEFT JOIN tdtaeleplan as p on (r.elementto=p.idelement) LEFT JOIN tdtaRelation as r2 on (r2.elementfrom=p.idelement AND r2.relationcode='planbuilding') LEFT JOIN tdtaElementLng AS b ON (r2.elementto=b.idelement) ORDER BY " + sort, true).getResultIds();
        ph.switchToDeterminate(locationids.size());
        ph.progress(this.getResourceText("project.reset-location-numbers.progress", this.app.getLocale()), 1);
        int progressCounter = 1;
        this.getDatastorage().executeUpdate("UPDATE tdtaelelocation SET number = " + (startnumber - 1), true);
        Iterator iterator = locationids.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            CmsLocation l = (CmsLocation)this.loadElement(id, this.getUser());
            if (l.isTrash()) {
                l.setAttributeValue("number", "-1");
            } else {
                l.createNewNumber();
            }
            l.save();
            ph.progress(progressCounter++);
        }
        ph.progressDone();
        this.app.getFilter().resetSearchResult();
        this.app.getActionProvider().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED);
    }

    public void updateObservationNumbers(ProgressHandler ph) {
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this, this.getAdminUser(), CMS_LOCATION);
        List recs = s.search().getResult();
        ph.switchToDeterminate(recs.size());
        ph.progress(this.getResourceText("project.reset-observation-numbers.progress", this.app.getLocale()), 1);
        int progressCounter = 1;
        for (DataRecord rec : recs) {
            CmsLocation loc = (CmsLocation)this.loadElement(rec.getLong("meta_id"), this.getAdminUser());
            loc.updateObservationNumbers();
            ph.progress(progressCounter++);
        }
        ph.progressDone();
        this.app.getActionProvider().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setElementtype(CMS_OBSERVATION));
    }

    public ArrayList<SimpleGeometry> getDrawings(long idupload) {
        ArrayList<SimpleGeometry> result = new ArrayList<SimpleGeometry>();
        List recs = this.getDatastorage().executeQuery("SELECT * FROM tdtaDrawing WHERE idfileupload = " + idupload, true).getResult();
        long lastGeometryId = 0L;
        for (DataRecord rec : recs) {
            String wkt = rec.getString("geometry");
            if ("LINESTRING EMPTY".equalsIgnoreCase(wkt)) continue;
            try {
                SimpleGeometry g = SimpleGeometry.fromWKT((String)rec.getString("geometry"));
                g.setType(rec.getInt("geometrytype").intValue());
                g.setId(rec.getLong("idgeometry").longValue());
                g.getDisplay().setColor(rec.getInt("color"), true);
                g.getDisplay().setLinewidth(rec.getInt("linewidth"), true);
                result.add(g);
            }
            catch (IllegalArgumentException ex) {
                ThemisLogger.logger.warning("Cannot create geometry with String '" + rec.getString("geometry"));
            }
        }
        return result;
    }

    public ArrayList<CmsElementSummary> getBuildings() {
        CmsElement loc = this.getApplication().getDefaultElement(CMS_LOCATION);
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this, this.getUser(), CMS_LOCATION);
        s.addSelectMeta();
        s.removeSelect("el.title");
        s.addSelect("ele.titel", "meta_title");
        s.addSelectAttribute(loc.getAttribute("building"));
        s.addWhereBoolean("ele.building", true);
        s.setSort("ele.titel");
        return s.search().getResultAsElementSummary();
    }

    public ArrayList<CmsBasicElement> getFilters() {
        if (!this.isOpen()) {
            return new ArrayList<CmsBasicElement>();
        }
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this, this.getUser(), CMS_FILTER);
        s.addSelectMeta();
        s.setSort("el.title");
        return s.search().getResultAsBasicElements();
    }

    public CmsFilter getFilterByName(String name) {
        if (name == null) {
            return null;
        }
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this, this.getUser(), CMS_FILTER);
        s.addWhereAttribute(this.getDefaultElement(CMS_FILTER).getAttribute("name"), "=", name);
        ArrayList ids = s.search().getResultIds();
        if (ids.isEmpty()) {
            return null;
        }
        return (CmsFilter)this.loadElement((Long)ids.get(0), this.getUser());
    }

    public String getNewFilterName(String name) {
        ArrayList<CmsBasicElement> filters = this.getFilters();
        ArrayList<String> usedNames = new ArrayList<String>();
        for (CmsBasicElement be : filters) {
            usedNames.add(be.getTitle().toLowerCase());
        }
        int counter = 1;
        String newName = name;
        while (usedNames.contains(newName)) {
            newName = name + " (" + ++counter + ")";
        }
        return newName;
    }

    public ArrayList<CmsBasicElement> getJobTemplates() {
        ArrayList<CmsBasicElement> result = new ArrayList<CmsBasicElement>();
        if (!this.isOpen()) {
            return result;
        }
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this, this.getUser(), CMS_JOBTEMPLATE);
        s.addSelectMeta();
        s.addSelectAllAttributes(CMS_JOBTEMPLATE);
        s.setSort("el.title");
        for (DataRecord rec : s.search().getResult()) {
            CmsBasicElement ele = new CmsBasicElement(rec);
            ele.setAttribute("autoexecute", rec.getBoolean("jobtemplateautoexecute") != false ? "true" : "false");
            result.add(ele);
        }
        return result;
    }

    public String getIconName(String filename) {
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this, this.getUser());
        s.setElementtypes(CMS_ICON);
        s.addSelectAttribute(this.getDefaultElement(CMS_ICON).getAttribute("title"));
        s.addSelectUploadItem((CmsAttribute)this.getDefaultElement(CMS_ICON).getUploadAttribute("file"));
        s.addWhere("iconfiletbl.name", "=", Util.toSqlString((String)filename));
        List recs = s.search().getResult();
        if (recs.isEmpty()) {
            return null;
        }
        return ((DataRecord)recs.get(0)).getString("icontitle");
    }

    public CmsElement getIconByFile(String filename) {
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this, this.getUser());
        s.setElementtypes(CMS_ICON);
        s.addSelectAttribute(this.getDefaultElement(CMS_ICON).getAttribute("title"));
        s.addSelectUploadItem((CmsAttribute)this.getDefaultElement(CMS_ICON).getUploadAttribute("file"));
        s.addWhere("iconfiletbl.name", "=", Util.toSqlString((String)filename));
        List recs = s.search().getResult();
        if (recs.isEmpty()) {
            return null;
        }
        return this.loadElement(((DataRecord)recs.get(0)).getLong("meta_id"), this.getUser());
    }

    public CmsElement getIcon(String iconname) {
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this, this.getUser());
        s.setElementtypes(CMS_ICON);
        s.addSelectAttribute(this.getDefaultElement(CMS_ICON).getAttribute("title"));
        s.addWhere("ele.title", "=", Util.toSqlString((String)iconname));
        DataRecord rec = s.search().firstRow();
        if (rec == null) {
            return null;
        }
        return this.loadElement(rec.getLong("meta_id"), this.getUser());
    }

    public Map<Long, CmsIcon> loadIcons() {
        ThemisProject project = ThemisApplication.getInstance().getProject();
        HashMap<Long, CmsIcon> icons = new HashMap<Long, CmsIcon>();
        if (this.isOpen()) {
            CmsSqlSearch s = new CmsSqlSearch((CmsApplication)project, project.getUser(), false);
            s.setElementtypes(CMS_ICON);
            s.setSort("el.title");
            s.addSelectMeta();
            ArrayList result = s.search().getResultAsElementSummary();
            for (CmsElementSummary sum : result) {
                icons.put(sum.getId(), (CmsIcon)sum.getElement());
            }
        }
        return icons;
    }

    public ArrayList<CmsBasicElement> getIcons() {
        ArrayList<CmsBasicElement> icons = new ArrayList<CmsBasicElement>();
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this, this.getUser(), false);
        s.setElementtypes(CMS_ICON);
        s.setSort("el.title");
        s.addSelectMeta();
        s.addSelectAttribute((CmsAttribute)this.getDefaultElement(CMS_ICON).getUploadAttribute("file"));
        SearchResult result = s.search();
        for (DataRecord rec : result.getResult()) {
            CmsBasicElement item = new CmsBasicElement(rec);
            item.setAttribute("file", rec.getString("filepath"));
            icons.add(item);
        }
        return icons;
    }

    public String getVersion() {
        return VERSION;
    }

    public String getVersionNumber() {
        return 6.1f + (VERSION_BETA.equals("2") ? VERSION_BETA : ".") + "2";
    }

    public CmsApplication getApplication() {
        return this;
    }

    public TemplateManager getTemplateManger() {
        return this.templateManager;
    }

    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public PlanManager getPlanManager() {
        return this.planManager;
    }

    public void postCreateTables() throws SQLException {
        if (!this.getDatastorage().hasTable("tdtaDrawing")) {
            String fieldTypeTextarea = this.getDatastorage().getFieldType(13, 0);
            String fieldTypeInteger = this.getDatastorage().getFieldType(7, 0);
            this.getDatastorage().executeUpdate("CREATE TABLE tdtaDrawing (idfileupload BIGINT, idgeometry BIGINT, geometry " + fieldTypeTextarea + ", geometrytype " + fieldTypeInteger + ", color " + fieldTypeInteger + ", linewidth " + fieldTypeInteger + ", PRIMARY KEY (idfileupload,idgeometry));", true);
        }
        if (!this.getDatastorage().hasTable("trelEventElement")) {
            this.getDatastorage().executeUpdate("CREATE TABLE trelEventElement (idevent BIGINT references tdtaEleEvent(idelement) ON UPDATE cascade ON DELETE cascade, idelement BIGINT references tdtaElement(idelement) ON UPDATE cascade ON DELETE cascade, PRIMARY KEY (idevent,idelement));", true);
        }
    }

    protected synchronized void updateApplicationDatabase(ProgressHandler ph, int progressStep) {
        ThemisProjectUpdater.getInstance().update(ThemisProjectUpdater.Phase.INIT, ph);
    }

    public static void clearProjectFolderAnalysis() {
        notAccessableFiles.clear();
    }

    private static boolean addNotAccessableFile(File f) {
        notAccessableFiles.add(f.getAbsolutePath());
        if (notAccessableFiles.size() > 100) {
            notAccessableFiles.remove(0);
        }
        return false;
    }

    private static boolean removeNotAccessableFile(File f) {
        notAccessableFiles.remove(f.getAbsolutePath());
        return false;
    }

    public static boolean isProjectFolder(File folder) {
        if (folder == null) {
            return false;
        }
        if (notAccessableFiles.contains(folder.getAbsolutePath())) {
            return false;
        }
        if (!folder.isDirectory()) {
            return ThemisProject.addNotAccessableFile(folder);
        }
        if (!new File(folder, "statistics.properties").isFile()) {
            return ThemisProject.addNotAccessableFile(folder);
        }
        return true;
    }

    public static boolean isProjectFolderAndroidReplacement(File folder) {
        File f_android = new File(folder, "db/themis.h2.db.android");
        return f_android.isFile();
    }

    public void renameAndroidReplacementFile(File folder) {
        File f = new File(folder, "db/themis.h2.db");
        File f_android = new File(folder, "db/themis.h2.db.android");
        f_android.renameTo(f);
    }

    public int getObservationCount() {
        DataRecord rec;
        if (this.isOpen() && (rec = this.getDatastorage().executeQuery("SELECT count(idelement) AS count FROM tdtaelement WHERE elementtype='observation' AND not deleted", true).firstRow()) != null) {
            return rec.getInt("count");
        }
        return 0;
    }

    public HashMap<Long, ArrayList<Long>> getNewObservations(Date dt1, Date dt2) {
        dt1.setTime(dt1.getTime() - 86400000L);
        HashMap<Long, ArrayList<Long>> map1 = this.getEditedObservations(null, dt1);
        HashMap<Long, ArrayList<Long>> map2 = this.getEditedObservations(null, dt2);
        for (long idtype : map2.keySet()) {
            ArrayList<Long> newIds = new ArrayList<Long>();
            Iterator iterator = MapCompat.getOrDefault(map2, idtype, new ArrayList()).iterator();
            while (iterator.hasNext()) {
                long idelement = (Long)iterator.next();
                if (MapCompat.getOrDefault(map1, idtype, new ArrayList()).contains(idelement)) continue;
                newIds.add(idelement);
            }
            map2.put(idtype, newIds);
        }
        return map2;
    }

    public HashMap<Long, ArrayList<Long>> getEditedObservations(Date dt0, Date dt1) {
        HashMap<Long, ArrayList<Long>> map = new HashMap<Long, ArrayList<Long>>();
        String sql = "SELECT distinct r.elementto as idelement, o.idtype as idtype FROM tdtaelehistory as h INNER JOIN tdtarelation as r on (h.idelement=r.elementfrom and r.relationcode='historyobservation') INNER JOIN tdtaeleobservation as o on (r.elementto=o.idelement) INNER JOIN tdtaelement as e on (e.idelement=o.idelement) WHERE NOT e.deleted ";
        if (dt0 != null) {
            sql = sql + "AND eventdate >= " + Util.toSqlString((Date)dt0, (TimeZone)this.app.getTimeZone());
        }
        if (dt1 != null) {
            sql = sql + "AND eventdate <= " + Util.toSqlString((Date)dt1, (TimeZone)this.app.getTimeZone());
        }
        List recs = this.getDatastorage().executeQuery(sql, true).getResult();
        for (DataRecord rec : recs) {
            long idtype = rec.getLong("idtype");
            long idelement = rec.getLong("idelement");
            ArrayList<Long> lst = MapCompat.getOrDefault(map, idtype, new ArrayList());
            if (!lst.contains(idelement)) {
                lst.add(idelement);
            }
            map.put(idtype, lst);
        }
        return map;
    }

    public int getLocationCount() {
        DataRecord rec;
        if (this.isOpen() && (rec = this.getDatastorage().executeQuery("SELECT count(idelement) AS count FROM tdtaelement WHERE elementtype='location' AND not deleted", true).firstRow()) != null) {
            return rec.getInt("count");
        }
        return 0;
    }

    public int getHistoryCount() {
        DataRecord rec;
        if (this.isOpen() && (rec = this.getDatastorage().executeQuery("SELECT count(idelement) AS count FROM tdtaelement WHERE elementtype='history' AND not deleted", true).firstRow()) != null) {
            return rec.getInt("count");
        }
        return 0;
    }

    public String toString() {
        CmsProject p = this.getProjectElement();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getResourceText("ThemisProject.project2.text", this.app.getLocale())).append(p.getTitle());
        sb.append(this.getResourceText("ThemisProject.directory.text", this.app.getLocale())).append(this.getProjectFolder().getAbsolutePath());
        sb.append(this.getResourceText("ThemisProject.lastEntry.text", this.app.getLocale())).append(Util.formatDate((Date)this.getLastAccessDate(), (String)Util.DATETIME_READ, (TimeZone)this.getTimeZone()));
        LinkedHashMap<String, String> projectInfo = this.getProjectInfo();
        for (String k : projectInfo.keySet()) {
            sb.append("\n  ").append(k).append(": ").append(projectInfo.get(k));
        }
        return sb.toString();
    }

    public String getResourceText(String code) {
        return this.getResourceText(code, this.app.getLocale());
    }

    public String getResourceText(String code, String ... params) {
        String s = this.getResourceText(code, this.app.getLocale());
        return MessageFormat.format(s, params);
    }

    public LinkedHashMap<String, String> getProjectInfo() {
        LRULinkedHashMap map = new LRULinkedHashMap();
        if (this.isOpen()) {
            List recs = this.getDatastorage().executeQuery("SELECT e.elementtype AS elementtype, count(e.idelement) AS count FROM tdtaElement AS e WHERE NOT e.deleted GROUP BY e.elementtype ORDER BY e.elementtype ", true).getResult();
            for (DataRecord rec : recs) {
                map.put("count" + rec.getString("elementtype"), rec.getString("count"));
            }
            DataRecord rec = this.getDatastorage().executeQuery("SELECT count(idelement) AS count FROM tdtaElement WHERE deleted", true).firstRow();
            map.put("countdeleted", rec.getString("count"));
            map.put("datefirstaccess", Util.formatDate((Date)this.getFirstAccessDate(), (String)Util.DATETIME_READ, (TimeZone)this.getTimeZone()));
            map.put("datelastaccess", Util.formatDate((Date)this.getLastAccessDate(), (String)Util.DATETIME_READ, (TimeZone)this.getTimeZone()));
            map.put("maxidelement", Long.toString(this.getLastElementId()));
            map.put("maxidupload", Long.toString(this.getLastUploadId()));
            map.put("projectuuid", this.getProjectElement().getUUID().toString());
            map.put("themisbuild", Integer.toString(2146));
        }
        return map;
    }

    public boolean isSpecialApp() {
        return this.getLicenseLevel() == 5;
    }

    public int getLicenseLevel() {
        String l = this.getProjectProperty(CONF_LICENSE, null);
        if (l == null) {
            this.setLicenseLevel(10);
            return 10;
        }
        int result = Integer.parseInt(l);
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    void setLicenseLevel(int licenseLevel) {
        this.setProjectProperty(CONF_LICENSE, Integer.toString(licenseLevel));
    }

    public boolean isEditFutureData() {
        return false;
    }

    public File getProjectStaticsFile() {
        return new File(this.getProjectFolder(), "statistics.properties");
    }

    public Properties getProjectStatistics() {
        return this.getProjectStatistics(false, false);
    }

    public Properties getProjectStatistics(boolean forceAllYears, boolean dosave) {
        if (!this.isOpen()) {
            return null;
        }
        this.getLogger().info("updating project statistics");
        Properties stats = new Properties();
        File propsfile = this.getProjectStaticsFile();
        if (propsfile.isFile()) {
            try (FileReader reader = new FileReader(propsfile);){
                stats.load(reader);
                reader.close();
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(ThemisFolder.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(ThemisFolder.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.getFileAccess().setHidden(propsfile, true);
        }
        stats.setProperty("version", "2");
        stats.setProperty("projectversion", Integer.toString(this.getDatastorage().getDatabaseApplicationVersion(this.getProjectCode() + FOLDER_DB)));
        stats.setProperty("count.plans", Integer.toString(this.getDatastorage().getElementtypeCount(CMS_PLAN)));
        stats.setProperty("count.buildings", Integer.toString(this.getDatastorage().getElementtypeCount(CMS_LOCATION, "tdtaelelocation", "building")));
        stats.setProperty("count.locations", Integer.toString(this.getDatastorage().getElementtypeCount(CMS_LOCATION)));
        DataRecord rec = this.getEventSearchResult().firstRow();
        stats.setProperty("last.event", rec != null ? rec.getString("meta_title") : "-");
        if (this.getProjectElement() != null) {
            stats.setProperty("access.creator", this.getProjectElement().getAttributeValue("meta_iduser_name"));
        }
        stats.setProperty("access.last-user", this.getUser().getUsername());
        stats.setProperty("access.last", Util.formatDate((Date)this.getLastAccessDate(), (String)Util.DATETIME_READ, (TimeZone)this.getTimeZone()));
        stats.setProperty("access.first", Util.formatDate((Date)this.getFirstAccessDate(), (String)Util.DATETIME_READ, (TimeZone)this.getTimeZone()));
        if (this.getProjectElement() != null) {
            stats.setProperty("project.id", this.getProjectElement().getAttributeValue("projectid"));
            stats.setProperty(CONF_TITLE, this.getProjectElement().getAttributeValue("projecttitle"));
            stats.setProperty(CONF_NUMBER, this.getProjectElement().getAttributeValue("projectnumber"));
            File projectimagefile = this.getProjectElement().getUploadAttribute("projectimage").getFirstUploadItemFile();
            stats.setProperty("project.image", projectimagefile == null ? VERSION_BETA : projectimagefile.getName());
            stats.setProperty("project.uuid", this.getProjectElement().getUUID().toString());
        }
        int count = 0;
        HashMap<Long, ArrayList<Long>> observations = this.getEditedObservations(null, null);
        Integer[] integerArray = new Integer[]{1, 2};
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int idtype = integerArray[i];
            int typecount = 0;
            if (observations.containsKey(idtype)) {
                typecount = observations.get(idtype).size();
            }
            count += typecount;
            stats.setProperty("count.observations.type" + idtype, Integer.toString(typecount));
        }
        stats.setProperty("count.observations", Integer.toString(count));
        stats.setProperty("count.events", Integer.toString(this.getDatastorage().getElementtypeCount(CMS_EVENT)));
        ThemisFilter f = new ThemisFilter(this.app, false);
        f.setMangelFilter();
        stats.setProperty("count.opentasks", Integer.toString(f.getFilteredObservationIds().size()));
        rec = this.getDatastorage().executeQuery("SELECT min(duedate) AS nextduedate FROM tdtaeleobservation WHERE duedate IS NOT null AND (NOT done OR done IS NULL) AND NOT idelement IN (select idelement from tdtaelement where deleted) ", true).firstRow();
        String dt = rec != null ? Util.formatDate((Date)rec.getDate("nextduedate", this.getTimeZone()), (String)Util.DATE_READ, (TimeZone)this.getTimeZone()) : "-";
        stats.setProperty("next.duedate", dt);
        ArrayList<Integer> yearsToProcess = new ArrayList<Integer>();
        if (forceAllYears) {
            Pair<Date, Date> eventDateRange = this.getEventDateRange();
            GregorianCalendar cal = new GregorianCalendar();
            if (eventDateRange.value1 != null && eventDateRange.value2 != null) {
                cal.setTime((Date)eventDateRange.value1);
                int year1 = cal.get(1);
                cal.setTime((Date)eventDateRange.value2);
                int year2 = cal.get(1);
                for (int yy = year1; yy <= year2; ++yy) {
                    yearsToProcess.add(yy);
                }
            }
        } else {
            yearsToProcess.addAll(this.yearsForStatistics);
        }
        Iterator eventDateRange = yearsToProcess.iterator();
        while (eventDateRange.hasNext()) {
            int year = (Integer)eventDateRange.next();
            stats.setProperty("count.events." + year, Integer.toString(this.getDatastorage().getElementtypeCount(CMS_EVENT, this.getDefaultElement(CMS_EVENT).getTablename(), "date >= '" + year + "-01-01' AND date <= '" + year + "-12-31'")));
            stats.setProperty("count.checks." + year, Integer.toString(this.getDatastorage().getElementtypeCount(CMS_HISTORY, this.getDefaultElement(CMS_HISTORY).getTablename(), "eventdate >= '" + year + "-01-01' AND eventdate <= '" + year + "-12-31'")));
            Date dt1 = new GregorianCalendar(year, 0, 1).getTime();
            Date dt2 = new GregorianCalendar(year, 11, 31).getTime();
            observations = this.getEditedObservations(null, dt2);
            count = 0;
            for (long idtype : observations.keySet()) {
                count += observations.get(idtype).size();
                stats.setProperty("count.observations.type" + idtype + "." + year, Integer.toString(observations.get(idtype).size()));
            }
            stats.setProperty("count.observations." + year, Integer.toString(count));
            observations = this.getNewObservations(dt1, dt2);
            count = 0;
            for (long idtype : observations.keySet()) {
                count += observations.get(idtype).size();
                stats.setProperty("count.newobservations.type" + idtype + "." + year, Integer.toString(observations.get(idtype).size()));
            }
            stats.setProperty("count.newobservations." + year, Integer.toString(count));
        }
        if (dosave) {
            this.getFileAccess().delete(propsfile);
            try (OutputStream os = this.getFileAccess().outputStream(propsfile);){
                stats.store(os, VERSION_BETA);
                os.close();
            }
            catch (IOException e) {
                this.getLogger().severe("Cannot write statistics to project folder");
            }
            this.getFileAccess().setHidden(propsfile, true);
        }
        return stats;
    }

    public static Document getXmlDocument(ZipFile zip, ZipEntry entry) throws IOException, JDOMException {
        InputStream inputStream = zip.getInputStream(entry);
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(inputStream);
        Util.closeStream((Closeable)inputStream);
        return doc;
    }

    public static int getSoftwareVersion() {
        String[] v1 = VERSION.split("-");
        String[] v2 = v1[0].split("\\.");
        int v = Integer.parseInt(v2[0]) * 100;
        if (v2.length > 1) {
            v += Integer.parseInt(v2[1]);
        }
        return v;
    }

    public int getProjectVersion() {
        String v = this.getProjectProperty(CONF_PROJECTVERSION);
        if (v == null) {
            return 403;
        }
        int vInt = Integer.parseInt(v);
        if (vInt > 9999) {
            vInt /= 100;
        }
        return vInt;
    }

    public String getProjectError() {
        return this.projectError;
    }

    @Deprecated
    public boolean showAttribute(String col) {
        String[] defaultFalse;
        for (String c : defaultFalse = new String[]{"title", " control", "measure", "quantity", "locDimension", "freetext1", "freetext2", "freetext3", "risk"}) {
            if (!c.equals(col)) continue;
            return "show".equals(this.getProjectProperty("observationtable.column." + col, "hide"));
        }
        return "show".equals(this.getProjectProperty("observationtable.column." + col, "show"));
    }

    public void setAttributeVisibility(String col, boolean v) {
        this.setProjectProperty("observationtable.column." + col, v ? "show" : "hide", true);
    }

    public ArrayList<String> getObservationListAttributes() {
        String atts = this.getProjectProperty("observationtable.display", "fullnumber,location,observationtitle,plan,duedate,done,control");
        if (atts == null || VERSION_BETA.equals(atts)) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(atts.split(",")));
    }

    public void setObservationListAttributes(List<String> atts) {
        this.setProjectProperty("observationtable.display", String.join((CharSequence)",", atts), true);
    }

    public void moveObservationListAttribute(int fromIndex, int toIndex) {
        ArrayList<String> atts = this.getObservationListAttributes();
        if (fromIndex < 1 || fromIndex > atts.size() || toIndex < 1 || toIndex > atts.size()) {
            return;
        }
        String item = (String)atts.get(fromIndex - 1);
        atts.remove(fromIndex - 1);
        atts.add(toIndex - 1, item);
        this.setObservationListAttributes(atts);
    }

    public String getTableAttribute(String col) {
        return this.getProjectProperty("observationtable.attribute." + col, "null");
    }

    public void setTableAttribute(String tableColumn, String v) {
        this.setProjectProperty("observationtable.attribute." + tableColumn, v, true);
    }

    public ArrayList<String> getLocationTableColumns() {
        String attstr = this.getProjectProperty("table.location.columns", "locnumber:30:integer,plan:70:string,location:70:string,locationgroup:70:string");
        return new ArrayList<String>(Arrays.asList(attstr.split(",")));
    }

    public ArrayList<String> getLocationTableColumnCodes() {
        String attstr = this.getProjectProperty("table.location.columns", "locnumber:30:integer,plan:70:string,location:70:string,locationgroup:70:string");
        ArrayList<String> codes = new ArrayList<String>();
        for (String c : Arrays.asList(attstr.split(","))) {
            codes.add(c.split(":")[0]);
        }
        return codes;
    }

    public void setLocationTableColumnCodes(ArrayList<String> cols) {
        ArrayList<String> colspecs = this.getLocationTableColumns();
        String atts = String.join((CharSequence)",", cols);
        this.setProjectProperty("table.location.columns", atts);
    }

    public void setLocationTableColumns(ArrayList<String> cols) {
        String atts = String.join((CharSequence)",", cols);
        this.setProjectProperty("table.location.columns", atts);
    }

    @Deprecated
    public ArrayList<String> getObservationTableColumns() {
        String attstr = this.getProjectProperty("table.observation.columns", VERSION_BETA);
        return new ArrayList<String>(Arrays.asList(attstr.split(",")));
    }

    public static Image getIconImage(String fn) {
        Image img = icons.get(fn);
        if (img == null) {
            try {
                File iconFile = ThemisApplication.getInstance().getProject().getUploadFile(CMS_ICON, fn);
                if (iconFile != null && iconFile.isFile()) {
                    img = ImagePanel.readIcon((File)iconFile);
                } else {
                    ThemisApplication.getInstance().getProject().getLogger().warning("Cannot load icon: " + (iconFile == null ? "NULL" : iconFile.getName()));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return img;
    }

    public static BufferedImage getIconImage35px(String fn) {
        BufferedImage img = icons35px.get(fn);
        if (img == null) {
            try {
                File iconFile = ThemisApplication.getInstance().getProject().getUploadFile(CMS_ICON, fn);
                img = iconFile != null && iconFile.exists() && iconFile.isFile() ? ImageHelper.loadImage((File)iconFile) : ImageHelper.loadImage((URL)ThemisProject.class.getResource(fn));
                if (img != null) {
                    img = Util.resizeImage((BufferedImage)img, (int)35, (int)35);
                    icons35px.put(fn, img);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return img;
    }

    public ArrayList<File> getProjects(File folder, boolean includeSub) {
        return this.getProjects(folder, includeSub, 0, new Date().getTime());
    }

    public ArrayList<File> getProjects(File folder, boolean includeSub, int level, long milis) {
        ArrayList<File> projects = new ArrayList<File>();
        if (level > 5) {
            return projects;
        }
        File[] files = folder.listFiles();
        if (files == null) {
            return projects;
        }
        for (File f : files) {
            if (ThemisProject.isProjectFolder(f)) {
                projects.add(f);
                continue;
            }
            if (!f.isDirectory() || !includeSub) continue;
            projects.addAll(this.getProjects(f, includeSub, level + 1, milis));
        }
        return projects;
    }

    public boolean isUploadImageEditable(UploadItem item) {
        if (item == null) {
            return false;
        }
        CmsEvent ev = this.getSelectionManager().getCurrentEvent();
        if (ev == null) {
            return false;
        }
        long idHistory = item.getIdelement();
        if (idHistory < 0L) {
            return true;
        }
        ArrayList eventIds = this.getDatastorage().getRelationIds(idHistory, "historyevent", true);
        return eventIds.isEmpty() || !this.isEventSigned((Long)eventIds.get(0));
    }

    public ElementCache getCache() {
        return this.themiscache;
    }

    public String checkoutProject(ThemisFolder themisFile, ProgressHandler ph) {
        Object targetFolder;
        ThemisElement themisElement;
        boolean renameSuccess;
        File history;
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        ph.switchToDeterminate(6);
        if (!themisFile.isProject()) {
            return "error.checkoutproject.not-a-project";
        }
        if (themisFile.isLocal()) {
            return "error.checkoutproject.already-checkedout";
        }
        if (themisFile.getProjectLock().isLocked()) {
            return "error.checkoutproject.project-in-use";
        }
        if (themisFile.isServerAccess()) {
            return "error.checkoutproject.server-project-no-checkout";
        }
        if (this.isOpen()) {
            return "error.checkoutproject.a-project-is-open";
        }
        File dbfile_project = themisFile.getDatabaseFile();
        File dbfile_renamed = new File(dbfile_project.getAbsolutePath() + "_orig");
        ThemisProjectProperties props = new ThemisProjectProperties(themisFile);
        if (props.getThemisBuildNr() < 1905 && !(history = new File(props.getProjectFolder(), "data/history")).isDirectory()) {
            this.open(themisFile, null, null, false, false, false, false, false, null);
            this.close(new Closing().withoutTrigger().withoutExport().withoutAsking(), null);
        }
        ph.increaseProgress(1);
        ThemisLock themisLocalLock = themisFile.getLocalLock();
        ThemisLock themisRemoteLock = themisFile.getProjectLock();
        if (themisLocalLock.isLocked()) {
            String msg = themisLocalLock.toString();
            int result = this.app.getDialog().showInfoOptionDialog("dialog.network.use-local-copy-ask", "dialog.network.title", new Object[]{this.getResourceText("text.cancel"), this.getResourceText("dialog.network.use-local-copy"), this.getResourceText("dialog.network.delete-local-copy"), this.getResourceText("dialog.network.use-remote")});
            switch (result) {
                case 0: {
                    this.reset();
                    return null;
                }
                case 1: {
                    themisFile.deleteLocalLock();
                    return null;
                }
                case 2: {
                    themisFile.deleteLocal();
                    this.getFileAccess().rename(dbfile_renamed, dbfile_project);
                    break;
                }
                case 3: {
                    this.getFileAccess().rename(themisFile.getLocalProjectFolder(), new File(themisFile.getLocalProjectFolder().getParentFile(), themisFile.getLocalProjectFolder().getName() + "_copy"));
                    this.localProjectCopyRenamed = true;
                    this.getFileAccess().rename(dbfile_renamed, dbfile_project);
                }
            }
        } else {
            this.getFileAccess().rename(dbfile_renamed, dbfile_project);
        }
        File localProjectFolder = themisFile.getLocalProjectFolder();
        localProjectFolder.mkdirs();
        if (dbfile_renamed.isFile()) {
            int renamecounter = 1;
            String renamebase = dbfile_renamed.getName();
            File dbfile_renamed_bak = new File(dbfile_renamed.getParentFile(), (String)renamebase + renamecounter);
            while (dbfile_renamed_bak.isFile() && renamecounter < 10) {
                dbfile_renamed_bak = new File(dbfile_renamed.getParentFile(), (String)renamebase + ++renamecounter);
            }
            if (dbfile_renamed_bak.isFile()) {
                dbfile_renamed_bak = new File(dbfile_renamed.getParentFile(), (String)renamebase + "0");
                dbfile_renamed_bak.delete();
            }
            this.getFileAccess().rename(dbfile_renamed, dbfile_renamed_bak);
        }
        if (!(renameSuccess = this.getFileAccess().rename(dbfile_project, dbfile_renamed))) {
            this.reset();
            return "error.network.cannot-rename-db-orig";
        }
        ph.increaseProgress(1);
        this.getLogger().fine("Copying database to a local folder: '" + localProjectFolder.getAbsolutePath() + "'");
        if (!this.getFileAccess().copy(dbfile_renamed, themisFile.getLocalDatabaseFile())) {
            return "error.checkoutproject.cannot-copy-database";
        }
        themisLocalLock.create();
        themisRemoteLock.create();
        if (this.isOpen()) {
            for (CmsElementSummary plan : this.getPlans()) {
                themisElement = (CmsPlan)this.loadElement(plan.getId(), this.getUser());
            }
        } else {
            targetFolder = new File(themisFile.getLocalDataFolder(), CMS_PLANFILE);
            this.getFileAccess().copy(new File(themisFile.getProjectDataFolder(), CMS_PLANFILE), (File)targetFolder);
        }
        ph.increaseProgress(1);
        if (this.isOpen()) {
            for (CmsBasicElement icon : this.getIcons()) {
                themisElement = (CmsIcon)this.loadElement(icon.getId(), this.getUser());
            }
        } else {
            targetFolder = new File(themisFile.getLocalDataFolder(), CMS_ICON);
            this.getFileAccess().copy(new File(themisFile.getProjectDataFolder(), CMS_ICON), (File)targetFolder);
        }
        ph.increaseProgress(1);
        if (this.isOpen()) {
            for (CmsElementSummary doc : this.getDocuments()) {
                themisElement = (CmsInfo)this.loadElement(doc.getId(), this.getUser());
            }
        } else {
            targetFolder = new File(themisFile.getLocalDataFolder(), CMS_INFO);
            this.getFileAccess().copy(new File(themisFile.getProjectDataFolder(), CMS_INFO), (File)targetFolder);
        }
        ph.increaseProgress(1);
        targetFolder = new File(themisFile.getLocalDataFolder(), CMS_HISTORY);
        if (this.isOpen()) {
            String sql = "select f.idfileupload, f.path, r.elementfrom AS idhistory, r.elementto AS idobservation, h.eventdate, h.timehours\nfrom tdtafileupload AS f INNER JOIN tdtaRelation AS r ON (f.idelement=r.elementfrom AND r.relationcode='historyobservation') INNER JOIN tdtaEleHistory AS h ON (f.idelement=h.idelement)\norder by idobservation,eventdate desc, timehours desc";
            List recs = this.getDatastorage().executeQuery(sql, true).getResult();
            ArrayList<String> filenames = new ArrayList<String>();
            long prevObs = -1L;
            long prevHist = -1L;
            for (DataRecord rec : recs) {
                long idobs = rec.getLong("idobservation");
                long idhist = rec.getLong("idhistory");
                String filename = rec.getString("path");
                if (idobs != prevObs) {
                    filenames.add(filename);
                    prevObs = idobs;
                    prevHist = idhist;
                    continue;
                }
                if (idhist != prevHist) continue;
                filenames.add(filename);
            }
            for (String fn : filenames) {
                this.getFileAccess().copy(new File(themisFile.getProjectDataFolder(), "history/" + fn), new File((File)targetFolder, fn));
            }
        } else {
            this.getFileAccess().copy(new File(themisFile.getProjectDataFolder(), CMS_HISTORY), (File)targetFolder);
        }
        ph.increaseProgress(1);
        return null;
    }

    public boolean isThemisFileDirectAccess() {
        return this.themisFileDirectAccess != null;
    }

    public void setThemisFileDirectAccess(File f) {
        this.themisFileDirectAccess = f;
    }

    public File getThemisFileDirectAccess() {
        return this.themisFileDirectAccess;
    }

    public String createProject(ThemisFolder themisFile, ProgressHandler ph) {
        this.projectFolder = themisFile.getProjectFolder();
        boolean projectfolderAvailable = this.getFileAccess().mkdirs(this.projectFolder);
        if (!projectfolderAvailable) {
            return "error.createproject.cannot-create-folder";
        }
        this.getFileAccess().mkdirs(new File(this.projectFolder, FOLDER_DB));
        this.getFileAccess().setHidden(new File(this.projectFolder, FOLDER_DB), true);
        this.getFileAccess().mkdirs(new File(this.projectFolder, FOLDER_DB_BACKUP));
        this.getFileAccess().setHidden(new File(this.projectFolder, FOLDER_DB_BACKUP), true);
        this.getFileAccess().mkdirs(new File(this.projectFolder, FOLDER_DATA));
        this.getFileAccess().setHidden(new File(this.projectFolder, FOLDER_DATA), true);
        this.getFileAccess().mkdirs(new File(this.projectFolder, FOLDER_TEMP));
        this.getFileAccess().setHidden(new File(this.projectFolder, FOLDER_TEMP), true);
        this.getFileAccess().mkdirs(new File(this.projectFolder, FOLDER_PLANSNIPPET));
        this.getFileAccess().setHidden(new File(this.projectFolder, FOLDER_PLANSNIPPET), true);
        this.getLogger().info("creating system properties ...");
        this.themisProperties = this.createProperties();
        File traceFile = null;
        File dbFile = this.getDatabaseFile();
        boolean dbOk = this.initialiseProjectDatabase(dbFile, traceFile, ph, 0);
        if (dbOk) {
            this.getProjectStatistics(false, true);
            try {
                this.getDatastorage().close();
            }
            catch (Exception ex) {
                ThemisLogger.logger.log(Level.SEVERE, "Cannot close project: " + ex.getLocalizedMessage(), ex);
            }
            this.getDatastorage().closeTraceFile();
        }
        themisFile.isProject();
        return this.openProject(themisFile, false, ph);
    }

    public String openProject(ThemisFolder themisFile, boolean openLocal, ProgressHandler ph) {
        this.open(themisFile, null, null, true, ThemisUtil.isOnNetworkDrive(themisFile.getProjectFolder()), false, openLocal, false, ph);
        return null;
    }

    public String openProjectQuietly(ThemisFolder themisFile, boolean openLocal, ProgressHandler ph) {
        this.open(themisFile, null, null, false, ThemisUtil.isOnNetworkDrive(themisFile.getProjectFolder()), false, openLocal, false, ph);
        return null;
    }

    public void removeThemisServer() {
        this.server = null;
        this.app.getSettings().setThemisServerCode(null);
    }

    public ThemisCloudServer getThemisServer() throws IllegalArgumentException {
        if (this.server == null && this.app.getSettings().hasThemisServerCode()) {
            String servercode = this.app.getSettings().getThemisServerCode();
            try {
                this.server = ThemisCloudServer.fromCode(servercode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.server;
    }

    public void setThemisServer(ThemisCloudServer s) {
        this.server = s;
        if (s == null) {
            this.app.getSettings().setThemisServerCode(null);
        }
    }

    public boolean hasThemisServer() {
        return this.getThemisServer() != null;
    }

    public ArrayList<Long> importDoneJobs(ThemisCloudServer server, List<ThemisJob> jobs, ProgressHandler ph) {
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        ArrayList<Long> eventIds = new ArrayList<Long>();
        ArrayList<String> errors = new ArrayList<String>();
        int counter = 0;
        int jobcount = 0;
        ph.switchToDeterminate(jobs.size() * 3);
        if (jobs.isEmpty()) {
            return eventIds;
        }
        this.getLogger().info("importing " + jobs.size() + " jobs ...");
        for (ThemisJob job : jobs) {
            ph.progress(++jobcount + " von " + jobs.size() + " Auftr\u00e4gen werden importiert", counter++);
            this.getLogger().info("job '" + jobs.toString() + "' [" + job.getUuid() + "]: Downloading ...");
            try {
                ThemisFile tf = server.importJob(this, job);
                this.getLogger().info("job '" + jobs.toString() + "' [" + job.getUuid() + "]: Importing into project ...");
                CmsEvent ev = tf.getEvent();
                if (ev != null && !eventIds.contains(ev.getId())) {
                    eventIds.add(ev.getId());
                }
                this.getLogger().info("job '" + jobs.toString() + "' [" + job.getUuid() + "]: Moving to archive on server ...");
                ph.progress(jobcount + " von " + jobs.size() + " Auftr\u00e4gen werden vom Server gel\u00f6scht", counter++);
                server.moveJobFromDoneToImported(this, job);
                server.deleteJobData(this, job);
            }
            catch (Exception ex) {
                errors.add(job.toString() + ": " + ex.getLocalizedMessage());
            }
        }
        if (!errors.isEmpty()) {
            this.app.getDialog().showErrorDialog("Fehler beim Lesen der Auftr\u00e4ge:\n- " + String.join((CharSequence)"\n- ", errors));
        }
        return eventIds;
    }

    static {
        notAccessableFiles = new ArrayList();
        icons = new HashMap();
        icons35px = new HashMap();
    }

    public static enum PlanExport {
        NONE,
        RELEVANT,
        BUILDING,
        ALL;

    }

    public static enum Elementtype {
        CMS_PLAN("plan"),
        CMS_PLANFILE("planfile"),
        CMS_ICON("icon");

        private final String code;

        private Elementtype(String c) {
            this.code = c;
        }

        public String getCode() {
            return this.code;
        }
    }
}

