/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFile;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.template.TemplateDescription;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import org.jdom.JDOMException;
import org.openide.util.Exceptions;

public class ThemisProjectCreator {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ThemisFolder projectFolder;
    File templateFile = null;
    ArrayList<File> planFiles = new ArrayList();
    CmsPlan.Papersize planPapersize = CmsPlan.Papersize.PDF;
    Date eventDate;
    String eventTitle;
    String serverCode;
    String projectTitle;

    public ThemisProjectCreator(File folder, String name) {
        this.projectFolder = new ThemisFolder(new File(folder, name));
    }

    public ThemisProjectCreator setTemplateFile(File f) {
        this.templateFile = f;
        return this;
    }

    public ThemisProjectCreator setTemplateFile(TemplateDescription standardTemplate) {
        File tempFile = ThemisApplication.getInstance().getApplicationDataTempFolder();
        boolean success = standardTemplate.saveToFile(tempFile);
        if (success) {
            String fn = standardTemplate.file;
            if (fn.toLowerCase().endsWith(".zip")) {
                fn = Util.getFileNameWithoutExtension((File)new File(tempFile, standardTemplate.file)) + ".xlsx";
            }
            this.templateFile = new File(tempFile, fn);
        }
        return this;
    }

    public File getTemplateFile() {
        if (ThemisLicense.isLicenseLevelExact(ThemisLicense.LicenseLevel.APP)) {
            String productEdition = ThemisApplication.getInstance().getLicense().getProductEdition();
            URL url = null;
            String fn = null;
            switch (productEdition) {
                case "Brandschutzbuch": {
                    fn = "projektvorlage_brandschutz-eigenkontrolle.xlsx";
                    break;
                }
                case "VdS-Arbeitssicherheit": {
                    fn = "projektvorlage_vds_arbeitssicherheit.xlsx";
                }
            }
            if (fn != null) {
                url = this.getClass().getResource("/at/grid/themis/ontology/media/vorlagen/" + fn);
            }
            if (url != null) {
                try {
                    File tempFile = ThemisApplication.getInstance().getApplicationDataTempFolder();
                    File f = new File(tempFile, fn);
                    Util.copy((URL)url, (File)f);
                    return f;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
        return this.templateFile;
    }

    public ThemisProjectCreator setPapersize(CmsPlan.Papersize s) {
        this.planPapersize = s;
        return this;
    }

    public ThemisProjectCreator addPlanFile(File f) {
        this.planFiles.add(f);
        return this;
    }

    public ThemisProjectCreator addPlanFile(ArrayList<File> files) {
        this.planFiles.addAll(files);
        return this;
    }

    public ThemisProjectCreator setEvent(String t, Date dt) {
        this.eventDate = dt;
        this.eventTitle = t;
        return this;
    }

    public ThemisProjectCreator setServer(String c) {
        this.serverCode = c;
        return this;
    }

    public ThemisProjectCreator setTitle(String t) {
        this.projectTitle = t;
        return this;
    }

    public void createProject(ProgressHandler ph) {
        File f;
        if (this.projectFolder == null) {
            this.app.getDialog().showErrorDialog("error.noProjectRootFolderDefined");
            return;
        }
        if (this.projectFolder.getProjectFolder().exists()) {
            this.app.getDialog().showErrorDialog("error.projectFolderAlreadyUsed");
            return;
        }
        this.app.getActionProvider().setActive(false);
        String result = this.project.createProject(this.projectFolder, ph);
        if (result != null) {
            this.app.getDialog().showErrorDialog(result);
            return;
        }
        if (this.projectTitle != null) {
            this.project.getProjectElement().setProjectTitle(this.projectTitle);
            this.project.getProjectElement().save();
        }
        if ((f = this.getTemplateFile()) != null) {
            if (f.getName().toLowerCase().endsWith(".themis")) {
                ThemisFile tf = new ThemisFile().setContentType(ThemisFile.ContentType.TEMPLATE);
                try {
                    tf.loadFromFile(f, true);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (JDOMException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                this.app.getSettings().setTemplateUseTexts(true);
                this.app.getSettings().setTemplateUseLists(true);
                this.app.getSettings().setTemplateUseIcons(true);
                this.app.getSettings().setTemplateUseSettings(true);
                this.app.getSettings().setTemplateUseContacts(true);
                this.app.getSettings().setTemplateUseDocuments(true);
                this.project.getTemplateManger().loadTemplate(f);
            }
        }
        try {
            this.project.getPlanManager().createNewPlanElements(this.planFiles, -1L, CmsPlan.Papersize.A3, 0, ph);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (this.eventDate != null) {
            CmsEvent ev = (CmsEvent)this.project.createElement("event");
            ev.getDateAttribute("date").setDate(this.eventDate);
            if ("".equals(this.eventTitle)) {
                this.eventTitle = "Ereignis";
            }
            ev.setAttributeValue("title", this.eventTitle);
            ev.save();
            this.project.getSelectionManager().setCurrentEvent(ev, true, (Object)this);
        }
        if (this.serverCode != null && !"".equals(this.serverCode)) {
            ThemisApplication.getInstance().getSettings().setThemisServerCode(this.serverCode);
        }
        this.app.getActionProvider().setActive(true);
        this.app.getActionProvider().invokeAction(ThemisAction.PROJECT_OPENED);
    }
}

