/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.content.Keytable;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsUser;
import at.grid.cms.search.CmsBasicSearch;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.gui.Point;
import at.grid.themis.ontology.ColorOption;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisLogger;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.action.SimpleAction;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.attribute.manager.ThemisAttributeManager;
import at.grid.themis.ontology.element.CmsFormular;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.element.CmsPlanfile;
import at.grid.themis.ontology.element.CmsProject;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.report.ReportTableLayout;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.DefaultProgressHandler;
import at.grid.util.Dimension;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import at.grid.util.XML;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;

public class ThemisProjectUpdater {
    private static ThemisProjectUpdater instance;
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    HashMap<Integer, UpdateAction> updateActions = new HashMap();
    ArrayList<Integer> executedUpdates = new ArrayList();
    private int currentApplicationVersion = -1;
    private int currentProjectVersion = -1;
    public static final int PROJECT_SETTINGS_VERSION = 18;
    private static int LAST_DB_VERSION;
    private static final int DBAPPVERSION = 52;

    public ThemisProjectUpdater() {
        this.createUpdateActions();
        this.reset();
    }

    public static ThemisProjectUpdater getInstance() {
        if (instance == null) {
            instance = new ThemisProjectUpdater();
        }
        return instance;
    }

    public void reset() {
        this.currentApplicationVersion = -1;
        this.currentProjectVersion = -1;
    }

    public static int getLastDatabaseVersion() {
        return LAST_DB_VERSION;
    }

    public static int getLastVersion() {
        int result = -1;
        for (int v : ThemisProjectUpdater.getInstance().updateActions.keySet()) {
            if (v <= result) continue;
            result = v;
        }
        return result;
    }

    protected final void createUpdateActions() {
        this.updateActions.put(3, new UpdateAction(Phase.INIT, ph -> {
            CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getAdminUser(), "observation");
            List recs = s.search().getResult();
            for (DataRecord rec : recs) {
                CmsElement e = this.project.loadElement(rec.getLong("meta_id"), this.project.getAdminUser());
                e.save();
            }
        }));
        this.updateActions.put(4, new UpdateAction(Phase.INIT, ph -> {
            CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getAdminUser(), "plan");
            List recs = s.search().getResult();
            for (DataRecord rec : recs) {
                CmsElement e = this.project.loadElement(rec.getLong("meta_id"), this.project.getAdminUser());
                if (e.hasAttributeValue("sort")) continue;
                e.setAttributeValue("sort", Long.toString(e.getId()));
                e.save();
            }
        }));
        this.updateActions.put(5, new UpdateAction(Phase.INIT, ph -> {
            CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getAdminUser(), "event");
            s.addSelectAttribute(this.project.getDefaultElement("event").getAttribute("date"));
            List recs = s.search().getResult();
            for (DataRecord rec : recs) {
                long eventid = rec.getLong("meta_id");
                if (rec.isEmpty("eventdate")) continue;
                String dt = rec.getString("eventdate");
                this.project.getDatastorage().executeUpdate("UPDATE tdtaEleHistory SET eventdate = '" + dt + "' WHERE idelement IN (  SELECT elementfrom FROM tdtarelation   WHERE relationcode = 'historyevent' AND elementto = " + eventid + ")", true);
            }
            recs = this.project.getDatastorage().executeQuery("SELECT ro.elementto AS observationid, re.elementto AS eventid, ro.elementfrom AS historyid  FROM tdtaRelation AS ro  INNER JOIN tdtaRelation AS re ON (   ro.elementfrom=re.elementfrom    AND ro.relationcode='historyobservation'    AND re.relationcode='historyevent'   AND ro.elementto!=re.elementto) ", true).getResult();
            ArrayList<String> combinations = new ArrayList<String>();
            for (DataRecord rec : recs) {
                String combination = rec.get("observationid") + "." + rec.getString("eventid");
                if (combinations.contains(combination)) {
                    CmsElement.remove((CmsApplication)this.project, (long)rec.getLong("historyid"), (CmsUser)this.project.getAdminUser());
                    continue;
                }
                combinations.add(combination);
            }
        }));
        this.updateActions.put(6, new UpdateAction(Phase.INIT, ph -> {
            this.project.getDatastorage().executeUpdate("UPDATE tdtaEleObservation SET done='false' WHERE donedate IS NULL", true);
            this.project.getDatastorage().executeUpdate("UPDATE tdtaEleObservation SET done='true' WHERE donedate IS NOT NULL", true);
            this.project.getDatastorage().executeUpdate("UPDATE tdtaEleHistory SET done='false' WHERE donedate IS NULL", true);
            this.project.getDatastorage().executeUpdate("UPDATE tdtaEleHistory SET done='true' WHERE donedate IS NOT NULL", true);
        }));
        this.updateActions.put(40, new UpdateAction(Phase.INIT, ph -> this.project.getProjectStatistics(true, true)));
        this.updateActions.put(41, new UpdateAction(Phase.INIT, ph -> {
            this.project.getDatastorage().executeUpdate("MERGE INTO tdtaelementlng(idelement,title) KEY (idelement) SELECT idelement,title FROM tdtaeleobservation", true);
            this.project.getDatastorage().executeUpdate("MERGE INTO tdtaelementlng(idelement,title) KEY (idelement) SELECT idelement,titel FROM tdtaelelocation", true);
        }));
        this.updateActions.put(42, new UpdateAction(Phase.INIT, ph -> {
            ArrayList ids = this.project.getDatastorage().executeQuery("SELECT t.idelement AS meta_id FROM tdtaEleObservationTemplate AS t INNER JOIN tdtaElement AS e ON (t.idelement=e.idelement) WHERE e.deleted", true).getResultIds();
            ids.addAll(this.project.getDatastorage().executeQuery("SELECT t.idelement AS meta_id FROM tdtaEleLocationTemplate AS t INNER JOIN tdtaElement AS e ON (t.idelement=e.idelement) WHERE e.deleted", true).getResultIds());
            ids.addAll(this.project.getDatastorage().executeQuery("SELECT t.idelement AS meta_id FROM tdtaelelocationgroup AS t INNER JOIN tdtaElement AS e ON (t.idelement=e.idelement) WHERE e.deleted", true).getResultIds());
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                this.project.loadElement(id, this.project.getUser()).moveToTrash();
            }
        }));
        this.updateActions.put(43, new UpdateAction(Phase.INIT, ph -> this.project.getDatastorage().executeUpdate("UPDATE tdtaEleLocationgroup SET groupfullid = idelement || '.', groupfullname = titel", true)));
        this.updateActions.put(44, new UpdateAction(Phase.INIT, ph -> this.project.getDatastorage().executeUpdate("UPDATE tdtaEleObservation SET done = 'f' WHERE idType IN (2,3) ", true)));
        this.updateActions.put(45, new UpdateAction(Phase.INIT, ph -> {
            this.project.getDatastorage().executeUpdate("UPDATE tdtaEleObservation SET idtype = 1 WHERE idtype IS NULL OR idtype < 0 ", true);
            this.project.getDatastorage().executeUpdate("UPDATE tdtaEleObservationtemplate SET idtype = 1 WHERE idtype IS NULL OR idtype < 0 ", true);
        }));
        this.updateActions.put(46, new UpdateAction(Phase.INIT, ph -> {
            this.project.getDatastorage().executeUpdate("UPDATE tdtaEleObservation SET rpz = null WHERE rpz = 0 ", true);
            this.project.getDatastorage().executeUpdate("UPDATE tdtaEleHistory SET rpz = null WHERE rpz = 0 ", true);
        }));
        this.updateActions.put(47, new UpdateAction(Phase.INIT, ph -> this.project.getDatastorage().executeUpdate("UPDATE tdtaEleObservation SET done = 'f' WHERE idtype IN (2,3) ", true)));
        this.updateActions.put(48, new UpdateAction(Phase.INIT, ph -> {
            List recs = this.project.getDatastorage().executeQuery("SELECT t.idelement AS idelement, f.path AS file FROM tdtaelelocationtemplate AS t LEFT JOIN tdtaRelation AS r ON (t.idelement=r.elementfrom AND r.relationcode='locationtemplateicon') LEFT JOIN tdtafileupload AS f ON (f.idelement=r.elementto)", true).getResult();
            for (DataRecord rec : recs) {
                if (rec.getString("file") == null) continue;
                this.project.getDatastorage().executeUpdate("UPDATE tdtaelelocationtemplate SET iconfile=" + Util.toSqlString((String)rec.getString("file")) + " WHERE idelement=" + rec.getLong("idelement"), true);
            }
        }));
        this.updateActions.put(50, new UpdateAction(Phase.INIT, ph -> {
            File fld0 = new File(this.project.getProjectFolder(), "data");
            List recs = this.project.getDatastorage().executeQuery("select * from tdtafileupload", true).getResult();
            if (recs.size() > 30 && ph != null) {
                ph.progress(recs.size() + " Dateien werden aktualisiert - dies kann ggf. etwas dauern ...");
            }
            for (DataRecord rec : recs) {
                if (rec.isEmpty("idelement")) continue;
                long elementid = rec.getLong("idelement");
                String elementtype = rec.getString("elementtype");
                if (elementtype == null || "".equals(elementtype)) {
                    elementtype = this.project.getDatastorage().getElementtypeById(elementid);
                }
                String fn = rec.getString("path");
                File fld1 = new File(fld0, elementtype);
                fld1.mkdirs();
                this.project.getFileAccess().move(new File(fld0, fn), new File(fld1, fn));
                this.project.getDatastorage().executeUpdate("update tdtafileupload set elementtype=" + Util.toSqlString((String)elementtype) + " where idfileupload = " + rec.getLong("idfileupload"), true);
            }
            this.updateThemisProjectStructureVersion(50);
        }));
        this.updateActions.put(52, new UpdateAction(Phase.INIT, ph -> {
            String fieldType = this.project.getDatastorage().getFieldType(7, 0);
            if (!this.project.getDatastorage().hasTableField("tdtaDrawing", "color")) {
                this.project.getDatastorage().executeUpdate("ALTER TABLE tdtaDrawing ADD color " + fieldType, true);
                this.project.getDatastorage().executeUpdate("ALTER TABLE tdtaDrawing ADD linewidth " + fieldType, true);
            }
        }));
        this.updateActions.put(53, new UpdateAction(Phase.INIT, ph -> this.project.getDatastorage().executeUpdate("DELETE FROM tdtaElement WHERE elementtype IN ('locationgroup','locationtemplate','observationtemplate','measuretemplate') AND deleted", true)));
        this.updateActions.put(54, new UpdateAction(Phase.INIT, ph -> this.project.getDatastorage().executeUpdate("UPDATE config SET intval=53 WHERE key='themis'", true)));
        this.updateActions.put(56, new UpdateAction(Phase.OPEN, ph -> {
            ArrayList<CmsBasicElement> reportTemplates = this.project.getReportTemplates();
            for (CmsBasicElement ele : reportTemplates) {
                if (ele.getId() < 0L) continue;
                CmsReport rep = (CmsReport)this.project.loadElement(ele.getId(), this.project.getUser());
                String xmlString = rep.getAttributeValue("xml");
                try {
                    Element xml = Util.fromXml((String)xmlString);
                    Element tables = XML.getXPathElement((Element)xml, (String)"/reportspec/layout/tables");
                    if (tables == null) continue;
                    for (Element layout : tables.getChildren("layout")) {
                        ReportTableLayout rtl = (ReportTableLayout)this.project.createElement("reporttable");
                        rtl.fromXML(layout);
                        if (!rtl.hasName()) continue;
                        rtl.save();
                    }
                }
                catch (IOException | JDOMException ex) {
                    ex.printStackTrace();
                }
            }
        }));
        this.updateActions.put(57, new UpdateAction(Phase.INIT, ph -> {
            File fldOld = new File(this.project.getProjectFolder(), "data");
            List recs = this.project.getDatastorage().executeQuery("SELECT * FROM tdtafileupload", true).getResult();
            if (recs.size() > 30 && ph != null) {
                ph.progress(recs.size() + " Dateien werden aktualisiert - dies kann ggf. etwas dauern ...");
            }
            for (DataRecord rec : recs) {
                if (rec.isEmpty("idelement")) continue;
                long elementid = rec.getLong("idelement");
                String elementtype = rec.getString("elementtype");
                if (elementtype == null || "".equals(elementtype)) {
                    elementtype = this.project.getDatastorage().getElementtypeById(elementid);
                }
                String fn = rec.getString("path");
                File fldNew = new File(fldOld, elementtype);
                fldNew.mkdirs();
                File targetFile = new File(fldNew, fn);
                if (targetFile.isFile()) continue;
                this.project.getFileAccess().move(new File(fldOld, fn), targetFile);
                this.project.getDatastorage().executeUpdate("UPDATE tdtafileupload SET elementtype=" + Util.toSqlString((String)elementtype) + " where idfileupload = " + rec.getLong("idfileupload"), true);
            }
            this.updateThemisProjectStructureVersion(50);
        }));
        this.updateActions.put(58, new UpdateAction(Phase.SYSTEM, ph -> {
            String templateUpdateUrl = "https://update.themis-software.at/templates61/";
            Element xml = this.app.getSettings().getXmlElement("/themis/system/template/download", true);
            xml.setText(templateUpdateUrl);
        }));
        this.updateActions.put(59, new UpdateAction(Phase.INIT, ph -> {
            this.project.getDatastorage().setDatabaseApplicationVersion("themis", 52);
            this.project.getDatastorage().executeUpdate("DELETE FROM config WHERE key='themis' AND intval>52", true);
        }));
        this.updateActions.put(60, new UpdateAction(Phase.INIT, ph -> {
            CmsFormular form = this.project.getFormByAlias("befund");
            if (form != null) {
                form.setUUID("2d398f93-3c54-4d71-b540-a9e61ce3c841");
                form.save();
            }
        }));
        this.updateActions.put(61, new UpdateAction(Phase.OPEN, ph -> {
            CmsReport rep = (CmsReport)this.project.createElement("report");
            Element xml = this.app.getSettings().getXmlElement("/themis/project/reportspec", false);
            if (xml != null) {
                Element tablesXml = this.app.getSettings().getXmlElement("/themis/project/reportspec/layout/tables", false);
                if (tablesXml != null) {
                    List tables = tablesXml.getChildren();
                    for (Element table : tables) {
                        ReportTableLayout rtl = (ReportTableLayout)this.project.createElement("reporttable");
                        rtl.fromXML(table);
                        rtl.save();
                    }
                }
                rep.setReportFromXml((Element)xml.detach());
                rep.setLayoutName("Eigene Protokollvorlage");
                rep.save();
                this.app.getSettings().setLastReportLayoutId(rep.getId());
            }
        }));
        this.updateActions.put(62, new UpdateAction(Phase.INIT, ph -> {
            this.project.getDatastorage().setDatabaseApplicationVersion("themis", 52);
            this.project.getDatastorage().executeUpdate("DELETE FROM config WHERE key='themis' AND intval>52", true);
        }));
        this.updateActions.put(63, new UpdateAction(Phase.INIT, ph -> {
            this.project.getDatastorage().setDatabaseApplicationVersion("themis", 52);
            this.project.getDatastorage().executeUpdate("DELETE FROM config WHERE key='themis' AND intval>52", true);
        }));
        this.updateActions.put(64, new UpdateAction(Phase.OPEN, ph -> {
            Element e = this.app.getSettings().getXmlElement("/themis/project/report/tables", true);
            List layouts = e.getChildren();
            ArrayList rtls = new ArrayList();
            for (Element layout : layouts) {
                ReportTableLayout rtlNew = (ReportTableLayout)this.project.createElement("reporttable");
                rtlNew.fromXML(layout);
                rtlNew.setName(this.project.getNewReportTableName(rtlNew.getName()));
                rtlNew.save();
            }
        }));
    }

    public void executeUpdate(Phase phase, int v, ProgressHandler ph) {
        boolean foundUpdate;
        UpdateAction a;
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        if ((a = this.updateActions.get(v)) != null) {
            if (a.isPhase(phase)) {
                a.execute(ph);
                this.executedUpdates.add(v);
            }
        } else if (phase == Phase.INIT && (foundUpdate = this.updateApplicationDatabaseSingleAction(ph, v))) {
            this.executedUpdates.add(v);
        }
    }

    public void update(Phase phase, ProgressHandler ph) {
        boolean isProjectOpen = this.project.isOpen();
        if (this.currentApplicationVersion < 0) {
            this.currentApplicationVersion = this.app.getSettings().getXmlVersion();
        }
        if (phase == Phase.SYSTEM) {
            this.update(phase, this.currentApplicationVersion, ph);
        } else {
            if (this.currentProjectVersion < 0 && this.project.isOpen()) {
                if (phase == Phase.PREPARE) {
                    ThemisFolder tfld = this.project.getThemisFile();
                    this.currentProjectVersion = Util.parseInt((String)tfld.getProperties().getProperty("projectversion", "56"), (int)56);
                } else {
                    this.currentProjectVersion = this.project.getDatastorage().getDatabaseApplicationVersion("themisupdate");
                }
            }
            if (this.currentProjectVersion == 0) {
                this.currentProjectVersion = 53;
            }
            this.update(phase, this.currentProjectVersion, ph);
        }
    }

    public void update(Phase phase, int appversion, ProgressHandler ph) {
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        int lastAppversion = this.getLastVersion();
        int loopcounter = 0;
        int origAppVersion = appversion;
        while (appversion < lastAppversion) {
            ++loopcounter;
            this.executeUpdate(phase, ++appversion, ph);
        }
        switch (phase) {
            case SYSTEM: {
                this.app.getSettings().setXmlVersion(this.getLastVersion());
                this.app.getSettings().saveToFile();
                break;
            }
            case PREPARE: {
                break;
            }
            case INIT: 
            case OPEN: {
                this.project.getDatastorage().setDatabaseApplicationVersion("themisupdate", appversion);
            }
        }
        if (loopcounter > 0) {
            this.project.getLogger().info("Update phase " + (Object)((Object)phase) + ": updated from version " + origAppVersion + " -> " + lastAppversion);
        } else {
            this.project.getLogger().info("Update phase " + (Object)((Object)phase) + ": nothing to do");
        }
    }

    public void updateThemisProjectStructureVersion(int v) {
        int v0;
        if (this.project.isOpen() && v > (v0 = this.project.getDatastorage().getDatabaseApplicationVersion("themis"))) {
            this.project.getDatastorage().setDatabaseApplicationVersion("themis", v);
        }
    }

    public boolean updateApplicationDatabaseSingleAction(ProgressHandler ph, int v) {
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        switch (v) {
            case 7: {
                CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getAdminUser(), "observation");
                List recs = s.search().getResult();
                for (DataRecord rec : recs) {
                    CmsObservation obs = (CmsObservation)this.project.loadElement(rec.getLong("meta_id"), this.project.getAdminUser());
                    if (obs.getUploadAttribute("files").size() <= 0) continue;
                    ArrayList<CmsElement> histories = new ArrayList<CmsElement>();
                    Iterator iterator = obs.getRelationAttribute("histories").getElementIds().iterator();
                    while (iterator.hasNext()) {
                        long id = (Long)iterator.next();
                        histories.add(this.project.loadElement(id, this.project.getAdminUser()));
                    }
                    if (histories.isEmpty()) continue;
                    Collections.sort(histories, new Comparator<CmsElement>(){

                        @Override
                        public int compare(CmsElement o1, CmsElement o2) {
                            if (!o1.hasAttributeValue("eventdate") || !o2.hasAttributeValue("eventdate")) {
                                return 0;
                            }
                            return o1.getDateAttribute("eventdate").getDate().before(o2.getDateAttribute("eventdate").getDate()) ? -1 : 1;
                        }
                    });
                    for (UploadItem upload : obs.getUploadAttribute("files").getUploadItems()) {
                        Date uploaddate = upload.getUploaddate();
                        CmsHistory hist = null;
                        for (CmsElement h : histories) {
                            if (hist == null) {
                                hist = (CmsHistory)h;
                                continue;
                            }
                            long delta1 = uploaddate.getTime() - hist.getDateAttribute("eventdate").getDate().getTime();
                            long delta2 = uploaddate.getTime() - h.getDateAttribute("eventdate").getDate().getTime();
                            if (delta2 < 0L || delta2 >= delta1) continue;
                            hist = (CmsHistory)h;
                        }
                        if (hist == null) {
                            hist = (CmsHistory)((Object)histories.get(histories.size() - 1));
                        }
                        hist.getUploadAttribute("files").addUpload(upload);
                    }
                    for (CmsElement h : histories) {
                        h.save();
                    }
                }
                return true;
            }
            case 8: {
                CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getAdminUser(), "history");
                List recs = s.search().getResult();
                for (DataRecord rec : recs) {
                    this.project.loadElement(rec.getLong("meta_id"), this.project.getAdminUser()).save();
                }
                return true;
            }
            case 9: {
                boolean updateDB = true;
                boolean selContact = false;
                boolean selPrioity = false;
                boolean selTopic = true;
                if (updateDB) {
                    if (!selContact) {
                        if (selPrioity) {
                            CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "company");
                            s.addSelectMeta();
                            List recs = s.search().getResult();
                            if (!recs.isEmpty()) {
                                Keytable tbl = this.project.getKeytable("priority");
                                tbl.clear();
                                for (DataRecord rec : recs) {
                                    tbl.addTerm(rec.getLong("meta_id").longValue(), rec.getString("meta_lang"), rec.getString("meta_title"));
                                }
                                tbl.save();
                                this.project.getDatastorage().executeUpdate("UPDATE tdtaEleObservation AS o SET idpriority = (SELECT elementTo FROM tdtaRelation AS r WHERE o.idelement=r.elementFrom AND r.relationcode='observationcompany')", true);
                                this.project.getDatastorage().executeUpdate("DELETE FROM tdtaRelation WHERE relationcode='observationcompany'm", true);
                            }
                        } else if (selTopic) {
                            CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "company");
                            s.addSelectMeta();
                            List recs = s.search().getResult();
                            if (!recs.isEmpty()) {
                                Keytable tbl = this.project.getKeytable("topic");
                                tbl.clear();
                                for (DataRecord rec : recs) {
                                    tbl.addTerm(rec.getLong("meta_id").longValue(), rec.getString("meta_lang"), rec.getString("meta_title"));
                                }
                                tbl.save();
                                this.project.getDatastorage().executeUpdate("UPDATE tdtaEleObservation AS o SET idtopic = (SELECT elementTo FROM tdtaRelation AS r WHERE o.idelement=r.elementFrom AND r.relationcode='observationcompany')", true);
                                this.project.getDatastorage().executeUpdate("DELETE FROM tdtaRelation WHERE r.relationcode='observationcompany')", true);
                            }
                        }
                    }
                } else {
                    return true;
                }
                return true;
            }
            case 10: {
                Keytable tbl = this.project.getKeytable("priority");
                if (!tbl.hasName("de")) {
                    tbl.addName("de", "Priorit\u00e4t");
                }
                if (!(tbl = this.project.getKeytable("observationtype")).hasName("de")) {
                    tbl.addName("de", "Kategorie");
                }
                if (!(tbl = this.project.getKeytable("topic")).hasName("de")) {
                    tbl.addName("de", "Thema");
                }
                return true;
            }
            case 11: {
                this.project.getDatastorage().executeUpdate("ALTER TABLE tdtaElementHistory DROP PRIMARY KEY", true);
                return true;
            }
            case 12: {
                CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getAdminUser(), "observationtemplate");
                ArrayList ids = s.search().getResultIds();
                Iterator h = ids.iterator();
                while (h.hasNext()) {
                    long id = (Long)h.next();
                    this.project.loadElement(id, this.project.getAdminUser()).save();
                }
                return true;
            }
            case 13: {
                return true;
            }
            case 14: {
                CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getAdminUser(), "observation");
                ArrayList ids = s.search().getResultIds();
                Iterator h = ids.iterator();
                while (h.hasNext()) {
                    long id2 = (Long)h.next();
                    CmsObservation obs = (CmsObservation)this.project.loadElement(id2, this.project.getAdminUser());
                    ArrayList<UploadItem> uploads = obs.getUploads(false);
                    ArrayList<Long> toBeRemoved = new ArrayList<Long>();
                    for (CmsElement hist : obs.getHistories()) {
                        List histUploads = hist.getUploadAttribute("files").getUploadItems();
                        toBeRemoved.clear();
                        for (UploadItem item : histUploads) {
                            if (uploads.contains(item)) {
                                uploads.remove(item);
                                continue;
                            }
                            toBeRemoved.add(item.getId());
                        }
                        Iterator iterator = toBeRemoved.iterator();
                        while (iterator.hasNext()) {
                            long itemid = (Long)iterator.next();
                            hist.getUploadAttribute("files").deleteUpload(itemid);
                        }
                        hist.getUploadAttribute("files").clearItemsToBeRemoved();
                    }
                    if (!uploads.isEmpty()) {
                        this.project.app.getDialog().showWarningDialog("unreferenced upload in osbervation " + obs.getTitle());
                    }
                    obs.save();
                }
                return true;
            }
            case 15: {
                Object eleLoc;
                long id;
                CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getAdminUser(), "location");
                s.setSort("meta_id");
                ArrayList ids = s.search().getResultIds();
                int counter = 1;
                Iterator id2 = ids.iterator();
                while (id2.hasNext()) {
                    id = (Long)id2.next();
                    this.project.getDatastorage().executeUpdate("UPDATE tdtaEleLocation SET number = '" + counter + "' WHERE idelement=" + id, true);
                    this.project.loadElement(id, this.project.getAdminUser()).save();
                    ++counter;
                }
                if (this.project.app.getDialog().showConfirmDialog("Sollen die Beobachtungen neu nummeriert werden?", "Beobachtungen neu nummerieren")) {
                    s = new CmsBasicSearch((CmsApplication)this.project, this.project.getAdminUser(), "observation");
                    ids = s.search().getResultIds();
                    id2 = ids.iterator();
                    while (id2.hasNext()) {
                        id = (Long)id2.next();
                        CmsObservation obs = (CmsObservation)this.project.loadElement(id, this.project.getAdminUser());
                        eleLoc = obs.getRelationAttribute("location").getFirstElement();
                        if (eleLoc != null) {
                            CmsLocation loc = (CmsLocation)obs.getRelationAttribute("location").getFirstElement().getElement();
                            int number = loc.getRelationAttribute("observations").getElementIds().indexOf(id);
                            number = number < 0 ? loc.getRelationAttribute("observations").size() + 1 : ++number;
                            obs.getLongAttribute("number").setValue((long)number);
                            obs.setCurrentHistoryToBeIgnored();
                            obs.save();
                            continue;
                        }
                        this.project.getLogger().warning("Observation deleted due to missing location: #" + obs.getId() + " " + obs.getTitle());
                        obs.moveToTrash();
                    }
                }
                Properties propsConfig = new Properties();
                File f = new File(new File(this.project.getProjectFolder(), "conf"), "themis.properties");
                if (f.isFile()) {
                    try {
                        propsConfig.load(new FileReader(f));
                        propsConfig.remove("db.uri");
                        if (this.project.getProjectProperty("project.title") == null) {
                            this.project.setProjectProperty("project.title", propsConfig.getProperty("project.title", ""));
                        }
                        if (this.project.getProjectProperty("project.info") == null) {
                            this.project.setProjectProperty("project.info", propsConfig.getProperty("project.info", ""));
                        }
                        if (this.project.getProjectProperty("project.client") == null) {
                            this.project.setProjectProperty("project.client", propsConfig.getProperty("project.client", ""));
                        }
                        if (this.project.getProjectProperty("project.number") == null) {
                            this.project.setProjectProperty("project.number", propsConfig.getProperty("project.number", ""));
                        }
                    }
                    catch (FileNotFoundException uploads) {
                    }
                    catch (IOException uploads) {
                        // empty catch block
                    }
                }
                CmsProject p = (CmsProject)this.project.createElement("project");
                p.setAttributeValue("projecttitle", this.project.getProjectProperty("project.title"));
                p.setAttributeValue("longtext2", this.project.getProjectProperty("project.client"));
                p.setAttributeValue("text1", this.project.getProjectProperty("project.number"));
                p.setAttributeValue("longtext3", this.project.getProjectProperty("project.info"));
                p.save();
                s = new CmsBasicSearch((CmsApplication)this.project, this.project.getAdminUser(), "observation");
                ids = s.search().getResultIds();
                eleLoc = ids.iterator();
                while (eleLoc.hasNext()) {
                    long id3 = (Long)eleLoc.next();
                    this.project.loadElement(id3, this.project.getAdminUser()).save();
                }
                try {
                    Properties fileProps = new Properties();
                    File f2 = new File(this.project.getProjectFolder(), "conf/themis.properties");
                    if (f2.exists()) {
                        fileProps.load(new FileReader(f2));
                        for (String k : fileProps.stringPropertyNames()) {
                            this.project.setProjectProperty(k, fileProps.getProperty(k));
                        }
                    } else {
                        ThemisLogger.logger.log(Level.INFO, "Project properties file does not exist!");
                    }
                }
                catch (IOException ex) {
                    ThemisLogger.logger.log(Level.SEVERE, "Error while trying to load project properties: " + ex.getLocalizedMessage(), ex);
                }
                return true;
            }
            case 16: {
                CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getAdminUser(), "observation");
                ArrayList ids = s.search().getResultIds();
                Iterator ex = ids.iterator();
                while (ex.hasNext()) {
                    long id = (Long)ex.next();
                    CmsObservation obs = (CmsObservation)this.project.loadElement(id, this.project.getAdminUser());
                    obs.getUploads(false);
                    obs.save();
                    for (CmsElement ele : obs.getHistories()) {
                        ele.save();
                    }
                }
                return true;
            }
            case 17: {
                CmsUser u = this.project.getUser();
                long idgroup = u.getMainGroupId();
                this.project.getDatastorage().executeUpdate("UPDATE tdtaElement SET metaowner = " + idgroup, true);
                this.project.getDatastorage().executeUpdate("UPDATE tdtaElementlng SET metatranslator = " + u.getId(), true);
                this.project.getDatastorage().executeUpdate("UPDATE tdtaElement SET metacreator = " + u.getId(), true);
                this.project.getDatastorage().executeUpdate("UPDATE tdtaElement SET idwriteaccess = 3", true);
                if (!this.executedUpdates.contains(15)) {
                    CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "observation");
                    ArrayList ids = s.search().getResultIds();
                    Iterator number = ids.iterator();
                    while (number.hasNext()) {
                        long id = (Long)number.next();
                        CmsObservation obs = (CmsObservation)this.project.loadElement(id, this.project.getAdminUser());
                        obs.save();
                    }
                }
                return true;
            }
            case 18: {
                return true;
            }
            case 19: {
                CmsUser u = this.project.getUser();
                long idgroup = u.getMainGroupId();
                this.project.getDatastorage().executeUpdate("UPDATE tdtaElement SET metaowner = " + idgroup, true);
                this.project.getDatastorage().executeUpdate("UPDATE tdtaElementlng SET metatranslator = " + u.getId(), true);
                this.project.getDatastorage().executeUpdate("UPDATE tdtaElement SET metacreator = " + u.getId(), true);
                this.project.getDatastorage().executeUpdate("UPDATE tdtaElement SET idwriteaccess = 3", true);
                return true;
            }
            case 20: {
                String fieldType = this.project.getDatastorage().getFieldType(13, 0);
                if (!this.project.getDatastorage().hasTable("tdtaDrawing")) {
                    this.project.getDatastorage().executeUpdate("CREATE TABLE tdtaDrawing (idfileupload BIGINT, idgeometry BIGINT, geometry " + fieldType + ", PRIMARY KEY (idfileupload,idgeometry));", true);
                }
                return true;
            }
            case 21: {
                this.project.getDatastorage().executeUpdate("UPDATE tdtaEleObservation AS o SET editor = (SELECT u.username FROM tdtaUser AS u INNER JOIN tdtaElementLng AS el ON (el.metatranslator=u.idelement) WHERE o.idelement=el.idelement) ", true);
                this.project.setProjectProperty("observationtable.column.editor", "hide");
                return true;
            }
            case 22: {
                this.project.getDatastorage().executeUpdate("ALTER USER themis SET PASSWORD 'oE93ly-2oq'", true);
                return true;
            }
            case 23: {
                String fieldType = this.project.getDatastorage().getFieldType(7, 0);
                if (!this.project.getDatastorage().hasTableField("tdtaDrawing", "geometrytype")) {
                    this.project.getDatastorage().executeUpdate("ALTER TABLE tdtaDrawing ADD geometrytype " + fieldType, true);
                }
                return true;
            }
            case 24: {
                List recs = this.project.getDatastorage().executeQuery("SELECT elementfrom,elementto FROM tdtarelation WHERE relationcode='locationtemplategroup'", true).getResult();
                for (DataRecord rec : recs) {
                    this.project.getDatastorage().executeUpdate("UPDATE tdtaEleLocationtemplate SET idgroup = " + rec.getLong("elementto") + " WHERE idelement = " + rec.getLong("elementfrom"), true);
                }
                return true;
            }
            case 25: {
                CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "plan");
                ArrayList ids = s.search().getResultIds();
                Iterator rec = ids.iterator();
                while (rec.hasNext()) {
                    long id = (Long)rec.next();
                    CmsPlan plan = (CmsPlan)this.project.loadElement(id, this.project.getUser());
                    CmsPlanfile planfile = plan.getCurrentPlanfileElement();
                    UploadItem item = plan.getUploadAttribute("image").getFirstUploadItem();
                    if (item != null) {
                        planfile.getUploadAttribute("image").addUpload(item);
                        Dimension d = Util.getJPEGDimension((File)item.getFile());
                        planfile.getIntegerAttribute("imagewidth").setValue(d.width);
                        planfile.getIntegerAttribute("imageheight").setValue(d.height);
                    }
                    plan.getRelationAttribute("planfiles").add((CmsElement)planfile);
                    plan.getLongAttribute("currentplanfile").setValue(planfile.getId());
                    plan.getUploadAttribute("image").getUploadItems().clear();
                    plan.save();
                }
                return true;
            }
            case 26: {
                long id;
                ArrayList ids = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "plan").search().getResultIds();
                Iterator rec = ids.iterator();
                while (rec.hasNext()) {
                    id = (Long)rec.next();
                    this.project.loadElement(id, this.project.getUser()).save();
                }
                ids = new CmsBasicSearch((CmsApplication)this.project, this.project.getAdminUser(), "company").search().getResultIds();
                rec = ids.iterator();
                while (rec.hasNext()) {
                    id = (Long)rec.next();
                    this.project.loadElement(id, this.project.getUser()).save();
                }
                ids = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "event").search().getResultIds();
                rec = ids.iterator();
                while (rec.hasNext()) {
                    id = (Long)rec.next();
                    this.project.loadElement(id, this.project.getUser()).save();
                }
                ids = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "location").search().getResultIds();
                rec = ids.iterator();
                while (rec.hasNext()) {
                    id = (Long)rec.next();
                    this.project.loadElement(id, this.project.getUser()).save();
                }
                ids = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "info").search().getResultIds();
                rec = ids.iterator();
                while (rec.hasNext()) {
                    id = (Long)rec.next();
                    this.project.loadElement(id, this.project.getUser()).save();
                }
                this.project.getDatastorage().executeUpdate("UPDATE tdtaElementLng AS el SET summary = (SELECT description FROM tdtaEleObservation AS o WHERE el.idelement=o.idelement)", true);
                return true;
            }
            case 27: {
                this.project.getDatastorage().executeUpdate("UPDATE tdtaEleObservation SET idtype = 1", true);
                return true;
            }
            case 28: {
                Keytable keytable = this.project.getKeytable("uploaddetail");
                if (!keytable.hasId(1L, this.project.getUser().getCurrentLanguage())) {
                    keytable.addTerm(1L, this.project.getUser().getCurrentLanguage(), "Protokoll");
                }
                if (!keytable.hasId(2L, this.project.getUser().getCurrentLanguage())) {
                    keytable.addTerm(2L, this.project.getUser().getCurrentLanguage(), "Intern");
                }
                return true;
            }
            case 29: {
                Keytable keytable = this.project.getKeytable("obstype");
                if (!keytable.hasId(4L, this.project.getUser().getCurrentLanguage())) {
                    keytable.addTerm(4L, this.project.getUser().getCurrentLanguage(), "Aufgabe");
                    keytable.save();
                }
                return true;
            }
            case 30: {
                return true;
            }
            case 31: {
                for (DataRecord rec : this.project.getDatastorage().executeQuery("select distinct constraint_name as c from information_schema.constraints where lower(table_name)='tdtadrawing' and lower(column_list)='idfileupload'", true).getResult()) {
                    String constraint = rec.getString("c");
                    this.project.getDatastorage().executeUpdate("alter table tdtadrawing drop constraint " + constraint, true);
                }
                return true;
            }
            case 32: {
                List recs = this.project.getDatastorage().executeQuery("SELECT h.idelement AS idHistory, h.code AS histCode, h.quantity AS histquantity, o.code AS obsCode, o.quantity AS obsquantity FROM tdtaelehistory AS h INNER JOIN tdtarelation AS r ON (h.idelement=r.elementfrom AND r.relationcode='historyobservation') INNER JOIN tdtaeleobservation AS o ON (o.idelement=r.elementto)", true).getResult();
                for (DataRecord rec : recs) {
                    String obsCode = rec.getString("obscode");
                    String obsQuantity = rec.getString("obsquantity");
                    if (rec.isNull("histcode")) {
                        this.project.getDatastorage().executeUpdate("UPDATE tdtaEleHistory SET code=" + Util.toSqlString((String)obsCode) + " WHERE idelement = " + rec.getLong("idhistory"), true);
                    }
                    if (!rec.isNull("histquantity")) continue;
                    this.project.getDatastorage().executeUpdate("UPDATE tdtaEleHistory SET quantity=" + Util.toSqlString((String)obsQuantity) + " WHERE idelement = " + rec.getLong("idhistory"), true);
                }
                return true;
            }
            case 33: {
                this.project.getDatastorage().executeUpdate("UPDATE tdtaEleObservation SET idtype=1 WHERE idtype IS NULL", true);
                return true;
            }
            case 34: {
                return true;
            }
            case 35: {
                CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getAdminUser(), "plan");
                ArrayList ids = s.search().getResultIds();
                Iterator rec = ids.iterator();
                while (rec.hasNext()) {
                    long id = (Long)rec.next();
                    this.project.loadElement(id, this.project.getAdminUser()).save();
                }
                return true;
            }
            case 36: {
                return true;
            }
            case 37: {
                ArrayList<String> dbupdates = new ArrayList<String>();
                for (String et : this.project.getElementtypes()) {
                    CmsElement e = this.project.getDefaultElement(et);
                    for (CmsAttribute att : e.getAttributes()) {
                        if (!att.isOfType(13)) continue;
                        String tablename = e.getTablename();
                        String fieldname = att.getField();
                        dbupdates.add(tablename + ":" + fieldname);
                    }
                }
                dbupdates.add("tdtadrawing:geometry");
                dbupdates.add("tdtafileupload:path");
                dbupdates.add("tdtaelementlng:summary");
                dbupdates.add("config:stringval");
                for (String dbupdate : dbupdates) {
                    String[] split = dbupdate.split(":");
                    String tablename = split[0];
                    String fieldname = split[1];
                    this.project.getDatastorage().executeUpdate("ALTER TABLE " + tablename + " ADD " + fieldname + "vc varchar", true);
                    this.project.getDatastorage().executeUpdate("UPDATE " + tablename + " SET " + fieldname + "vc = " + fieldname, true);
                    this.project.getDatastorage().executeUpdate("ALTER TABLE " + tablename + " DROP " + fieldname, true);
                    this.project.getDatastorage().executeUpdate("ALTER TABLE " + tablename + " ALTER COLUMN " + fieldname + "vc rename to " + fieldname, true);
                    this.project.getLogger().info("updated table field " + tablename + "." + fieldname + " to VARCHAR ...");
                }
                return true;
            }
            case 38: {
                this.project.getDatastorage().executeUpdate("create table config2 as select * from config where key='ontologyversion'", true);
                List recs2 = this.project.getDatastorage().executeQuery("select distinct key from config", true).getResult();
                int insertCount = 0;
                for (DataRecord rec : recs2) {
                    DataRecord row = this.project.getDatastorage().executeQuery("select * from config where key='" + rec.getString("key") + "' order by datetime desc limit 1", true).firstRow();
                    String intval = "null";
                    if (!row.isEmpty("intval")) {
                        intval = row.getString("intval");
                    }
                    if ((insertCount += this.project.getDatastorage().executeUpdate("insert into config2 values (" + Util.toSqlString((String)row.getString("datetime")) + "," + Util.toSqlString((String)row.getString("key")) + "," + intval + "," + Util.toSqlString((String)row.getString("stringval")) + ")", true)) != 0) continue;
                    return true;
                }
                this.project.getDatastorage().executeUpdate("drop table config", true);
                this.project.getDatastorage().executeUpdate("alter table config2 rename to config", true);
                this.project.getDatastorage().executeUpdate("create index config_key on config(key)", true);
                return true;
            }
            case 39: {
                this.project.getDatastorage().executeUpdate("UPDATE tdtaEleLocation AS l SET (groupfullid) = (SELECT r.elementto || '.' FROM tdtaRelation AS r WHERE (l.idelement=r.elementfrom AND r.relationcode='locationgroup'))", true);
                return true;
            }
        }
        return false;
    }

    public int updateProjectSettings(int v) {
        int newVersion = v;
        switch (v) {
            case 0: {
                this.app.getProject().getDatastorage().executeUpdate("CREATE TABLE config2 AS SELECT * FROM config", true);
                this.app.getProject().getDatastorage().executeUpdate("DROP TABLE config", true);
                this.app.getProject().getDatastorage().executeUpdate("ALTER TABLE config2 RENAME TO config", true);
                try {
                    this.app.getSettings().setImageUploadSize(Integer.parseInt(this.project.getProjectProperty("image.size", this.app.getConfiguration("image.size", "2000"))));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++newVersion;
            }
            case 1: {
                boolean imageForObs = "obs".equalsIgnoreCase(this.project.getProjectProperty("attribute.addfoto", "obs"));
                this.app.getSettings().setImageForObservation(imageForObs);
                this.app.getSettings().setImageForLocation(!imageForObs);
                ++newVersion;
            }
            case 2: {
                this.app.getSettings().setPermissionEditTemplates(this.project.getProjectProperty("permission.edittemplate", "*"));
                ++newVersion;
            }
            case 3: {
                this.app.getSettings().setDisplayIconSize(ThemisUtil.validateInteger(this.project.getProjectProperty("icon.size", this.app.getConfiguration("icon.size", "30")), 30, true, "", false));
                this.app.getSettings().setDisplayPointSize(ThemisUtil.validateInteger(this.project.getProjectProperty("point.size", this.app.getConfiguration("point.size", "15")), 15, true, "", false));
                this.app.getSettings().setDisplayLineSize(ThemisUtil.validateInteger(this.project.getProjectProperty("line.size", this.app.getConfiguration("line.size", "6")), 6, true, "", false));
                this.app.getSettings().setDisplayFontSize(ThemisUtil.validateInteger(this.project.getProjectProperty("font.size", this.app.getConfiguration("font.size", "14")), 14, true, "", false));
                ++newVersion;
            }
            case 4: {
                this.app.getSettings().setDisplayColorPoint(this.project.getProjectProperty("display.color.default", "242,142,4"));
                this.app.getSettings().setDisplayColorPointSelected(this.project.getProjectProperty("display.color.sel", "4,30,100"));
                ++newVersion;
            }
            case 5: {
                this.app.getSettings().getLocationAttribute("documents").setUsed(this.checkOldShowAttribute("locDocument"));
                this.app.getSettings().getLocationAttribute("list1").setUsed(this.checkOldShowAttribute("locList1"));
                this.app.getSettings().getLocationAttribute("list1").setLabel(this.project.getProjectProperty("attribute.loclist1.name", "Liste 1"));
                this.app.getSettings().getLocationAttribute("list2").setUsed(this.checkOldShowAttribute("locList2"));
                this.app.getSettings().getLocationAttribute("list2").setLabel(this.project.getProjectProperty("attribute.loclist2.name", "Liste 2"));
                this.app.getSettings().getLocationAttribute("text1").setUsed(this.checkOldShowAttribute("locCode1"));
                this.app.getSettings().getLocationAttribute("text1").setLabel(this.project.getProjectProperty("attribute.loccode.name", "Text 1"));
                this.app.getSettings().getLocationAttribute("text2").setUsed(this.checkOldShowAttribute("locCode2"));
                this.app.getSettings().getLocationAttribute("text2").setLabel(this.project.getProjectProperty("attribute.loccode2.name", "Text 2"));
                this.app.getSettings().getLocationAttribute("barcode").setUsed(this.checkOldShowAttribute("locBarcode"));
                this.app.getSettings().getLocationAttribute("quantity").setUsed(this.checkOldShowAttribute("locQuantity"));
                this.app.getSettings().getLocationAttribute("icon").setUsed(this.checkOldShowAttribute("locIcon"));
                this.app.getSettings().getLocationAttribute("group").setUsed(this.checkOldShowAttribute("locGroup"));
                this.app.getSettings().getLocationAttribute("size").setUsed(this.checkOldShowAttribute("locDimension"));
                this.app.getSettings().getLocationAttribute("prefixsuffix").setUsed(this.checkOldShowAttribute("locPrefixSuffix"));
                this.app.getSettings().getLocationAttribute("suffix").setUsed(this.checkOldShowAttribute("locPrefixSuffix"));
                ++newVersion;
            }
            case 6: {
                this.app.getSettings().getObservationAttribute("quantity").setUsed(this.checkOldShowAttribute("quantity"));
                this.app.getSettings().getObservationAttribute("duedate").setUsed(this.checkOldShowAttribute("duedate"));
                this.app.getSettings().getObservationAttribute("donedate").setUsed(this.checkOldShowAttribute("done"));
                this.app.getSettings().getObservationAttribute("done").setUsed(this.checkOldShowAttribute("done"));
                this.app.getSettings().getObservationAttribute("assessment").setUsed(this.checkOldShowAttribute("risk"));
                this.app.getSettings().getObservationAttribute("assessment").setLabel(this.project.getProjectProperty("attribute.obsrisk.name", "Beurteilung"));
                this.app.getSettings().getObservationAttribute("responsible").setUsed(this.checkOldShowAttribute("contactname"));
                this.app.getSettings().getObservationAttribute("measure").setUsed(this.checkOldShowAttribute("measure"));
                this.app.getSettings().getObservationAttribute("documents").setUsed(this.checkOldShowAttribute("document"));
                this.app.getSettings().getObservationAttribute("text1").setUsed(this.checkOldShowAttribute("obsCode1"));
                this.app.getSettings().getObservationAttribute("text1").setLabel(this.project.getProjectProperty("attribute.obscode.name", "Text 1"));
                this.app.getSettings().getObservationAttribute("text2").setUsed(this.checkOldShowAttribute("freetext1"));
                this.app.getSettings().getObservationAttribute("text2").setLabel(this.project.getProjectProperty("attribute.obsfreetext1.name", "Text 2"));
                this.app.getSettings().getObservationAttribute("text3").setUsed(this.checkOldShowAttribute("freetext2"));
                this.app.getSettings().getObservationAttribute("text3").setLabel(this.project.getProjectProperty("attribute.obsfreetext2.name", "Text 3"));
                this.app.getSettings().getObservationAttribute("text4").setUsed(this.checkOldShowAttribute("freetext3"));
                this.app.getSettings().getObservationAttribute("text4").setLabel(this.project.getProjectProperty("attribute.obsfreetext3.name", "Text 4"));
                this.app.getSettings().getObservationAttribute("longtext1").setUsed(this.checkOldShowAttribute("langtext1"));
                this.app.getSettings().getObservationAttribute("longtext1").setLabel(this.project.getProjectProperty("attribute.obslangtext1.name", "Langtext 1"));
                this.app.getSettings().getObservationAttribute("longtext2").setUsed(this.checkOldShowAttribute("langtext2"));
                this.app.getSettings().getObservationAttribute("longtext2").setLabel(this.project.getProjectProperty("attribute.obslangtext2.name", "Langtext 2"));
                this.app.getSettings().getObservationAttribute("list1").setUsed(this.checkOldShowAttribute("topic"));
                this.app.getSettings().getObservationAttribute("list1").setLabel(this.project.getProjectProperty("attribute.obstopic.name", "Liste 1"));
                this.app.getSettings().getObservationAttribute("list2").setUsed(this.checkOldShowAttribute("observationtype"));
                this.app.getSettings().getObservationAttribute("list2").setLabel(this.project.getProjectProperty("attribute.observationtype.name", "Liste 2"));
                this.app.getSettings().getObservationAttribute("list3").setUsed(this.checkOldShowAttribute("priority"));
                this.app.getSettings().getObservationAttribute("list3").setLabel(this.project.getProjectProperty("attribute.obspriority.name", "Liste 3"));
                ++newVersion;
            }
            case 7: {
                String atts = this.app.getConfiguration("observationtable.display", "type,fullnumber,location,observationtitle,plan,duedate,done,control,hasaudio,hasimage");
                this.app.getSettings().clearObservationTableAttributes();
                String[] stringArray = atts.split(",");
                int n = stringArray.length;
                block80: for (int i = 0; i < n; ++i) {
                    String att;
                    switch (att = stringArray[i]) {
                        case "type": {
                            this.app.getSettings().addObservationTableAttributes("observation", "type");
                            continue block80;
                        }
                        case "fullnumber": {
                            this.app.getSettings().addObservationTableAttributes("observation", "fullnumber");
                            continue block80;
                        }
                        case "plan": {
                            this.app.getSettings().addObservationTableAttributes("location", "plan");
                            continue block80;
                        }
                        case "location": {
                            this.app.getSettings().addObservationTableAttributes("location", "title");
                            continue block80;
                        }
                        case "referencedate": {
                            this.app.getSettings().addObservationTableAttributes("observation", "controldate");
                            continue block80;
                        }
                        case "editor": {
                            this.app.getSettings().addObservationTableAttributes("observation", "editor");
                            continue block80;
                        }
                        case "control": {
                            this.app.getSettings().addObservationTableAttributes("observation", "control");
                            continue block80;
                        }
                        case "observationtitle": {
                            this.app.getSettings().addObservationTableAttributes("observation", "title");
                            continue block80;
                        }
                        case "description": {
                            this.app.getSettings().addObservationTableAttributes("location", "description");
                            continue block80;
                        }
                        case "observationdescription": {
                            this.app.getSettings().addObservationTableAttributes("observation", "description");
                            continue block80;
                        }
                        case "langtext1": {
                            this.app.getSettings().addObservationTableAttributes("observation", "longtext1");
                            continue block80;
                        }
                        case "langtext2": {
                            this.app.getSettings().addObservationTableAttributes("observation", "longtext2");
                            continue block80;
                        }
                        case "measure": {
                            this.app.getSettings().addObservationTableAttributes("observation", "measure");
                            continue block80;
                        }
                        case "duedate": {
                            this.app.getSettings().addObservationTableAttributes("observation", "duedate");
                            continue block80;
                        }
                        case "done": {
                            this.app.getSettings().addObservationTableAttributes("observation", "done");
                            continue block80;
                        }
                        case "contactname": {
                            this.app.getSettings().addObservationTableAttributes("observation", "responsible");
                            continue block80;
                        }
                        case "topic": {
                            this.app.getSettings().addObservationTableAttributes("observation", "list1");
                            continue block80;
                        }
                        case "observationtype": {
                            this.app.getSettings().addObservationTableAttributes("observation", "list2");
                            continue block80;
                        }
                        case "priority": {
                            this.app.getSettings().addObservationTableAttributes("observation", "list3");
                            continue block80;
                        }
                        case "risk": {
                            this.app.getSettings().addObservationTableAttributes("observation", "assessment");
                            continue block80;
                        }
                        case "code": {
                            this.app.getSettings().addObservationTableAttributes("observation", "text1");
                            continue block80;
                        }
                        case "freetext1": {
                            this.app.getSettings().addObservationTableAttributes("observation", "text2");
                            continue block80;
                        }
                        case "freetext2": {
                            this.app.getSettings().addObservationTableAttributes("observation", "text3");
                            continue block80;
                        }
                        case "freetext3": {
                            this.app.getSettings().addObservationTableAttributes("observation", "text4");
                            continue block80;
                        }
                        case "quantity": {
                            this.app.getSettings().addObservationTableAttributes("observation", "quantity");
                            continue block80;
                        }
                        case "hasimage": {
                            this.app.getSettings().addObservationTableAttributes("observation", "hasimage");
                            continue block80;
                        }
                        case "hasaudio": {
                            this.app.getSettings().addObservationTableAttributes("observation", "hasaudio");
                        }
                    }
                }
                ++newVersion;
            }
            case 8: {
                int systemsetting = Integer.parseInt(this.app.getConfiguration("display.label", "0"));
                String sel = this.project.getProjectProperty("project.plan.label", systemsetting == 1 || systemsetting == 2 ? "title" : "");
                if ("".equals(sel) || this.app.getSettings().getLocationAttribute(sel) == null) {
                    this.app.getSettings().setDisplayLabelAttribute(null);
                } else {
                    this.app.getSettings().setDisplayLabelAttribute(sel);
                }
                boolean withNumber = "yes".equalsIgnoreCase(this.project.getProjectProperty("project.plan.label-number", systemsetting < 2 ? "yes" : "no"));
                this.app.getSettings().setDisplayLabelNumber(withNumber);
                ++newVersion;
            }
            case 9: {
                int option = 0;
                if ("yes".equalsIgnoreCase(this.app.getConfiguration("display.hidedone", "no"))) {
                    option = 1;
                }
                this.app.getSettings().setDisplayHideDoneTask(option);
                ++newVersion;
            }
            case 10: {
                Element reportspec = new Element("reportspec");
                Element report = new Element("report");
                reportspec.addContent((Content)report);
                report.addContent((Content)new Element("title").setText(""));
                report.addContent((Content)new Element("number").setText(this.project.getProjectProperty("export.protocol.number", "")));
                report.addContent((Content)new Element("author").setText(this.project.getProjectProperty("export.protocol.author", "")));
                report.addContent((Content)new Element("version").setText(this.project.getProjectProperty("export.protocol.version", "")));
                report.addContent((Content)new Element("distribution").setText(this.project.getProjectProperty("export.protocol.distribution", "")));
                report.addContent((Content)new Element("information").setText(this.project.getProjectProperty("export.protocol.information", "")));
                Element export = new Element("export");
                reportspec.addContent((Content)export);
                export.addContent((Content)new Element("folder").setText(this.project.getProjectProperty("export.folder", "")));
                export.addContent((Content)new Element("subfolder").setText(this.project.getProjectProperty("export.createSubfolder", "yes")));
                export.addContent((Content)new Element("filename").setText(this.project.getProjectProperty("export.name", "")));
                export.addContent((Content)new Element("includenumber").setText(this.project.getProjectProperty("export.includeNumber", "no")));
                export.addContent((Content)new Element("includedate").setText(this.project.getProjectProperty("export.includeDate", "no")));
                export.addContent((Content)new Element("v1").setText("no"));
                Element content = new Element("content");
                reportspec.addContent((Content)content);
                content.addContent((Content)new Element("onlylocation").setText("no".equals(this.project.getProjectProperty("export.includeDate", "no")) ? "yes" : "no"));
                content.addContent((Content)new Element("withhistory").setText("no"));
                Element plan = new Element("plan");
                reportspec.addContent((Content)plan);
                String withPlans = "no";
                plan.addContent((Content)new Element("export").setText(withPlans));
                plan.addContent((Content)new Element("emptyPlans").setText(this.project.getProjectProperty("export.includeDate", "no")));
                plan.addContent((Content)new Element("transparency").setText(this.project.getProjectProperty("export.transparency", "0")));
                plan.addContent((Content)new Element("compression").setText(this.project.getProjectProperty("export.pdf.compression", "0")));
                plan.addContent((Content)new Element("infostamp").setText(this.project.getProjectProperty("export.infostamp", "0")));
                Element plansnippt = new Element("plansnippt");
                reportspec.addContent((Content)plansnippt);
                plansnippt.addContent((Content)new Element("size").setText(this.project.getProjectProperty("export.plansize", "0")));
                plansnippt.addContent((Content)new Element("label").setText(this.project.getProjectProperty("export.mapsnippet.withlabel", "no")));
                Element options = new Element("options");
                reportspec.addContent((Content)options);
                String showimages = "event";
                if ("1".equals(this.project.getProjectProperty("export.allimages", "1"))) {
                    showimages = "all";
                }
                options.addContent((Content)new Element("images").setText(showimages));
                options.addContent((Content)new Element("documents").setText(this.project.getProjectProperty("export.withDocuments", "no")));
                String hyperlink = "document";
                if ("1".equals(this.project.getProjectProperty("export.hyperlink", "1"))) {
                    hyperlink = "folder";
                }
                options.addContent((Content)new Element("documentlink").setText(hyperlink));
                this.app.getSettings().getXmlElement("/themis/project", true).removeChildren(reportspec.getName());
                this.app.getSettings().getXmlElement("/themis/project", true).addContent((Content)reportspec);
                ++newVersion;
            }
            case 11: {
                ++newVersion;
            }
            case 12: {
                this.app.getSettings().setTerm(ThemisSettings.Term.StatusOffen, this.app.getConfiguration("export.statusoffen", this.project.getResourceText("text.status-offen-default")));
                this.app.getSettings().setTerm(ThemisSettings.Term.StatusErledigt, this.app.getConfiguration("export.statuserledigt", this.project.getResourceText("text.status-erledigt-default")));
                this.app.getSettings().setTerm(ThemisSettings.Term.TypAufgabe, this.app.getConfiguration("text.observationtype.aufgabe", this.project.getResourceText("text.observationtype.aufgabe-default")));
                this.app.getSettings().setTerm(ThemisSettings.Term.TypInformation, this.app.getConfiguration("text.observationtype.info", this.project.getResourceText("text.observationtype.info-default")));
                this.app.getSettings().setTerm(ThemisSettings.Term.TypKontrolle, this.app.getConfiguration("text.observationtype.kontrolle", this.project.getResourceText("text.observationtype.kontrolle-default")));
                this.app.getSettings().setTerm(ThemisSettings.Term.TypMangel, this.app.getConfiguration("text.observationtype.mangel", this.project.getResourceText("text.observationtype.mangel-default")));
                this.app.getSettings().setTerm(ThemisSettings.Term.TextNoContent, "-");
                this.app.getSettings().setTerm(ThemisSettings.Term.TextNoEvent, this.app.getConfiguration("text.noevent", this.project.getResourceText("text.filter-noevent.info")));
                this.app.getSettings().setTerm(ThemisSettings.Term.TextNoImage, this.app.getConfiguration("text.noimage", this.project.getResourceText("text.no-image")));
                ++newVersion;
            }
            case 13: {
                ColorOption co;
                String colorBackground = this.app.getSettings().getXmlAttribute("/themis/project/display/color/label/@background", "51,102,255");
                boolean labelTransparent = this.app.getSettings().getXmlAttribute("/themis/project/display/color/label/@transparent", "false").equalsIgnoreCase("true");
                String colorText = this.app.getSettings().getXmlAttribute("/themis/project/display/color/label/@text", "255,255,255");
                if (labelTransparent) {
                    co = new ColorOption(this.project.getResourceText("ColorOption.none"));
                } else {
                    int coBackground = ColorOption.getColorFromString(colorBackground);
                    int coText = ColorOption.getColorFromString(colorText);
                    co = new ColorOption("", coBackground);
                    co.setForegroundColor(coText);
                }
                this.app.getSettings().setDisplayColorOption(co);
                ++newVersion;
            }
            case 14: {
                ++newVersion;
            }
            case 15: {
                int sizePx = this.app.getSettings().getDisplayIconSize();
                sizePx = (int)(254.0 * (double)sizePx / 300.0);
                this.app.getSettings().setDisplayIconSize(sizePx);
                this.app.getSettings().setDisplayPointSize((int)(254.0 * (double)this.app.getSettings().getDisplayPointSize() / 300.0));
                this.app.getSettings().setDisplayLineSize((int)(254.0 * (double)this.app.getSettings().getDisplayLineSize() / 300.0));
                this.app.getSettings().setDisplayFontSize((int)(254.0 * (double)this.app.getSettings().getDisplayFontSize() / 300.0));
                Point offset = this.app.getSettings().getDisplayLabelOffset();
                if (offset != null) {
                    offset.setX(254.0 * offset.getX() / 300.0);
                    offset.setY(254.0 * offset.getY() / 300.0);
                    this.app.getSettings().setDisplayLabelOffset(offset);
                }
                ++newVersion;
            }
            case 17: {
                this.update17();
                ++newVersion;
            }
            case 18: {
                Element e = this.app.getSettings().getXmlElement("/themis/project/attributes/observationtable", false);
                if (e != null) {
                    e = (Element)e.detach();
                    e.setName("attributes");
                    this.app.getSettings().getXmlElement("/themis/project/observationtable", true).addContent((Content)e);
                }
                ++newVersion;
            }
        }
        return newVersion;
    }

    public void updateUploadItems(ProgressHandler ph) {
        List recs;
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        if ((recs = this.project.getDatastorage().executeQuery("SELECT idfileupload,idelement FROM tdtafileupload WHERE code='files' AND (fileinfo='' or fileinfo='')", true).getResult()).size() > 30) {
            ph.progress(recs.size() + " Bilder werden aktualisiert - dies kann ggf. etwas dauern ...");
        }
        for (DataRecord rec : recs) {
            CmsElement e = this.project.loadElement(rec.getLong("idelement"), this.project.getUser());
            this.project.getDatastorage().executeUpdate("UPDATE tdtafileupload SET fileinfo=" + Util.toSqlString((String)e.getTitle()) + " WHERE idfileupload = " + rec.getLong("idfileupload"), true);
        }
    }

    private void changeElementAttribute(String elementtype, String fieldOld, String fieldNew) {
        String tbl = this.project.getDefaultElement(elementtype).getTablename();
        if (this.project.getDatastorage().hasTableField(tbl, fieldOld) && !this.project.getDatastorage().hasTableField(tbl, fieldNew)) {
            this.project.getDatastorage().executeUpdate("ALTER TABLE " + tbl + " ALTER COLUMN " + fieldOld + " RENAME TO " + fieldNew, true);
        } else if (this.project.getDatastorage().hasTableField(tbl, fieldOld)) {
            this.project.getDatastorage().executeUpdate("UPDATE " + tbl + " SET " + fieldNew + " = " + fieldOld, true);
            this.project.getDatastorage().executeUpdate("ALTER TABLE " + tbl + " DROP COLUMN " + fieldOld, true);
        }
        if ("observation".equals(elementtype)) {
            this.changeElementAttribute("observationtemplate", fieldOld, fieldNew);
        } else if ("location".equals(elementtype)) {
            this.changeElementAttribute("locationtemplate", fieldOld, fieldNew);
        }
        this.project.getLogger().info("Updated " + elementtype + " attribute: " + fieldOld + " -> " + fieldNew);
    }

    private void renameKeytable(String oldname, String newname) {
        if (this.project.getDatastorage().hasTable("tkey" + oldname)) {
            this.project.getDatastorage().executeUpdate("ALTER TABLE tkey" + oldname + " ALTER COLUMN id" + oldname + " RENAME TO id" + newname, true);
            this.project.getDatastorage().executeUpdate("ALTER TABLE tkey" + oldname + " ALTER COLUMN " + oldname + "sort RENAME TO " + newname + "sort", true);
            this.project.getDatastorage().executeUpdate("ALTER TABLE tkey" + oldname + " ALTER COLUMN " + oldname + "color RENAME TO " + newname + "color", true);
            this.project.getDatastorage().executeUpdate("ALTER TABLE tkey" + oldname + "lng ALTER COLUMN id" + oldname + " RENAME TO id" + newname, true);
            this.project.getDatastorage().executeUpdate("ALTER TABLE tkey" + oldname + "lng ALTER COLUMN " + oldname + "term RENAME TO " + newname + "term", true);
            if (this.project.getDatastorage().hasTable("tkey" + newname)) {
                this.project.getDatastorage().executeUpdate("ALTER TABLE tkey" + newname + " RENAME TO tkey" + newname + "_bak", true);
                this.project.getDatastorage().executeUpdate("ALTER TABLE tkey" + newname + "lng RENAME TO tkey" + newname + "lng_bak", true);
            }
            this.project.getDatastorage().executeUpdate("ALTER TABLE tkey" + oldname + " RENAME TO tkey" + newname, true);
            this.project.getDatastorage().executeUpdate("ALTER TABLE tkey" + oldname + "lng RENAME TO tkey" + newname + "lng", true);
        }
    }

    public boolean checkOldShowAttribute(String col) {
        String[] defaultFalse;
        for (String c : defaultFalse = new String[]{"title", " control", "measure", "quantity", "locDimension", "freetext1", "freetext2", "freetext3", "langtext1", "langtext2", "risk", "topic"}) {
            if (!c.equals(col)) continue;
            return "show".equals(this.app.getConfiguration("observationtable.column." + col, "hide"));
        }
        return "show".equals(this.app.getConfiguration("observationtable.column." + col, "show"));
    }

    public void updateElementsForVersion62() {
        this.changeElementAttribute("event", "comment", "longtext1");
        this.changeElementAttribute("event", "location", "text1");
        this.changeElementAttribute("company", "tel", "text1");
        this.changeElementAttribute("project", "projectnumber", "text1");
        this.changeElementAttribute("project", "projectlocation", "text2");
        this.changeElementAttribute("project", "customer", "longtext1");
        this.changeElementAttribute("project", "info", "longtext2");
        this.changeElementAttribute("observation", "code", "text1");
        this.changeElementAttribute("observation", "freetext1", "text2");
        this.changeElementAttribute("observation", "freetext2", "text3");
        this.changeElementAttribute("observation", "freetext3", "text4");
        this.changeElementAttribute("observation", "langtext1", "longtext1");
        this.changeElementAttribute("observation", "langtext2", "longtext2");
        this.changeElementAttribute("observation", "idtopic", "idobservationlist1");
        this.changeElementAttribute("observation", "idobservationtype", "idobservationlist2");
        this.changeElementAttribute("observation", "idpriority", "idobservationlist3");
        this.changeElementAttribute("observation", "quantity", "text5");
        this.renameKeytable("topic", "observationlist1");
        this.renameKeytable("observationtype", "observationlist2");
        this.renameKeytable("priority", "observationlist3");
        this.changeElementAttribute("observation", "idtype", "idobservationtype");
        this.renameKeytable("obstype", "observationtype");
        this.changeElementAttribute("observation", "idrepeat", "idobservationrepeat");
        this.renameKeytable("repeat", "observationrepeat");
        this.project.getDatastorage().executeUpdate("ALTER TABLE tdtaEleObservation ADD COLUMN float5 FLOAT", true);
        this.project.getDatastorage().executeUpdate("ALTER TABLE tdtaEleObservationTemplate ADD COLUMN float5 FLOAT", true);
        this.project.getDatastorage().executeUpdate("UPDATE tdtaEleObservation SET float5 = rpz", true);
        this.changeElementAttribute("location", "code", "text1");
        this.changeElementAttribute("location", "code2", "text2");
        this.changeElementAttribute("location", "quantity", "text5");
        this.changeElementAttribute("location", "idlist1", "idlocationlist1");
        this.changeElementAttribute("location", "idlist2", "idlocationlist2");
        this.changeElementAttribute("location", "idlist3", "idlocationlist3");
        this.changeElementAttribute("location", "idlist4", "idlocationlist4");
        this.renameKeytable("list1", "locationlist1");
        this.renameKeytable("list2", "locationlist2");
        this.renameKeytable("list3", "locationlist3");
        this.renameKeytable("list4", "locationlist4");
        this.project.getDatastorage().executeUpdate("ALTER TABLE tdtaEleProject DROP projectid", true);
        this.project.getDatastorage().executeUpdate("ALTER TABLE tdtaEleProject DROP masterpath", true);
        this.project.getDatastorage().executeUpdate("ALTER TABLE tdtaEleProject DROP masterlastelement", true);
        this.project.getDatastorage().executeUpdate("ALTER TABLE tdtaEleProject DROP masterlastupload", true);
    }

    public void update17() {
        String attid;
        int isUsed;
        List attributeElements;
        ThemisAttributeManager tam = this.app.getSettings().getEventAttributeManager();
        tam.addAttribute(ThemisAttribute.create(ThemisAttribute.Type.LONGTEXT, ThemisAttribute.Target.EVENT, "longtext1").setLabel("Beschreibung").setUsed(true), true);
        tam.addAttribute(ThemisAttribute.create(ThemisAttribute.Type.TEXT, ThemisAttribute.Target.EVENT, "text1").setLabel("Ort").setUsed(true), true);
        ThemisAttribute ta = tam.getAttribute("time");
        if (ta != null) {
            ta.setUsed(true);
        }
        if ((ta = tam.getAttribute("participants")) != null) {
            ta.setUsed(true);
        }
        tam = this.app.getSettings().getContactAttributeManager();
        tam.addAttribute(ThemisAttribute.create(ThemisAttribute.Type.TEXT, ThemisAttribute.Target.CONTACT, "text1").setLabel("Telefon").setUsed(true), true);
        ta = tam.getAttribute("email");
        if (ta != null) {
            ta.setUsed(true);
        }
        tam = this.app.getSettings().getProjectAttributeManager();
        tam.addAttribute(ThemisAttribute.create(ThemisAttribute.Type.TEXT, ThemisAttribute.Target.PROJECT, "text1").setLabel("Nummer").setUsed(true), true);
        tam.addAttribute(ThemisAttribute.create(ThemisAttribute.Type.TEXT, ThemisAttribute.Target.PROJECT, "text2").setLabel("Ort").setUsed(true), true);
        tam.addAttribute(ThemisAttribute.create(ThemisAttribute.Type.LONGTEXT, ThemisAttribute.Target.PROJECT, "longtext1").setLabel("Auftraggeber").setUsed(true), true);
        tam.addAttribute(ThemisAttribute.create(ThemisAttribute.Type.LONGTEXT, ThemisAttribute.Target.PROJECT, "longtext2").setLabel("Beschreibung").setUsed(true), true);
        HashMap<String, String> replaceCode = new HashMap<String, String>();
        replaceCode.put("code", "text1");
        replaceCode.put("freetext1", "text2");
        replaceCode.put("freetext2", "text3");
        replaceCode.put("freetext3", "text4");
        replaceCode.put("langtext1", "longtext1");
        replaceCode.put("langtext2", "longtext2");
        replaceCode.put("topic", "list1");
        replaceCode.put("observationtype", "list2");
        replaceCode.put("priority", "list3");
        replaceCode.put("quantity", "text5");
        replaceCode.put("risk", "float5");
        tam = this.app.getSettings().getObservationAttributeManager();
        ThemisAttributeManager tam2 = this.app.getSettings().getObservationTemplateAttributeManager();
        tam.clear();
        tam2.clear();
        Element e = this.app.getSettings().getXmlElement("/themis/project/attributes/observationattributes", false);
        if (e != null) {
            attributeElements = e.getChildren("observationattribute");
            for (Element a : attributeElements) {
                for (String att : new String[]{"id", "code", "keytable"}) {
                    if (a.getAttribute(att) == null) continue;
                    a.setAttribute(att, replaceCode.getOrDefault(a.getAttributeValue(att), a.getAttributeValue(att)));
                }
                String[] debug2 = Util.toXml((Element)a);
                isUsed = "true".equalsIgnoreCase(a.getAttributeValue("use"));
                attid = a.getAttributeValue("id");
                ta = this.app.getSettings().getObservationAttribute(attid);
                if (ta == null && isUsed) {
                    ta = ThemisAttribute.create(a);
                }
                if (ta == null) continue;
                ta.setUsed(isUsed != 0);
                ta.setShow(a.getAttributeValue("show", "mkia"));
                tam.addAttribute(ta, true);
                tam2.addAttribute(ta, true);
            }
        }
        replaceCode.clear();
        replaceCode.put("code", "text1");
        replaceCode.put("code2", "text2");
        replaceCode.put("quantity", "text5");
        tam = this.app.getSettings().getLocationAttributeManager();
        tam.clear();
        e = this.app.getSettings().getXmlElement("/themis/project/attributes/locationattributes", false);
        if (e != null) {
            attributeElements = e.getChildren("locationattribute");
            for (Element a : attributeElements) {
                for (String att : new String[]{"id", "code", "keytable"}) {
                    if (a.getAttribute(att) == null) continue;
                    a.setAttribute(att, replaceCode.getOrDefault(a.getAttributeValue(att), a.getAttributeValue(att)));
                }
                String debugxml = Util.toXml((Element)a);
                isUsed = "true".equalsIgnoreCase(a.getAttributeValue("use")) ? 1 : 0;
                attid = a.getAttributeValue("id");
                if (attid == null || "hasaudio".equals(attid) || "hasimage".equals(attid)) continue;
                ta = this.app.getSettings().getLocationAttribute(attid);
                if (ta == null && isUsed) {
                    ta = ThemisAttribute.create(a);
                }
                if ("prefixsuffix".equals(attid)) {
                    ta.setCmsCode("prenumber").setSqlCode("prenumber");
                } else if ("suffix".equals(attid)) {
                    ta.setCmsCode("postnumber").setSqlCode("postnumber");
                }
                if (ta == null) continue;
                ta.setUsed(isUsed != 0);
                tam.addAttribute(ta, true);
            }
        }
        tam = this.app.getSettings().getObservationAttributeManager();
        boolean imgForObs = this.app.getSettings().getXmlElementText("/themis/project/image/target", "obs").toLowerCase().contains("obs");
        this.app.getSettings().setImageForObservation(imgForObs);
        this.app.getSettings().setImageForLocation(!imgForObs);
        this.app.getSettings().getXmlElement("/themis/project/image/target", true).setText("");
        Element xml = this.app.getSettings().getXmlElement("/themis/project/export/url", false);
        if (xml != null) {
            xml.getParent().removeContent((Content)xml);
        }
        if ((xml = this.app.getSettings().getXmlElement("/themis/project/reportspec", false)) != null) {
            CmsReport rep = (CmsReport)this.project.createElement("report");
            rep.setReportFromXml(xml);
            rep.setLayoutName("Standard");
            rep.save();
            xml.getParent().removeContent((Content)xml);
        }
    }

    public void cleanUpSettings() {
        Element xml = this.app.getSettings().getXmlElement("/themis/project/reportspec/export", false);
        if (xml != null) {
            xml.removeChild("templatefile");
        }
        this.app.getSettings().removeProperty("system.tree.explorer");
        this.app.getSettings().removeProperty("project.location");
        this.app.getSettings().removeProperty("recentlocationtemplates");
        this.app.getSettings().removeProperty("export.plansize");
        this.app.getSettings().removeProperty("export.mapsnippet.withlabel");
        this.app.getSettings().removeProperty("export.plansnippet.userdefined");
        this.app.getSettings().removeProperty("export.plansnippet.iconsize");
        this.app.getSettings().removeProperty("export.plansnippet.fontsize");
        this.app.getSettings().removeProperty("export.plansnippet.iconsize2");
        this.app.getSettings().removeProperty("export.plansnippet.linesize");
        this.app.getSettings().removeProperty("export.statusoffen");
        this.app.getSettings().removeProperty("export.statuserledigt");
        this.app.getSettings().removeProperty("text.observationtype.mangel");
        this.app.getSettings().removeProperty("text.observationtype.aufgabe");
        this.app.getSettings().removeProperty("text.observationtype.info");
        this.app.getSettings().removeProperty("text.observationtype.kontrolle");
        this.app.getSettings().removeProperty("text.noevent");
        this.app.getSettings().removeProperty("text.noimage");
        this.app.getSettings().removeProperty("permission.edittemplate");
        this.app.getSettings().removeProperty("display.color.edit");
        this.app.getSettings().removeProperty("export.allimages");
        this.app.getSettings().removeProperty("export.filetype");
        this.app.getSettings().removeProperty("export.pdf.compression");
        this.app.getSettings().removeProperty("file.singlecklick");
    }

    static {
        LAST_DB_VERSION = 52;
    }

    class UpdateAction {
        Phase phase;
        SimpleAction action;

        public UpdateAction(Phase p, SimpleAction a) {
            this.phase = p;
            this.action = a;
        }

        public boolean isPhase(Phase p) {
            return this.phase == p;
        }

        public void execute(ProgressHandler ph) {
            this.action.execute(ph);
        }
    }

    public static enum Phase {
        SYSTEM,
        PREPARE,
        INIT,
        OPEN;

    }
}

