/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology;

import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.storage.DataRecord;
import at.grid.themis.ontology.Closing;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFile;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisLogger;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisProjectStatus;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.attribute.manager.ThemisAttributeManager;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.util.DefaultProgressHandler;
import at.grid.util.ImageInfo;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import at.grid.webdav.NextCloudWebDAV;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.swing.filechooser.FileSystemView;
import org.openide.util.Exceptions;

public class ThemisUtil {
    private static FileSystemView fsv = FileSystemView.getFileSystemView();

    public static int validateInteger(String val, int defaultValue, boolean onlyPositive, String label, boolean showMessage) {
        int result;
        block4: {
            result = defaultValue;
            try {
                result = Integer.parseInt(val);
                if (onlyPositive && result < 0) {
                    result = defaultValue;
                    if (showMessage) {
                        ThemisApplication.getInstance().getDialog().showErrorDialog("Keine negativen Werte erlaubt f\u00fcr " + label + ": " + val);
                    }
                }
            }
            catch (Exception e) {
                if (!showMessage) break block4;
                ThemisApplication.getInstance().getDialog().showErrorDialog("Ung\u00fcltiger Ganzzahl-Wert f\u00fcr " + label + ": " + val);
            }
        }
        return result;
    }

    public static double validateDouble(String val, double defaultValue, boolean onlyPositive, String label, boolean showMessage) {
        double result;
        block4: {
            result = defaultValue;
            try {
                result = Double.parseDouble(val);
                if (onlyPositive && result < 0.0) {
                    result = defaultValue;
                    if (showMessage) {
                        ThemisApplication.getInstance().getDialog().showErrorDialog("Keine negativen Werte erlaubt f\u00fcr " + label + ": " + val);
                    }
                }
            }
            catch (Exception e) {
                if (!showMessage) break block4;
                ThemisApplication.getInstance().getDialog().showErrorDialog("Ung\u00fcltiger Wert f\u00fcr " + label + ": " + val);
            }
        }
        return result;
    }

    public static Color getColorFromString(String color) {
        String[] rgb = color.split(",");
        return new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
    }

    public static String getStringFromColor(Color color) {
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }

    public static Date applyPeriodToDate(Date dt, int idUnit, int count) {
        int field;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(dt);
        switch (idUnit) {
            case 1: {
                field = 6;
                break;
            }
            case 2: {
                field = 3;
                break;
            }
            case 3: {
                field = 2;
                break;
            }
            case 4: {
                field = 1;
                break;
            }
            default: {
                field = 6;
            }
        }
        ((Calendar)cal).add(field, count);
        return cal.getTime();
    }

    public static String toStringWithIgnore(CmsElement e, String lb1, String lb2, boolean showStatus, List<String> ignoreAtts, boolean withHtml) {
        String tab = "  ";
        StringBuilder sb = new StringBuilder();
        ThemisAttributeManager tam = ThemisApplication.getInstance().getSettings().getAttributeManager(e.getElementcode());
        ArrayList<ThemisAttribute> atts = new ArrayList<ThemisAttribute>();
        for (ThemisAttribute att : tam.getAttributes()) {
            if (ignoreAtts.contains(att.getId())) continue;
            atts.add(att);
        }
        return ThemisUtil.toString(e, lb1, lb2, showStatus, atts, withHtml);
    }

    public static String toString(CmsElement e, String lb1, String lb2, boolean showStatus, ArrayList<ThemisAttribute> atts, boolean withHtml) {
        String tab = "  ";
        StringBuilder sb = new StringBuilder();
        if (e == null) {
            return null;
        }
        if (atts == null) {
            atts = ThemisApplication.getInstance().getSettings().getAttributeManager(e.getElementcode()).getAttributes();
        }
        for (ThemisAttribute att : atts) {
            String val;
            if (att.getCmsCode() == null || "".equals(att.getCmsCode()) || !e.hasAttributeValue(att.getCmsCode()) || !showStatus && (att.getId().equals("done") || att.getId().equals("duedate")) || (val = e.getAttributeValue(att.getCmsCode())).isEmpty()) continue;
            if (withHtml) {
                val = val.replaceAll("\n", "<br>");
            }
            sb.append(withHtml ? "<b>" : "").append(att.getLabel()).append(": ").append(withHtml ? "</b>" : "").append(withHtml ? "" : lb1).append(tab).append(val).append(withHtml ? "<br>" : lb2);
        }
        return sb.toString();
    }

    public static void showError(String txt, Exception ex) {
        ThemisApplication.getInstance().getDialog().showErrorDialog(txt, ex);
        ex.printStackTrace();
    }

    private static ArrayList<File> getFiles(File root, String fld) {
        ArrayList<File> files = new ArrayList<File>();
        File folder = new File(root, fld);
        File[] fldFiles = folder.listFiles();
        if (fldFiles != null) {
            for (File f : fldFiles) {
                files.add(f);
            }
        }
        return files;
    }

    public static ArrayList<File> getImageFiles(ThemisFolder tf, int longside) {
        ArrayList<File> files = new ArrayList<File>();
        if (tf == null) {
            return files;
        }
        File folderRoot = new File(tf.getProjectFolder(), "data");
        files.addAll(ThemisUtil.getFiles(folderRoot, "history"));
        files.addAll(ThemisUtil.getFiles(folderRoot, "location"));
        ArrayList<File> filesProcess = new ArrayList<File>();
        for (File f : files) {
            ImageInfo info = new ImageInfo(f);
            if (info.getLongSide() <= longside) continue;
            filesProcess.add(f);
        }
        return filesProcess;
    }

    public static ArrayList<File> getIconFiles(ThemisFolder tf, int longside) {
        ArrayList<File> files = new ArrayList<File>();
        if (tf == null) {
            return files;
        }
        File folderRoot = new File(tf.getProjectFolder(), "data");
        files.addAll(ThemisUtil.getFiles(folderRoot, "icon"));
        ArrayList<File> filesProcess = new ArrayList<File>();
        for (File f : files) {
            ImageInfo info = new ImageInfo(f);
            if (info.getLongSide() <= longside) continue;
            filesProcess.add(f);
        }
        return filesProcess;
    }

    public static String updateImage(ArrayList<File> files, int longside, float quality, ProgressHandler ph) {
        if (files.isEmpty()) {
            return "Es sind keine Dateien im Ordner vorhanden";
        }
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        float q = quality / 100.0f;
        ph.switchToDeterminate(files.size());
        int count = 0;
        for (File f : files) {
            if (ph.isCancelled()) {
                return null;
            }
            ImageInfo info = new ImageInfo(f);
            String mime = info.getMimeType();
            if (f.isFile() && info.getLongSide() > longside) {
                try {
                    BufferedImage bi = longside == 0 ? ImageIO.read(f) : Util.resizeImageOnLongSide((BufferedImage)ImageIO.read(f), (int)longside);
                    f.delete();
                    ThemisUtil.createImageFile(bi, f, mime, q);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    return ex.getMessage();
                }
            }
            ph.progress(count);
            ++count;
        }
        return null;
    }

    public static String createImageFile(BufferedImage bufimg, File outputFile, String mime, float quality) {
        ImageWriter writer = null;
        try {
            String ext = Util.getFileExtension((File)outputFile);
            if ("".equals(ext)) {
                return "Unknown image format";
            }
            if ("tif".equalsIgnoreCase(ext)) {
                ext = "tiff";
            }
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByMIMEType(mime);
            writer = iter.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            try {
                iwp.setCompressionMode(2);
                if (iwp.getCompressionType() != null) {
                    iwp.setCompressionQuality(quality);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            writer.setOutput(ImageIO.createImageOutputStream(outputFile));
            writer.write(null, new IIOImage(bufimg, null, null), iwp);
            writer.dispose();
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "Error: " + ex.getMessage();
        }
    }

    public static ArrayList<File> removeUnusedUploads() {
        String fn;
        ThemisProject project = ThemisApplication.getInstance().getProject();
        if (!project.isOpen()) {
            return new ArrayList<File>();
        }
        ArrayList<String> filenames = new ArrayList<String>();
        for (UploadItem item : project.getDatastorage().getUploadItems(true, null)) {
            File f = item.getFile();
            fn = f.getName().toLowerCase();
            filenames.add(fn);
        }
        ArrayList<File> notUsed = new ArrayList<File>();
        for (File f : Util.getFiles((File)new File(project.getProjectFolder(), "data"), null, (boolean)true)) {
            fn = f.getName().toLowerCase();
            if (filenames.contains(fn)) continue;
            notUsed.add(f);
        }
        for (File f : notUsed) {
            f.delete();
        }
        return notUsed;
    }

    public static byte[] writeJPG(BufferedImage bi, float compression) throws IOException {
        ImageWriter jpgWriter = ImageIO.getImageWritersByFormatName("jpg").next();
        ImageWriteParam jpgWriteParam = jpgWriter.getDefaultWriteParam();
        jpgWriteParam.setCompressionMode(2);
        jpgWriteParam.setCompressionQuality(compression);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        jpgWriter.setOutput(new MemoryCacheImageOutputStream(baos));
        IIOImage outputImage = new IIOImage(bi, null, null);
        jpgWriter.write(null, outputImage, jpgWriteParam);
        baos.flush();
        byte[] returnImage = baos.toByteArray();
        baos.close();
        return returnImage;
    }

    public static void setProjectIcon(File folder) {
        try {
            File imageFile;
            folder.mkdirs();
            File iniFile = new File(folder, "desktop.ini");
            if (!iniFile.exists()) {
                PrintWriter out = new PrintWriter(iniFile);
                out.write("[.ShellClassInfo]\nIconResource=themis.ico,0\n");
                out.close();
            }
            if (!(imageFile = new File(folder, "themis.ico")).exists()) {
                URL url = ThemisUtil.class.getResource("/at/grid/themis/ontology/media/themis.ico");
                InputStream iconIS = url.openStream();
                try (FileOutputStream iconOS = new FileOutputStream(imageFile);){
                    Util.copy((InputStream)iconIS, (OutputStream)iconOS);
                }
            }
            Files.setAttribute(Paths.get(iniFile.getAbsolutePath(), new String[0]), "dos:hidden", Boolean.TRUE, LinkOption.NOFOLLOW_LINKS);
            Files.setAttribute(Paths.get(imageFile.getAbsolutePath(), new String[0]), "dos:hidden", Boolean.TRUE, LinkOption.NOFOLLOW_LINKS);
            Runtime.getRuntime().exec("attrib +s " + folder.getAbsolutePath());
        }
        catch (Exception e) {
            ThemisLogger.logger.severe(e.getLocalizedMessage());
        }
    }

    public static void removeSystemFolder(File folder) {
        try {
            Runtime.getRuntime().exec("attrib -s " + folder.getAbsolutePath());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isOnNetworkDrive(ThemisFolder file) {
        if (file == null) {
            return false;
        }
        return ThemisUtil.isOnNetworkDrive(file.getProjectFolder());
    }

    public static boolean isOnNetworkDrive(File file) {
        if (file == null) {
            return false;
        }
        String path = file.getAbsolutePath();
        if (path.startsWith("\\\\")) {
            return true;
        }
        if (path.toLowerCase().contains("onedrive") || path.toLowerCase().contains("one drive")) {
            return true;
        }
        File f = file;
        for (int counter = 0; !fsv.isDrive(f) && counter < 100 && f.getParentFile() != null; ++counter) {
            f = f.getParentFile();
        }
        String desc = fsv.getSystemTypeDescription(f);
        return desc != null && desc.toLowerCase().startsWith("n");
    }

    public static CmsLocation copyLocation(long locId) {
        ThemisProject project = ThemisApplication.getInstance().getProject();
        if (!project.isOpen()) {
            return null;
        }
        CmsLocation origLocation = (CmsLocation)project.loadElement(locId, project.getUser());
        CmsLocation location = (CmsLocation)origLocation.copy("files,observations");
        location.getAttribute("position").clear();
        location.getAttribute("labelposition").clear();
        location.getAttribute("barcode").clear();
        location.getRelationAttribute("plan").clear();
        if (project.checkForCurrentEvent(false)) {
            List obsIds = origLocation.getRelationAttribute("observations").getElementIds();
            Iterator iterator = obsIds.iterator();
            while (iterator.hasNext()) {
                long obsId = (Long)iterator.next();
                CmsObservation obsOrig = (CmsObservation)project.loadElement(obsId, project.getUser());
                CmsObservation obs = (CmsObservation)obsOrig.copy("location,files,donedate,histories");
                obs.setLocation(location);
                obs.setNumber(location.getNextObservationNumber());
                location.getRelationAttribute("observations").add((CmsElement)obs);
                location.addObservation(obs);
            }
        }
        return location;
    }

    public static boolean uploadFileToNextcloud(String url, String pwd, InputStream is, String fname) {
        NextCloudWebDAV webdav = NextCloudWebDAV.fromShareUrl((String)url, (String)pwd);
        try {
            webdav.putFileAsZip(is, null, fname);
            return true;
        }
        catch (IOException ex) {
            ThemisApplication.getInstance().getDialog().showErrorDialog("Die Datei kann nicht hochgeladen werden: {0}", ex.getMessage());
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean uploadFileToNextcloud(String url, String pwd, File f) {
        NextCloudWebDAV webdav = NextCloudWebDAV.fromShareUrl((String)url, (String)pwd);
        try {
            webdav.putFile(null, f);
            return true;
        }
        catch (IOException ex) {
            ThemisApplication.getInstance().getDialog().showErrorDialog("Die Datei kann nicht hochgeladen werden: {0}", ex.getMessage());
            ex.printStackTrace();
            return false;
        }
    }

    public static ThemisProjectStatus checkUploadFileStatus(ProgressHandler ph) {
        return ThemisUtil.updateUploadFiles(false, ph);
    }

    public static ThemisProjectStatus updateUploadFiles(boolean doUpdate, ProgressHandler ph) {
        ThemisProject project = ThemisApplication.getInstance().getProject();
        if (!project.isOpen()) {
            return null;
        }
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        ThemisProjectStatus update = new ThemisProjectStatus();
        ArrayList items = project.getDatastorage().getAllUploadItems();
        ph.switchToDeterminate(items.size());
        File dataFolder = new File(project.getProjectFolder(), "data");
        ArrayList<Long> uploadIds = new ArrayList<Long>();
        File missingImage = new File(project.getTempfileLocation(), "dummy-image.jpg");
        try {
            Util.copy((InputStream)ThemisUtil.class.getResourceAsStream("/at/grid/themis/ontology/media/missing-file.jpg"), (OutputStream)new FileOutputStream(missingImage));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        File notUsedFolder = new File(project.getProjectFolder(), "not-used");
        for (UploadItem item : items) {
            if (ph.isCancelled()) {
                return update;
            }
            uploadIds.add(item.getId());
            String elementtype = item.getElementtype();
            if (elementtype == null || "".equals(elementtype)) {
                elementtype = project.getDatastorage().getElementtypeById(item.getIdelement());
            }
            if (elementtype == null) {
                update.addErrorUpload(item.getId(), "no element found for this UpdateItem");
                continue;
            }
            String fn = item.getFilename();
            File targetFolder = new File(dataFolder, elementtype);
            targetFolder.mkdirs();
            File fileInData = new File(dataFolder, fn);
            File fileInTarget = new File(targetFolder, fn);
            if (!fileInTarget.exists()) {
                if (fileInData.exists()) {
                    update.addMoveUpload(fn);
                    project.getLogger().warning("upload item '" + fn + "' not in right folder, need to move");
                    if (!doUpdate) continue;
                    Util.move((File)fileInData, (File)fileInTarget);
                    project.createActionLog("file_moved", item.getId(), item.getFilename());
                    continue;
                }
                update.addMissingUpload(item.getId());
                project.getLogger().severe("upload item '" + fn + "' not found!");
                if (!doUpdate) continue;
                try {
                    Util.copy((File)missingImage, (File)item.getFile());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            project.getLogger().info("upload item '" + fn + "' found, nothing to do");
        }
        for (File f : Util.getFiles((File)dataFolder, null, (boolean)true)) {
            String[] split = f.getName().split("_");
            long id = Util.parseLong((String)split[0], (long)-1L);
            if (id <= 0L) continue;
            if (!uploadIds.contains(id)) {
                update.addNotUsedUpload(f);
                project.getLogger().severe("file '" + f.getName() + "' found, not in use");
                if (!doUpdate) continue;
                notUsedFolder.mkdirs();
                Util.move((File)f, (File)new File(notUsedFolder, f.getName()));
                project.createActionLog("file_delete", id, f.getName());
                continue;
            }
            boolean bl = true;
        }
        return update;
    }

    public static void updateFileLocations(ProgressHandler ph) {
        ThemisProject project = ThemisApplication.getInstance().getProject();
        if (!project.isOpen()) {
            return;
        }
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        File dataFolder = new File(project.getProjectFolder(), "data");
        List recs = project.getDatastorage().executeQuery("select * from tdtafileupload", true).getResult();
        ph.switchToDeterminate(recs.size());
        for (DataRecord rec : recs) {
            ph.progress(recs.size() + " Dateien werden aktualisiert - dies kann ggf. etwas dauern ...");
            if (rec.isEmpty("idelement")) continue;
            long elementid = rec.getLong("idelement");
            long idFileUpload = rec.getLong("idfileupload");
            String elementtype = rec.getString("elementtype");
            if (elementtype == null || "".equals(elementtype)) {
                elementtype = project.getDatastorage().getElementtypeById(elementid);
            }
            String fn = rec.getString("path");
            File targetFolder = new File(dataFolder, elementtype);
            targetFolder.mkdirs();
            File fileInData = new File(dataFolder, fn);
            File fileInTarget = new File(targetFolder, fn);
            if (!fileInTarget.exists() && fileInData.exists()) {
                project.getFileAccess().move(fileInData, fileInTarget);
            }
            project.getDatastorage().executeUpdate("update tdtafileupload set elementtype=" + Util.toSqlString((String)elementtype) + " where idfileupload = " + idFileUpload, true);
        }
    }

    public static boolean exportProjectAsThemisFile(ThemisFolder themis, File destFile, boolean overwrite, ProgressHandler ph) {
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        ThemisApplication app = ThemisApplication.getInstance();
        if (themis == null || !themis.isProject()) {
            app.getDialog().showInfoDialog("project.no-project-selected");
            return false;
        }
        if (app.getProject().isOpen() && app.getProject().getProjectFolder().equals(themis.getProjectFolder())) {
            if (app.getDialog().showConfirmDialog("project.project-open-close")) {
                app.getProject().close(new Closing().withoutExport().withoutWaiting(), ph);
            } else {
                return false;
            }
        }
        File projectfolder = themis.getProjectFolder();
        if (destFile == null) {
            destFile = new File(projectfolder.getParentFile(), themis.getFolderName() + ".themis");
        }
        if (!"themis".equalsIgnoreCase(Util.getFileExtension((File)destFile))) {
            destFile = new File(destFile.getParentFile(), Util.getFileNameWithoutExtension((File)destFile) + ".themis");
        }
        if (destFile.isFile() && !overwrite) {
            if (app.getDialog().showConfirmDialog("export.zip-already-exists", "export.zip-already-exists.title", new Object[]{destFile.getName()})) {
                destFile.delete();
            } else {
                return false;
            }
        }
        app.getProject().openProjectQuietly(themis, false, ph);
        ThemisFile tf = app.getProject().getProjectAsThemisFile();
        try {
            tf.saveToFile(destFile, true);
        }
        catch (IOException ex) {
            return false;
        }
        app.getProject().close(new Closing().withoutAsking().withoutExport().withoutTrigger(), ph);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportProjectAsZip(ThemisFolder themis, File destFile, boolean overwrite, ProgressHandler ph) {
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        ThemisApplication app = ThemisApplication.getInstance();
        if (themis == null || !themis.isProject()) {
            app.getDialog().showInfoDialog("project.no-project-selected");
            return false;
        }
        if (app.getProject().isOpen() && app.getProject().getProjectFolder().equals(themis.getProjectFolder())) {
            if (app.getDialog().showConfirmDialog("project.project-open-close")) {
                app.getProject().close(new Closing().withoutExport().withoutWaiting(), ph);
            } else {
                return false;
            }
        }
        File projectfolder = themis.getProjectFolder();
        if (destFile == null) {
            destFile = new File(projectfolder.getParentFile(), themis.getFolderName() + ".zip");
        }
        if (!"zip".equalsIgnoreCase(Util.getFileExtension((File)destFile))) {
            destFile = new File(destFile.getParentFile(), Util.getFileNameWithoutExtension((File)destFile) + ".zip");
        }
        if (destFile.isFile() && !overwrite) {
            if (app.getDialog().showConfirmDialog("export.zip-already-exists", "export.zip-already-exists.title", new Object[]{destFile.getName()})) {
                destFile.delete();
            } else {
                return false;
            }
        }
        File db = new File(projectfolder, "db/themis.h2.db");
        File dborig = new File(projectfolder, "db/themis.h2.db_orig");
        boolean copiedOrig = false;
        if (!db.isFile()) {
            try {
                if (dborig.isFile()) {
                    Util.copy((File)dborig, (File)db);
                    copiedOrig = true;
                } else {
                    ArrayList<File> files = themis.getDatabaseBackupFileList();
                    if (files != null && !files.isEmpty()) {
                        File dbBak = files.get(files.size() - 1);
                        Util.copy((File)dbBak, (File)db);
                    }
                }
            }
            catch (IOException files) {
                // empty catch block
            }
        }
        ph.progress("Speichere Projekt '" + themis.getFolderName() + "'");
        int numberOfFiles = 4 + Util.countFilesInSubdirectories((File)new File(projectfolder, "data"));
        ph.switchToDeterminate(numberOfFiles);
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            app.getProject().getLogger().info("creating ZIP file: " + destFile.getAbsolutePath());
            Path folder = Paths.get(projectfolder.getAbsolutePath(), new String[0]);
            Path zipFilePath = Paths.get(destFile.getAbsolutePath(), new String[0]);
            fos = new FileOutputStream(zipFilePath.toFile());
            zos = new ZipOutputStream(fos);
            ThemisUtil.addFileToZip(folder, folder, "desktop.ini", zos, ph);
            ThemisUtil.addFileToZip(folder, folder, "statistics.properties", zos, ph);
            ThemisUtil.addFileToZip(folder, folder, "themis.ico", zos, ph);
            if (!db.isFile() && dborig.isFile()) {
                ThemisUtil.addFileToZip(folder, folder, "db/themis.h2.db_orig", zos, ph);
            } else {
                ThemisUtil.addFileToZip(folder, folder, "db/themis.h2.db", zos, ph);
            }
            if (!ph.isCancelled()) {
                ThemisUtil.addFileToZip(folder, folder, "data", zos, ph);
            }
        }
        catch (IOException ex) {
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (copiedOrig) {
            Util.delete((File)db);
        }
        return true;
    }

    private static void addFileToZip(Path root, Path folder, String fn, ZipOutputStream zos, ProgressHandler ph) {
        block5: {
            File f;
            block4: {
                if (ph.isCancelled()) {
                    return;
                }
                f = new File(folder.toFile(), fn);
                if (!f.isDirectory()) break block4;
                File[] filesInFolder = f.listFiles();
                if (filesInFolder == null) break block5;
                for (File ff : filesInFolder) {
                    ThemisUtil.addFileToZip(root, Paths.get(f.getAbsolutePath(), new String[0]), ff.getName(), zos, ph);
                }
                break block5;
            }
            try {
                ThemisApplication.getInstance().getProject().getLogger().info("adding file to ZIP: " + folder + "/" + fn);
                Path file = Paths.get(f.getAbsolutePath(), new String[0]);
                zos.putNextEntry(new ZipEntry(root.getParent().relativize(file).toString()));
                Files.copy(file, zos);
                zos.closeEntry();
                ph.progress(fn);
                ph.increaseProgress(1);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static Dimension getWindowSize(String dialogcode, int defaultWidth, int defaultHeight, ThemisApplication app) {
        String dim = app.getConfiguration("dialog.#.size".replaceAll("#", dialogcode));
        if (dim == null) {
            if (defaultHeight < 0 || defaultWidth < 0) {
                return null;
            }
            return new Dimension(defaultWidth, defaultHeight);
        }
        String[] dims = dim.split(",");
        return new Dimension((int)Double.parseDouble(dims[0]), (int)Double.parseDouble(dims[1]));
    }

    public static void setWindowSize(String elementcode, Dimension dim, ThemisApplication app) {
        app.setConfiguration("dialog.#.size".replaceAll("#", elementcode), dim.width + "," + dim.height, true);
    }

    public static void createDemoProject(File fld, ProgressHandler ph) {
        ThemisProject p = ThemisApplication.getInstance().getProject();
        if (p.isOpen()) {
            return;
        }
        String fn = "demo-project";
        File projectFolder = new File(fld, fn);
        int counter = 2;
        while (projectFolder.exists()) {
            String fn2 = fn + counter;
            projectFolder = new File(fld, fn2);
            ++counter;
        }
        ThemisFolder folder = new ThemisFolder(projectFolder);
        String result = p.createProject(folder, ph);
        if (result != null) {
            ThemisApplication.getInstance().getDialog().showErrorDialog(result);
            return;
        }
        if (result != null) {
            ThemisApplication.getInstance().getDialog().showWarningDialog(result);
        }
        ThemisApplication.getInstance().getActionProvider().setActive(true);
        ThemisApplication.getInstance().getActionProvider().invokeAction(ThemisAction.PROJECT_OPENED);
    }

    public static enum ImageType {
        IMAGE,
        ICON;

    }
}

