/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.action;

import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ActionProvider {
    Logger logger = Logger.getAnonymousLogger();
    ArrayList<ThemisActionListener> listeners = new ArrayList();
    ArrayList<ThemisActionListener> listenersEditor = new ArrayList();
    protected boolean secondaryAction = false;
    boolean active = true;
    protected Target target = Target.GUI;

    public ActionProvider() {
    }

    public ActionProvider(Logger l) {
        if (l != null) {
            this.logger = l;
        }
    }

    public void setLogger(Logger l) {
        if (l != null) {
            this.logger = l;
        }
    }

    public void setTarget(Target t) {
        this.target = t;
    }

    public ArrayList<ThemisActionListener> getListeners() {
        int s = this.listeners.size();
        return new ArrayList<ThemisActionListener>(this.listeners);
    }

    public ArrayList<ThemisActionListener> getListenersEditor() {
        return new ArrayList<ThemisActionListener>(this.listenersEditor);
    }

    public ArrayList<ThemisActionListener> getRelevantListeners() {
        switch (this.target) {
            case EDITOR: {
                return this.getListenersEditor();
            }
        }
        return this.getListeners();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void register(ThemisActionListener listener) {
        this.logger.info("Registering '" + listener.getClass().getName() + "' with action provider");
        this.listeners.add(listener);
    }

    public void registerEditor(ThemisActionListener listener) {
        this.listenersEditor.add(listener);
    }

    public synchronized void invokeAction(ThemisAction a) {
        if (this.isActive()) {
            this.invokeAction(a, false);
        }
    }

    public synchronized void invokeAction(ThemisAction a, boolean force) {
        try {
            if (this.isActive() && !this.secondaryAction || force) {
                this.secondaryAction = true;
                for (ThemisActionListener listener : this.getRelevantListeners()) {
                    listener.onAction(a);
                }
                this.secondaryAction = false;
                a.reset();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum Target {
        COMMAND,
        GUI,
        EDITOR;

    }
}

