/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.attribute;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.BooleanAttribute;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.attribute.DateAttribute;
import at.grid.cms.attribute.IntegerAttribute;
import at.grid.cms.attribute.KeyAttribute;
import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.attribute.TextAttribute;
import at.grid.cms.attribute.TextareaAttribute;
import at.grid.cms.attribute.UploadAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.attribute.ThemisBooleanAttribute;
import at.grid.themis.ontology.attribute.ThemisComplexAttribute;
import at.grid.themis.ontology.attribute.ThemisDateAttribute;
import at.grid.themis.ontology.attribute.ThemisListAttribute;
import at.grid.themis.ontology.attribute.ThemisLongtextAttribute;
import at.grid.themis.ontology.attribute.ThemisNoneAttribute;
import at.grid.themis.ontology.attribute.ThemisNumberAttribute;
import at.grid.themis.ontology.attribute.ThemisRelationAttribute;
import at.grid.themis.ontology.attribute.ThemisTextAttribute;
import at.grid.themis.ontology.attribute.ThemisUploadAttribute;
import at.grid.themis.ontology.attribute.manager.ThemisAttributeManager;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.interfaces.IconItem;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.Util;
import java.util.Objects;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.openide.util.Exceptions;

public abstract class ThemisAttribute
implements IconItem {
    protected Type type;
    private Target target;
    ThemisApplication app;
    private String id;
    private String cmsCode;
    private CmsAttribute cmsatt = null;
    protected String sqlCode;
    private String label;
    private boolean used;
    private boolean writeprotected;
    private boolean checklistedit;
    private int width;
    private boolean mandatory = false;
    private boolean userdefined;
    private boolean virtual;
    private boolean allowObservationList = true;
    private boolean allowChecklistEdit = true;
    protected boolean allowCustomise = true;
    private ThemisAttribute inherit = null;
    String show = "mkia";

    public ThemisAttribute(ThemisApplication app, Target target, String id, String cmscode, String sqlSelect, String label, Edit style, boolean userdefined, int defaultWidth) {
        this.app = app;
        if (cmscode == null) {
            cmscode = "";
        }
        this.target = target;
        this.id = id;
        this.cmsCode = cmscode;
        this.sqlCode = sqlSelect;
        this.label = label;
        if ("".equals(this.label)) {
            this.label = id;
        }
        this.setEditStyle(style);
        this.userdefined = userdefined;
        this.width = defaultWidth;
    }

    public static ThemisAttribute create(Type t, Target target) {
        return ThemisAttribute.create(t, target, null);
    }

    public static ThemisAttribute create(Type t, Target target, String id) {
        ThemisApplication app = ThemisApplication.getInstance();
        ThemisAttribute ta = null;
        if (id == null) {
            id = app.getSettings().getNextAttributeId(target.toString(), t);
        }
        switch (t) {
            case TEXT: {
                ta = new ThemisTextAttribute(app, target, id, id, id, t.toString(), Edit.DIALOG_ONLY, true, 0);
                break;
            }
            case LONGTEXT: {
                ta = new ThemisLongtextAttribute(app, target, id, id, id, t.toString(), Edit.DIALOG_ONLY, true, 0);
                break;
            }
            case BOOLEAN: {
                ta = new ThemisBooleanAttribute(app, target, id, id, id, t.toString(), Edit.DIALOG_ONLY, true, 0);
                break;
            }
            case COMPLEX: {
                ta = new ThemisComplexAttribute(app, target, id, id, id, t.toString(), Edit.DIALOG_ONLY, true, 0);
                break;
            }
            case DATE: {
                ta = new ThemisDateAttribute(app, target, id, id, id, t.toString(), Edit.DIALOG_ONLY, true, 0);
                break;
            }
            case LIST: {
                ta = new ThemisListAttribute(app, target, id, id, id, t.toString(), Edit.DIALOG_ONLY, true, 0);
                break;
            }
            case NUMBER: {
                ta = new ThemisNumberAttribute(app, target, id, id, id, t.toString(), Edit.DIALOG_ONLY, true, 0);
                break;
            }
            case RELATION: {
                ta = new ThemisRelationAttribute(app, target, id, id, id, t.toString(), Edit.DIALOG_ONLY, true, 0);
                break;
            }
            case UPLOAD: {
                ta = new ThemisUploadAttribute(app, target, id, id, id, t.toString(), Edit.DIALOG_ONLY, true, 0);
                break;
            }
            case NONE: {
                ta = new ThemisNoneAttribute(app, target, id, id, id, t.toString(), Edit.DIALOG_ONLY, true, 0);
            }
        }
        if (ta != null) {
            app.getSettings().addAttribute(target.toString(), ta);
        }
        return ta;
    }

    public static ThemisAttribute create(Element xml) {
        String name = xml.getName();
        Target tar = ThemisAttribute.getTarget(name.replaceAll("attribute", ""));
        String id = xml.getAttributeValue("id");
        Type t = ThemisAttribute.getTypeFromId(xml.getAttributeValue("type"));
        ThemisAttribute ta = ThemisAttribute.create(t, tar, id);
        ta.setCmsCode(xml.getAttributeValue("code", id));
        ta.setLabel(xml.getAttributeValue("label", id));
        ta.setWriteprotected("true".equalsIgnoreCase(xml.getAttributeValue("writeprotected")));
        ta.setChecklistedit("true".equalsIgnoreCase(xml.getAttributeValue("checklist")));
        ta.setUsed("true".equalsIgnoreCase(xml.getAttributeValue("use")));
        return ta;
    }

    public abstract void createDatabase();

    public String getTypeCode() {
        switch (this.type) {
            case DATE: {
                return "date";
            }
            case NUMBER: {
                return "number";
            }
        }
        return "string";
    }

    public static Type getTypeFromId(String id) {
        int count = 0;
        while (Util.isNumber((String)id.substring(id.length() - count - 1))) {
            ++count;
        }
        String ch = id.substring(0, id.length() - count);
        switch (ch.toLowerCase()) {
            case "text": {
                return Type.TEXT;
            }
            case "longtext": {
                return Type.LONGTEXT;
            }
            case "date": {
                return Type.DATE;
            }
            case "boolean": {
                return Type.BOOLEAN;
            }
            case "complex": {
                return Type.COMPLEX;
            }
            case "list": {
                return Type.LIST;
            }
            case "unknown": {
                return Type.NONE;
            }
            case "number": {
                return Type.NUMBER;
            }
            case "relation": {
                return Type.RELATION;
            }
            case "upload": {
                return Type.UPLOAD;
            }
        }
        return Type.NONE;
    }

    public String getSqlCode() {
        return this.sqlCode;
    }

    public String getSqlSort() {
        return this.sqlCode;
    }

    public ThemisAttribute setSqlCode(String code) {
        this.sqlCode = code;
        return this;
    }

    public String getCmsCode() {
        return this.cmsCode;
    }

    public ThemisAttribute setCmsCode(String code) {
        this.cmsCode = code;
        return this;
    }

    public CmsAttribute createCmsAttribute(CmsElement ele) {
        if (ele == null) {
            return null;
        }
        Element xml = this.getCmsAttributeSpecification();
        try {
            switch (this.type) {
                case BOOLEAN: {
                    return new BooleanAttribute((CmsApplication)this.app.getProject(), ele, xml);
                }
                case TEXT: {
                    return new TextAttribute((CmsApplication)this.app.getProject(), ele, xml);
                }
                case LONGTEXT: {
                    return new TextareaAttribute((CmsApplication)this.app.getProject(), ele, xml);
                }
                case DATE: {
                    return new DateAttribute((CmsApplication)this.app.getProject(), ele, xml);
                }
                case LIST: {
                    return new KeyAttribute((CmsApplication)this.app.getProject(), ele, xml);
                }
                case NUMBER: {
                    return new IntegerAttribute((CmsApplication)this.app.getProject(), ele, xml);
                }
                case RELATION: {
                    return new RelationAttribute((CmsApplication)this.app.getProject(), ele, xml);
                }
                case UPLOAD: {
                    return new UploadAttribute((CmsApplication)this.app.getProject(), ele, xml);
                }
            }
        }
        catch (DataConversionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public CmsAttribute getCmsAttribute() {
        CmsAttribute att = null;
        String attcode = this.getCmsCode();
        CmsElement ele = this.app.getProject().getDefaultElement(this.getTargetCode());
        if (ele != null) {
            att = ele.getAttribute(attcode);
        }
        return att;
    }

    public Element getCmsAttributeSpecification() {
        String code = this.getCmsCode();
        String target = this.getTargetCode();
        String sql = this.getSqlCode();
        switch (this.type) {
            case BOOLEAN: {
                return new Element("attribute").setAttribute("code", code).setAttribute("type", "boolean").setAttribute("field", sql);
            }
            case TEXT: {
                return new Element("attribute").setAttribute("code", code).setAttribute("type", "text").setAttribute("field", sql).setAttribute("multilingual", "false").setAttribute("size", "250");
            }
            case LONGTEXT: {
                return new Element("attribute").setAttribute("code", code).setAttribute("type", "textarea").setAttribute("field", sql).setAttribute("multilingual", "false");
            }
            case DATE: {
                return new Element("attribute").setAttribute("code", code).setAttribute("type", "date").setAttribute("field", sql);
            }
            case LIST: {
                return new Element("attribute").setAttribute("code", code).setAttribute("type", "key").setAttribute("field", sql).setAttribute("table", target + code);
            }
            case NUMBER: {
                return new Element("attribute").setAttribute("code", code).setAttribute("type", "float").setAttribute("field", sql);
            }
            case RELATION: {
                return new Element("attribute").setAttribute("code", code).setAttribute("type", "relation").setAttribute("elementcodes", "").setAttribute("relationcode", code).setAttribute("group", "_meta");
            }
            case UPLOAD: {
                return new Element("attribute").setAttribute("code", code).setAttribute("type", "upload");
            }
        }
        return null;
    }

    public static Target getTarget(String elementtype) {
        switch (elementtype) {
            case "project": {
                return Target.PROJECT;
            }
            case "event": {
                return Target.EVENT;
            }
            case "observation": {
                return Target.OBSERVATION;
            }
            case "location": {
                return Target.LOCATION;
            }
            case "company": {
                return Target.CONTACT;
            }
            case "locationgroup": {
                return Target.GROUP;
            }
        }
        return Target.NONE;
    }

    public Target getTarget() {
        return this.target;
    }

    public String getTargetLetter(boolean translate) {
        switch (this.target) {
            case OBSERVATION: {
                return translate ? "b." : "obs.";
            }
            case LOCATION: {
                return translate ? "g." : "loc.";
            }
            case EVENT: {
                return translate ? "e." : "eve.";
            }
            case PROJECT: {
                return translate ? "p." : "prj.";
            }
            case GROUP: {
                return translate ? "grp." : "grp.";
            }
            case CONTACT: {
                return translate ? "c." : "com.";
            }
            case MEASURE: {
                return translate ? "m." : "msr.";
            }
            case OBSERVATIONTEMPLATE: {
                return translate ? "vo" : "tob.";
            }
        }
        return "";
    }

    public String getTargetCode() {
        switch (this.target) {
            case OBSERVATION: 
            case OBSERVATIONTEMPLATE: {
                return "observation";
            }
            case LOCATION: {
                return "location";
            }
            case EVENT: {
                return "event";
            }
            case PROJECT: {
                return "project";
            }
            case CONTACT: {
                return "company";
            }
            case MEASURE: {
                return "measuretemplate";
            }
            case GROUP: {
                return "locationgroup";
            }
        }
        return null;
    }

    public String getUniqueKey() {
        return this.getTargetCode() + "$" + this.getId();
    }

    public static ThemisAttribute getAttribute(String uniqueKey) {
        String[] split = uniqueKey.split("$");
        ThemisSettings settings = ThemisApplication.getInstance().getSettings();
        ThemisAttributeManager tam = settings.getAttributeManager(split[0]);
        if (tam != null && split.length > 1) {
            return tam.getAttribute(split[1]);
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPlaceholder(boolean translate) {
        if (!translate) {
            return this.getTargetLetter(false) + this.getId();
        }
        int count = 1;
        while (Util.isNumber((String)this.id.substring(this.id.length() - count - 1))) {
            ++count;
        }
        String ch = this.id.substring(0, this.id.length() - count);
        return this.getTargetLetter(true).toUpperCase() + ThemisApplication.getInstance().getProject().getResourceText("attribute.type." + ch) + this.id.substring(this.id.length() - count);
    }

    public boolean checkPlaceholder(String ph) {
        if (ph == null || ph.length() < 3) {
            return false;
        }
        return ph.equalsIgnoreCase(this.getPlaceholder(true)) || ph.equalsIgnoreCase(this.getPlaceholder(false));
    }

    public String getTypeAsString() {
        return this.type.toString();
    }

    public String getTypeForXml() {
        return this.type.getCode();
    }

    public Type getTypeId() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public ThemisAttribute setLabel(String label) {
        this.label = label;
        return this;
    }

    public boolean isUsed() {
        if (this.inherit != null) {
            return this.inherit.isUsed();
        }
        return this.isAlwaysUsed() ? true : this.used;
    }

    public ThemisAttribute setUsed(boolean used) {
        if (this.inherit != null || this.isAlwaysUsed()) {
            return this;
        }
        this.used = used;
        ThemisSettings settings = this.app.getSettings();
        switch (this.target) {
            case LOCATION: {
                settings.setLocationAttributeUsage(this, used);
                break;
            }
            case OBSERVATION: {
                settings.setObservationAttributeUsage(this, used);
            }
        }
        return this;
    }

    public void setInherit(ThemisAttribute ta) {
        this.inherit = ta;
    }

    public boolean isInherit() {
        return this.inherit != null;
    }

    public boolean isWriteprotected() {
        if (this.inherit != null) {
            return this.inherit.isWriteprotected();
        }
        return this.writeprotected;
    }

    public void setWriteprotected(boolean writeprotected) {
        this.writeprotected = writeprotected;
    }

    @Deprecated
    public void setEditStyle(int editstyle) {
        switch (editstyle) {
            case 0: {
                this.setEditStyle(Edit.DIALOG_ONLY);
                break;
            }
            case 1: {
                this.setEditStyle(Edit.ADMIN_ONLY);
                break;
            }
            case 2: {
                this.setEditStyle(Edit.DIALOG_AND_CHECKLIST);
            }
        }
    }

    public void setEditStyle(Edit style) {
        this.writeprotected = style == Edit.ADMIN_ONLY;
        this.checklistedit = style == Edit.DIALOG_AND_CHECKLIST;
    }

    public Edit getEditStyle() {
        if (this.inherit != null) {
            return this.inherit.getEditStyle();
        }
        if (this.writeprotected) {
            return Edit.ADMIN_ONLY;
        }
        if (this.checklistedit) {
            return Edit.DIALOG_AND_CHECKLIST;
        }
        return Edit.DIALOG_ONLY;
    }

    public boolean isShowInTable() {
        return this.width > 0;
    }

    public void setWidthInTable(int width) {
        this.width = width;
    }

    public int getWidthInTable() {
        return this.width;
    }

    public ThemisAttribute setAlwaysUsed() {
        this.mandatory = true;
        this.setUsed(true);
        return this;
    }

    public boolean isAlwaysUsed() {
        if (this.inherit != null) {
            return this.inherit.isAlwaysUsed();
        }
        return this.mandatory;
    }

    public boolean isChecklistedit() {
        if (this.inherit != null) {
            return this.inherit.isChecklistedit();
        }
        return this.checklistedit;
    }

    public void setChecklistedit(boolean checklistedit) {
        this.checklistedit = checklistedit;
    }

    public boolean isUserdefined() {
        return this.userdefined;
    }

    public void setUserdefined(boolean userdefined) {
        this.userdefined = userdefined;
    }

    public boolean isObsListAllowed() {
        return this.allowObservationList;
    }

    public ThemisAttribute setChecklistAllowed(boolean checklistAllowed) {
        this.allowChecklistEdit = checklistAllowed;
        return this;
    }

    public boolean isChecklistAllowed() {
        return this.allowChecklistEdit;
    }

    public ThemisAttribute setObsListAllowed(boolean obsListAllowed) {
        this.allowObservationList = obsListAllowed;
        return this;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public ThemisAttribute setVirtual(boolean virtual) {
        this.virtual = virtual;
        return this;
    }

    public String getValue(CmsLocation e) {
        boolean usePrefix = this.app.getSettings().getLocationAttribute("prefixsuffix").isUsed();
        boolean useSuffix = this.app.getSettings().getLocationAttribute("suffix").isUsed();
        switch (this.id) {
            case "group": {
                return e.getAttributeValue("locationgroup");
            }
            case "prefixsuffix": {
                return e.getAttributeValue("prenumber");
            }
            case "suffix": {
                return e.getAttributeValue("postnumber");
            }
            case "number": {
                return (usePrefix ? e.getAttributeValue("prenumber") : "") + e.getAttributeValue("number") + (useSuffix ? e.getAttributeValue("postnumber") : "");
            }
            case "documents": {
                return e.getRelationAttribute("infos").isEmpty() ? "" : "X";
            }
            case "size": {
                String w = e.getAttributeValue("dimwidth");
                String h = e.getAttributeValue("dimheight");
                String d = e.getAttributeValue("dimdiameter");
                if (d != null && !"".equals(d)) {
                    return "d=" + d;
                }
                return w + "x" + h;
            }
            case "hasimage": {
                return e.getImageUploadItems().isEmpty() ? "" : "X";
            }
            case "hasaudio": {
                return e.getAudioUploadItems().isEmpty() ? "" : "X";
            }
        }
        if (this.type == Type.BOOLEAN) {
            return e.getBooleanAttribute(this.cmsCode).isSet() ? "X" : "";
        }
        if (this.type == Type.RELATION) {
            return e.getRelationAttribute(this.cmsCode).getFirstElementTitle();
        }
        return e.getAttributeValue(this.getCmsCode());
    }

    public String getValue(CmsObservation e) {
        switch (this.id) {
            case "number": {
                return e.getAttributeValue("number");
            }
            case "documents": {
                return e.getRelationAttribute("infos").isEmpty() ? "" : "X";
            }
            case "hasimage": {
                return "";
            }
            case "hasaudio": {
                return "";
            }
        }
        if (this.type == Type.BOOLEAN) {
            return e.getBooleanAttribute(this.cmsCode).isSet() ? "X" : "";
        }
        if (this.type == Type.RELATION) {
            return e.getRelationAttribute(this.cmsCode).getFirstElementTitle();
        }
        return e.getAttributeValue(this.getCmsCode());
    }

    public String toString() {
        if (this.getId() == null) {
            return "-";
        }
        String attString = "themisattribute." + this.getTargetCode() + "." + this.getId();
        String resString = ThemisApplication.getInstance().getProject().getResourceText(attString);
        return (this.label == null || "".equals(this.label) ? "-" : this.label) + " [" + resString + "]";
    }

    @Override
    public String getIconKey() {
        if (this.id.equals("barcode")) {
            return "key_barcode";
        }
        if (this.id.equals("responsible")) {
            return "key_person";
        }
        if (this.id.equals("plan")) {
            return "key_plan";
        }
        if (this.id.equals("gps")) {
            return "key_gps";
        }
        if (this.id.equals("size")) {
            return "key_measure";
        }
        if (this.id.equals("quantity") && this.target == Target.LOCATION) {
            return "key_number";
        }
        if (this.id.equals("assessment")) {
            return "key_assessment";
        }
        if (this.id.equals("documents")) {
            return "key_file";
        }
        if (this.id.equals("icon")) {
            return "key_icon";
        }
        if (this.id.equals("group")) {
            return "key_group";
        }
        if (this.id.equals("prefixsuffix")) {
            return "key_prefix_suffix";
        }
        if (this.id.equals("suffix")) {
            return "key_prefix_suffix";
        }
        if (this.type != null) {
            switch (this.type) {
                case TEXT: 
                case LONGTEXT: {
                    return "key_text";
                }
                case DATE: {
                    return "key_date";
                }
                case BOOLEAN: {
                    return "key_checkbox";
                }
                case COMPLEX: {
                    break;
                }
                case NUMBER: {
                    return "key_number";
                }
                case RELATION: {
                    break;
                }
                case LIST: {
                    return "key_list";
                }
            }
        }
        return null;
    }

    @Override
    public int getForegroundColor() {
        return -1;
    }

    @Override
    public int getBackgroundColor() {
        return -1;
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + Objects.hashCode((Object)this.target);
        hash = 89 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThemisAttribute other = (ThemisAttribute)obj;
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        return this.target == other.target;
    }

    public boolean doShow(long observationtype) {
        switch ((int)observationtype) {
            case 1: {
                return this.show.contains("m");
            }
            case 2: {
                return this.show.contains("k");
            }
            case 3: {
                return this.show.contains("i");
            }
            case 4: {
                return this.show.contains("a");
            }
        }
        return false;
    }

    public String getShow() {
        return this.show;
    }

    public ThemisAttribute setShow(String show) {
        this.show = show;
        return this;
    }

    public boolean isShowDefault() {
        return this.show.contains("m") && this.show.contains("k") && this.show.contains("i") && this.show.contains("a");
    }

    public ThemisAttribute setAllowObservationList(boolean obsListAllowed) {
        this.allowObservationList = obsListAllowed;
        return this;
    }

    public boolean isAllowObservationList() {
        return this.allowObservationList;
    }

    public ThemisAttribute setAllowChecklistEdit(boolean checklistAllowed) {
        this.allowChecklistEdit = checklistAllowed;
        return this;
    }

    public boolean isAllowChecklistEdit() {
        return this.allowChecklistEdit;
    }

    public ThemisAttribute setAllowCustomise(boolean flg) {
        this.allowCustomise = flg;
        return this;
    }

    public boolean isAllowCustomise() {
        return this.allowCustomise;
    }

    public static enum Target {
        OBSERVATION{

            public String toString() {
                return "observation";
            }
        }
        ,
        OBSERVATIONTEMPLATE{

            public String toString() {
                return "observationtemplate";
            }
        }
        ,
        LOCATION{

            public String toString() {
                return "location";
            }
        }
        ,
        EVENT{

            public String toString() {
                return "event";
            }
        }
        ,
        CONTACT{

            public String toString() {
                return "company";
            }
        }
        ,
        PROJECT{

            public String toString() {
                return "project";
            }
        }
        ,
        GROUP{

            public String toString() {
                return "locationgroup";
            }
        }
        ,
        MEASURE{

            public String toString() {
                return "measuretemplate";
            }
        }
        ,
        NONE{

            public String toString() {
                return "";
            }
        };

    }

    public static enum Edit {
        NONE("none"),
        ADMIN("admin"),
        EDITOR("editor"),
        USER("user"),
        DIALOG_ONLY("dialogonly"),
        ADMIN_ONLY("adminonly"),
        DIALOG_AND_CHECKLIST("dialogandchecklist");

        private final String code;

        private Edit(String code) {
            this.code = code;
        }

        public String toString() {
            return this.code;
        }

        public Edit fromString(String s) {
            if (s == null) {
                return NONE;
            }
            switch (s.toLowerCase()) {
                case "admin": {
                    return ADMIN;
                }
                case "editor": {
                    return EDITOR;
                }
                case "user": {
                    return USER;
                }
            }
            return NONE;
        }
    }

    public static enum Type {
        TEXT("text", "string"),
        LONGTEXT("longtext", "string"),
        DATE("date", "date"),
        BOOLEAN("boolean", "boolean"),
        COMPLEX("complex", "unknown"),
        NUMBER("number", "float"),
        RELATION("relation", "string"),
        LIST("list", "string"),
        UPLOAD("upload", "unknown"),
        NONE("unknown", "unknown");

        private final String code;
        private final String sqltype;

        private Type(String code, String sqltype) {
            this.code = code;
            this.sqltype = sqltype;
        }

        public String getCode() {
            return this.code;
        }

        public String getSQLtype() {
            return this.sqltype;
        }

        public String toString() {
            return ThemisApplication.getInstance().getProject().getResourceText("attribute.type." + this.code);
        }
    }
}

