/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.attribute;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.interfaces.IconItem;
import at.grid.themis.ontology.settings.ThemisSettings;

public class ThemisAttributeOld
implements IconItem {
    public static final int TEXT = 1;
    public static final int LONGTEXT = 2;
    public static final int DATE = 3;
    public static final int BOOLEAN = 4;
    public static final int COMPLEX = 5;
    public static final int NUMBER = 6;
    public static final int RELATION = 7;
    public static final int LIST = 8;
    public static final int DIALOG_ONLY = 0;
    public static final int ADMIN_ONLY = 1;
    public static final int DIALOG_AND_CHECKLIST = 2;
    public static final int OBSERVATION = 1;
    public static final int LOCATION = 2;
    private int target;
    ThemisApplication app;
    private String id;
    private String code;
    private String sqlSelect;
    private String label;
    private int type;
    private boolean used;
    private boolean writeprotected;
    private boolean checklistedit;
    private int width;
    private boolean alwaysUsed = false;
    private boolean userdefined;
    private boolean virtual;
    private boolean obsListAllowed = true;
    private boolean checkListAllowed = true;
    private ThemisAttributeOld inherit = null;

    public ThemisAttributeOld(ThemisApplication app, int target, String id, String code, String sqlSelect, String label, int editstyle, boolean userdefined, int defaultWidth, int attributetype) {
        this.app = app;
        if (code == null) {
            code = "";
        }
        this.target = target;
        this.id = id;
        this.code = code;
        this.sqlSelect = sqlSelect;
        this.label = label;
        if ("".equals(this.label)) {
            this.label = id;
        }
        this.setEditStyle(editstyle);
        this.userdefined = userdefined;
        this.width = defaultWidth;
        this.type = attributetype;
    }

    public int getTarget() {
        return this.target;
    }

    public String getTargetCode() {
        switch (this.target) {
            case 1: {
                return "observation";
            }
            case 2: {
                return "location";
            }
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getTypeId() {
        return this.type;
    }

    public String getType() {
        switch (this.type) {
            case 1: {
                return ThemisApplication.getInstance().getProject().getResourceText("attribute.type.text");
            }
            case 2: {
                return ThemisApplication.getInstance().getProject().getResourceText("attribute.type.longtext");
            }
            case 3: {
                return ThemisApplication.getInstance().getProject().getResourceText("attribute.type.date");
            }
            case 4: {
                return ThemisApplication.getInstance().getProject().getResourceText("attribute.type.flag");
            }
            case 5: {
                return ThemisApplication.getInstance().getProject().getResourceText("attribute.type.complex");
            }
            case 6: {
                return ThemisApplication.getInstance().getProject().getResourceText("attribute.type.number");
            }
            case 7: {
                return ThemisApplication.getInstance().getProject().getResourceText("attribute.type.relation");
            }
            case 8: {
                return ThemisApplication.getInstance().getProject().getResourceText("attribute.type.list");
            }
        }
        return ThemisApplication.getInstance().getProject().getResourceText("attribute.type.unknown");
    }

    public String getTypeForXml() {
        switch (this.type) {
            case 1: {
                return "text";
            }
            case 2: {
                return "longtext";
            }
            case 3: {
                return "date";
            }
            case 4: {
                return "flag";
            }
            case 5: {
                return "complex";
            }
            case 6: {
                return "number";
            }
            case 7: {
                return "relation";
            }
            case 8: {
                return "list";
            }
        }
        return "unknown";
    }

    public String getTypeCode() {
        switch (this.type) {
            case 3: {
                return "date";
            }
            case 4: {
                return "boolean";
            }
            case 6: {
                return "float";
            }
        }
        return "string";
    }

    public String getSqlSelect() {
        return this.sqlSelect;
    }

    public String getSqlSort() {
        switch (this.type) {
            case 8: {
                return this.sqlSelect + "sort";
            }
        }
        return this.sqlSelect;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getLabel() {
        return this.label;
    }

    public ThemisAttributeOld setLabel(String label) {
        this.label = label;
        return this;
    }

    public boolean isUsed() {
        if (this.inherit != null) {
            return this.inherit.isUsed();
        }
        return this.isAlwaysUsed() ? true : this.used;
    }

    public ThemisAttributeOld setUsed(boolean used) {
        if (this.inherit != null || this.isAlwaysUsed()) {
            return this;
        }
        this.used = used;
        ThemisSettings settings = this.app.getSettings();
        switch (this.target) {
            case 2: {
                break;
            }
        }
        return this;
    }

    public void setInherit(ThemisAttributeOld ta) {
        this.inherit = ta;
    }

    public boolean isInherit() {
        return this.inherit != null;
    }

    public boolean isWriteprotected() {
        if (this.inherit != null) {
            return this.inherit.isWriteprotected();
        }
        return this.writeprotected;
    }

    public void setWriteprotected(boolean writeprotected) {
        this.writeprotected = writeprotected;
    }

    public void setEditStyle(int editstyle) {
        this.writeprotected = editstyle == 1;
        this.checklistedit = editstyle == 2;
    }

    public int getEditStyle() {
        if (this.inherit != null) {
            return this.inherit.getEditStyle();
        }
        if (this.writeprotected) {
            return 1;
        }
        if (this.checklistedit) {
            return 2;
        }
        return 0;
    }

    public boolean isShowInTable() {
        return this.width > 0;
    }

    public void setWidthInTable(int width) {
        this.width = width;
    }

    public int getWidthInTable() {
        return this.width;
    }

    public ThemisAttributeOld setAlwaysUsed() {
        this.alwaysUsed = true;
        this.setUsed(true);
        return this;
    }

    public boolean isAlwaysUsed() {
        if (this.inherit != null) {
            return this.inherit.isAlwaysUsed();
        }
        return this.alwaysUsed;
    }

    public boolean isChecklistedit() {
        if (this.inherit != null) {
            return this.inherit.isChecklistedit();
        }
        return this.checklistedit;
    }

    public void setChecklistedit(boolean checklistedit) {
        this.checklistedit = checklistedit;
    }

    public boolean isUserdefined() {
        return this.userdefined;
    }

    public void setUserdefined(boolean userdefined) {
        this.userdefined = userdefined;
    }

    public boolean isObsListAllowed() {
        return this.obsListAllowed;
    }

    public ThemisAttributeOld setChecklistAllowed(boolean checklistAllowed) {
        this.checkListAllowed = checklistAllowed;
        return this;
    }

    public boolean isChecklistAllowed() {
        return this.checkListAllowed;
    }

    public ThemisAttributeOld setObsListAllowed(boolean obsListAllowed) {
        this.obsListAllowed = obsListAllowed;
        return this;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public ThemisAttributeOld setVirtual(boolean virtual) {
        this.virtual = virtual;
        return this;
    }

    public String getValue(CmsLocation e) {
        boolean usePrefix = this.app.getSettings().getLocationAttribute("prefixsuffix").isUsed();
        boolean useSuffix = this.app.getSettings().getLocationAttribute("suffix").isUsed();
        switch (this.id) {
            case "group": {
                return e.getAttributeValue("locationgroup");
            }
            case "prefixsuffix": {
                return e.getAttributeValue("prenumber");
            }
            case "suffix": {
                return e.getAttributeValue("postnumber");
            }
            case "number": {
                return (usePrefix ? e.getAttributeValue("prenumber") : "") + e.getAttributeValue("number") + (useSuffix ? e.getAttributeValue("postnumber") : "");
            }
            case "documents": {
                return e.getRelationAttribute("infos").isEmpty() ? "" : "X";
            }
            case "size": {
                String w = e.getAttributeValue("dimwidth");
                String h = e.getAttributeValue("dimheight");
                String d = e.getAttributeValue("dimdiameter");
                if (d != null && !"".equals(d)) {
                    return "d=" + d;
                }
                return w + "x" + h;
            }
            case "hasimage": {
                return e.getImageUploadItems().isEmpty() ? "" : "X";
            }
            case "hasaudio": {
                return e.getAudioUploadItems().isEmpty() ? "" : "X";
            }
        }
        if (this.type == 4) {
            return e.getBooleanAttribute(this.code).isSet() ? "X" : "";
        }
        if (this.type == 7) {
            return e.getRelationAttribute(this.code).getFirstElementTitle();
        }
        return e.getAttributeValue(this.getCode());
    }

    public String getValue(CmsObservation e) {
        switch (this.id) {
            case "number": {
                return e.getAttributeValue("number");
            }
            case "documents": {
                return e.getRelationAttribute("infos").isEmpty() ? "" : "X";
            }
            case "hasimage": {
                return "";
            }
            case "hasaudio": {
                return "";
            }
        }
        if (this.type == 4) {
            return e.getBooleanAttribute(this.code).isSet() ? "X" : "";
        }
        if (this.type == 7) {
            return e.getRelationAttribute(this.code).getFirstElementTitle();
        }
        return e.getAttributeValue(this.getCode());
    }

    public String toString() {
        if (this.getId() == null) {
            return "-";
        }
        String attString = "themisattribute." + this.getTargetCode() + "." + this.getId();
        String resString = ThemisApplication.getInstance().getProject().getResourceText(attString);
        return (this.label == null || "".equals(this.label) ? "-" : this.label) + " [" + resString + "]";
    }

    @Override
    public String getIconKey() {
        if (this.id.equals("barcode")) {
            return "key_barcode";
        }
        if (this.id.equals("responsible")) {
            return "key_person";
        }
        if (this.id.equals("plan")) {
            return "key_plan";
        }
        if (this.id.equals("gps")) {
            return "key_gps";
        }
        if (this.id.equals("size")) {
            return "key_measure";
        }
        if (this.id.equals("quantity") && this.target == 2) {
            return "key_number";
        }
        if (this.id.equals("assessment")) {
            return "key_assessment";
        }
        if (this.id.equals("documents")) {
            return "key_file";
        }
        if (this.id.equals("icon")) {
            return "key_icon";
        }
        if (this.id.equals("group")) {
            return "key_group";
        }
        if (this.id.equals("prefixsuffix")) {
            return "key_prefix_suffix";
        }
        if (this.id.equals("suffix")) {
            return "key_prefix_suffix";
        }
        switch (this.type) {
            case 1: 
            case 2: {
                return "key_text";
            }
            case 3: {
                return "key_date";
            }
            case 4: {
                return "key_checkbox";
            }
            case 5: {
                break;
            }
            case 6: {
                return "key_number";
            }
            case 7: {
                break;
            }
            case 8: {
                return "key_list";
            }
        }
        return null;
    }

    @Override
    public int getForegroundColor() {
        return -1;
    }

    @Override
    public int getBackgroundColor() {
        return -1;
    }

    static enum Target {
        OBSERVATION,
        LOCATION;

    }
}

