/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.attribute.manager;

import at.grid.cms.element.CmsElement;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public abstract class ThemisAttributeManager {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    private HashMap<String, ThemisAttribute> attributes = new HashMap();
    private ArrayList<String> attributeOrder = new ArrayList();
    private ArrayList<ThemisAttributeManager> linkedAttributeManager = new ArrayList();

    public void initialise() {
        this.attributes.clear();
        this.attributeOrder.clear();
        CmsElement ele = this.project.getDefaultElement(this.getElementtype());
        this.initialiseSpecific();
        for (ThemisAttribute themisAttribute : this.getAllAttributes()) {
        }
    }

    public void addLinkedAttributeManager(ThemisAttributeManager tam) {
        this.linkedAttributeManager.add(tam);
    }

    protected abstract String getElementtype();

    public abstract String getLetter();

    protected abstract void initialiseSpecific();

    public String getNextAttributeId(ThemisAttribute.Type t) {
        String result;
        int counter = 1;
        while (this.attributeOrder.contains(result = t.getCode() + counter)) {
            ++counter;
        }
        return result;
    }

    public ThemisAttribute addAttribute(ThemisAttribute ta, boolean addToCms) {
        return this.addAttribute(ta, -1, addToCms);
    }

    public ThemisAttribute addAttribute(ThemisAttribute taRef, int idx, boolean addToCms) {
        ThemisAttribute ta = taRef;
        return ta;
    }

    private void addNewAttributeAtPosition(ThemisAttribute ta, int idx) {
        this.attributes.put(ta.getId(), ta);
        if (idx >= 0 && idx < this.attributeOrder.size()) {
            this.attributeOrder.add(idx, ta.getId());
        } else {
            this.attributeOrder.add(ta.getId());
        }
    }

    public ThemisAttribute getAttribute(String id) {
        return this.attributes.get(id);
    }

    public boolean hasAttribute(String id) {
        return this.attributes.get(id) != null;
    }

    public ArrayList<ThemisAttribute> getAllAttributes() {
        ArrayList<ThemisAttribute> atts = new ArrayList<ThemisAttribute>();
        this.attributeOrder.forEach(id -> atts.add(this.getAttribute((String)id)));
        return atts;
    }

    public ArrayList<ThemisAttribute> getAttributes() {
        ArrayList<ThemisAttribute> atts = new ArrayList<ThemisAttribute>();
        this.attributeOrder.stream().filter(id -> this.getAttribute((String)id).isUsed()).forEachOrdered(id -> atts.add(this.getAttribute((String)id)));
        return atts;
    }

    public ArrayList<ThemisAttribute> getDynamicAttributes() {
        ArrayList<ThemisAttribute> atts = new ArrayList<ThemisAttribute>();
        this.attributeOrder.stream().filter(id -> !this.getAttribute((String)id).isAlwaysUsed()).forEachOrdered(id -> atts.add(this.getAttribute((String)id)));
        return atts;
    }

    public void setAttributeUsed(String id, boolean flg) {
        this.setAttributeUsed(this.getAttribute(id), flg);
    }

    public void setAttributeUsed(ThemisAttribute ta, boolean flg) {
    }

    public boolean isUsed(String id) {
        ThemisAttribute att = this.getAttribute(id);
        return att != null && att.isUsed();
    }

    public String getLabel(String id) {
        ThemisAttribute att = this.getAttribute(id);
        return att == null ? "" : att.getLabel();
    }

    @Deprecated
    public void setAttributeUsed(String id) {
        this.setAttributeUsed(id, true);
    }

    @Deprecated
    public void setAttributeUsed(ThemisAttribute ta) {
        this.setAttributeUsed(ta, true);
    }

    @Deprecated
    public void setAttributeNotUsed(String id) {
        this.setAttributeUsed(id, false);
    }

    @Deprecated
    public void setAttributeNotUsed(ThemisAttribute ta) {
        this.setAttributeUsed(ta, false);
    }

    public void clearAttributeUsage() {
    }

    public void removeAttribute(ThemisAttribute ta) {
    }

    public void clear() {
    }

    public void moveAttribute(ThemisAttribute ta, int dir) {
        int swapIdx;
        if (dir != -1 && dir != 1) {
            return;
        }
        String id = ta.getId();
        int idx = this.attributeOrder.indexOf(id);
        for (swapIdx = idx + dir; swapIdx >= 0 && swapIdx < this.attributeOrder.size() && !this.getAttribute(this.attributeOrder.get(swapIdx)).isUsed(); swapIdx += dir) {
        }
        if (swapIdx >= 0 && swapIdx < this.attributeOrder.size()) {
            Collections.swap(this.attributeOrder, idx, swapIdx);
        }
    }
}

