/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.cli;

import at.grid.themis.ontology.ThemisFile;
import at.grid.themis.ontology.cli.ThemisAbstractAction;
import at.grid.util.cli.CLIApplication;
import at.grid.util.cli.Command;
import java.io.File;

public class ExportAction
extends ThemisAbstractAction {
    public ExportAction(CLIApplication app) {
        super(app);
    }

    protected String execute(Command cmd) {
        String error;
        block13: {
            error = null;
            try {
                String file = cmd.getArgument(0);
                File f = new File(file);
                String content = "projekt";
                if (cmd.countArgs() > 1) {
                    content = cmd.getArgument(1).toLowerCase();
                }
                ThemisFile tf = new ThemisFile();
                switch (content) {
                    case "projekt": {
                        tf.setAsFullProject();
                        break;
                    }
                    case "vorlage": {
                        tf.setAsProjectTemplate();
                        break;
                    }
                    case "filter": {
                        tf.setWithPlans();
                        tf.setWithTemplates();
                        tf.setWithAllImages();
                        tf.addContent(this.themis.getFilter().getFilteredLocationIds());
                        tf.addContent(this.themis.getFilter().getFilteredObservationIds());
                    }
                }
                tf.saveToFile(f, true);
            }
            catch (Exception e) {
                this.project.getLogger().severe(e.getMessage());
                if (!this.themis.isDebugMode()) break block13;
                e.printStackTrace();
            }
        }
        return error;
    }

    @Override
    protected String validate(Command cmd) {
        String result = super.validate(cmd);
        if (cmd.countArgs() < 1) {
            return "Es ist keine Datei angegeben";
        }
        return result;
    }

    @Override
    protected boolean isOpenProjectRequired() {
        return true;
    }

    protected String getUsage() {
        return "EXPORT <datei> {vorlage | filter | projekt}";
    }

    protected String getDescription() {
        StringBuffer s = new StringBuffer();
        s.append("Exportiert Daten aus einem Projekt");
        return s.toString();
    }

    protected String getCommand() {
        return "export";
    }

    protected String getCommandAlt() {
        return "e";
    }
}

