/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.cli;

import at.grid.themis.ontology.ThemisFile;
import at.grid.themis.ontology.cli.ThemisAbstractAction;
import at.grid.util.Util;
import at.grid.util.cli.CLIApplication;
import at.grid.util.cli.Command;
import java.io.File;

public class ImportAction
extends ThemisAbstractAction {
    public ImportAction(CLIApplication app) {
        super(app);
    }

    protected String execute(Command cmd) {
        String error;
        block5: {
            error = null;
            try {
                String fn = cmd.getArgument(0);
                File f = this.getFile(fn);
                boolean moveToArchive = cmd.hasOption("archive");
                ThemisFile tf = new ThemisFile().setContentType(ThemisFile.ContentType.CONTENT);
                String importresult = tf.loadFromFile(f, true).getError();
                if (importresult != null) {
                    this.project.getLogger().severe(importresult);
                }
                if (moveToArchive) {
                    File fDest = new File("");
                    Util.copy((File)f, (File)fDest);
                    if (fDest.isFile() && fDest.length() == f.length() && f.isFile()) {
                        f.delete();
                    }
                }
            }
            catch (Exception e) {
                this.project.getLogger().severe(e.getMessage());
                if (!this.themis.isDebugMode()) break block5;
                e.printStackTrace();
            }
        }
        return error;
    }

    @Override
    protected String validate(Command cmd) {
        String result = super.validate(cmd);
        if (cmd.countArgs() < 1) {
            return "Es muss eine Datei angegeben werden";
        }
        return result;
    }

    @Override
    protected boolean isOpenProjectRequired() {
        return true;
    }

    protected String getUsage() {
        return "IMPORT <datei> -archive - Importiert die Datei in das geladene Projekt\n  -arcive - Die Importdatei wird in das Projektarchiv verschoben";
    }

    protected String getDescription() {
        StringBuffer s = new StringBuffer();
        s.append("Importiert Daten in ein Projekt");
        return s.toString();
    }

    protected String getCommand() {
        return "import";
    }

    protected String getCommandAlt() {
        return "i";
    }
}

