/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.cli;

import at.grid.themis.ontology.cli.ThemisAbstractAction;
import at.grid.util.Util;
import at.grid.util.cli.CLIApplication;
import at.grid.util.cli.Command;
import java.io.File;
import java.util.ArrayList;

public class ListAction
extends ThemisAbstractAction {
    public ListAction(CLIApplication app) {
        super(app);
    }

    protected String execute(Command cmd) {
        String error;
        block3: {
            error = null;
            try {
                String action = cmd.getArgument(0);
                if ("project".equalsIgnoreCase(action)) {
                    String folder = cmd.getOption("folder", null);
                    boolean includeSub = cmd.hasOption("sub");
                    this.exeListProject(cmd, folder, includeSub);
                }
            }
            catch (Exception e) {
                this.project.getLogger().severe(e.getMessage());
                if (!this.themis.isDebugMode()) break block3;
                e.printStackTrace();
            }
        }
        return error;
    }

    private String exeListProject(Command cmd, String folder, boolean includeSub) {
        File fld = folder == null ? this.themis.getCurrentFolder() : new File(folder);
        cmd.display("Projekte im Ordner " + fld.getAbsolutePath());
        ArrayList<File> projects = this.project.getProjects(fld, includeSub);
        int count = 1;
        for (File f : projects) {
            cmd.display(Util.expandString((String)Integer.toString(count++), (String)" ", (int)5, (boolean)true) + "   " + f.getAbsolutePath());
        }
        return null;
    }

    @Override
    protected String validate(Command cmd) {
        String result = super.validate(cmd);
        if (result != null) {
            return result;
        }
        if (cmd.countArgs() < 1) {
            return "Es ist keine Aktion definiert";
        }
        return result;
    }

    protected String getUsage() {
        return "LIST project folder=<folder> [/sub]";
    }

    protected String getDescription() {
        StringBuffer s = new StringBuffer();
        s.append("F\u00fchrt eine Liste aller Projekte auf");
        return s.toString();
    }

    protected String getCommand() {
        return "list";
    }

    protected String getCommandAlt() {
        return "l";
    }
}

