/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.cli;

import at.grid.themis.ontology.Closing;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.cli.ThemisAbstractAction;
import at.grid.util.Util;
import at.grid.util.cli.CLIApplication;
import at.grid.util.cli.Command;
import java.io.File;
import java.util.ArrayList;

public class ProjectAction
extends ThemisAbstractAction {
    public ProjectAction(CLIApplication app) {
        super(app);
    }

    protected String execute(Command cmd) {
        String error;
        block14: {
            error = null;
            try {
                String action = cmd.getArgument(0);
                switch (action.toLowerCase()) {
                    case "open": {
                        return this.exeOpen(cmd);
                    }
                    case "close": {
                        return this.exeClose(cmd);
                    }
                    case "updateimage": {
                        return this.exeUpdateImage(cmd, ThemisUtil.ImageType.IMAGE);
                    }
                    case "updateicon": {
                        return this.exeUpdateImage(cmd, ThemisUtil.ImageType.ICON);
                    }
                }
            }
            catch (Exception e) {
                this.project.getLogger().severe(e.getMessage());
                if (!this.themis.isDebugMode()) break block14;
                e.printStackTrace();
            }
        }
        return error;
    }

    private String exeClose(Command cmd) {
        if (!this.project.isOpen()) {
            return "Es ist kein Projekt ge\u00f6ffnet";
        }
        cmd.display("Das Projekt '" + this.project.getProjectFolder().getAbsolutePath() + "' wird geschlossen ...");
        this.project.close(new Closing().withoutExport().withoutTrigger(), null);
        if (this.project.isOpen()) {
            return "Das Projekt kann nicht geschlossen werden: " + this.project.getProjectError();
        }
        return null;
    }

    private String exeOpen(Command cmd) {
        if (cmd.countArgs() < 2) {
            return "Kein Projekt zum \u00d6ffnen angegeben";
        }
        if (this.project.isOpen()) {
            return "Es ist bereits ein Projekt ge\u00f6ffnet: " + this.project.getProjectFolder().getAbsolutePath();
        }
        String fld = cmd.getArgument(1);
        File f = new File(fld);
        if (!f.exists()) {
            f = new File(this.themis.getCurrentFolder(), fld);
        }
        if (!f.exists()) {
            return "Keinen Ordner mit dem angegebenen Namen '" + fld + "' gefunden";
        }
        if (!ThemisProject.isProjectFolder(f)) {
            return "Der angegebene Ordner '" + fld + "' ist kein THEMIS Projektordner";
        }
        cmd.display("Das Projekt '" + fld + "' wird ge\u00f6ffnet ...");
        this.project.open(f, null, null, false, false, false, false, false, null);
        if (!this.project.isOpen()) {
            return "Das Projekt kann nicht ge\u00f6ffnet werden: " + this.project.getProjectError();
        }
        return null;
    }

    private String exeUpdateImage(Command cmd, ThemisUtil.ImageType type) {
        if (!this.project.isOpen()) {
            return "Es ist kein Projekt ge\u00f6ffnet";
        }
        int longside = Util.parseInt((String)cmd.getOption("size", "0"), (int)0);
        float quality = Util.parseFloat((String)cmd.getOption("quality", "70"), (float)70.0f);
        if (quality < 1.0f || quality > 100.0f) {
            return "Qualit\u00e4t muss zwischen 1 und 100 liegen";
        }
        ArrayList<File> files = new ArrayList<File>();
        File folderRoot = new File(this.project.getProjectFolder(), "data");
        switch (type) {
            case ICON: {
                files.addAll(ThemisUtil.getIconFiles(this.project.getThemisFile(), longside));
                break;
            }
            case IMAGE: {
                files.addAll(ThemisUtil.getImageFiles(this.project.getThemisFile(), longside));
            }
        }
        if (files.isEmpty()) {
            return "Es sind keine Dateien im Ordner zu bearbeiten";
        }
        ThemisUtil.updateImage(files, longside, quality, null);
        return null;
    }

    @Override
    protected String validate(Command cmd) {
        String result = super.validate(cmd);
        if (result != null) {
            return result;
        }
        if (cmd.countArgs() == 0) {
            return "Es ist keine Aktion definiert";
        }
        if (cmd.getArgument(0).equalsIgnoreCase("open") && cmd.countArgs() < 1) {
            return "Es muss ein Projektordner angegeben werden";
        }
        return result;
    }

    protected String getUsage() {
        return "PROJECT OPEN <project-folder>\n  ... Projekt wird ge\u00f6ffnet\nPROJECT CLOSE\n  ... Projekt wird geschlossen\nPROJECT UPDATEIMAGE {size=<longside-pixel>} {quality=<quality>}\n  ... Die Fotos im aktuell offenen Projekt werden neu gerechnet\n";
    }

    protected String getDescription() {
        StringBuffer s = new StringBuffer();
        s.append("Funktionen zum \u00d6ffnen, Schlie\u00dfen und bearbeiten von Projekten");
        return s.toString();
    }

    protected String getCommand() {
        return "project";
    }

    protected String getCommandAlt() {
        return "p";
    }
}

