/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.cli;

import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.cli.ThemisAbstractAction;
import at.grid.themis.ontology.server.ThemisDatabaseServer;
import at.grid.util.Util;
import at.grid.util.cli.CLIApplication;
import at.grid.util.cli.Command;
import java.io.File;

public class ServerAction
extends ThemisAbstractAction {
    ThemisDatabaseServer server = ThemisDatabaseServer.getInstance();

    public ServerAction(CLIApplication app) {
        super(app);
    }

    protected String execute(Command cmd) {
        String error;
        block33: {
            error = null;
            try {
                String action = cmd.getArgument(0);
                String port = cmd.getOption("port", "8082");
                String host = cmd.getOption("host", "localhost");
                switch (action.toLowerCase()) {
                    case "start": {
                        String result = this.server.startServer(host, port);
                        if (result == null) {
                            cmd.display("Der Server ist mit Port " + port + " gestartet!");
                            break;
                        }
                        cmd.display(result);
                        break;
                    }
                    case "stop": {
                        this.server.stopServer();
                        cmd.display("Der Server mit Port " + port + " wurde beendet");
                        break;
                    }
                    case "add": {
                        if (cmd.countArgs() < 2) {
                            return "Es muss der Pfad zum Projekt angegeben werden";
                        }
                        String fld = cmd.getArgument(1);
                        File f = new File(fld);
                        if (!f.exists()) {
                            f = new File(this.themis.getCurrentFolder(), fld);
                        }
                        if (!f.exists()) {
                            return "Keinen Ordner mit dem angegebenen Namen '" + fld + "' gefunden";
                        }
                        if (!ThemisProject.isProjectFolder(f)) {
                            return "Der angegebene Ordner '" + fld + "' ist kein THEMIS Projektordner";
                        }
                        ThemisFolder tf = new ThemisFolder(f);
                        if (tf.getProjectLock().isLocked()) {
                            return "Das Projekt ist gerade in Verwendung";
                        }
                        this.server.addProject(tf);
                        cmd.display("Das Projekt '" + fld + "' wurde f\u00fcr den Server-Zugriff konfiguriert");
                        return null;
                    }
                    case "remove": {
                        if (cmd.countArgs() < 2) {
                            return "Es muss der Pfad zum Projekt angegeben werden";
                        }
                        String fld = cmd.getArgument(1);
                        File f = new File(fld);
                        if (!f.exists()) {
                            f = new File(this.themis.getCurrentFolder(), fld);
                        }
                        if (!f.exists()) {
                            return "Keinen Ordner mit dem angegebenen Namen '" + fld + "' gefunden";
                        }
                        if (!ThemisProject.isProjectFolder(f)) {
                            return "Der angegebene Ordner '" + fld + "' ist kein THEMIS Projektordner";
                        }
                        ThemisFolder tf = new ThemisFolder(f);
                        if (tf.getProjectLock().isLocked()) {
                            return "Das Projekt ist gerade in Verwendung";
                        }
                        this.server.removeProject(tf);
                        cmd.display("Der Server-Zugriff auf das Projekt '" + fld + "' wurde entfernt");
                        return null;
                    }
                    case "list": {
                        cmd.display("Folgende Projekte sind f\u00fcr den Server-Zugriff konfiguriert:");
                        int count = 1;
                        for (ThemisFolder p : this.server.getServerProjects()) {
                            cmd.display(Util.expandString((String)Integer.toString(count++), (String)" ", (int)5, (boolean)true) + "   " + p.getProjectFolder().getAbsolutePath());
                        }
                        return null;
                    }
                    case "status": {
                        if (this.server.isRunning()) {
                            cmd.display("Der Server l\u00e4uft \u00fcber den Port " + this.server.getPort());
                        } else {
                            cmd.display("Der Server l\u00e4uft nicht");
                        }
                        return null;
                    }
                }
            }
            catch (Exception e) {
                this.project.getLogger().severe(e.getMessage());
                error = e.getMessage();
                if (!this.themis.isDebugMode()) break block33;
                e.printStackTrace();
            }
        }
        return error;
    }

    @Override
    protected String validate(Command cmd) {
        String result = super.validate(cmd);
        if (cmd.countArgs() == 0) {
            return "Es ist keine Aktion definiert";
        }
        return result;
    }

    protected String getUsage() {
        return "SERVER start [host=<host-ip/name>] [/port=<port>]\nSERVER stop\nSERVER status\nSERVER list\nSERVER add <path-to-project>\nSERVER remove <path-to-project>";
    }

    protected String getDescription() {
        StringBuffer s = new StringBuffer();
        s.append("Verwaltung des Datenbank-Servers");
        return s.toString();
    }

    protected String getCommand() {
        return "server";
    }

    protected String getCommandAlt() {
        return "s";
    }
}

