/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.cli;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.util.cli.Action;
import at.grid.util.cli.CLIApplication;
import at.grid.util.cli.Command;
import java.io.File;

public abstract class ThemisAbstractAction
extends Action {
    ThemisApplication themis = ThemisApplication.getInstance();
    ThemisProject project = this.themis.getProject();

    public ThemisAbstractAction(CLIApplication app) {
        super(app);
    }

    protected String validate(Command cmd) {
        if (this.isLicenseRequired()) {
            if (!this.themis.getLicense().hasLicense()) {
                return "Die Lizenz ist nicht aktiviert";
            }
            if (!this.themis.getLicense().hasFeature("server")) {
                return "Bei der Lizenz handelt es sich nicht um eine THEMIS-Server Lizenz";
            }
        }
        if (this.isOpenProjectRequired() && !this.themis.getProject().isOpen()) {
            return "Es ist kein Projekt geladen";
        }
        return null;
    }

    protected boolean isLicenseRequired() {
        return true;
    }

    protected boolean isOpenProjectRequired() {
        return false;
    }

    protected File getFile(String fn) {
        File f = new File(fn);
        if (f.exists()) {
            return f;
        }
        f = new File(this.app.getCurrentDir(), fn);
        return f;
    }
}

