/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.cli;

import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.cli.ThemisAbstractAction;
import at.grid.util.Util;
import at.grid.util.cli.CLIApplication;
import at.grid.util.cli.Command;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.openide.util.Exceptions;

public class ToolAction
extends ThemisAbstractAction {
    private static final byte[] BUFFER = new byte[0x400000];

    public ToolAction(CLIApplication app) {
        super(app);
    }

    protected String execute(Command cmd) {
        String error;
        block10: {
            error = null;
            try {
                String action;
                switch (action = cmd.getArgument(0).toLowerCase()) {
                    case "correct": {
                        return this.exeCorrectThemisFile(cmd);
                    }
                    case "updatedb": {
                        return this.exeUpdateDb(cmd);
                    }
                }
            }
            catch (Exception e) {
                this.project.getLogger().severe(e.getMessage());
                if (!this.themis.isDebugMode()) break block10;
                e.printStackTrace();
            }
        }
        return error;
    }

    private String exeUpdateDb(Command cmd) {
        if (cmd.countArgs() < 2) {
            return "Es muss eine Datei angegeben wrden.";
        }
        if (!this.project.isOpen()) {
            return "Es ist kein Projekt ge\u00f6ffnet";
        }
        String fn = cmd.getArgument(1);
        File f = this.getFile(fn);
        if (f == null || !f.isFile()) {
            return "Die angegeben Datei existiert nicht";
        }
        StringBuilder sb = new StringBuilder();
        try {
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            String ln = br.readLine();
            while (ln != null) {
                if (!"".equals(ln.trim()) && !ln.startsWith("#")) {
                    sb.append(ln).append("\n  ");
                    sb.append("->" + this.project.getDatastorage().executeUpdate(ln, true)).append(" Datens\u00e4tze\n");
                }
                ln = br.readLine();
            }
            br.close();
            fr.close();
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            sb.append("Fehler: ").append(ex.getMessage()).append("\n");
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            sb.append("Fehler: ").append(ex.getMessage()).append("\n");
        }
        return sb.toString();
    }

    private String exeCorrectThemisFile(Command cmd) {
        ZipEntry entry;
        String fnIn = cmd.getOption("in");
        if (fnIn == null) {
            return "Keine Datei angegeben";
        }
        File f = this.getFile(fnIn);
        if (f == null || !f.isFile()) {
            return "Die angegeben Datei existiert nicht";
        }
        String fnOut = cmd.getOption("out");
        if (fnOut == null) {
            fnOut = Util.getFileNameWithoutExtension((File)f) + "_corr." + Util.getFileExtension((File)f);
        }
        File fOut = new File(this.app.getCurrentDir(), fnOut);
        ZipOutputStream out = null;
        ZipFile zip = null;
        try {
            out = new ZipOutputStream(new FileOutputStream(fOut));
            zip = new ZipFile(f);
        }
        catch (Exception ex) {
            cmd.getSource().display("... FEHLER: " + ex.getMessage());
            ex.printStackTrace();
        }
        if (zip == null || out == null) {
            Util.closeStream((Closeable)zip);
            Util.closeStream((Closeable)out);
            return "Kann die *.themis-Datei nicht \u00f6ffnen";
        }
        cmd.getSource().display("Lese die ZIP-Date ein ...");
        Enumeration<? extends ZipEntry> entries = zip.entries();
        int countEntries = 0;
        long maxId = 10000L;
        while (entries.hasMoreElements()) {
            long id;
            entry = entries.nextElement();
            String entryName = entry.getName();
            if (entryName.toLowerCase().endsWith("_element.xml") && (id = Util.parseLong((String)entryName.split("_")[1], (long)0L)) > maxId) {
                maxId = id;
            }
            ++countEntries;
        }
        cmd.getSource().display("... " + countEntries + " Eintr\u00e4ge gefunden");
        long nextId = maxId + 1L;
        entries = zip.entries();
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        cmd.getSource().display("Hole max. ID ...");
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.toLowerCase().endsWith("_element.xml") || !entryName.toLowerCase().startsWith("observation_")) continue;
            long id = Util.parseLong((String)entryName.split("_")[1], (long)0L);
            map.put(id, nextId);
            ++nextId;
        }
        cmd.getSource().display("... max. iD = " + nextId);
        cmd.getSource().display("Korrigiere Eintr\u00e4ge ...");
        entries = zip.entries();
        Document eledoc = null;
        int counter = 0;
        float percentage = 10.0f;
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            String entryName = entry.getName();
            long id = 0L;
            if (entryName.toLowerCase().endsWith("_element.xml")) {
                id = Util.parseLong((String)entryName.split("_")[1], (long)0L);
            }
            Long newId = (Long)map.get(id);
            if (entryName.toLowerCase().endsWith("_element.xml") && entryName.toLowerCase().startsWith("observation_")) {
                cmd.getSource().display(entryName + " wird korrigiert und umbenannt ...");
                if (newId == null) continue;
                try {
                    eledoc = ThemisProject.getXmlDocument(zip, entry);
                    Element eleMeta = eledoc.getRootElement().getChild("meta");
                    eleMeta.getChild("meta_id").setText(Long.toString(newId));
                    String content = Util.toXml((Document)eledoc);
                    ZipEntry e = new ZipEntry("observation_" + newId + "_element.xml");
                    out.putNextEntry(e);
                    Object data = content.getBytes(StandardCharsets.UTF_8);
                    out.write((byte[])data, 0, ((Object)data).length);
                    out.closeEntry();
                    cmd.getSource().display("... OK");
                }
                catch (Exception ex) {
                    cmd.getSource().display("... FEHLER: " + ex.getMessage());
                    ex.printStackTrace();
                }
            } else if (entryName.toLowerCase().endsWith("_element.xml") && entryName.toLowerCase().startsWith("location_")) {
                try {
                    cmd.getSource().display(entryName + " wird \u00fcberpr\u00fcft ...");
                    boolean foundObs = false;
                    eledoc = ThemisProject.getXmlDocument(zip, entry);
                    Element eleData = eledoc.getRootElement().getChild("data");
                    List observations = eleData.getChild("observations").getChildren("observation");
                    for (Element obs : observations) {
                        long idObs = Util.parseLong((String)obs.getAttributeValue("id"), (long)0L);
                        if (!map.containsKey(idObs)) continue;
                        obs.setAttribute("id", Long.toString((Long)map.get(idObs)));
                        foundObs = true;
                    }
                    String content = Util.toXml((Document)eledoc);
                    ZipEntry e = new ZipEntry(entry.getName());
                    out.putNextEntry(e);
                    byte[] data = content.getBytes(StandardCharsets.UTF_8);
                    out.write(data, 0, data.length);
                    out.closeEntry();
                    cmd.getSource().display("... OK " + (foundObs ? "mit" : "ohne") + " Korrektur");
                }
                catch (Exception ex) {
                    cmd.getSource().display("... FEHLER: " + ex.getMessage());
                    ex.printStackTrace();
                }
            } else {
                try {
                    out.putNextEntry(entry);
                    if (!entry.isDirectory()) {
                        ToolAction.copy(zip.getInputStream(entry), out);
                    }
                }
                catch (Exception ex) {
                    cmd.getSource().display("... FEHLER: " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
            if (!(100.0f * (float)(++counter) / (float)countEntries > percentage)) continue;
            cmd.getSource().display("... " + percentage + "% fertig ...");
            percentage += 10.0f;
        }
        Util.closeStream((Closeable)zip);
        Util.closeStream((Closeable)out);
        cmd.getSource().display("... 100% fertig!");
        return null;
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        int bytesRead;
        while ((bytesRead = input.read(BUFFER)) != -1) {
            output.write(BUFFER, 0, bytesRead);
        }
    }

    @Override
    protected String validate(Command cmd) {
        String result = super.validate(cmd);
        if (result != null) {
            return result;
        }
        if (cmd.countArgs() == 0) {
            return "Check usage";
        }
        return result;
    }

    protected String getUsage() {
        return "TOOL correct in=<filename> out=<filename>\n  ... *.themis Datei korrigieren\nTOOL updatedb <filename>\n  ... Datenbank aktualisieren mit SQL";
    }

    protected String getDescription() {
        StringBuffer s = new StringBuffer();
        s.append("Diverse Werkzeuge, um Daten zu reparieren oder zu aktualisieren");
        return s.toString();
    }

    protected String getCommand() {
        return "tool";
    }

    protected String getCommandAlt() {
        return "t";
    }
}

