/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.element;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsUser;
import at.grid.cms.storage.DataRecord;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.ThemisElement;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;

public class CmsEvent
extends ThemisElement {
    private String titleAfterLoad = null;
    private Date dateAfterLoad = null;
    private String timeAfterLoad = null;

    public String getSummary() {
        String time = this.hasAttributeValue("time") ? this.getAttributeValue("time") : this.app.getResourceText("text.event.notime", this.themis.getLocale());
        String place = this.hasAttributeValue("place") ? this.getAttributeValue("place") : this.app.getResourceText("text.event.noplace", this.themis.getLocale());
        return place + ", " + time;
    }

    public String getTitle() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getAttributeValue("title"));
        if (this.hasAttributeValue("date")) {
            sb.append(" (").append(this.getAttributeValue("date"));
            if (this.hasAttributeValue("time")) {
                sb.append(", ").append(this.getAttributeValue("time"));
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public String getEventTitle() {
        return this.getAttributeValue("title");
    }

    public Date getEventDate() {
        return this.getDateAttribute("date").getDate();
    }

    public String getEventTime() {
        return this.getAttributeValue("time");
    }

    public boolean verifyElement() {
        boolean check = super.verifyElement();
        if (!this.hasAttributeValue("date")) {
            ThemisApplication.getInstance().getDialog().showInfoDialog("Bitte geben Sie ein Datum an.");
            return false;
        }
        return check;
    }

    protected void preSave() {
        String t = this.getAttributeValue("time");
        int h = 0;
        String t1 = t.split(" ")[0];
        String[] split = t1.split("-");
        String t0 = split.length > 0 ? split[0] : t1;
        String thours = t0.split(":")[0];
        try {
            h = Integer.parseInt(thours);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getIntegerAttribute("timehours").setValue(h);
    }

    protected void postLoad() {
        this.titleAfterLoad = this.getAttributeValue("title");
        this.dateAfterLoad = new Date(this.getDateAttribute("date").getDate().getTime());
        this.timeAfterLoad = this.getAttributeValue("timehours");
    }

    protected void postSave() {
        super.postSave();
        String title = this.getAttributeValue("title");
        Date dt = this.getDateAttribute("date").getDate();
        String time = this.getAttributeValue("timehours");
        if (dt == null) {
            return;
        }
        boolean didTitleChange = this.titleAfterLoad == null || !title.equals(this.titleAfterLoad);
        boolean didDateChange = this.dateAfterLoad == null || !dt.equals(this.dateAfterLoad);
        boolean didTimeChange = this.timeAfterLoad == null || !time.equals(this.timeAfterLoad);
        Iterator iterator = this.getRelationAttribute("histories").getElementIds().iterator();
        while (iterator.hasNext()) {
            long historyid = (Long)iterator.next();
            CmsElement history = this.getApplication().loadElement(historyid, this.getCurrentUser());
            if (history == null || history.getRelationAttribute("observation").isEmpty()) {
                if (history == null) continue;
                history.moveToTrash();
                continue;
            }
            if (didDateChange) {
                history.getDateAttribute("eventdate").setDate(this.getDateAttribute("date").getDate());
            }
            if (didTimeChange) {
                history.setAttributeValue("timehours", time);
            }
            if (!didTitleChange && !didDateChange && !didTimeChange) continue;
            history.save();
            long obsid = history.getRelationAttribute("observation").getFirstElementId();
            CmsObservation obs = (CmsObservation)this.getApplication().loadElement(obsid, this.getCurrentUser());
            obs.setCurrentHistoryToBeIgnored();
            obs.save();
        }
    }

    public void remove() {
        boolean doremove = true;
        if (!this.getRelationAttribute("histories").isEmpty()) {
            doremove = ThemisApplication.getInstance().getDialog().showConfirmDialog("Es sind noch " + this.getRelationAttribute("histories").size() + " Beobachtungen f\u00fcr dieses Ereignis definiert, tats\u00e4chlich l\u00f6schen?");
        }
        if (doremove) {
            if (this.getProject().getSelectionManager().getCurrentEventId() == this.getId()) {
                this.getProject().setCurrentEvent(null);
            }
            Iterator iterator = this.getRelationAttribute("histories").getElementIds().iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                CmsElement.remove((CmsApplication)this.getApplication(), (long)id, (CmsUser)this.getCurrentUser());
            }
            super.remove();
        }
    }

    public String moveToTrash() {
        return this.moveToTrash(null);
    }

    public String moveToTrash(ProgressHandler ph) {
        boolean doremove = true;
        if (doremove) {
            if (this.getProject().getSelectionManager().getCurrentEventId() == this.getId()) {
                this.getProject().setCurrentEvent(null);
            }
            Iterator iterator = this.getRelationAttribute("histories").getElementIds().iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                CmsElement.moveToTrash((CmsApplication)this.getApplication(), (long)id, (CmsUser)this.getCurrentUser());
            }
            return super.moveToTrash();
        }
        return "";
    }

    public void sign() {
        File f = new File(this.themis.getProject().getTempfileLocation(), "versiegelt.txt");
        if (f.isFile()) {
            f.delete();
        }
        try {
            Util.stringToFile((String)"versiegelt ohne unterschrift", (File)f);
            this.sign(f);
        }
        catch (IOException ex) {
            this.sign(null);
        }
    }

    public void sign(File f) {
        if (f != null && f.isFile()) {
            this.getUploadAttribute("signature").addUpload(f);
        }
        this.save(true, false);
    }

    public boolean isSigned() {
        return this.getUploadAttribute("signature").hasUploads();
    }

    public static boolean isSigned(long id) {
        ArrayList items = ThemisApplication.getInstance().getProject().getDatastorage().getUploadItems(id, "signature");
        return !items.isEmpty();
    }

    public void removeSignature(boolean save) {
        this.getUploadAttribute("signature").clear();
        if (save) {
            this.save();
        }
    }

    public void postCreate() {
        this.getDateAttribute("date").setDate(new Date());
    }

    public ArrayList<Long> getObservationIds() {
        ArrayList historyIds = this.app.getDatastorage().getRelationIds(this.getId(), "historyevent", false);
        return this.app.getDatastorage().getRelationIds((List)historyIds, "historyobservation", true);
    }

    public ArrayList<Long> getOpenTasks() {
        ArrayList<Long> result = new ArrayList<Long>();
        Date refdate = this.getDateAttribute("date").getDate();
        String refdateStr = Util.formatDate((Date)refdate, (String)Util.DATE_SQL, (TimeZone)this.themis.getTimeZone());
        List recs = this.app.getDatastorage().executeQuery("SELECT o.idelement FROM tdtaEleObservation AS o INNER JOIN tdtaElement AS e ON (e.idelement=o.idelement) WHERE o.idtype IN (1,4)  AND NOT e.deleted AND o.creationdate <= " + Util.toSqlString((Date)refdate, (TimeZone)this.themis.getTimeZone()) + " AND (o.donedate > " + Util.toSqlString((Date)refdate, (TimeZone)this.themis.getTimeZone()) + " OR o.donedate IS NULL)", true).getResult();
        for (DataRecord rec : recs) {
            long id = rec.getLong("idelement");
            CmsObservation obs = (CmsObservation)this.themis.getProject().loadElement(id, this.themis.getProject().getUser());
            CmsHistory hist = obs.getHistory(this);
            if (hist != null) {
                obs.applyHistory(hist);
            } else {
                hist = obs.getHistoryBefore(this);
                obs.applyHistory(hist);
            }
            if (obs.isDone()) continue;
            result.add(obs.getId());
        }
        return result;
    }

    public ArrayList<Long> getPlannedObservationIds() {
        return (ArrayList)this.getRelationAttribute("plannedobservations").getElementIds(false);
    }

    public void addModifiedElement(CmsElement e) {
        this.getRelationAttribute("modifiedelements").add(e);
    }

    public ArrayList<Long> getModifiedElementIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.addAll(this.getRelationAttribute("modifiedelements").getElementIds());
        return ids;
    }

    public boolean isModifiedWithinEvent(long id) {
        return this.getRelationAttribute("modifiedelements").getElementIds().contains(id);
    }

    public Properties getEventStatistics() {
        Properties props = new Properties();
        ArrayList<Long> obsIds = this.getObservationIds();
        List recs = this.themis.getProject().getDatastorage().executeQuery("SELECT idtype AS idtype, count(idtype) AS count FROM tdtaEleObservation WHERE idelement IN " + Util.toSqlString(obsIds, (boolean)false) + " GROUP BY idtype", true).getResult();
        for (DataRecord rec : recs) {
            props.setProperty("obs.type" + rec.get("idtype"), rec.get("count"));
        }
        props.setProperty("obs.created", Long.toString(this.getCreatedObservationIds().size()));
        return props;
    }

    public ArrayList<Long> getCreatedObservationIds() {
        HashMap<Long, Long> firstEventIds = this.getFirstEvent(this.getObservationIds());
        ArrayList<Long> createdObservationIds = new ArrayList<Long>();
        for (long idObs : firstEventIds.keySet()) {
            if (firstEventIds.get(idObs).longValue() != this.getId()) continue;
            createdObservationIds.add(idObs);
        }
        return createdObservationIds;
    }

    private HashMap<Long, Long> getFirstEvent(ArrayList<Long> obsIds) {
        String sql = "SELECT  r1.elementto AS idObservation ,r1.elementfrom AS idHistory ,r2.elementTo AS idEvent ,event.date AS eventdate ,event.timehours AS eventhours  FROM tdtaRelation AS r1  INNER JOIN tdtaRelation AS r2 ON (r1.elementfrom=r2.elementfrom AND r2.relationcode='historyevent')  INNER JOIN tdtaEleEvent AS event ON (r2.elementto=event.idelement)  WHERE  r1.relationcode='historyobservation'  AND r1.elementto IN " + Util.toSqlString(obsIds, (boolean)false) + " ORDER BY r1.elementto,event.date,event.timehours,event.idelement";
        List recs = this.themis.getProject().getDatastorage().executeQuery(sql, true).getResult();
        long id = -1L;
        HashMap<Long, Long> observationFirstHistory = new HashMap<Long, Long>();
        for (DataRecord rec : recs) {
            if (rec.getLong("idobservation") == id) continue;
            observationFirstHistory.put(rec.getLong("idobservation"), rec.getLong("idevent"));
            id = rec.getLong("idobservation");
        }
        return observationFirstHistory;
    }
}

