/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.element;

import at.grid.cms.element.CmsElement;
import at.grid.cms.storage.DataRecord;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsFormularHistory;
import at.grid.themis.ontology.element.ThemisElement;
import at.grid.themis.ontology.javafx.formeditor.FormItem;
import at.grid.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;

public class CmsFormular
extends ThemisElement {
    public String getTitle() {
        return this.getAttributeValue("name");
    }

    public String getDescription() {
        return this.getAttributeValue("description");
    }

    public String getFormName() {
        return this.getAttributeValue("name");
    }

    public void setFormName(String fn) {
        this.setAttributeValue("name", fn);
    }

    public void setFormAlias(String fa) {
        this.setAttributeValue("alias", fa);
    }

    public String getFormAlias() {
        return this.getAttributeValue("alias");
    }

    public void setFormXml(String xml) {
        this.setAttributeValue("xml", xml);
    }

    public String getFormXml() {
        return this.getAttributeValue("xml");
    }

    public ArrayList<Long> getEventIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (CmsFormularHistory fh : this.getFormHistories()) {
            ids.add(fh.getEventId());
        }
        return ids;
    }

    public CmsFormularHistory getCurrentFormHistory() {
        CmsEvent ev = this.themis.getProject().getSelectionManager().getCurrentEvent();
        if (ev == null) {
            return null;
        }
        ArrayList<CmsFormularHistory> formHistories = this.getFormHistories();
        CmsFormularHistory lastFormHistory = null;
        for (CmsFormularHistory fh : formHistories) {
            if (fh.getEventId() == ev.getId()) {
                return fh;
            }
            if (lastFormHistory != null && lastFormHistory.getEventDate() != null && !lastFormHistory.getEventDate().before(fh.getEventDate())) continue;
            lastFormHistory = fh;
        }
        CmsFormularHistory fh = (CmsFormularHistory)this.getProject().createElement("formhistory");
        fh.setParent(this);
        fh.setEvent(ev);
        fh.setFormContent(this.getFormXml());
        if (lastFormHistory != null) {
            fh.updateFormContent(lastFormHistory);
        }
        this.getRelationAttribute("histories").add((CmsElement)fh);
        return fh;
    }

    public ArrayList<CmsFormularHistory> getFormHistories() {
        ArrayList<CmsFormularHistory> result = new ArrayList<CmsFormularHistory>();
        for (CmsElement e : this.getRelationAttribute("histories").getFullElements()) {
            ((CmsFormularHistory)e).setParent(this);
            if (((CmsFormularHistory)e).getEventId() <= 0L) continue;
            result.add((CmsFormularHistory)e);
        }
        Collections.sort(result);
        return result;
    }

    public void removeHistories() {
        this.getRelationAttribute("histories").clear();
    }

    public CmsFormularHistory getFormHistory(CmsEvent event) {
        for (CmsFormularHistory fh : this.getFormHistories()) {
            if (fh.getEventId() != event.getId()) continue;
            return fh;
        }
        return null;
    }

    public CmsFormularHistory getLatestFormHistory() {
        ArrayList<CmsFormularHistory> fhs = this.getFormHistories();
        if (fhs.isEmpty()) {
            return null;
        }
        return fhs.get(fhs.size() - 1);
    }

    public ArrayList<String> getFilterNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (FormItem item : CmsFormular.getItemsFromXml(this.getFormXml(), null)) {
            for (String filtername : item.getRequiredFilternames()) {
                if (result.contains(filtername)) continue;
                result.add(filtername);
            }
        }
        return result;
    }

    public ArrayList<Long> getFilterIds() {
        ArrayList<String> filterNames = this.getFilterNames();
        ArrayList<Long> result = new ArrayList<Long>();
        for (String fn : filterNames) {
            result.add(this.themis.getProject().getFilterByName(fn).getId());
        }
        return result;
    }

    public static ArrayList<FormItem> getItemsFromXml(String xmlString, CmsFormularHistory parent) {
        Element xml;
        ArrayList<FormItem> items = new ArrayList<FormItem>();
        try {
            xml = Util.fromXml((String)xmlString);
        }
        catch (IOException | JDOMException ex) {
            ex.printStackTrace();
            return items;
        }
        List elements = xml.getChildren();
        for (Element element : elements) {
            FormItem item = FormItem.createItem(element);
            if (item == null) continue;
            item.setParent(parent);
            items.add(item);
        }
        return items;
    }

    protected void preSave() {
        super.preSave();
        String alias = this.getFormAlias();
        boolean exists = true;
        String aliasNr = "";
        int nr = 1;
        while (exists) {
            String sql = "SELECT idelement FROM tdtaEleFormular WHERE aliasname=" + Util.toSqlString((String)(alias + aliasNr)) + " AND idelement != " + this.getId();
            DataRecord rec = this.getApplication().getDatastorage().executeQuery(sql, true).firstRow();
            if (rec != null) {
                aliasNr = Integer.toString(nr++);
                continue;
            }
            exists = false;
        }
        this.setFormAlias(alias + aliasNr);
    }
}

