/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.element;

import at.grid.cms.element.CmsElement;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsFormular;
import at.grid.themis.ontology.element.ThemisElement;
import at.grid.themis.ontology.javafx.formeditor.FormItem;
import at.grid.util.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import org.jdom.Element;

public class CmsFormularHistory
extends ThemisElement
implements Comparable<CmsFormularHistory> {
    CmsFormular parent = null;
    ArrayList<FormItem> items = new ArrayList();
    Date eventDate = null;

    public void setParent(CmsFormular f) {
        this.parent = f;
    }

    public CmsFormular getParent() {
        return this.parent;
    }

    public ArrayList<FormItem> getItems() {
        return this.items;
    }

    public FormItem getItemById(String id) {
        if (id == null) {
            return null;
        }
        for (FormItem item : this.items) {
            if (!id.equals(item.getId())) continue;
            return item;
        }
        return null;
    }

    public void setFormContent(String xml) {
        this.setAttributeValue("content", xml);
        this.readItemsFromXml();
    }

    public String getFormContent() {
        return this.getAttributeValue("content");
    }

    public long getEventId() {
        long eventId = this.getRelationAttribute("event").getFirstElementId();
        return eventId;
    }

    public void setEvent(CmsEvent ev) {
        this.getRelationAttribute("event").set((CmsElement)ev);
        this.eventDate = ev == null ? null : ev.getEventDate();
    }

    public Date getEventDate() {
        return this.eventDate;
    }

    public CmsEvent getEvent() {
        long id = this.getEventId();
        return id > 0L ? (CmsEvent)this.app.loadElement(id, this.getCurrentUser()) : null;
    }

    private void readItemsFromXml() {
        this.items.clear();
        String xmlString = this.getFormContent();
        if (xmlString == null) {
            return;
        }
        this.items.addAll(CmsFormular.getItemsFromXml(xmlString, this));
    }

    public void updateFormContent(String formContent) {
        ArrayList<FormItem> newItems = CmsFormular.getItemsFromXml(formContent, null);
        HashMap<String, FormItem> itemMap = new HashMap<String, FormItem>();
        for (FormItem item : newItems) {
            itemMap.put(item.getId(), item);
        }
        for (FormItem item : this.getItems()) {
            String id = item.getId();
            FormItem newItem = (FormItem)itemMap.get(id);
            if (newItem == null || newItem.getType() == null || !newItem.getType().equals(item.getType())) continue;
            item.setValue(newItem.getValue());
        }
    }

    public void updateFormContent(CmsFormularHistory fh) {
        if (fh == null) {
            return;
        }
        for (FormItem item : this.getItems()) {
            String id = item.getId();
            FormItem oldItem = fh.getItemById(id);
            if (oldItem == null || oldItem.getType() == null || !oldItem.getType().equals(item.getType())) continue;
            item.setValue(oldItem.getValue());
        }
    }

    public String getFormContentFromItems() {
        Element root = new Element("formular");
        for (FormItem item : this.items) {
            item.applyValue();
            root.addContent(item.getXml().detach());
        }
        return Util.toXml((Element)root);
    }

    protected void preSave() {
        String result = this.getFormContentFromItems();
        this.setFormContent(result);
    }

    protected void postLoad() {
        this.readItemsFromXml();
        this.eventDate = this.themis.getProject().getEventDate(this.getEventId());
    }

    @Override
    public int compareTo(CmsFormularHistory o) {
        Date dt = this.getEventDate();
        if (dt == null) {
            return o == null || o.getEventDate() == null ? 0 : -1;
        }
        return o == null || o.getEventDate() == null ? 1 : dt.compareTo(o.getEventDate());
    }

    public String toString() {
        return Util.formatDate((Date)this.getEventDate(), (String)Util.DATE_READ, (TimeZone)TimeZone.getDefault());
    }
}

