/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.element;

import at.grid.cms.attribute.DateAttribute;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.ThemisElement;
import at.grid.themis.ontology.settings.ThemisSettings;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CmsHistory
extends ThemisElement {
    public String getSummary() {
        return this.getAttributeValue("description");
    }

    public String getTitle() {
        String t = this.getAttributeValue("title");
        if (!this.getRelationAttribute("event").isEmpty()) {
            return t + " [" + this.getRelationAttribute("event").getFirstElementTitle() + "]";
        }
        return "".equals(t) ? "-" : t;
    }

    public String getKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getEventId()).append(".").append(this.getObservationId());
        return sb.toString();
    }

    public long getEventId() {
        return this.getRelationAttribute("event").getFirstElementId();
    }

    public CmsEvent getEvent() {
        long idEvent = this.getRelationAttribute("event").getFirstElementId();
        if (idEvent > 0L) {
            return (CmsEvent)this.app.loadElement(idEvent, this.getCurrentUser());
        }
        return null;
    }

    public long getObservationId() {
        return this.getRelationAttribute("observation").getFirstElementId();
    }

    public void setEventAndObservation(CmsEvent ev, CmsObservation obs) {
        this.getRelationAttribute("event").clear();
        this.getRelationAttribute("event").add((CmsElement)ev);
        this.getRelationAttribute("observation").clear();
        this.getRelationAttribute("observation").add((CmsElement)obs);
        this.setAttributeValue("description", obs.getAttributeValue("description"));
        this.getRelationAttribute("responsible").clear();
        this.getRelationAttribute("responsible").add(obs.getRelationAttribute("responsible").getFirstElement());
        this.getDateAttribute("duedate").setDate(((DateAttribute)obs.getAttribute("duedate")).getDate());
        this.getBooleanAttribute("done").setValue(obs.getBooleanAttribute("done").isSet());
        this.getDateAttribute("eventdate").setDate(ev.getDateAttribute("date").getDate());
        this.getIntegerAttribute("timehours").setValue(ev.getIntegerAttribute("timehours").getIntValue());
    }

    public ArrayList<UploadItem> getImageUploadItems() {
        ArrayList<UploadItem> items = new ArrayList<UploadItem>();
        for (UploadItem item : this.getUploadAttribute("files").getUploadItems()) {
            if (!item.isImage()) continue;
            items.add(item);
        }
        return items;
    }

    public boolean hasImages() {
        return !this.getImageUploadItems().isEmpty();
    }

    protected void preSave() {
        this.setAttributeValue("responsibletxt", this.getRelationAttribute("responsible").getFirstElementTitle());
        for (UploadItem item : this.getUploadAttribute("files").getAllUploadItems()) {
            item.setFileInfo(this.getTitle());
        }
    }

    protected void postRemove() {
        CmsObservation ele;
        super.postRemove();
        CmsElementSummary obs = this.getRelationAttribute("observation").getFirstElement();
        if (obs != null && (ele = (CmsObservation)obs.getElement()) != null) {
            if (ele.getHistories().size() == 1 && ele.getHistories().get(0).getId() == this.getId()) {
                ele.remove();
            } else if (ele.getHistories().isEmpty()) {
                ele.remove();
            } else {
                ele.save();
            }
        }
    }

    protected void postTrash() {
        CmsObservation obs;
        super.postTrash();
        CmsElementSummary ele = this.getRelationAttribute("observation").getFirstElement();
        if (ele != null && (obs = (CmsObservation)ele.getElement()) != null) {
            List historyIds = obs.getRelationAttribute("histories").getElementIds(false);
            if (historyIds.isEmpty() || historyIds.contains(this.getId()) && historyIds.size() == 1) {
                obs.moveToTrash();
            } else {
                ele.save();
            }
        }
    }

    public boolean isLaterThan(CmsHistory h) {
        int later = this.isLaterThan(h.getDateAttribute("eventdate").getDate(), h.getIntegerAttribute("timehours").getIntValue());
        return later == 0 ? this.getEventId() > h.getEventId() : later > 0;
    }

    public boolean isLaterThan(CmsEvent e) {
        int later = this.isLaterThan(e.getDateAttribute("date").getDate(), e.getIntegerAttribute("timehours").getIntValue());
        return later == 0 ? this.getEventId() > e.getId() : later > 0;
    }

    private int isLaterThan(Date dt, int hour) {
        if (dt == null || !this.hasAttributeValue("eventdate")) {
            return 0;
        }
        Date dtThis = this.getDateAttribute("eventdate").getDate();
        if (dtThis.equals(dt)) {
            if (this.getIntegerAttribute("timehours").getIntValue() == hour) {
                return 0;
            }
            return this.getIntegerAttribute("timehours").getIntValue() > hour ? 1 : -1;
        }
        return dtThis.after(dt) ? 1 : -1;
    }

    public String toString(String lb1, String lb2) {
        return this.toString(lb1, lb2, null);
    }

    public String toString(String lb1, String lb2, CmsHistory compare) {
        ThemisSettings settings = ThemisApplication.getInstance().getSettings();
        ArrayList<ThemisAttribute> atts = new ArrayList<ThemisAttribute>();
        for (ThemisAttribute ta : settings.getObservationAttributes()) {
            if (ta.isUsed() && !"title".equals(ta.getId()) && !"repeat".equals(ta.getId()) && !"repeatunit".equals(ta.getId())) {
                String v0 = this.getAttributeValue(ta.getCmsCode());
                String v1 = null;
                if (compare != null) {
                    v1 = compare.getAttributeValue(ta.getCmsCode());
                }
                if (v0 == null || !v0.equals(v1)) {
                    atts.add(ta);
                }
            }
            if (!"editor".equals(ta.getId()) || compare != null && compare.getAttributeValue(ta.getCmsCode()).equals(this.getAttributeValue(ta.getCmsCode()))) continue;
            atts.add(ta);
        }
        String result = ThemisUtil.toString(this, lb1, lb2, true, atts, true);
        if (settings.getImageForObservation()) {
            String fileinfo = "<b>" + this.app.getResourceText("text.files", this.getCurrentUser().getCurrentLocale()) + ":</b>";
            for (UploadItem item : this.getUploadAttribute("files").getUploadItems()) {
                fileinfo = fileinfo + "  " + item.getName();
            }
            if (compare == null || this.getUploadAttribute("files").hasValue()) {
                result = result + fileinfo;
            }
        }
        return result;
    }
}

