/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.element;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.element.CmsUser;
import at.grid.cms.storage.DataRecord;
import at.grid.gui.BasicGeometry;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsIcon;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.element.ThemisElement;
import at.grid.themis.ontology.report.PlanSnippetGenerator;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class CmsLocation
extends ThemisElement {
    private long previousPlanId = -1L;
    private ArrayList<CmsElement> observations = new ArrayList();
    public static String TEXT1 = "code";
    public static String TEXT2 = "code2";

    public String getSummary() {
        if (this.isBuilding()) {
            int countplans = this.getRelationAttribute("buildingplans").size();
            String res = "text.location.buildingplan" + (countplans == 1 ? "" : "s");
            return this.app.getResourceText(res, this.themis.getLocale());
        }
        return this.hasAttributeValue("plan") ? this.getRelationAttribute("plan").getFirstElementTitle() : this.app.getResourceText("text.location.noplan", this.themis.getLocale());
    }

    public String getTitle() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getAttributeValue("title"));
        return sb.toString();
    }

    public String getFullNumber() {
        boolean usePrefix = this.themis.getSettings().getLocationAttribute("prefixsuffix").isUsed();
        boolean useSuffix = this.themis.getSettings().getLocationAttribute("suffix").isUsed();
        return (usePrefix ? this.getAttributeValue("prenumber") : "") + this.getAttributeValue("number") + (useSuffix ? this.getAttributeValue("postnumber") : "");
    }

    public String getBuildingTitle() {
        long idbuilding;
        long idplan = this.getRelationAttribute("plan").getFirstElementId();
        if (idplan < 0L) {
            return "-";
        }
        ArrayList ids = this.getProject().getDatastorage().getRelationIds(idplan, "planbuilding", true);
        long l = idbuilding = ids.isEmpty() ? -1L : (Long)ids.get(0);
        if (idbuilding < 0L) {
            return "-";
        }
        return this.getProject().loadElement(idbuilding, this.getProject().getAdminUser()).getAttributeValue("title");
    }

    public String getText1() {
        return this.getAttributeValue("code");
    }

    public String getText2() {
        return this.getAttributeValue("code2");
    }

    public SimpleGeometry getGeometry() {
        SimpleGeometry g = SimpleGeometry.fromWKT((String)this.getAttributeValue("position"));
        g.setReference((Object)this);
        g.setId(this.getId());
        return g;
    }

    public String toString() {
        return this.getTitle();
    }

    public void addObservation(CmsObservation o) {
        this.observations.add(o);
    }

    public ArrayList<CmsElement> getObservations() {
        return this.observations;
    }

    public void deleteObservation(long id) {
        this.getRelationAttribute("observations").delete(id);
        int idx = -1;
        for (int ii = 0; ii < this.observations.size(); ++ii) {
            if (this.observations.get(ii).getId() != id) continue;
            idx = ii;
            break;
        }
        if (idx >= 0) {
            this.observations.remove(idx);
        }
    }

    public ArrayList<Long> getFilteredObservationIds() {
        ArrayList<Long> filteredObsIds = ThemisApplication.getInstance().getFilter().getFilteredObservationIds();
        ArrayList<Long> ids = new ArrayList<Long>();
        Iterator iterator = this.getRelationAttribute("observations").getElementIds().iterator();
        while (iterator.hasNext()) {
            long obsid = (Long)iterator.next();
            if (!filteredObsIds.contains(obsid)) continue;
            ids.add(obsid);
        }
        return ids;
    }

    public long getNextObservationNumber() {
        int countObs = this.getRelationAttribute("observations").getElementIds(true).size();
        if (countObs > 0) {
            long lastId = this.getRelationAttribute("observations").getElementByIndex(countObs - 1).getId();
            DataRecord rec = this.app.getDatastorage().executeQuery("SELECT number FROM tdtaEleObservation WHERE idElement=" + lastId, true).firstRow();
            if (rec != null) {
                return rec.getLong("number") + 1L;
            }
            return countObs + 1;
        }
        return 1L;
    }

    public long createNewNumber() {
        int scheme = Integer.parseInt(this.getProject().getProjectProperty("attribute.locnumber.scheme", "0"));
        long number = 0L;
        long idplan = -1L;
        long idbuilding = -1L;
        if (this.getBooleanAttribute("building").isSet()) {
            number = this.getProject().getDatastorage().getNextBuildingNumber(this.getId());
        } else {
            switch (scheme) {
                case 0: {
                    number = this.getProject().getDatastorage().getNextLocationNumber(this.getId());
                    break;
                }
                case 2: {
                    idplan = this.getRelationAttribute("plan").getFirstElementId();
                    number = this.getProject().getDatastorage().getNextLocationNumberForPlan(this.getId(), idplan);
                    break;
                }
                case 1: {
                    idplan = this.getRelationAttribute("plan").getFirstElementId();
                    ArrayList ids = this.getProject().getDatastorage().getRelationIds(idplan, "planbuilding", true);
                    idbuilding = ids.isEmpty() ? -1L : (Long)ids.get(0);
                    number = this.getProject().getDatastorage().getNextLocationNumberForBuilding(this.getId(), idbuilding);
                }
            }
        }
        if (number == 0L) {
            number = 1L;
        }
        this.getLongAttribute("number").setValue(number);
        return number;
    }

    public boolean checkIfNumberExists() {
        int scheme = Integer.parseInt(this.getProject().getProjectProperty("attribute.locnumber.scheme", "0"));
        long number = this.getLongAttribute("number").getLong();
        long idplan = -1L;
        long idbuilding = -1L;
        if (this.getBooleanAttribute("building").isSet()) {
            return this.getProject().getDatastorage().hasBuildingNumber(number);
        }
        switch (scheme) {
            case 0: {
                return this.getProject().getDatastorage().hasLocationNumber(number);
            }
            case 2: {
                idplan = this.getRelationAttribute("plan").getFirstElementId();
                return this.getProject().getDatastorage().hasLocationNumberForPlan(number, idplan);
            }
            case 1: {
                idplan = this.getRelationAttribute("plan").getFirstElementId();
                ArrayList ids = this.getProject().getDatastorage().getRelationIds(idplan, "planbuilding", true);
                idbuilding = ids.isEmpty() ? -1L : (Long)ids.get(0);
                return this.getProject().getDatastorage().hasLocationNumberForBuilding(number, idbuilding);
            }
        }
        return this.getProject().getDatastorage().hasLocationNumber(number);
    }

    public void setAsBuilding() {
        if (!this.getBooleanAttribute("building").isSet()) {
            this.getBooleanAttribute("building").setValue(true);
            this.setAttributeValue("prenumber", "G");
            this.createNewNumber();
        }
    }

    public void applyIdMappingForElementtype(long oldId, long newId) {
        if (this.getLongAttribute("idplan").getLong() == oldId) {
            this.getLongAttribute("idplan").setValue(newId);
        }
        if (this.getLongAttribute("idbuilding").getLong() == oldId) {
            this.getLongAttribute("idbuilding").setValue(newId);
        }
        if (this.getLongAttribute("templateid").getLong() == oldId) {
            this.getLongAttribute("templateid").setValue(newId);
        }
    }

    public ArrayList<CmsAttribute> getElementReferenceAttributes() {
        ArrayList atts = super.getElementReferenceAttributes();
        atts.add(this.getAttribute("idplan"));
        atts.add(this.getAttribute("idbuilding"));
        atts.add(this.getAttribute("templateid"));
        return atts;
    }

    public ArrayList<UploadItem> getUploads() {
        ArrayList<UploadItem> items = new ArrayList<UploadItem>();
        for (UploadItem item : this.getUploadAttribute("files").getUploadItems()) {
            items.add(item);
        }
        return items;
    }

    public ArrayList<UploadItem> getImageUploadItems() {
        ArrayList<UploadItem> items = new ArrayList<UploadItem>();
        for (UploadItem item : this.getUploadAttribute("files").getUploadItems()) {
            if (!item.isImage()) continue;
            items.add(item);
        }
        return items;
    }

    public ArrayList<UploadItem> getAudioUploadItems() {
        ArrayList<UploadItem> items = new ArrayList<UploadItem>();
        for (UploadItem item : this.getUploadAttribute("files").getUploadItems()) {
            if (!item.isAudio()) continue;
            items.add(item);
        }
        return items;
    }

    protected void postCreate() {
        this.createNewNumber();
    }

    protected void preRemove() {
        super.preRemove();
        boolean obsDeleted = false;
        Iterator iterator = this.getRelationAttribute("observations").getElementIds().iterator();
        while (iterator.hasNext()) {
            long obsId = (Long)iterator.next();
            CmsElement.remove((CmsApplication)this.getProject(), (long)obsId, (CmsUser)this.getProject().getUser());
            obsDeleted = true;
        }
        if (obsDeleted) {
            ThemisApplication.getInstance().getActionProvider().invokeAction(ThemisAction.OBSERVATION_DELETED.from((Object)this, "pre remove"));
        }
    }

    protected void preTrash() {
        super.preTrash();
        boolean obsDeleted = false;
        Iterator iterator = this.getRelationAttribute("observations").getElementIds(false).iterator();
        while (iterator.hasNext()) {
            long obsId = (Long)iterator.next();
            CmsElement.moveToTrash((CmsApplication)this.getProject(), (long)obsId, (CmsUser)this.getProject().getUser());
            obsDeleted = true;
        }
        if (obsDeleted) {
            ThemisApplication.getInstance().getActionProvider().invokeAction(ThemisAction.OBSERVATION_DELETED.from((Object)this, "pre remove"));
        }
    }

    protected void postTrash() {
        super.postTrash();
        ThemisApplication.getInstance().getFilter().resetSearchResult();
    }

    protected void postUntrash() {
        super.preTrash();
        boolean obsRestored = false;
        for (CmsElementSummary ele : this.getRelationAttribute("observations").getElements(true)) {
            CmsElement.restoreFromTrash((CmsElementSummary)ele);
            obsRestored = true;
        }
        if (obsRestored) {
            ThemisApplication.getInstance().getActionProvider().invokeAction(ThemisAction.OBSERVATION_DELETED.from((Object)this, "pre remove"));
        }
    }

    protected void postLoad() {
        super.postLoad();
        this.previousPlanId = this.getRelationAttribute("plan").getFirstElementId();
    }

    protected void preSave() {
        CmsElementSummary locgroup;
        CmsEvent currentEvent;
        CmsIcon icon;
        File f;
        super.preSave();
        if (this.isBuilding()) {
            Iterator iterator = this.getRelationAttribute("plan").getElementIds().iterator();
            while (iterator.hasNext()) {
                long planid = (Long)iterator.next();
                this.app.getDatastorage().executeUpdate("UPDATE tdtaElePlan SET buildingtitle = " + Util.toSqlString((String)this.getTitle()) + " WHERE idelement = " + planid, true);
            }
        }
        CmsElementSummary ele = this.getRelationAttribute("icon").getFirstElement();
        this.getAttribute("iconfile").clear();
        if (ele != null && (f = (icon = (CmsIcon)ele.getElement()).getUploadAttribute("file").getFirstUploadItemFile()) != null) {
            this.setAttributeValue("iconfile", f.getName());
        }
        if (!this.hasAttributeValue("number") || this.getLongAttribute("number").getLong() == 0L) {
            this.getLongAttribute("number").setValue(this.getProject().getDatastorage().getNextCounter("tdtaelelocation", "number"));
        }
        for (CmsElement o : this.observations) {
            if (!o.isNew()) continue;
            o.save(true, true);
        }
        if (!this.observations.isEmpty()) {
            for (CmsElementSummary obs : this.getRelationAttribute("observations").getElements()) {
                if (obs.isNew()) continue;
                this.app.getDatastorage().updateElementTitle(obs);
            }
        }
        if ((currentEvent = this.themis.getProject().getCurrentEvent()) != null) {
            this.getRelationAttribute("event").add((CmsElement)currentEvent);
            currentEvent.addModifiedElement(this);
        }
        if ((locgroup = this.getRelationAttribute("locationgroup").getFirstElement()) == null) {
            this.setAttributeValue("groupfullid", null);
        } else {
            CmsElement locgroupele = locgroup.getElement();
            this.setAttributeValue("groupfullid", locgroupele == null ? null : locgroupele.getAttributeValue("groupfullid"));
        }
    }

    protected void preCopy() {
    }

    protected void postCopy() {
        this.createNewNumber();
        this.getAttribute("barcode").clear();
        this.getUploadAttribute("files").clear();
        if (this.themis.getProject().checkForCurrentEvent(false)) {
            List obsIds = this.getRelationAttribute("observations").getElementIds();
            this.getRelationAttribute("observations").clear();
            Iterator iterator = obsIds.iterator();
            while (iterator.hasNext()) {
                long obsId = (Long)iterator.next();
                CmsObservation obsOrig = (CmsObservation)this.app.loadElement(obsId, this.getCurrentUser());
                CmsObservation obs = (CmsObservation)obsOrig.copy("location,files,donedate,histories");
                obs.setLocation(this);
                obs.setNumber(this.getNextObservationNumber());
                this.getRelationAttribute("observations").add((CmsElement)obs);
                this.addObservation(obs);
            }
        } else {
            this.getRelationAttribute("observations").clear();
        }
    }

    protected void postSave() {
        super.postSave();
        if (!this.ignoreRelationsDuringSave && this.getRelationAttribute("plan").getFirstElementId() != this.previousPlanId) {
            for (CmsElementSummary ele : this.getRelationAttribute("observations").getElements()) {
                CmsObservation obs;
                if (!"observation".equals(ele.getElementcode()) || (obs = (CmsObservation)ele.getElement()) == null) continue;
                if (this.getRelationAttribute("plan").isEmpty()) {
                    obs.getRelationAttribute("plan").clear();
                } else {
                    obs.getRelationAttribute("plan").set(this.getRelationAttribute("plan").getFirstElement());
                }
                obs.save();
            }
            this.previousPlanId = this.getRelationAttribute("plan").getFirstElementId();
            this.deletePlanSnippetFiles();
        }
        for (CmsElement obs : this.observations) {
            obs.save();
        }
        ThemisApplication.getInstance().getFilter().resetSearchResult();
    }

    public boolean hasPlan() {
        return !this.getRelationAttribute("plan").isEmpty();
    }

    public long getPlanId() {
        CmsElementSummary planEle = this.getRelationAttribute("plan").getFirstElement();
        return planEle == null ? -1L : planEle.getId();
    }

    public CmsPlan getPlan() {
        CmsElementSummary planEle = this.getRelationAttribute("plan").getFirstElement();
        if (planEle != null) {
            return (CmsPlan)planEle.getElement();
        }
        return null;
    }

    public boolean isBuilding() {
        return this.getBooleanAttribute("building").isSet();
    }

    public void copyLocation(CmsLocation loc) {
        this.setAttributeValue("title", loc.getAttributeValue("title"));
        this.setAttributeValue("description", loc.getAttributeValue("description"));
        this.setAttributeValue("code", loc.getAttributeValue("code"));
        this.setAttributeValue("quantity", loc.getAttributeValue("quantity"));
        this.setAttributeValue("dimwidth", loc.getAttributeValue("dimwidth"));
        this.setAttributeValue("dimheight", loc.getAttributeValue("dimheight"));
        this.setAttributeValue("dimdiameter", loc.getAttributeValue("dimdiameter"));
        this.setAttributeValue("dimarea", loc.getAttributeValue("dimarea"));
        this.getKeyAttribute("list1").setValue(loc.getKeyAttribute("list1").getId());
        this.getKeyAttribute("list2").setValue(loc.getKeyAttribute("list2").getId());
        long groupid = loc.getRelationAttribute("locationgroup").getFirstElementId();
        this.getRelationAttribute("locationgroup").clear();
        if (groupid >= 0L) {
            this.getRelationAttribute("locationgroup").set(groupid);
        }
        for (Long infoId : loc.getRelationAttribute("infos").getElementIds()) {
            this.getRelationAttribute("infos").clear();
            if (infoId < 0L) continue;
            this.getRelationAttribute("infos").add(infoId.longValue());
        }
        long iconid = loc.getRelationAttribute("icon").getFirstElementId();
        this.getRelationAttribute("icon").clear();
        if (iconid >= 0L) {
            this.getRelationAttribute("icon").set(iconid);
        }
    }

    public void updateObservationNumbers() {
        List elements = this.getRelationAttribute("observations").getElements();
        int obsnumber = 1;
        for (CmsElementSummary oo : elements) {
            CmsObservation obs = (CmsObservation)oo.getElement();
            obs.setCurrentHistoryToBeIgnored();
            if (!oo.isTrash()) {
                obs.setNumber(obsnumber);
                ++obsnumber;
            } else {
                obs.setNumber(-1L);
            }
            obs.save();
            oo.update((CmsElement)obs);
        }
    }

    public static CmsLocation duplicate(long locationId, CmsPlan plan, BasicGeometry geo) {
        return CmsLocation.duplicate(locationId, plan, geo, false);
    }

    public static CmsLocation duplicate(long locationId, CmsPlan plan, BasicGeometry geo, boolean save) {
        ThemisProject project = ThemisApplication.getInstance().getProject();
        if (project != null && project.isOpen()) {
            CmsLocation locationOrig = (CmsLocation)project.loadElement(locationId, project.getUser());
            CmsLocation location = (CmsLocation)locationOrig.copy("files,observations");
            if (project.checkForCurrentEvent(false)) {
                List obsIds = locationOrig.getRelationAttribute("observations").getElementIds();
                Iterator iterator = obsIds.iterator();
                while (iterator.hasNext()) {
                    long obsId = (Long)iterator.next();
                    CmsObservation obsOrig = (CmsObservation)project.loadElement(obsId, project.getUser());
                    if (obsOrig.isTrash()) continue;
                    CmsObservation obs = (CmsObservation)obsOrig.copy("location,files,donedate,histories");
                    obs.setLocation(location);
                    obs.setNumber(location.getNextObservationNumber());
                    location.getRelationAttribute("observations").add((CmsElement)obs);
                    location.addObservation(obs);
                }
            }
            if (geo != null) {
                location.setAttributeValue("position", geo.toWKT());
            } else {
                location.setAttributeValue("position", "");
            }
            location.getAttribute("labelposition").clear();
            if (plan != null) {
                location.getRelationAttribute("plan").set((CmsElement)plan);
            } else {
                location.getRelationAttribute("plan").clear();
            }
            location.getAttribute("barcode").clear();
            if (save) {
                location.save();
            }
            return location;
        }
        return null;
    }

    public SimpleGeometry getPosition() {
        return SimpleGeometry.fromWKT((String)this.getAttributeValue("position"));
    }

    public void deletePlanSnippetFiles() {
        File[] fs;
        File fld = this.themis.getProject().getPlansnippetLocation();
        if (fld != null && fld.isDirectory() && (fs = fld.listFiles()) != null) {
            for (File f : fs) {
                if (!f.getName().startsWith(this.getId() + "_")) continue;
                f.delete();
            }
        }
    }

    public File createPlanSnippetFile() {
        CmsReport rep = new CmsReport();
        return PlanSnippetGenerator.generate(rep, this.getId());
    }

    public File getPlanSnippetFile(int size) {
        if (!this.hasPlan()) {
            return null;
        }
        File snippetfile = new File(this.themis.getProject().getPlansnippetLocation(), this.getId() + "_" + size + ".jpg");
        if (snippetfile.isFile()) {
            return snippetfile;
        }
        return null;
    }

    public String toStringWithIgnoreString(String lb1, String lb2, boolean showStatus, List<String> ignoreAttCodes) {
        ArrayList<ThemisAttribute> ignoreAtts = new ArrayList<ThemisAttribute>();
        for (String att : ignoreAttCodes) {
            ignoreAtts.add(this.themis.getSettings().getLocationAttribute(att));
        }
        return this.toStringWithIgnore(lb1, lb2, showStatus, ignoreAtts);
    }

    public String toStringWithIgnore(String lb1, String lb2, boolean showStatus, ArrayList<ThemisAttribute> ignoreAtts) {
        ThemisSettings settings = ThemisApplication.getInstance().getSettings();
        ArrayList<ThemisAttribute> atts = new ArrayList<ThemisAttribute>();
        ArrayList<ThemisAttribute> allatts = settings.getLocationAttributes();
        for (ThemisAttribute ta : allatts) {
            if (!ta.isUsed() || ignoreAtts != null && ignoreAtts.contains(ta) || "icon".equals(ta.getId())) continue;
            atts.add(ta);
        }
        return ThemisUtil.toString(this, lb1, lb2, showStatus, atts, false);
    }

    public String toHtml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<h1>").append(this.getFullNumber()).append(" ").append(this.getTitle()).append("</h1>");
        List<String> ignoreAtts = Arrays.asList("title", "number", "group", "icon");
        for (ThemisAttribute ta : this.themis.getSettings().getLocationAttributes()) {
            String val;
            if (!ta.isUsed() || ignoreAtts.contains(ta.getId()) || (val = this.getAttributeValue(ta.getCmsCode())) == null || val.isEmpty()) continue;
            sb.append("<p><b>").append(ta.getLabel()).append(": </b>").append(val).append("</p>");
        }
        return sb.toString();
    }
}

