/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.element;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.element.CmsUser;
import at.grid.cms.storage.DataRecord;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsIcon;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservationTemplate;
import at.grid.themis.ontology.element.ThemisElement;
import at.grid.util.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class CmsLocationTemplate
extends ThemisElement {
    ArrayList<CmsObservationTemplate> observationtemplates = new ArrayList();

    public String getSummary() {
        return "";
    }

    public String getTitle() {
        return this.getAttributeValue("title");
    }

    public void addObservationTemplate(CmsObservationTemplate o) {
        this.observationtemplates.add(o);
    }

    @Override
    public void setAttributes(Properties props) {
        for (String string : props.keySet()) {
            String val = props.getProperty(string);
            CmsAttribute att = this.getAttribute(string);
            if (att == null || att.getCode().startsWith("meta_")) continue;
            if (att.isOfType(14)) {
                switch (att.getCode()) {
                    case "infos": {
                        DataRecord rec = this.app.getDatastorage().executeQuery("SELECT idelement FROM tdtaEleInfo WHERE title=" + Util.toSqlString((String)val), true).firstRow();
                        if (rec == null) break;
                        ((RelationAttribute)att).set(rec.getLong("idelement").longValue());
                        break;
                    }
                }
                continue;
            }
            att.setValue(val);
        }
    }

    public void setAttributes(CmsLocation loc) {
        for (String code : new String[]{"title", "description", "prenumber", "postnumber", "quantity", "code", "code2", "text3", "text4", "longtext1", "longtext2", "longtext3", "longtext4", "dimwidth", "dimheight", "dimdiameter", "dimarea"}) {
            this.setAttributeValue(code, loc.getAttributeValue(code));
        }
        for (String code : new String[]{"list1", "list2", "list3", "list4"}) {
            this.getKeyAttribute(code).setValue(loc.getKeyAttribute(code).getId());
        }
        for (String code : new String[]{"date1", "date2", "date3", "date4"}) {
            this.getDateAttribute(code).setDate(loc.getDateAttribute(code).getDate());
        }
        for (String code : new String[]{"boolean1", "boolean2", "boolean3", "boolean4"}) {
            this.getBooleanAttribute(code).setValue(loc.getBooleanAttribute(code).isSet());
        }
        long groupid = loc.getRelationAttribute("locationgroup").getFirstElementId();
        this.getRelationAttribute("locationgroup").clear();
        if (groupid >= 0L) {
            this.getRelationAttribute("locationgroup").set(groupid);
        }
        long iconid = loc.getRelationAttribute("icon").getFirstElementId();
        this.getRelationAttribute("icon").clear();
        if (iconid >= 0L) {
            this.getRelationAttribute("icon").set(iconid);
        }
        List infoids = loc.getRelationAttribute("infos").getElementIds();
        this.getRelationAttribute("infos").clear();
        Iterator iterator = infoids.iterator();
        while (iterator.hasNext()) {
            long infoid = (Long)iterator.next();
            this.getRelationAttribute("infos").add(infoid);
        }
        this.getBooleanAttribute("showalways").setValue(loc.getBooleanAttribute("showalways").isSet());
    }

    public void applyTo(CmsLocation loc) {
        for (String code : new String[]{"title", "description", "prenumber", "postnumber", "quantity", "code", "code2", "text3", "text4", "longtext1", "longtext2", "longtext3", "longtext4", "dimwidth", "dimheight", "dimdiameter", "dimarea"}) {
            loc.setAttributeValue(code, this.getAttributeValue(code));
        }
        for (String code : new String[]{"list1", "list2", "list3", "list4"}) {
            loc.getKeyAttribute(code).setValue(this.getKeyAttribute(code).getId());
        }
        for (String code : new String[]{"date1", "date2", "date3", "date4"}) {
            loc.getDateAttribute(code).setDate(this.getDateAttribute(code).getDate());
        }
        for (String code : new String[]{"boolean1", "boolean2", "boolean3", "boolean4"}) {
            loc.getBooleanAttribute(code).setValue(this.getBooleanAttribute(code).isSet());
        }
        long groupid = this.getRelationAttribute("locationgroup").getFirstElementId();
        loc.getRelationAttribute("locationgroup").clear();
        if (groupid >= 0L) {
            loc.getRelationAttribute("locationgroup").set(groupid);
        }
        long iconid = this.getRelationAttribute("icon").getFirstElementId();
        loc.getRelationAttribute("icon").clear();
        if (iconid >= 0L) {
            loc.getRelationAttribute("icon").set(iconid);
        }
        List infoids = this.getRelationAttribute("infos").getElementIds();
        loc.getRelationAttribute("infos").clear();
        Iterator iterator = infoids.iterator();
        while (iterator.hasNext()) {
            long infoid = (Long)iterator.next();
            loc.getRelationAttribute("infos").add(infoid);
        }
        loc.getLongAttribute("templateid").setValue(this.getId());
        loc.getBooleanAttribute("showalways").setValue(this.getBooleanAttribute("showalways").isSet());
    }

    public void applyLinkTo(CmsLocation loc) {
        long groupid = this.getRelationAttribute("locationgroup").getFirstElementId();
        loc.getRelationAttribute("locationgroup").clear();
        if (groupid >= 0L) {
            loc.getRelationAttribute("locationgroup").set(groupid);
        }
        long iconid = this.getRelationAttribute("icon").getFirstElementId();
        loc.getRelationAttribute("icon").clear();
        if (iconid >= 0L) {
            loc.getRelationAttribute("icon").set(iconid);
        }
        loc.getLongAttribute("templateid").setValue(this.getId());
    }

    protected void preSave() {
        CmsIcon icon;
        File f;
        CmsElementSummary ele = this.getRelationAttribute("icon").getFirstElement();
        this.getAttribute("iconfile").clear();
        if (ele != null && (f = (icon = (CmsIcon)ele.getElement()).getUploadAttribute("file").getFirstUploadItemFile()) != null) {
            this.setAttributeValue("iconfile", f.getName());
        }
    }

    protected void postLoad() {
        this.setAttributeVisibility();
    }

    protected void postCreate() {
        this.setAttributeVisibility();
    }

    protected void postTrash() {
        super.postTrash();
        ArrayList ids = this.app.getDatastorage().executeQuery("select idelement as meta_id from tdtaeleobservationtemplate where idlocation=" + this.getId(), true).getResultIds();
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            CmsElement.moveToTrash((CmsApplication)this.app, (long)id, (CmsUser)this.getCurrentUser());
        }
    }

    protected void postRemove() {
        super.postRemove();
        ArrayList ids = this.app.getDatastorage().executeQuery("select idelement as meta_id from tdtaeleobservationtemplate where idlocation=" + this.getId(), true).getResultIds();
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            CmsElement.remove((CmsApplication)this.app, (long)id, (CmsUser)this.getCurrentUser());
        }
    }

    private void setAttributeVisibility() {
        ThemisApplication app = ThemisApplication.getInstance();
        for (ThemisAttribute ta : app.getSettings().getLocationAttributes()) {
            if (ta.getCmsCode() == null || "".equals(ta.getCmsCode()) || !this.hasAttribute(ta.getCmsCode())) continue;
            this.getAttribute(ta.getCmsCode()).setHidden(!ta.isUsed());
            this.getAttribute(ta.getCmsCode()).setLabel(ta.getLabel());
        }
        boolean useSize = app.getSettings().getLocationAttribute("size").isUsed();
        this.getAttribute("dimwidth").setHidden(!useSize);
        this.getAttribute("dimheight").setHidden(!useSize);
        this.getAttribute("dimdiameter").setHidden(!useSize);
        this.getAttribute("dimarea").setHidden(!useSize);
        boolean usePrefix = app.getSettings().getLocationAttribute("prefixsuffix").isUsed();
        boolean useSuffix = app.getSettings().getLocationAttribute("suffix").isUsed();
        this.getAttribute("prenumber").setHidden(!usePrefix);
        this.getAttribute("postnumber").setHidden(!useSuffix);
    }
}

