/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.element;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsUser;
import at.grid.themis.ontology.element.CmsLocationTemplate;
import at.grid.themis.ontology.element.CmsObservationTemplate;
import at.grid.themis.ontology.element.ThemisElement;
import at.grid.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CmsLocationgroup
extends ThemisElement {
    ArrayList<CmsLocationTemplate> locationtemplates = new ArrayList();
    ArrayList<CmsObservationTemplate> observationtemplates = new ArrayList();
    long origParent;

    public String getSummary() {
        return "";
    }

    public String getTitle() {
        return this.getAttributeValue("title");
    }

    public String toString() {
        return this.getTitle();
    }

    public boolean hasParentGroupChanged() {
        return this.origParent != this.getLongAttribute("parentgroup").getLong();
    }

    public long getParentGroupId() {
        return this.getLongAttribute("parentgroup").getLong();
    }

    public void addLocationTemplate(CmsLocationTemplate t) {
        this.locationtemplates.add(t);
    }

    public void addObservationTemplate(CmsObservationTemplate o) {
        this.observationtemplates.add(o);
    }

    public void applyIdMappingForElementtype(long oldId, long newId) {
        if (this.getLongAttribute("parentgroup").getLong() == oldId) {
            this.getLongAttribute("parentgroup").setValue(newId);
            this.origParent = -2L;
        }
    }

    public ArrayList<CmsAttribute> getElementReferenceAttributes() {
        ArrayList atts = super.getElementReferenceAttributes();
        atts.add(this.getAttribute("parentgroup"));
        return atts;
    }

    public void postLoad() {
        this.origParent = this.getLongAttribute("parentgroup").getLong();
    }

    public void preSave() {
        if (!this.ignoreRelationsDuringSave && (this.hasParentGroupChanged() || this.isNew())) {
            String fullid = this.getAttributeValue("groupfullid");
            int parentSort = -1;
            if (this.getLongAttribute("parentgroup").getLong() > 0L) {
                CmsElement g = this.app.loadElement(this.getLongAttribute("parentgroup").getLong(), this.getCurrentUser());
                if (g != null) {
                    parentSort = g.getIntegerAttribute("itemsort").getIntValue();
                    this.setAttributeValue("groupfullid", g.getAttributeValue("groupfullid") + this.getId() + ".");
                    this.setAttributeValue("groupfullname", g.getAttributeValue("groupfullname") + " / " + this.getTitle());
                }
            } else {
                this.setAttributeValue("groupfullid", this.getId() + ".");
                this.setAttributeValue("groupfullname", this.getTitle());
            }
            int n = this.app.getDatastorage().executeUpdate("UPDATE tdtaEleLocationgroup SET groupfullid = REPLACE(groupfullid," + Util.toSqlString((String)fullid) + "," + Util.toSqlString((String)this.getAttributeValue("groupfullid")) + ")", true);
        }
    }

    protected void postTrash() {
        super.postTrash();
        List ids = this.getRelationAttribute("locationtemplate").getElementIds(true);
        ids.addAll(this.getRelationAttribute("observationtemplate").getElementIds(true));
        ids.addAll(this.app.getDatastorage().executeQuery("select idelement as meta_id from tdtaelelocationgroup where parentgroup=" + this.getId(), true).getResultIds());
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            CmsElement.moveToTrash((CmsApplication)this.app, (long)id, (CmsUser)this.getCurrentUser());
        }
    }

    protected void postRemove() {
        super.postRemove();
        List ids = this.getRelationAttribute("locationtemplate").getElementIds(true);
        ids.addAll(this.getRelationAttribute("observationtemplate").getElementIds(true));
        ids.addAll(this.app.getDatastorage().executeQuery("select idelement as meta_id from tdtaelelocationgroup where parentgroup=" + this.getId(), true).getResultIds());
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            CmsElement.remove((CmsApplication)this.app, (long)id, (CmsUser)this.getCurrentUser());
        }
    }

    public int getGroupLevel() {
        String fullid = this.getAttributeValue("groupfullid");
        long level = fullid.codePoints().filter(ch -> ch == 46).count();
        return (int)level;
    }
}

