/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.element;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.ButtonAttribute;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.attribute.DateAttribute;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.storage.DataRecord;
import at.grid.gui.ImagePanel;
import at.grid.gui.Point;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.ThemisElement;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.Util;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.zip.ZipFile;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.imageio.ImageIO;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.jdom.Document;
import org.jdom.Element;

public class CmsObservation
extends ThemisElement {
    public static final int NOT_DONE = 1;
    public static final int DONE = 2;
    public static final int NOT_CHECKED = 3;
    public static final int CHECKED = 4;
    public static final int TYPE_DEFECT = 1;
    public static final int TYPE_CHECK = 2;
    public static final int TYPE_INFO = 3;
    public static final int TYPE_TASK = 4;
    List<CmsElement> histories = null;
    private CmsHistory currentHistory;
    private boolean ignoreCurrentHistory = false;
    boolean showextended = false;
    CmsLocation location = null;
    Date lastSavedDueDate = null;
    private HashMap<UploadItem, CmsElement> uploadHistoryMap = new HashMap();
    private boolean keepEditor = false;

    public String getSummary() {
        return this.getAttributeValue("description");
    }

    public String getTitle() {
        String s = this.getAttributeValue("title");
        if (s == null || s.equals("")) {
            s = this.getAttributeValue("description");
        }
        if (s == null || "".equals(s)) {
            s = this.app.getResourceText("text.observationWithoutTitle", this.themis.getLocale());
        }
        if (s.length() > 80) {
            s = s.substring(0, 80);
            int idx = s.lastIndexOf(" ");
            s = s.substring(0, idx) + "...";
        }
        return s;
    }

    public String getFullNumber() {
        boolean usePrefix = this.themis.getSettings().getLocationAttribute("prefixsuffix").isUsed();
        boolean useSuffix = this.themis.getSettings().getLocationAttribute("suffix").isUsed();
        return this.app.getDatastorage().getObservationFullNumber(this.getId(), usePrefix, useSuffix);
    }

    public void setLocation(CmsLocation loc) {
        this.location = loc;
        this.getRelationAttribute("location").set((CmsElement)loc);
        this.getRelationAttribute("plan").add(loc.getRelationAttribute("plan").getFirstElement());
    }

    public CmsLocation getLocation() {
        if (this.location != null) {
            return this.location;
        }
        return (CmsLocation)this.getRelationAttribute("location").getFirstElement().getElement();
    }

    public long getLocationId() {
        return this.getRelationAttribute("location").getFirstElementId();
    }

    public void setDuedateFromRepeat(long idUnit, int count) {
        Date dt = this.getDuedateFromRepeat(idUnit, count, false);
        if (dt != null) {
            this.getDateAttribute("duedate").setDate(dt);
        }
    }

    public static Date getNextDuedate(Date eventDate, Date currentDueDate, int idUnit, int count) {
        if (eventDate == null || idUnit <= 0 || count <= 0) {
            return null;
        }
        if (currentDueDate == null) {
            currentDueDate = eventDate;
        }
        Date newDate = ThemisApplication.applyPeriodToDate(eventDate, idUnit, count);
        boolean searchDate = true;
        while (searchDate) {
            Date nextDueDate = ThemisApplication.applyPeriodToDate(currentDueDate, idUnit, count);
            Date dateInBetween = new Date((currentDueDate.getTime() + nextDueDate.getTime()) / 2L);
            if (dateInBetween.after(newDate)) {
                searchDate = false;
                continue;
            }
            currentDueDate.setTime(nextDueDate.getTime());
        }
        return currentDueDate;
    }

    public int applyRepeatPeriod() {
        int idUnit = (int)this.getKeyAttribute("repeat").getId();
        int count = this.getIntegerAttribute("repeatcount").getIntValue();
        if (idUnit <= 0 || count <= 0) {
            return 0;
        }
        Date newDate = this.getDuedateFromRepeat(idUnit, count, false);
        if (newDate != null) {
            this.getDateAttribute("duedate").setDate(newDate);
        }
        return 0;
    }

    public Date getDuedateFromRepeat(long idUnit, int count, boolean dowarn) {
        CmsEvent event = this.getProject().getCurrentEvent();
        if (event == null || event.getDateAttribute("date").getDate() == null) {
            return null;
        }
        if (this.isOfType(1) || this.isOfType(4)) {
            return ThemisApplication.applyPeriodToDate(event.getDateAttribute("date").getDate(), (int)idUnit, count);
        }
        return CmsObservation.getNextDuedate(event.getDateAttribute("date").getDate(), this.getDateAttribute("duedate").getDate(), (int)idUnit, count);
    }

    public void loadHistories() {
        if (this.histories == null) {
            this.histories = new ArrayList<CmsElement>();
        } else {
            this.histories.clear();
        }
        Iterator iterator = this.getRelationAttribute("histories").getElementIds(false).iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            CmsElement h = this.getProject().loadElement(id, this.getProject().getUser());
            if (!h.hasAttributeValue("title") && this.hasAttribute("title")) {
                h.getKeyAttribute("type").setValue(this.getKeyAttribute("type").getId());
                h.setAttributeValue("title", this.getAttributeValue("title"));
                h.save();
            }
            this.histories.add(h);
        }
        this.sortHistories();
    }

    protected CmsEvent getCurrentEvent() {
        return this.getProject().getCurrentEvent();
    }

    private Date getReferenceDate() {
        if (this.histories == null || this.histories.isEmpty()) {
            return null;
        }
        return this.getLatestHistory().getDateAttribute("eventdate").getDate();
    }

    public void updateLastReferenceDate() {
        this.app.getDatastorage().executeUpdate("UPDATE " + this.getTablename() + " SET " + this.getAttribute("referencedate").getField() + " = " + Util.toSqlString((Date)this.getReferenceDate(), (TimeZone)this.app.getTimeZone()) + " WHERE idelement = " + this.getId(), true);
    }

    public void sortHistories() {
        Collections.sort(this.histories, (o1, o2) -> {
            Date dt2;
            if (!o1.hasAttributeValue("eventdate") || !o2.hasAttributeValue("eventdate")) {
                return 0;
            }
            Date dt1 = o1.getDateAttribute("eventdate").getDate();
            if (dt1.equals(dt2 = o2.getDateAttribute("eventdate").getDate())) {
                int deltaTime = o1.getIntegerAttribute("timehours").getIntValue() - o2.getIntegerAttribute("timehours").getIntValue();
                if (deltaTime == 0) {
                    return ((CmsHistory)((Object)o1)).getEventId() < ((CmsHistory)((Object)o2)).getEventId() ? -1 : 1;
                }
                return deltaTime < 0 ? -1 : 1;
            }
            return dt1.before(dt2) ? -1 : 1;
        });
    }

    public void applyHistories() {
        if (this.currentHistory == null) {
            CmsEvent ev = this.getCurrentEvent();
            if (this.getCurrentEvent() != null) {
                CmsHistory lastHistory = null;
                for (CmsElement e : this.histories) {
                    if (this.compare(ev, (CmsHistory)e) < 0) break;
                    lastHistory = (CmsHistory)e;
                }
                if (lastHistory != null) {
                    this.applyHistory(lastHistory);
                } else {
                    this.applyHistory(this.getLatestHistory());
                }
            }
        } else {
            this.applyHistory(this.currentHistory);
        }
    }

    public void applyHistory(CmsHistory hist) {
        if (hist != null) {
            this.setAttributeValue("editor", hist.getAttributeValue("editor"));
            if (hist.hasAttributeValue("title")) {
                this.setAttributeValue("title", hist.getAttributeValue("title"));
            }
            this.setAttributeValue("description", hist.getAttributeValue("description"));
            this.setAttributeValue("measure", hist.getAttributeValue("measure"));
            this.setAttributeValue("code", hist.getAttributeValue("code"));
            this.setAttributeValue("freetext1", hist.getAttributeValue("freetext1"));
            this.setAttributeValue("freetext2", hist.getAttributeValue("freetext2"));
            this.setAttributeValue("freetext3", hist.getAttributeValue("freetext3"));
            this.setAttributeValue("langtext1", hist.getAttributeValue("langtext1"));
            this.setAttributeValue("langtext2", hist.getAttributeValue("langtext2"));
            this.setAttributeValue("float1", hist.getAttributeValue("float1"));
            this.setAttributeValue("float2", hist.getAttributeValue("float2"));
            this.setAttributeValue("float3", hist.getAttributeValue("float3"));
            this.setAttributeValue("float4", hist.getAttributeValue("float4"));
            this.setAttributeValue("quantity", hist.getAttributeValue("quantity"));
            this.getRelationAttribute("responsible").clear();
            this.getRelationAttribute("responsible").add(hist.getRelationAttribute("responsible").getFirstElement());
            this.getDateAttribute("duedate").setDate(((DateAttribute)hist.getAttribute("duedate")).getDate());
            this.getBooleanAttribute("done").setValue(hist.getBooleanAttribute("done").isSet());
            this.getIntegerAttribute("risk").setValue(hist.getIntegerAttribute("risk").getValue());
            if (hist.getKeyAttribute("type").getId() >= 0L) {
                this.getKeyAttribute("type").setValue(hist.getKeyAttribute("type").getId());
            }
            this.getKeyAttribute("observationtype").setValue(hist.getKeyAttribute("observationtype").getId());
            this.getKeyAttribute("priority").setValue(hist.getKeyAttribute("priority").getId());
            this.getKeyAttribute("topic").setValue(hist.getKeyAttribute("topic").getId());
            this.getKeyAttribute("repeat").setValue(hist.getKeyAttribute("repeat").getId());
            this.setAttributeValue("repeatcount", hist.getAttributeValue("repeatcount"));
            this.getUploadAttribute("files").clearWithoutDelete();
            for (UploadItem item : this.getUploads(false)) {
                this.getUploadAttribute("files").addUpload(item);
            }
            if (this.currentHistory == null) {
                for (UploadItem upload : hist.getUploadAttribute("files").getAllUploadItems()) {
                    this.getUploadAttribute("files").addUpload(upload);
                }
            }
        }
    }

    protected void copyToHistory() {
        this.copyToHistory(this.currentHistory);
    }

    protected void copyToHistory(CmsHistory h) {
        if (h == null) {
            return;
        }
        h.setAttributeValue("editor", this.getAttributeValue("editor"));
        h.setAttributeValue("title", this.getAttributeValue("title"));
        h.setAttributeValue("description", this.getAttributeValue("description"));
        h.setAttributeValue("measure", this.getAttributeValue("measure"));
        h.setAttributeValue("code", this.getAttributeValue("code"));
        h.setAttributeValue("freetext1", this.getAttributeValue("freetext1"));
        h.setAttributeValue("freetext2", this.getAttributeValue("freetext2"));
        h.setAttributeValue("freetext3", this.getAttributeValue("freetext3"));
        h.setAttributeValue("langtext1", this.getAttributeValue("langtext1"));
        h.setAttributeValue("langtext2", this.getAttributeValue("langtext2"));
        h.setAttributeValue("float1", this.getAttributeValue("float1"));
        h.setAttributeValue("float2", this.getAttributeValue("float2"));
        h.setAttributeValue("float3", this.getAttributeValue("float3"));
        h.setAttributeValue("float4", this.getAttributeValue("float4"));
        h.setAttributeValue("quantity", this.getAttributeValue("quantity"));
        h.getRelationAttribute("responsible").clear();
        h.getRelationAttribute("responsible").add(this.getRelationAttribute("responsible").getFirstElement());
        h.getDateAttribute("duedate").setDate(((DateAttribute)this.getAttribute("duedate")).getDate());
        h.getBooleanAttribute("done").setValue(this.getBooleanAttribute("done").isSet());
        h.getUploadAttribute("files").clearWithoutDelete();
        for (UploadItem upload : this.getUploadAttribute("files").getAllUploadItems()) {
            if (!this.isCurrentHistoryUpload(upload)) continue;
            h.getUploadAttribute("files").addUpload(upload);
        }
        h.getIntegerAttribute("risk").setValue(this.getIntegerAttribute("risk").getValue());
        h.getKeyAttribute("type").setValue(this.getKeyAttribute("type").getId());
        h.getKeyAttribute("observationtype").setValue(this.getKeyAttribute("observationtype").getId());
        h.getKeyAttribute("priority").setValue(this.getKeyAttribute("priority").getId());
        h.getKeyAttribute("topic").setValue(this.getKeyAttribute("topic").getId());
        h.getKeyAttribute("repeat").setValue(this.getKeyAttribute("repeat").getId());
        h.setAttributeValue("repeatcount", this.getAttributeValue("repeatcount"));
    }

    protected boolean isLastHistory(CmsHistory hist) {
        if (this.histories == null || this.histories.isEmpty()) {
            return true;
        }
        if (hist == null) {
            return false;
        }
        return this.histories.indexOf((Object)hist) == this.histories.size() - 1;
    }

    public void restrictToHistoryUploads(CmsHistory hist) {
        if (hist == null) {
            return;
        }
        ArrayList<UploadItem> toBeKept = new ArrayList<UploadItem>();
        for (UploadItem item : this.getUploads(false)) {
            CmsElement histUpload = this.getHistoryForUpload(item);
            if (histUpload == null || hist.getId() != histUpload.getId()) continue;
            toBeKept.add(item);
        }
        this.getUploadAttribute("files").clearWithoutDelete();
        for (UploadItem item : toBeKept) {
            this.getUploadAttribute("files").addUpload(item);
        }
    }

    protected boolean isCurrentHistoryUpload(UploadItem item) {
        if (this.histories == null) {
            this.loadHistories();
        }
        for (CmsElement hist : this.histories) {
            if (hist == this.currentHistory || hist.getUploadAttribute("files").getUploadItemById(item.getId()) == null) continue;
            return false;
        }
        return true;
    }

    public ArrayList<UploadItem> getLatestUploads(boolean onlyImages) {
        ArrayList<UploadItem> items = new ArrayList<UploadItem>();
        if (this.histories == null) {
            this.loadHistories();
        }
        boolean foundUploads = false;
        for (int ii = this.histories.size() - 1; ii >= 0 && !foundUploads; --ii) {
            for (UploadItem it : this.histories.get(ii).getUploadAttribute("files").getUploadItems()) {
                if (onlyImages && !it.isImage()) continue;
                it.setProperty("date", Util.formatDate((Date)this.histories.get(ii).getDateAttribute("eventdate").getDate(), (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone()));
                items.add(it);
                foundUploads = true;
            }
        }
        return items;
    }

    public ArrayList<UploadItem> getUploads(boolean onlyImages) {
        ArrayList<UploadItem> items = new ArrayList<UploadItem>();
        if (this.histories == null) {
            this.loadHistories();
        }
        this.uploadHistoryMap.clear();
        for (CmsElement hist : this.histories) {
            for (UploadItem it : hist.getUploadAttribute("files").getUploadItems()) {
                if (onlyImages && !it.isImage()) continue;
                it.setFileInfo(hist.getTitle());
                it.setProperty("date", Util.formatDate((Date)hist.getDateAttribute("eventdate").getDate(), (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone()));
                items.add(it);
                this.uploadHistoryMap.put(it, hist);
            }
        }
        for (UploadItem it : this.getUploadAttribute("files").getUploadItems()) {
            if (onlyImages && !it.isImage() || items.contains(it)) continue;
            it.setFileInfo(this.getTitle());
            it.setProperty("date", Util.formatDate((Date)this.currentHistory.getDateAttribute("eventdate").getDate(), (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone()));
            items.add(it);
            this.uploadHistoryMap.put(it, this.getCurrentHistory());
        }
        return items;
    }

    public CmsElement getHistoryForUpload(UploadItem it) {
        return this.uploadHistoryMap.get(it);
    }

    public void removeUpload(long uploadId) {
        if (this.histories == null) {
            this.loadHistories();
        }
        if (this.currentHistory == null) {
            return;
        }
        this.currentHistory.getUploadAttribute("files").deleteUpload(uploadId);
        this.getUploadAttribute("files").deleteUpload(uploadId);
    }

    public void setKeepEditor(boolean f) {
        this.keepEditor = f;
    }

    public void actionButtonLocal(String buttoncode) {
        if ("showextended".equals(buttoncode)) {
            if (this.showextended) {
                this.getAttribute("s1").setHidden(true);
                this.getAttribute("s2").setHidden(true);
                this.getAttribute("number").setHidden(true);
                this.getAttribute("location").setHidden(true);
                this.getAttribute("plan").setHidden(true);
                this.getAttribute("s3").setHidden(true);
                this.getAttribute("referencedate").setHidden(true);
                this.getAttribute("histories").setHidden(true);
                this.showextended = false;
                ((ButtonAttribute)this.getAttribute("showextended")).setButtonText("Darstellung erweitern");
            } else {
                this.getAttribute("s1").setHidden(false);
                this.getAttribute("s2").setHidden(false);
                this.getAttribute("number").setHidden(false);
                this.getAttribute("location").setHidden(false);
                this.getAttribute("plan").setHidden(false);
                this.getAttribute("s3").setHidden(false);
                this.getAttribute("referencedate").setHidden(false);
                this.getAttribute("histories").setHidden(false);
                this.showextended = true;
                ((ButtonAttribute)this.getAttribute("showextended")).setButtonText("Darstellung reduzieren");
            }
        }
    }

    protected void postCreate() {
        super.postCreate();
        this.setAttributeValue("editor", this.getCurrentUser().getUsername());
        this.getKeyAttribute("type").setValue(1L);
        CmsEvent currentEvent = this.getCurrentEvent();
        if (currentEvent == null) {
            return;
        }
        if (this.getId() >= 0L) {
            this.currentHistory = this.getProject().createHistoryElement(currentEvent, this);
        }
        this.histories = new ArrayList<CmsElement>();
        this.histories.add(this.currentHistory);
        this.ignoreCurrentHistory = false;
        this.showextended = false;
        this.getAttribute("number").setHidden(true);
        this.getAttribute("location").setHidden(true);
        this.getAttribute("plan").setHidden(true);
        this.getAttribute("s3").setHidden(true);
        this.getAttribute("referencedate").setHidden(true);
        this.getAttribute("histories").setHidden(true);
        ((ButtonAttribute)this.getAttribute("showextended")).setButtonText("Darstellung erweitern");
    }

    protected void postLoad() {
        super.postLoad();
        this.setAttributeValue("editor", this.getCurrentUser().getUsername());
        CmsEvent currentEvent = this.getCurrentEvent();
        this.loadHistories();
        this.currentHistory = null;
        if (currentEvent != null) {
            for (CmsElement e : this.histories) {
                if (!e.getRelationAttribute("event").contains(currentEvent.getId())) continue;
                this.currentHistory = (CmsHistory)e;
                break;
            }
        }
        this.applyHistories();
        this.getRelationAttribute("histories").clear();
        for (CmsElement e : this.histories) {
            if (e.isNew()) continue;
            this.getRelationAttribute("histories").add(e);
        }
        if (!this.isLastHistory(this.currentHistory)) {
            this.getAttribute("warning").setHidden(false).setValue("Achtung, zu dieser Beobachtung gibt es bereits eine aktuellere Dokumentation!");
        } else {
            this.getAttribute("warning").setHidden(true);
        }
        this.ignoreCurrentHistory = false;
        this.lastSavedDueDate = this.getDateAttribute("duedate").getDate();
    }

    protected void preSave() {
        super.preSave();
        if (!this.keepEditor) {
            this.setAttributeValue("editor", this.getCurrentUser().getUsername());
        }
        CmsEvent currentEvent = this.getCurrentEvent();
        if (this.histories == null) {
            this.loadHistories();
        }
        if (currentEvent == null) {
            this.app.getLogger().severe("No current event defined while saving observation ID=" + this.getId());
        }
        if (currentEvent != null && !this.ignoreCurrentHistory) {
            this.getCurrentHistory();
            if (this.currentHistory == null) {
                this.currentHistory = this.getProject().createHistoryElement(currentEvent, this);
                this.histories.add(this.currentHistory);
            }
            this.copyToHistory();
            this.currentHistory.getRelationAttribute("observation").clear();
            this.currentHistory.save();
        }
        if (this.histories != null && !this.histories.isEmpty()) {
            this.applyHistory(this.getLatestHistory());
            Date creationdate = this.getDateAttribute("creationdate").getDate();
            Date firsthistorydate = this.histories.get(0).getDateAttribute("eventdate").getDate();
            if (creationdate == null || firsthistorydate.before(creationdate)) {
                this.getDateAttribute("creationdate").setDate(firsthistorydate);
            }
            if (!this.getBooleanAttribute("done").isSet()) {
                this.getDateAttribute("donedate").clear();
            }
        }
        this.getUploadAttribute("files").clearWithoutDelete();
        boolean hasImage = false;
        boolean hasAudio = false;
        this.getRelationAttribute("histories").clear();
        for (CmsElement e : this.histories) {
            this.getRelationAttribute("histories").add(e);
            for (UploadItem item : e.getUploadAttribute("files").getUploadItems()) {
                hasAudio = hasAudio || item.isAudio();
                hasImage = hasImage || item.isImage();
            }
        }
        this.getBooleanAttribute("hasimage").setValue(hasImage);
        this.getBooleanAttribute("hasaudio").setValue(hasAudio);
        this.getDateAttribute("referencedate").setDate(this.getReferenceDate());
        if (currentEvent != null) {
            this.getRelationAttribute("event").add((CmsElement)currentEvent);
        }
    }

    protected void postSave() {
        super.postSave();
        if (this.histories != null && !this.histories.isEmpty()) {
            this.applyHistory((CmsHistory)this.histories.get(this.histories.size() - 1));
        }
        this.lastSavedDueDate = this.getDateAttribute("duedate").getDate();
        ThemisApplication.getInstance().getFilter().resetSearchResult();
    }

    protected boolean verifyElement() {
        if (this.getRelationAttribute("location").isEmpty()) {
            this.app.getLogger().severe("Observation #" + this.getId() + " '" + this.getTitle() + "' cannot be saved, no location defined");
            this.setWarningmessage("Es ist kein Gegenstand zu der Beobachtung definiert!");
            return false;
        }
        return true;
    }

    protected void postRemove() {
        super.postRemove();
        if (this.getRelationAttribute("location").size() > 0) {
            CmsLocation loc = (CmsLocation)this.getRelationAttribute("location").getFirstElement().getElement();
            long planid = loc.getRelationAttribute("plan").getFirstElementId();
            CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.getProject(), this.getProject().getUser(), false);
            s.setElementtypes("observation");
            s.addWhereRelationId(this.getProject().getDefaultElement("observation").getAttribute("location"), "=", Long.toString(loc.getId()));
            if (!s.search().isEmpty()) {
                this.themis.getFilter().resetSearchResult();
                ThemisApplication.getInstance().getActionProvider().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setElementtype("observation").setId(loc.getId()).from((Object)this, "post remove"));
            }
        }
    }

    protected void postTrash() {
        super.postTrash();
        ThemisApplication.getInstance().getFilter().resetSearchResult();
    }

    protected void postCopy() {
        this.getUploadAttribute("files").clear();
        this.getRelationAttribute("histories").setDeleteRemoved(false);
        this.getRelationAttribute("histories").clear();
        this.getRelationAttribute("histories").setDeleteRemoved(true);
        this.getRelationAttribute("plannedfor").clear();
    }

    public void setCurrentHistoryToBeIgnored() {
        this.ignoreCurrentHistory = true;
    }

    public void setCurrentHistoryNotToBeIgnored() {
        this.ignoreCurrentHistory = false;
    }

    public CmsHistory getCurrentHistory() {
        return this.currentHistory;
    }

    public void setCurrentHistory(CmsHistory h) {
        this.currentHistory = h;
        CmsHistory oldHistory = this.getHistory(h.getEventId());
        if (oldHistory != null) {
            this.getRelationAttribute("histories").delete(oldHistory.getId());
            this.histories.remove((Object)oldHistory);
        }
        this.histories.add(h);
        this.getRelationAttribute("histories").add((CmsElement)h);
    }

    public boolean setControlled() {
        if (ThemisLicense.isActionDeniedForViewer(this.getThemisApplication())) {
            return false;
        }
        if (this.getProject().checkAndCreateEvent()) {
            if (this.isOfType(2)) {
                this.applyRepeatPeriod();
            }
            this.save();
        }
        return true;
    }

    public boolean isControlledInCurrentEvent() {
        long eventid = this.getProject().getCurrentEventId();
        if (this.currentHistory == null || eventid <= 0L) {
            return false;
        }
        return eventid == this.currentHistory.getRelationAttribute("event").getFirstElementId();
    }

    public boolean isControlledInEvent(long eventid) {
        if (eventid <= 0L) {
            return false;
        }
        for (CmsElement h : this.getHistories()) {
            if (eventid != h.getRelationAttribute("event").getFirstElementId()) continue;
            return true;
        }
        return false;
    }

    public void removeHistoryForEvent(long idEvent) {
        if (this.histories == null) {
            this.loadHistories();
        }
        boolean foundHistories = false;
        ArrayList<CmsElement> historiesToBeRemoved = new ArrayList<CmsElement>();
        for (CmsElement h : this.histories) {
            if (h.getRelationAttribute("event").getFirstElementId() != idEvent) continue;
            foundHistories = true;
            historiesToBeRemoved.add(h);
        }
        if (foundHistories) {
            for (CmsElement historyToBeRemoved : historiesToBeRemoved) {
                this.getRelationAttribute("histories").remove(historyToBeRemoved.getId());
                this.histories.remove(historyToBeRemoved);
            }
        }
    }

    public CmsHistory getLatestHistory() {
        if (this.histories == null || this.histories.isEmpty()) {
            return this.currentHistory;
        }
        this.sortHistories();
        return (CmsHistory)this.histories.get(this.histories.size() - 1);
    }

    public List<CmsElement> getHistories() {
        if (this.histories == null) {
            this.loadHistories();
        }
        return this.histories;
    }

    public CmsHistory getHistory(CmsEvent ev) {
        if (this.getHistories() == null) {
            return null;
        }
        for (CmsElement h : this.getHistories()) {
            if (ev == null || h.getRelationAttribute("event").getFirstElementId() != ev.getId()) continue;
            return (CmsHistory)h;
        }
        return null;
    }

    public CmsHistory getHistoryBefore(CmsEvent e) {
        if (this.histories == null) {
            this.loadHistories();
        }
        for (int ii = this.histories.size() - 1; ii >= 0; --ii) {
            CmsHistory h = (CmsHistory)this.histories.get(ii);
            if (h.isLaterThan(e) || h.getEventId() == e.getId()) continue;
            return h;
        }
        return null;
    }

    public CmsHistory getHistoryOrBefore(CmsEvent e) {
        if (e == null) {
            return null;
        }
        if (this.histories == null) {
            this.loadHistories();
        }
        for (int ii = this.histories.size() - 1; ii >= 0; --ii) {
            CmsHistory h = (CmsHistory)this.histories.get(ii);
            if (h.isLaterThan(e)) continue;
            return h;
        }
        return null;
    }

    public CmsHistory getHistory(long eventid) {
        for (CmsElement h : this.getHistories()) {
            if (h.getRelationAttribute("event").getFirstElementId() != eventid) continue;
            return (CmsHistory)h;
        }
        return null;
    }

    public void removeHistory(long id) {
        this.getRelationAttribute("histories").delete(id);
        for (CmsElement h : this.histories) {
            if (h.getId() != id) continue;
            this.histories.remove(h);
            break;
        }
        boolean ign = this.ignoreCurrentHistory;
        this.setCurrentHistoryToBeIgnored();
        this.save();
        if (!ign) {
            this.setCurrentHistoryNotToBeIgnored();
        }
    }

    public ArrayList<Long> getEventIds() {
        List historyIds = this.getRelationAttribute("histories").getElementIds();
        return this.getProject().getDatastorage().getRelationIds((List)((ArrayList)historyIds), this.getProject().getDefaultElement("event").getRelationAttribute("histories").getRelationcode(), true);
    }

    public CmsElement getContact() {
        CmsElementSummary contact = this.getRelationAttribute("responsible").getFirstElement();
        if (contact != null) {
            return contact.getElement();
        }
        return null;
    }

    public File createEmail() throws MessagingException, IOException {
        ThemisApplication app = ThemisApplication.getInstance();
        ThemisProject project = app.getProject();
        CmsHistory latestHistory = this.getLatestHistory();
        this.applyHistory(latestHistory);
        CmsElement loc = null;
        if (this.hasAttributeValue("location")) {
            loc = this.getRelationAttribute("location").getFirstElement().getElement();
        }
        StringBuilder sb = new StringBuilder();
        String email = "<div><p style='font-family:\"Verdana\";'>";
        String tab = "&#160;&#160;&#160;&#160;&#160;";
        if (loc != null) {
            email = email + "<b>Gegenstand: </b><br>Titel:<br>" + tab + loc.getTitle() + "<br>";
            for (ThemisAttribute ta : app.getSettings().getLocationAttributesUsed()) {
                if (!loc.hasAttributeValue(ta.getCmsCode())) continue;
                email = email + ta.getLabel() + ":<br>" + tab + loc.getAttributeValue(ta.getCmsCode()) + "<br>";
            }
            email = email + "<br><b>Beobachtung: </b><br>";
            email = email + this.toString("<br>");
        }
        email = email + "</p></div>";
        this.applyHistory(this.getCurrentHistory());
        ArrayList<Object> attachments = new ArrayList();
        attachments = this.getUploads(false);
        String recipient = null;
        CmsElement contact = this.getContact();
        if (contact != null) {
            recipient = contact.getAttributeValue("email");
        }
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", "smtp");
        Session mailSession = Session.getDefaultInstance((Properties)props, null);
        MimeMessage message = new MimeMessage(mailSession);
        message.setSubject("Information aus THEMIS");
        if (recipient != null && !"".equals(recipient)) {
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
        }
        message.setHeader("X-Unsent", "1");
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent((Object)email, "text/html");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        ImagePanel panel = new ImagePanel(ThemisApplication.getInstance().getProject().getLogger());
        for (UploadItem uploadItem : attachments) {
            if (uploadItem.isAudio()) continue;
            File imagefile = uploadItem.getFile();
            ArrayList<SimpleGeometry> drawings = project.getDrawings(uploadItem.getId());
            if (drawings.size() > 0) {
                imagefile = new File(project.getTempfileLocation(), uploadItem.getFilename());
                BufferedImage bi = ImageIO.read(uploadItem.getFile());
                panel.setBackgroundImage(bi);
                panel.removeGeometries();
                if (bi.getWidth() != 0 && !drawings.isEmpty()) {
                    double factor = (double)bi.getWidth() / (double)bi.getWidth();
                    for (SimpleGeometry geometry : drawings) {
                        for (int ii = 0; ii < geometry.size(); ++ii) {
                            Point p = (Point)geometry.getPoints().get(ii);
                        }
                        panel.addGeometry(geometry.scale(factor));
                    }
                }
                ImageIO.write((RenderedImage)panel.getAsBufferedImage(true), "jpg", imagefile);
            }
            messageBodyPart = new MimeBodyPart();
            FileDataSource source = new FileDataSource(imagefile);
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            messageBodyPart.setFileName(uploadItem.getFilename());
            multipart.addBodyPart((BodyPart)messageBodyPart);
        }
        message.setContent((Multipart)multipart);
        File folder = this.getApplication().getTempfileLocation();
        String string = Util.formatDate((Date)new Date(), (String)Util.DATETIME_FILE, (TimeZone)this.getApplication().getTimeZone()) + "_" + this.getId() + ".eml";
        File emailfile = new File(folder, string);
        FileOutputStream fos = new FileOutputStream(emailfile);
        message.writeTo((OutputStream)fos);
        Util.closeStream((Closeable)fos);
        return emailfile;
    }

    public void setNumber(long number) {
        this.getLongAttribute("number").setValue(number);
    }

    public boolean setNextNumber() {
        long idLoc = this.getRelationAttribute("location").getFirstElementId();
        ArrayList obsIds = this.app.getDatastorage().getRelationIds(idLoc, "locationobservation", true);
        obsIds.remove(this.getId());
        String sql = "SELECT number AS nr FROM tdtaEleObservation AS o INNER JOIN tdtaElement AS e ON (o.idelement=e.idelement) WHERE o.idElement IN " + Util.toSqlString((Iterable)obsIds) + " AND NOT e.deleted";
        ArrayList<Long> numbers = new ArrayList<Long>();
        long maxNr = 0L;
        for (DataRecord rec : this.app.getDatastorage().executeQuery(sql, true).getResult()) {
            numbers.add(rec.getLong("nr"));
            if (rec.getLong("nr") <= maxNr) continue;
            maxNr = rec.getLong("nr");
        }
        if (numbers.contains(this.getLongAttribute("number").getLong())) {
            this.getLongAttribute("number").setValue(maxNr + 1L);
            return true;
        }
        return false;
    }

    public boolean isOfType(int type) {
        return this.getKeyAttribute("type").getId() == (long)type;
    }

    public void setDone(boolean flg) {
        boolean alreadyDone = this.getBooleanAttribute("done").isSet();
        this.getBooleanAttribute("done").setValue(flg);
        if (!flg) {
            this.getDateAttribute("donedate").clear();
        } else if (!alreadyDone) {
            this.getDateAttribute("donedate").setDate(this.themis.getProject().getCurrentEvent().getDateAttribute("date").getDate());
        }
    }

    public boolean isDone() {
        return this.getAttributeValueBoolean("done");
    }

    public static ArrayList<String> getChecklistAttributes() {
        ArrayList<String> atts = new ArrayList<String>();
        atts.add("langtext1");
        atts.add("langtext2");
        atts.add("measure");
        atts.add("responsible");
        atts.add("observationtype");
        atts.add("priority");
        atts.add("topic");
        atts.add("code");
        atts.add("risk");
        atts.add("freetext1");
        atts.add("freetext2");
        atts.add("freetext3");
        atts.add("quantity");
        atts.add("editor");
        return atts;
    }

    public String toString() {
        return this.toString("\n", "\n", true);
    }

    public String toString(String linebreak) {
        return this.toString(linebreak, linebreak);
    }

    public String toString(String lb1, String lb2) {
        return this.toString(lb1, lb2, true);
    }

    public String toString(String lb1, String lb2, boolean showStatus, ArrayList<ThemisAttribute> atts) {
        return ThemisUtil.toString(this, lb1, lb2, showStatus, atts, false);
    }

    public String toString(String lb1, String lb2, boolean showStatus) {
        return this.toStringWithIgnore(lb1, lb2, showStatus, new ArrayList<ThemisAttribute>());
    }

    public String toStringWithIgnoreString(String lb1, String lb2, boolean showStatus, List<String> ignoreAttCodes) {
        ArrayList<ThemisAttribute> ignoreAtts = new ArrayList<ThemisAttribute>();
        for (String att : ignoreAttCodes) {
            ignoreAtts.add(this.themis.getSettings().getObservationAttribute(att));
        }
        return this.toStringWithIgnore(lb1, lb2, showStatus, ignoreAtts);
    }

    public String toStringWithIgnore(String lb1, String lb2, boolean showStatus, ArrayList<ThemisAttribute> ignoreAtts) {
        ThemisSettings settings = ThemisApplication.getInstance().getSettings();
        ArrayList<ThemisAttribute> atts = new ArrayList<ThemisAttribute>();
        for (ThemisAttribute ta : settings.getObservationAttributes()) {
            if (!ta.isUsed() || !ta.doShow(this.getKeyAttribute("type").getId()) || ignoreAtts != null && ignoreAtts.contains(ta) || "title".equals(ta.getId()) || "repeat".equals(ta.getId()) || "repeatunit".equals(ta.getId())) continue;
            atts.add(ta);
        }
        return this.toString(lb1, lb2, showStatus, atts);
    }

    public String toHtml() {
        StringBuilder sb = new StringBuilder();
        CmsLocation loc = this.getLocation();
        if (loc != null) {
            sb.append(loc.toHtml());
        }
        sb.append("<h2>").append(this.getFullNumber()).append(" ").append(this.getTitle()).append(" [").append(this.getAttributeValue("type")).append("]</h2>");
        List<String> ignoreAtts = Arrays.asList("title", "repeat", "repeatunit", "type");
        for (ThemisAttribute ta : this.themis.getSettings().getObservationAttributes()) {
            String val;
            if (!ta.isUsed() || ignoreAtts.contains(ta.getId()) || (val = this.getAttributeValue(ta.getCmsCode())) == null || val.isEmpty()) continue;
            sb.append("<p><b>").append(ta.getLabel()).append(": </b>").append(val).append("</p>");
        }
        return sb.toString();
    }

    public void applyIdMappingForElementtype(long oldId, long newId) {
        if (this.getLongAttribute("templateid").getLong() == oldId) {
            this.getLongAttribute("templateid").setValue(newId);
        }
    }

    public ArrayList<CmsAttribute> getElementReferenceAttributes() {
        ArrayList atts = super.getElementReferenceAttributes();
        atts.add(this.getAttribute("templateid"));
        return atts;
    }

    public void updateUploads(Document doc, ZipFile zip) {
        if (doc == null) {
            return;
        }
        Element eleData = doc.getRootElement().getChild("data");
        this.updateUploads(eleData, zip);
    }

    public void updateUploads(Element eleData, ZipFile zip) {
        if (eleData == null) {
            return;
        }
        this.getUploadAttribute("files").setValue(eleData.getChild("files"), zip);
    }

    public int compare(CmsEvent ev, CmsHistory hist) {
        Date dt2;
        if (!ev.hasAttributeValue("date") || !hist.hasAttributeValue("eventdate")) {
            return 0;
        }
        Date dt1 = ev.getDateAttribute("date").getDate();
        if (dt1.equals(dt2 = hist.getDateAttribute("eventdate").getDate())) {
            int deltaTime = ev.getIntegerAttribute("timehours").getIntValue() - hist.getIntegerAttribute("timehours").getIntValue();
            if (deltaTime == 0) {
                return ev.getId() < hist.getEventId() ? -1 : 1;
            }
            return deltaTime < 0 ? -1 : 1;
        }
        return dt1.before(dt2) ? -1 : 1;
    }
}

