/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.element;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.attribute.KeyAttribute;
import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.content.Keytable;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsUser;
import at.grid.cms.storage.DataRecord;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsCompany;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.ThemisElement;
import at.grid.util.Util;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class CmsObservationTemplate
extends ThemisElement {
    public String getSummary() {
        return "";
    }

    public String getTitle() {
        String s = this.getAttributeValue("title");
        if ((s == null || "".equals(s)) && (s = this.getAttributeValue("description")).length() > 60) {
            int idx = (s = s.substring(0, 60)).indexOf(".");
            if (idx < 0) {
                idx = s.lastIndexOf(" ");
            }
            s = s.substring(0, idx) + "...";
        }
        if (s == null || "".equals(s)) {
            s = this.app.getResourceText("text.observationtemplateWithoutTitle", this.themis.getLocale());
        }
        return s;
    }

    public void setAttributes(CmsObservation obs) {
        this.getKeyAttribute("observationtype").setValue(obs.getKeyAttribute("observationtype").getId());
        this.getKeyAttribute("type").setValue(obs.getKeyAttribute("type").getId());
        this.getKeyAttribute("priority").setValue(obs.getKeyAttribute("priority").getId());
        this.getKeyAttribute("topic").setValue(obs.getKeyAttribute("topic").getId());
        if (obs.hasAttributeValue("repeatcount") && !obs.getAttributeValue("repeatcount").equals("0")) {
            long idunit = obs.getKeyAttribute("repeat").getId();
            this.setAttributeValue("duedate", obs.getAttributeValue("repeatcount"));
            this.getKeyAttribute("repeat").setValue(idunit < 0L ? 1L : idunit);
        } else if (obs.getAttribute("duedate").hasValue()) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(10, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            int delta = Util.countDays((Calendar)cal, (Date)cal.getTime(), (Date)obs.getDateAttribute("duedate").getDate(), (boolean)false);
            this.getIntegerAttribute("duedate").setValue(delta);
        }
        if (obs.getRelationAttribute("responsible").size() > 0) {
            this.getRelationAttribute("responsible").set(obs.getRelationAttribute("responsible").getFirstElement());
        }
        this.setAttributeValue("title", obs.getAttributeValue("title"));
        this.setAttributeValue("code", obs.getAttributeValue("code"));
        this.setAttributeValue("freetext1", obs.getAttributeValue("freetext1"));
        this.setAttributeValue("freetext2", obs.getAttributeValue("freetext2"));
        this.setAttributeValue("freetext3", obs.getAttributeValue("freetext3"));
        this.setAttributeValue("langtext1", obs.getAttributeValue("langtext1"));
        this.setAttributeValue("langtext2", obs.getAttributeValue("langtext2"));
        this.setAttributeValue("float1", obs.getAttributeValue("float1"));
        this.setAttributeValue("float2", obs.getAttributeValue("float2"));
        this.setAttributeValue("float3", obs.getAttributeValue("float3"));
        this.setAttributeValue("float4", obs.getAttributeValue("float4"));
        this.setAttributeValue("quantity", obs.getAttributeValue("quantity"));
        this.setAttributeValue("description", obs.getAttributeValue("description"));
        this.setAttributeValue("measure", obs.getAttributeValue("measure"));
        List infoids = obs.getRelationAttribute("infos").getElementIds();
        this.getRelationAttribute("infos").clear();
        Iterator iterator = infoids.iterator();
        while (iterator.hasNext()) {
            long infoid = (Long)iterator.next();
            this.getRelationAttribute("infos").add(infoid);
        }
    }

    public void applyTo(CmsObservation obs) {
        if (this.themis.getProject().getSelectionManager().getCurrentEventId() < 0L) {
            return;
        }
        long typeId = this.getKeyAttribute("type").getId();
        if (typeId < 0L) {
            typeId = 1L;
        }
        obs.getKeyAttribute("type").setValue(typeId);
        obs.getKeyAttribute("observationtype").setValue(this.getKeyAttribute("observationtype").getId());
        obs.getKeyAttribute("priority").setValue(this.getKeyAttribute("priority").getId());
        obs.getKeyAttribute("topic").setValue(this.getKeyAttribute("topic").getId());
        obs.setAttributeValue("description", this.getAttributeValue("description"));
        obs.setAttributeValue("measure", this.getAttributeValue("measure"));
        obs.setAttributeValue("title", this.getAttributeValue("title"));
        obs.setAttributeValue("code", this.getAttributeValue("code"));
        obs.setAttributeValue("freetext1", this.getAttributeValue("freetext1"));
        obs.setAttributeValue("freetext2", this.getAttributeValue("freetext2"));
        obs.setAttributeValue("freetext3", this.getAttributeValue("freetext3"));
        obs.setAttributeValue("langtext1", this.getAttributeValue("langtext1"));
        obs.setAttributeValue("langtext2", this.getAttributeValue("langtext2"));
        obs.setAttributeValue("float1", this.getAttributeValue("float1"));
        obs.setAttributeValue("float2", this.getAttributeValue("float2"));
        obs.setAttributeValue("float3", this.getAttributeValue("float3"));
        obs.setAttributeValue("float4", this.getAttributeValue("float4"));
        obs.setAttributeValue("quantity", this.getAttributeValue("quantity"));
        obs.getKeyAttribute("repeat").setValue(this.getKeyAttribute("repeat").getId() == -1L ? 1L : this.getKeyAttribute("repeat").getId());
        obs.setAttributeValue("repeatcount", this.getAttributeValue("duedate"));
        int dateCount = this.getIntegerAttribute("duedate").getIntValue();
        if (dateCount > 0) {
            int idUnit = (int)this.getKeyAttribute("repeat").getId();
            obs.getDateAttribute("duedate").setDate(ThemisApplication.applyPeriodToDate(obs.getCurrentEvent().getDateAttribute("date").getDate(), idUnit, dateCount));
        } else {
            obs.getDateAttribute("duedate").clear();
        }
        if (this.getRelationAttribute("responsible").size() > 0) {
            obs.getRelationAttribute("responsible").set(this.getRelationAttribute("responsible").getFirstElement());
        } else {
            obs.getRelationAttribute("responsible").clear();
        }
        obs.getLongAttribute("templateid").setValue(this.getId());
        List infoids = this.getRelationAttribute("infos").getElementIds();
        obs.getRelationAttribute("infos").clear();
        Iterator iterator = infoids.iterator();
        while (iterator.hasNext()) {
            long infoid = (Long)iterator.next();
            obs.getRelationAttribute("infos").add(infoid);
        }
    }

    protected void postLoad() {
        this.setAttributeVisibility();
    }

    protected void postCreate() {
        this.setAttributeVisibility();
        this.getKeyAttribute("type").setValue(1L);
    }

    protected void postTrash() {
        super.postTrash();
        ArrayList ids = this.app.getDatastorage().executeQuery("select idelement as meta_id from tdtaelemeasuretemplate where idlocation=" + this.getId(), true).getResultIds();
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            CmsElement.moveToTrash((CmsApplication)this.app, (long)id, (CmsUser)this.getCurrentUser());
        }
    }

    protected void postRemove() {
        super.postRemove();
        ArrayList ids = this.app.getDatastorage().executeQuery("select idelement as meta_id from tdtaelemeasuretemplate where idlocation=" + this.getId(), true).getResultIds();
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            CmsElement.remove((CmsApplication)this.app, (long)id, (CmsUser)this.getCurrentUser());
        }
    }

    public void setAttributeVisibility() {
        ThemisApplication app = ThemisApplication.getInstance();
        for (ThemisAttribute ta : app.getSettings().getObservationAttributes()) {
            if (ta.getCmsCode() == null || "".equals(ta.getCmsCode()) || !this.hasAttribute(ta.getCmsCode())) continue;
            this.getAttribute(ta.getCmsCode()).setHidden(!ta.isUsed());
            this.getAttribute(ta.getCmsCode()).setLabel(ta.getLabel());
        }
        if (this.getAttribute("infos").isHidden()) {
            this.getAttribute("s5").setHidden(true);
        }
        this.getAttribute("done").setHidden(true);
        boolean useDuedate = app.getSettings().getObservationAttribute("duedate").isUsed();
        this.getAttribute("repeat").setHidden(!useDuedate);
        this.getAttribute("duedate").setHidden(!useDuedate);
        boolean useGroup = app.getSettings().getLocationAttribute("group").isUsed();
        this.getAttribute("locationgroup").setHidden(!useGroup);
        if (this.hasAttributeValue("location") || !useGroup) {
            this.getAttribute("locationgroup").setHidden(true);
            this.getAttribute("location").setHidden(false);
        } else {
            this.getAttribute("locationgroup").setHidden(false);
            this.getAttribute("location").setHidden(true);
        }
    }

    @Override
    public void setAttributes(Properties props) {
        for (String string : props.keySet()) {
            String val = props.getProperty(string);
            CmsAttribute att = this.getAttribute(string);
            if (att == null || att.getCode().startsWith("meta_")) continue;
            if (att.isOfType(8)) {
                Keytable keytable = ((KeyAttribute)att).getKeytable();
                long id = -1L;
                if ("repeat".equals(keytable.getCode())) {
                    if (val != null && !"".equals(val)) {
                        id = Long.parseLong(val);
                    }
                    if (!keytable.hasId(id, this.getLang())) continue;
                    ((KeyAttribute)att).setValue(id);
                    continue;
                }
                if (val == null || "".equals(val)) continue;
                id = keytable.getIdByTerm(val, this.getLang());
                if (id < 0L) {
                    id = keytable.createNewId();
                    keytable.addTerm(id, this.getLang(), val);
                    keytable.save();
                    ((KeyAttribute)att).setValue(id);
                    continue;
                }
                ((KeyAttribute)att).setValue(id);
                continue;
            }
            if (att.isOfType(14)) {
                DataRecord rec;
                if ("responsible".equals(att.getCode())) {
                    if ("".equals(val)) {
                        att.clear();
                        continue;
                    }
                    if (val == null) continue;
                    rec = this.app.getDatastorage().executeQuery("SELECT idelement FROM tdtaEleCompany WHERE name=" + Util.toSqlString((String)val), true).firstRow();
                    if (rec == null) {
                        CmsCompany c = (CmsCompany)this.getProject().createElement("company");
                        c.setAttributeValue("name", val);
                        c.save();
                        ((RelationAttribute)att).set(c.getId());
                        continue;
                    }
                    ((RelationAttribute)att).set(rec.getLong("idelement").longValue());
                    continue;
                }
                if (!"infos".equals(att.getCode()) || val == null || "".equals(val) || (rec = this.app.getDatastorage().executeQuery("SELECT idelement FROM tdtaEleInfo WHERE title=" + Util.toSqlString((String)val), true).firstRow()) == null) continue;
                ((RelationAttribute)att).set(rec.getLong("idelement").longValue());
                continue;
            }
            att.setValue(val);
        }
    }
}

