/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.element;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.storage.SearchResult;
import at.grid.data.Coordinates2D;
import at.grid.data.grid.GridGeometry;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsPlanCalibration;
import at.grid.themis.ontology.element.CmsPlanfile;
import at.grid.themis.ontology.element.ThemisElement;
import at.grid.util.Dimension;
import at.grid.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CmsPlan
extends ThemisElement {
    public static final int CALIB_NONE = 0;
    public static final int CALIB_POINTS = 1;
    public static final int CALIB_COORDINATES = 2;
    public static final int CALIB_WORLDFILE = 3;
    public static final int DPI = 300;
    public static final float INCH_MM = 25.4f;
    GridGeometry geo = null;
    CmsLocation building = null;

    public String getSummary() {
        int countloc = this.getRelationAttribute("locations").size();
        String res = "text.plan.location" + (countloc == 1 ? "" : "s");
        return this.app.getResourceText(res, this.themis.getLocale());
    }

    public String getTitle() {
        return this.getAttributeValue("title");
    }

    public String getFilename() {
        String buildingtitle = this.getRelationAttribute("building").getFirstElementTitle();
        String plantitle = this.getTitle();
        if (buildingtitle != null) {
            plantitle = buildingtitle + "_" + plantitle;
        }
        plantitle = plantitle.replaceAll("\\\\", "-");
        plantitle = plantitle.replaceAll("/", "-");
        return plantitle;
    }

    public long getBuildingId() {
        return this.getRelationAttribute("building").getFirstElementId();
    }

    public CmsLocation getBuilding() {
        if (this.getRelationAttribute("building").isEmpty()) {
            return null;
        }
        if (this.building == null) {
            this.building = (CmsLocation)this.getRelationAttribute("building").getFirstElement().getElement();
        }
        return this.building;
    }

    public Papersize getPapersize() {
        int w = this.getPaperWidth();
        int h = this.getPaperHeight();
        switch (w * h) {
            case 62370: {
                return Papersize.A4;
            }
            case 124740: {
                return Papersize.A3;
            }
            case 249480: {
                return Papersize.A2;
            }
            case 498960: {
                return Papersize.A1;
            }
            case 997920: {
                return Papersize.A0;
            }
        }
        return Papersize.Custom;
    }

    public int getPaperWidth() {
        return Math.round(25.4f * (float)this.getCurrentPlanfileElement().getIntegerAttribute("imagewidth").getIntValue() / 300.0f);
    }

    public int getPaperHeight() {
        return Math.round(25.4f * (float)this.getCurrentPlanfileElement().getIntegerAttribute("imageheight").getIntValue() / 300.0f);
    }

    public long getCurrentPlanfileId() {
        return this.getLongAttribute("currentplanfile").getLong();
    }

    public String getCurrentPlanfileName() {
        CmsPlanfile currentPlanfileElement = this.getCurrentPlanfileElement();
        if (currentPlanfileElement != null) {
            return currentPlanfileElement.getUploadAttribute("image").getFirstUploadItemName();
        }
        return null;
    }

    public CmsPlanfile getCurrentPlanfileElement() {
        CmsElementSummary lastElement;
        long currentPlanfileId = this.getCurrentPlanfileId();
        CmsPlanfile planfile = (CmsPlanfile)this.getRelationAttribute("planfiles").getFullElement(currentPlanfileId);
        if (planfile == null && (lastElement = this.getRelationAttribute("planfiles").getLastElement()) != null) {
            planfile = (CmsPlanfile)this.getRelationAttribute("planfiles").getFullElement(lastElement.getId());
        }
        if (planfile == null) {
            planfile = (CmsPlanfile)this.getProject().createElement("planfile");
            this.getRelationAttribute("planfiles").add((CmsElement)planfile);
            this.setCurrentPlanfile(planfile.getId());
        }
        if (planfile.getIntegerAttribute("imagewidth").getIntValue() == 0 && planfile.getUploadAttribute("image").size() > 0) {
            this.updatePlanfileImageDimensions(planfile);
        }
        return planfile;
    }

    public void setCurrentPlanfile(long id) {
        this.getLongAttribute("currentplanfile").setValue(id);
    }

    public void deleteCurrentPlanfile() {
        if (this.getPlanfiles().size() < 2) {
            return;
        }
        long currentPlanfileId = this.getCurrentPlanfileId();
        this.getRelationAttribute("planfiles").delete(currentPlanfileId);
        this.setCurrentPlanfile(this.getRelationAttribute("planfiles").getFirstElementId());
        if (this.isCalibrated()) {
            this.setCalibPlanfile();
        }
    }

    public List<CmsElementSummary> getPlanfiles() {
        return this.getRelationAttribute("planfiles").getElements();
    }

    public File getPlanFile() {
        CmsPlanfile planfile = this.getCurrentPlanfileElement();
        return planfile == null ? null : planfile.getUploadAttribute("image").getFirstUploadItemFile();
    }

    public String getPlanFileName() {
        CmsPlanfile planfile = this.getCurrentPlanfileElement();
        return planfile == null ? "" : planfile.getUploadAttribute("image").getFirstUploadItemName();
    }

    public long getPlanLongside() {
        UploadItem item;
        int h;
        CmsPlanfile planfile = this.getCurrentPlanfileElement();
        if (planfile == null) {
            return 0L;
        }
        int w = planfile.getIntegerAttribute("imagewidth").getIntValue();
        if (w * (h = planfile.getIntegerAttribute("imageheight").getIntValue()) == 0 && (item = planfile.getUploadAttribute("image").getFirstUploadItem()) != null) {
            Dimension d = Util.getJPEGDimension((File)item.getFile());
            w = d.width;
            h = d.height;
            planfile.getIntegerAttribute("imagewidth").setValue(w);
            planfile.getIntegerAttribute("imageheight").setValue(h);
            if (!planfile.isNew()) {
                planfile.save();
            }
        }
        return Math.max(w, h);
    }

    public GridGeometry getPlanExtent() {
        CmsPlanfile planfile = this.getCurrentPlanfileElement();
        if (this.isCalibrated()) {
            return planfile.getCalibration().toGeometry();
        }
        return new GridGeometry(planfile.getIntegerAttribute("imagewidth").getIntValue(), planfile.getIntegerAttribute("imageheight").getIntValue(), new Coordinates2D(0.0, 0.0), 1.0);
    }

    public boolean isCalibrated() {
        return this.getCalibMethod() != 0;
    }

    public boolean isCurrentPlanfileCalibrated() {
        CmsPlanCalibration calib = this.getCurrentPlanfileElement().getCalibration();
        return calib != null && calib.getMethod() != 0;
    }

    public int getCalibMethod() {
        if (this.hasAttribute("calibmethod")) {
            return this.getIntegerAttribute("calibmethod").getIntValue();
        }
        return 0;
    }

    public void setCalibMethod(int method) {
        if (this.isCalibrated() && method != 0 && method != this.getCalibMethod()) {
            throw new IllegalStateException("Plan is already calibrated");
        }
        this.getIntegerAttribute("calibmethod").setValue(method);
    }

    public long getCalibPlanfileId() {
        if (this.hasAttribute("calibplanfile")) {
            return this.getLongAttribute("calibplanfile").getLong();
        }
        return -1L;
    }

    private void setCalibPlanfile() {
        this.getLongAttribute("calibplanfile").setValue(this.getCurrentPlanfileId());
    }

    public boolean isCurrentPlanfileCalibrationBase() {
        return this.isCalibrated() && this.getCurrentPlanfileId() == this.getCalibPlanfileId();
    }

    public CmsPlanfile getCalibPlanfileElement() {
        long id = this.getLongAttribute("calibplanfile").getLong();
        if (id > 0L && "planfile".equals(this.app.getDatastorage().getElementtypeById(id))) {
            return (CmsPlanfile)this.getRelationAttribute("planfiles").getFullElement(id);
        }
        this.getLongAttribute("calibplanfile").setValue(-1L);
        return null;
    }

    public void addPlanFile(File f, File pdf, Dimension d, Date dt) {
        if (d == null) {
            d = Util.getJPEGDimension((File)f);
        }
        if (d == null) {
            d = new Dimension();
        }
        CmsElement planfile = this.getProject().createElement("planfile");
        planfile.getUploadAttribute("image").addUpload(f);
        if (pdf != null) {
            planfile.getUploadAttribute("pdf").addUpload(pdf);
        }
        planfile.getDateAttribute("uploaddate").setDate(dt);
        planfile.getIntegerAttribute("imagewidth").setValue(d.width);
        planfile.getIntegerAttribute("imageheight").setValue(d.height);
        this.getRelationAttribute("planfiles").add(planfile);
        this.setCurrentPlanfile(planfile.getId());
    }

    public boolean hasGeometry() {
        CmsPlanCalibration calib = this.getCurrentPlanfileElement().getCalibration();
        return calib != null && calib.toGeometry() != null;
    }

    public GridGeometry getGeometry() {
        return this.geo;
    }

    public void updateCalibration(String worldfile) {
        try {
            CmsPlanfile planfile = this.getCurrentPlanfileElement();
            GridGeometry newGeo = new GridGeometry(worldfile, planfile.getIntegerAttribute("imagewidth").getIntValue(), planfile.getIntegerAttribute("imageheight").getIntValue());
            CmsPlanCalibration calib = new CmsPlanCalibration(worldfile, planfile.getIntegerAttribute("imagewidth").getIntValue(), planfile.getIntegerAttribute("imageheight").getIntValue());
            this.updateCalibration(3, planfile, calib, newGeo);
        }
        catch (IOException ex) {
            Logger.getLogger(CmsPlan.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void updateCalibration(int method, double planX1, double planY1, double planX2, double planY2, double geoX1, double geoY1, double geoX2, double geoY2) {
        CmsPlanfile planfile = this.getCurrentPlanfileElement();
        if (planfile.getIntegerAttribute("imageheight").getIntValue() == 0) {
            this.updatePlanfileImageDimensions(planfile);
        }
        CmsPlanCalibration calib = new CmsPlanCalibration(planX1, planY1, planX2, planY2, geoX1, geoY1, geoX2, geoY2, planfile.getIntegerAttribute("imagewidth").getIntValue(), planfile.getIntegerAttribute("imageheight").getIntValue());
        calib.setMethod(method);
        GridGeometry newGeo = calib.toGeometry();
        this.updateCalibration(method, planfile, calib, newGeo);
    }

    public void updateCalibration(int method, CmsPlanfile planfile, CmsPlanCalibration calib, GridGeometry newGeo) {
        boolean updateLocations = false;
        if (!this.isCalibrated()) {
            this.setCalibMethod(method);
            updateLocations = true;
            this.setCalibPlanfile();
        } else if (this.getCalibMethod() != method) {
            throw new IllegalArgumentException("Calibration method mismatch");
        }
        if (updateLocations) {
            this.calculateGeoreference(newGeo);
        }
        planfile.setCalibration(calib);
    }

    public void removeCalibration() {
        this.calculateGeoreference(null);
        this.setCalibMethod(0);
        this.getLongAttribute("calibplanfile").clear();
        for (CmsElement planfile : this.getRelationAttribute("planfiles").getFullElements()) {
            ((CmsPlanfile)planfile).removeCalibration();
        }
    }

    private void calculateGeoreference(GridGeometry newGeo) {
        if (!this.getProject().isOpen()) {
            return;
        }
        CmsElement loc = this.getProject().getDefaultElement("location");
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.getProject(), this.getProject().getUser(), false);
        s.setElementtypes("location");
        s.addSelectTitle("meta_title");
        s.addSelectAttribute(loc.getAttribute("position"));
        s.addSelectAttribute(loc.getAttribute("labelposition"));
        s.addWhereRelationId(loc.getAttribute("plan"), "=", Long.toString(this.getId()));
        s.setIgnoreTrash();
        SearchResult result = s.search();
        for (DataRecord rec : result.getResult()) {
            SimpleGeometry geom = SimpleGeometry.fromWKT((String)rec.getString("position"));
            SimpleGeometry geomlabel = null;
            String labelpos = rec.getString("labelposition");
            if (labelpos != null && !"".equals(labelpos)) {
                geomlabel = SimpleGeometry.fromWKT((String)labelpos);
            }
            if (this.geo != null) {
                geom = geom.retransform(0, this.geo);
                if (geomlabel != null) {
                    geomlabel = geomlabel.retransform(0, this.geo);
                }
            }
            if (newGeo != null) {
                geom = geom.transform(0, newGeo);
                if (geomlabel != null) {
                    geomlabel = geomlabel.transform(0, newGeo);
                }
            }
            this.getProject().getDatastorage().executeUpdate("UPDATE tdtaEleLocation SET position = '" + geom.toWKT() + "' WHERE idElement = " + rec.getLong("meta_id"), true);
            if (geomlabel == null) continue;
            this.getProject().getDatastorage().executeUpdate("UPDATE tdtaEleLocation SET labelposition = '" + geomlabel.toWKT() + "' WHERE idElement = " + rec.getLong("meta_id"), true);
        }
        this.geo = newGeo;
        this.save();
    }

    public void reloadLocations() {
        this.app.getDatastorage().loadElementRelation((CmsElement)this, this.getRelationAttribute("locations"));
    }

    public void applyIdMappingForElementtype(long oldId, long newId) {
        if (this.getLongAttribute("calibplanfile").getLong() == oldId) {
            this.getLongAttribute("calibplanfile").setValue(newId);
        }
        if (this.getLongAttribute("currentplanfile").getLong() == oldId) {
            this.getLongAttribute("currentplanfile").setValue(newId);
        }
    }

    public ArrayList<CmsAttribute> getElementReferenceAttributes() {
        ArrayList atts = super.getElementReferenceAttributes();
        atts.add(this.getAttribute("calibplanfile"));
        atts.add(this.getAttribute("currentplanfile"));
        return atts;
    }

    protected void postCopy() {
        super.postCopy();
        this.getIntegerAttribute("sort").setValue((int)this.getId());
    }

    protected void postCreate() {
        super.postCreate();
        this.getIntegerAttribute("sort").setValue((int)this.getId());
    }

    protected void postLoad() {
        CmsPlanfile planfile = this.getCurrentPlanfileElement();
        if (planfile != null) {
            CmsPlanCalibration calib = planfile.getCalibration();
            this.geo = calib != null ? calib.toGeometry() : null;
        }
    }

    protected void preSave() {
        super.preSave();
        String buildingtitle = this.getRelationAttribute("building").getFirstElementTitle();
        if (buildingtitle == null) {
            this.getAttribute("buildingtitle").clear();
        } else {
            this.setAttributeValue("buildingtitle", buildingtitle);
        }
        this.reloadLocations();
        CmsEvent currentEvent = this.themis.getProject().getCurrentEvent();
        if (currentEvent != null) {
            this.getRelationAttribute("event").add((CmsElement)currentEvent);
            currentEvent.addModifiedElement(this);
        }
    }

    public void remove() {
        boolean doremove = true;
        if (!this.getRelationAttribute("locations").isEmpty()) {
            ThemisApplication.getInstance().getDialog().showWarningDialog("Es sind noch " + this.getRelationAttribute("locations").size() + " Gegenst\u00e4nde in diesem Plan definiert, der Plan kann nicht gel\u00f6scht werden!");
        } else {
            super.remove();
        }
    }

    public String moveToTrash() {
        boolean doremove = true;
        if (!this.getRelationAttribute("locations").isEmpty()) {
            ThemisApplication.getInstance().getDialog().showWarningDialog("Es sind noch " + this.getRelationAttribute("locations").size() + " Gegenst\u00e4nde in diesem Plan definiert, der Plan kann nicht gel\u00f6scht werden!");
            return "";
        }
        return super.moveToTrash();
    }

    private void updatePlanfileImageDimensions(CmsPlanfile planfile) {
        File f = planfile.getUploadAttribute("image").getFirstUploadItemFile();
        Dimension dim = this.themis.getImageHandler().getImageDimension(f);
        if (dim != null) {
            planfile.getIntegerAttribute("imagewidth").setValue(dim.getWidth());
            planfile.getIntegerAttribute("imageheight").setValue(dim.getHeight());
            planfile.save();
        }
    }

    public boolean containsLocation(long idLoc) {
        List elementIds = this.getRelationAttribute("locations").getElementIds();
        return this.getRelationAttribute("locations").contains(idLoc);
    }

    public boolean containsLocation(List<Long> idLocs) {
        for (long id : idLocs) {
            if (!this.containsLocation(id)) continue;
            return true;
        }
        return false;
    }

    public static enum Papersize {
        PDF("Wie in PDF", 0, 0),
        A4("DIN A4", 210, 297),
        A3("DIN A3", 297, 420),
        A2("DIN A2", 420, 594),
        A1("DIN A1", 594, 840),
        A0("DIN A0", 840, 1188),
        Custom("Frei", -1, -1);

        private String lbl;
        private int width;
        private int height;

        private Papersize(String lbl, int width, int height) {
            this.lbl = lbl;
            this.width = width;
            this.height = height;
        }

        public String toString() {
            return this.lbl;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidthAndHeight() {
            return this.width * this.height;
        }

        public static boolean isLandscape(int w, int h) {
            return w > h;
        }
    }
}

