/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.element;

import at.grid.data.Coordinates2D;
import at.grid.data.grid.GridGeometry;
import at.grid.util.Util;
import java.io.IOException;

public class CmsPlanCalibration {
    int method = -1;
    double planX1;
    double planY1;
    double planX2;
    double planY2;
    double geoX1;
    double geoY1;
    double geoX2;
    double geoY2;
    String worldfile;
    int width;
    int height;

    public CmsPlanCalibration(String worldfile, int w, int h) {
        this.worldfile = worldfile;
        this.method = 3;
        this.width = w;
        this.height = h;
    }

    public CmsPlanCalibration(double planX1, double planY1, double planX2, double planY2, double geoX1, double geoY1, double geoX2, double geoY2, int w, int h) {
        this.planX1 = planX1;
        this.planY1 = planY1;
        this.planX2 = planX2;
        this.planY2 = planY2;
        this.geoX1 = geoX1;
        this.geoY1 = geoY1;
        this.geoX2 = geoX2;
        this.geoY2 = geoY2;
        this.width = w;
        this.height = h;
    }

    public int getMethod() {
        return this.method;
    }

    public double getPlanX1() {
        return this.planX1;
    }

    public double getPlanY1() {
        return this.planY1;
    }

    public double getPlanX2() {
        return this.planX2;
    }

    public double getPlanY2() {
        return this.planY2;
    }

    public String getPlan1String() {
        return Util.round((double)this.planX1, (int)1) + " / " + Util.round((double)this.planY1, (int)1);
    }

    public String getPlan2String() {
        return Util.round((double)this.planX2, (int)1) + " / " + Util.round((double)this.planY2, (int)1);
    }

    public String getWorldfile() {
        return this.worldfile;
    }

    public double getGeoX1() {
        return this.geoX1;
    }

    public double getGeoY1() {
        return this.geoY1;
    }

    public double getGeoX2() {
        return this.geoX2;
    }

    public double getGeoY2() {
        return this.geoY2;
    }

    public GridGeometry toGeometry() {
        if (this.method == 0) {
            return null;
        }
        if (this.method == 3) {
            try {
                return new GridGeometry(this.worldfile, this.width, this.height);
            }
            catch (IOException ex) {
                return null;
            }
        }
        double sizeX = (this.geoX2 - this.geoX1) / (this.planX2 - this.planX1);
        double sizeY = (this.geoY2 - this.geoY1) / (this.planY2 - this.planY1);
        Coordinates2D corner = new Coordinates2D(this.geoX1 - this.planX1 * sizeX, this.geoY1 + ((double)this.height - this.planY1) * sizeY);
        return new GridGeometry(this.width, this.height, corner, sizeX, -sizeY);
    }

    public String toString() {
        switch (this.method) {
            case 3: {
                return this.width + "," + this.height + "," + this.worldfile;
            }
            case 1: {
                return this.width + "," + this.height + "," + this.planX1 + "," + this.planY1 + "," + this.planX2 + "," + this.planY2 + "," + this.geoX1;
            }
        }
        return this.width + "," + this.height + "," + this.planX1 + "," + this.planY1 + "," + this.planX2 + "," + this.planY2 + "," + this.geoX1 + "," + this.geoY1 + "," + this.geoX2 + "," + this.geoY2;
    }

    public static CmsPlanCalibration fromString(String s) {
        CmsPlanCalibration calib;
        String[] split = s.split(",");
        if (s == null || "".equals(s)) {
            CmsPlanCalibration calib2 = new CmsPlanCalibration(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0, 0);
            calib2.method = 0;
            return calib2;
        }
        if (split.length == 3) {
            calib = new CmsPlanCalibration(split[2], Integer.parseInt(split[0]), Integer.parseInt(split[1]));
        } else {
            calib = new CmsPlanCalibration(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0, 0);
            if (split.length >= 6) {
                calib.width = Integer.parseInt(split[0]);
                calib.height = Integer.parseInt(split[1]);
                calib.planX1 = Double.parseDouble(split[2]);
                calib.planY1 = Double.parseDouble(split[3]);
                calib.planX2 = Double.parseDouble(split[4]);
                calib.planY2 = Double.parseDouble(split[5]);
            }
            if (split.length >= 10) {
                calib.method = 2;
                calib.geoX1 = Double.parseDouble(split[6]);
                calib.geoY1 = Double.parseDouble(split[7]);
                calib.geoX2 = Double.parseDouble(split[8]);
                calib.geoY2 = Double.parseDouble(split[9]);
            } else {
                calib.method = 1;
                calib.geoX1 = 0.0;
                calib.geoY1 = 0.0;
                calib.geoX2 = 100.0;
                calib.geoY2 = 100.0;
            }
        }
        return calib;
    }

    void setMethod(int method) {
        this.method = method;
    }
}

