/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.element;

import at.grid.cms.attribute.UploadAttribute;
import at.grid.cms.content.UploadItem;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.ThemisElement;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.report.PdfContent;
import at.grid.themis.ontology.report.Placeholder;
import at.grid.themis.ontology.report.ReportPageSetup;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.themis.ontology.signature.ThemisSignature;
import at.grid.util.Util;
import at.grid.util.XML;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.swing.filechooser.FileSystemView;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.openide.util.Exceptions;

public class CmsReport
extends ThemisElement {
    public static UUID DEFAULT_UUID = UUID.fromString("0ffba981-3bb4-4c5e-be6e-d094d6c89d2c");
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    public ThemisFilter filter;
    public String protTitel = "";
    public String protNummer = "";
    public String protKenntnis = "";
    public String protVerfasser = "";
    public String protVersion = "";
    public String protVerteiler = "";
    public String protDatum = "";
    public File exportFolder = null;
    public String exportFilename = "";
    public boolean exportCreateSubfolder = true;
    public ReportFormat exportFormat = ReportFormat.PDF_STANDARD;
    public ReportPageSetup pageFormat = new ReportPageSetup();
    public ArrayList<PdfContent> templatePdfLayout = new ArrayList();
    public Content contentType = Content.FILTER;
    public String sort;
    public String sort1;
    public String sort2;
    public String sort3;
    public String sortUse;
    public boolean exportLocationsWithoutObservations = false;
    public boolean exportOnlyLocations = false;
    public boolean exportWithHistories = false;
    public ImageIntegration exportImages = ImageIntegration.EVENT;
    public boolean showDateInImage = false;
    public CmsEvent event = null;
    public ArrayList<CmsEvent> periodEvents = new ArrayList();
    public boolean exportOnlyPlans = false;
    public boolean exportPlans = false;
    public PlanFormat exportPlanFormat = null;
    public int planTransparency = 2;
    public int pdfCompression = 2;
    public boolean exportEmptyPlans = false;
    public int planStampPosition = 0;
    public int planSnippetSize = 4;
    public int planSnippetSizeMM = 55;
    public int planIconSize = 15;
    public boolean planSnippetLabel = false;
    public boolean includeDocuments = false;
    public boolean hyperlinkOnFile = false;
    public ImageExport includeImages = ImageExport.NO;
    public String textObservationtypeMangel;
    public String textObservationtypeAufgabe;
    public String textObservationtypeKontrolle;
    public String textObservationtypeInfo;
    public String textNoEvent;
    public String textNoImage;
    public String textNoContent;
    public String textStatusOpen;
    public String textStatusDone;
    public LocalDate periodFromDate = null;
    public LocalDate periodUntilDate = null;
    public String periodYear = null;
    public String periodMonth = null;
    public boolean summaryReport = false;
    public List<ThemisFolder> projects = null;
    public ArrayList<ThemisSignature> signatures = new ArrayList();
    Placeholder ph = new Placeholder(this);
    private int numberOfImagesPerRow = 4;

    public CmsReport() {
        this(true);
    }

    public CmsReport(boolean doInitialise) {
        if (doInitialise) {
            this.planSnippetLabel = this.app.getSettings().getLocationAttribute("icon").isUsed();
            this.filter = this.app.getFilter();
            this.loadTextFromSettings();
        }
    }

    public String getTitle() {
        switch (this.exportFormat) {
            case EXCEL: {
                return "[XLS] " + this.getAttributeValue("name");
            }
            case WORD: {
                return "[DOC] " + this.getAttributeValue("name");
            }
            case PDF_STANDARD: {
                return "[PDF] " + this.getAttributeValue("name");
            }
            case PDF_EXTENDED: {
                return "[PDF] " + this.getAttributeValue("name");
            }
            case PDF_FREE: {
                return "[PDF] " + this.getAttributeValue("name");
            }
        }
        return this.getAttributeValue("name");
    }

    public void setLayoutName(String title) {
        this.setAttributeValue("name", title);
    }

    public String getLayoutName() {
        String n = this.getAttributeValue("name");
        if (n == null || "".equals(n)) {
            n = "Neues Berichtslayout";
        }
        return n;
    }

    public void setTemplateFile(File f) {
        if (f != null) {
            if (this.isFileNew(f)) {
                this.getUploadAttribute("reporttemplate").clear();
                this.getUploadAttribute("reporttemplate").addUpload(f);
                this.setAttributeValue("filereference", f.getAbsolutePath());
                this.setAttributeValue("filehash", Util.md5((File)f));
            }
        } else {
            this.getAttribute("reporttemplate").clear();
            this.getAttribute("filereference").clear();
            this.getAttribute("filehash").clear();
        }
    }

    public File getTemplateFile() {
        return this.getUploadAttribute("reporttemplate").getFirstUploadItemFile();
    }

    public File getTemplateFileFromSource() {
        String fn = this.getAttributeValue("filereference");
        return fn == null ? null : new File(fn);
    }

    public String getTemplateFilename() {
        UploadItem item = this.getUploadAttribute("reporttemplate").getFirstUploadItem();
        return item == null ? null : item.getName();
    }

    private boolean isFileNew(File f) {
        String md5;
        if (f != null && f.isFile() && (md5 = Util.md5((File)f)) != null) {
            return !md5.equals(this.getAttributeValue("filehash"));
        }
        return false;
    }

    public boolean hasNewTemplateVersion() {
        if (this.hasAttributeValue("filereference")) {
            return this.isFileNew(new File(this.getAttributeValue("filereference")));
        }
        return false;
    }

    public void updateTemplateFile() {
        File f = new File(this.getAttributeValue("filereference"));
        if (f.isFile()) {
            this.setTemplateFile(f);
            this.save();
        }
    }

    public boolean isTemplateFileValid() {
        File f = this.getTemplateFile();
        String nameTemplateFile = f == null ? null : f.getName().toLowerCase();
        boolean filetypeOk = false;
        switch (this.exportFormat) {
            case EXCEL: {
                filetypeOk = nameTemplateFile != null && (nameTemplateFile.endsWith(".xls") || nameTemplateFile.endsWith(".xlsx") || nameTemplateFile.endsWith(".xlsm"));
                break;
            }
            case WORD: {
                filetypeOk = nameTemplateFile != null && (nameTemplateFile.endsWith(".doc") || nameTemplateFile.endsWith(".docx"));
                break;
            }
            default: {
                filetypeOk = true;
            }
        }
        return filetypeOk;
    }

    public void postCreate() {
    }

    public void postLoad() {
        this.applyXml();
    }

    public void applyXml() {
        this.planSnippetLabel = this.app.getSettings().getLocationAttributeManager().isUsed("icon");
        this.filter = this.app.getFilter();
        this.loadTextFromSettings();
        this.setReportFromXml();
        UploadAttribute uploadAttribute = this.getUploadAttribute("reporttemplate");
        List uploadItems = uploadAttribute.getUploadItems();
        boolean debug = true;
    }

    public void postUpdate() {
        this.loadTextFromSettings();
        this.setReportFromXml();
    }

    public void preSave() {
        String s = Util.toXml((Element)this.getReportAsXml());
        this.setAttributeValue("xml", s);
        if (this.hasNewTemplateVersion()) {
            this.updateTemplateFile();
        }
        this.getUploadAttribute("reporttemplate").purge();
    }

    private final void loadTextFromSettings() {
        this.textStatusOpen = this.app.getSettings().getTerm(ThemisSettings.Term.StatusOffen);
        this.textStatusDone = this.app.getSettings().getTerm(ThemisSettings.Term.StatusErledigt);
        this.textObservationtypeMangel = this.app.getSettings().getTerm(ThemisSettings.Term.TypMangel);
        this.textObservationtypeAufgabe = this.app.getSettings().getTerm(ThemisSettings.Term.TypAufgabe);
        this.textObservationtypeKontrolle = this.app.getSettings().getTerm(ThemisSettings.Term.TypKontrolle);
        this.textObservationtypeInfo = this.app.getSettings().getTerm(ThemisSettings.Term.TypInformation);
        this.textNoEvent = this.app.getSettings().getTerm(ThemisSettings.Term.TextNoEvent);
        this.textNoImage = this.app.getSettings().getTerm(ThemisSettings.Term.TextNoImage);
        this.textNoContent = this.app.getSettings().getTerm(ThemisSettings.Term.TextNoContent);
    }

    public float getPdfCompressionValue() {
        switch (this.pdfCompression) {
            case 0: {
                return 1.0f;
            }
            case 1: {
                return 0.7f;
            }
            case 2: {
                return 0.5f;
            }
            case 3: {
                return 0.2f;
            }
            case 4: {
                return 0.05f;
            }
        }
        return 0.7f;
    }

    public int getPdfImageResolution() {
        switch (this.pdfCompression) {
            case 0: {
                return 400;
            }
            case 1: {
                return 300;
            }
            case 2: {
                return 300;
            }
            case 3: {
                return 200;
            }
            case 4: {
                return 150;
            }
        }
        return 300;
    }

    public float getTransparency() {
        switch (this.planTransparency) {
            case 0: {
                return 1.0f;
            }
            case 1: {
                return 0.75f;
            }
            case 2: {
                return 0.5f;
            }
            case 3: {
                return 0.15f;
            }
        }
        return 0.5f;
    }

    public String getSortSql() {
        if (this.sort != null && !"".equals(this.sort)) {
            return this.sort;
        }
        StringBuilder sb = new StringBuilder();
        if (this.sort1 != null && !"".equals(this.sort1)) {
            sb.append(this.sort1);
        }
        if (this.sort2 != null && !"".equals(this.sort2)) {
            sb.append(sb.length() > 0 ? "," : "").append(this.sort2);
        }
        if (this.sort3 != null && !"".equals(this.sort3)) {
            sb.append(sb.length() > 0 ? "," : "").append(this.sort3);
        }
        if (sb.length() == 0) {
            boolean useLocationPrefix = this.app.getSettings().getLocationAttribute("prefixsuffix").isUsed();
            boolean useLocationSuffix = this.app.getSettings().getLocationAttribute("suffix").isUsed();
            String numberSort = (useLocationPrefix ? "ele.prenumber," : "") + "ele.number" + (useLocationSuffix ? ",ele.postnumber" : "");
            return numberSort;
        }
        return sb.toString();
    }

    public boolean hasSort() {
        return this.sort != null && !"".equals(this.sort) || this.sort1 != null && !"".equals(this.sort1);
    }

    public int getPlanSnippetSize() {
        return (int)((float)(Math.max(10, this.planSnippetSizeMM) * 300) / 25.4f);
    }

    public File getExportFolder() {
        if (this.exportCreateSubfolder) {
            return new File(this.exportFolder, this.getFilename());
        }
        return this.exportFolder;
    }

    public String getFilename() {
        String fn = this.ph.apply(this.exportFilename).replace("/", "-").replace("\\", "-").trim();
        return fn;
    }

    public File getDestinationFile() {
        String fn = this.getFilename();
        if (fn == null || "".equals(fn)) {
            return null;
        }
        File fld = this.app.getSettings().getFolderReportOutput().getValue(true);
        if (this.exportCreateSubfolder) {
            fld = new File(fld, fn);
        }
        String extension = "pdf";
        switch (this.exportFormat) {
            case EXCEL: 
            case WORD: {
                File f = this.getTemplateFile();
                extension = Util.getFileExtension((File)f);
                break;
            }
            case PDF_STANDARD: 
            case PDF_EXTENDED: 
            case PDF_FREE: 
            case PDF_STANDARD_OPEN: {
                extension = "pdf";
            }
        }
        if (!fn.toLowerCase().endsWith("." + extension.toLowerCase())) {
            fn = fn + "." + extension;
        }
        return new File(fld, fn);
    }

    public boolean hasEvent() {
        return this.event != null || !this.periodEvents.isEmpty();
    }

    public CmsEvent getLastEvent() {
        if (this.event != null) {
            return this.event;
        }
        if (!this.periodEvents.isEmpty()) {
            return this.periodEvents.get(this.periodEvents.size() - 1);
        }
        return null;
    }

    public Element getReportAsXml() {
        Element reportspec = new Element("reportspec");
        Element report = new Element("report");
        reportspec.addContent((org.jdom.Content)report);
        report.addContent((org.jdom.Content)new Element("title").setText(this.protTitel));
        report.addContent((org.jdom.Content)new Element("number").setText(this.protNummer));
        report.addContent((org.jdom.Content)new Element("author").setText(this.protVerfasser));
        report.addContent((org.jdom.Content)new Element("version").setText(this.protVersion));
        report.addContent((org.jdom.Content)new Element("distribution").setText(this.protVerteiler));
        report.addContent((org.jdom.Content)new Element("information").setText(this.protKenntnis));
        report.addContent((org.jdom.Content)new Element("date").setText(this.protDatum));
        Element sigs = new Element("signatures");
        reportspec.addContent((org.jdom.Content)sigs);
        for (ThemisSignature sig : this.signatures) {
            sigs.addContent((org.jdom.Content)new Element("signature").setAttribute("name", sig.getName()).setAttribute("funktion", sig.getFunction()));
        }
        Element export = new Element("export");
        reportspec.addContent((org.jdom.Content)export);
        export.addContent((org.jdom.Content)new Element("folder").setText(this.exportFolder == null ? FileSystemView.getFileSystemView().getDefaultDirectory().getAbsoluteFile().getAbsolutePath() : this.exportFolder.getAbsolutePath()));
        export.addContent((org.jdom.Content)new Element("filename").setText(this.exportFilename));
        export.addContent((org.jdom.Content)new Element("subfolder").setText(this.exportCreateSubfolder ? "yes" : "no"));
        switch (this.exportFormat) {
            case EXCEL: {
                export.addContent((org.jdom.Content)new Element("format").setText("xls"));
                break;
            }
            case WORD: {
                export.addContent((org.jdom.Content)new Element("format").setText("doc"));
                break;
            }
            case PDF_STANDARD: {
                export.addContent((org.jdom.Content)new Element("format").setText("pdf"));
                break;
            }
            case PDF_STANDARD_OPEN: {
                export.addContent((org.jdom.Content)new Element("format").setText("pdf2"));
                break;
            }
            case PDF_EXTENDED: {
                export.addContent((org.jdom.Content)new Element("format").setText("pdfextended"));
                break;
            }
            case PDF_FREE: {
                export.addContent((org.jdom.Content)new Element("format").setText("pdffree"));
            }
        }
        export.addContent((org.jdom.Content)new Element("templatefile").setText(this.getAttributeValue("filereference", "")));
        Element layout = new Element("layout");
        reportspec.addContent((org.jdom.Content)layout);
        Element layoutPdf = new Element("pdf");
        layout.addContent((org.jdom.Content)layoutPdf);
        for (PdfContent pdf : this.templatePdfLayout) {
            if (pdf == null) continue;
            layoutPdf.addContent((org.jdom.Content)pdf.toXml());
        }
        layout.addContent((org.jdom.Content)this.pageFormat.toXml());
        Element content = new Element("content");
        reportspec.addContent((org.jdom.Content)content);
        switch (this.contentType) {
            case EVENT: {
                content.addContent((org.jdom.Content)new Element("contenttype").setText("event"));
                if (this.event == null) break;
                content.addContent((org.jdom.Content)new Element("event").setText(Long.toString(this.event.getId())));
                break;
            }
            case FILTER: {
                content.addContent((org.jdom.Content)new Element("contenttype").setText("filter"));
                break;
            }
            case SELECTION: {
                content.addContent((org.jdom.Content)new Element("contenttype").setText("selection"));
                break;
            }
            case PERIOD: {
                content.addContent((org.jdom.Content)new Element("contenttype").setText("period").setAttribute("month", this.periodMonth).setAttribute("year", this.periodYear));
            }
        }
        content.addContent((org.jdom.Content)new Element("withhistory").setText(this.exportWithHistories ? "yes" : "no"));
        content.addContent((org.jdom.Content)new Element("locationwithoutobservation").setText(this.exportLocationsWithoutObservations ? "yes" : "no"));
        Element imageElement = new Element("images");
        switch (this.exportImages) {
            case ALL: {
                imageElement.setText("all");
                break;
            }
            case EVENT: {
                imageElement.setText("event");
                break;
            }
            case LAST: {
                imageElement.setText("last");
                break;
            }
            default: {
                imageElement.setText("all");
            }
        }
        imageElement.setAttribute("withdate", this.showDateInImage ? "yes" : "no");
        content.addContent((org.jdom.Content)imageElement);
        Element contentSort = new Element("sort").setText(this.sort == null ? "" : this.sort);
        contentSort.setAttribute("sort1", this.sort1 == null ? "" : this.sort1);
        contentSort.setAttribute("sort2", this.sort2 == null ? "" : this.sort2);
        contentSort.setAttribute("sort3", this.sort3 == null ? "" : this.sort3);
        content.addContent((org.jdom.Content)contentSort);
        Element plan = new Element("plan");
        reportspec.addContent((org.jdom.Content)plan);
        if (this.exportPlans) {
            switch (this.exportPlanFormat) {
                case JPG: {
                    plan.addContent((org.jdom.Content)new Element("export").setText("jpg"));
                    break;
                }
                case SINGLEPDF: {
                    plan.addContent((org.jdom.Content)new Element("export").setText("singlepdf"));
                    break;
                }
                case MULTIPLEPDF: {
                    plan.addContent((org.jdom.Content)new Element("export").setText("multiplepdf"));
                }
            }
        } else {
            plan.addContent((org.jdom.Content)new Element("export").setText("no"));
        }
        plan.addContent((org.jdom.Content)new Element("emptyPlans").setText(this.exportEmptyPlans ? "yes" : "no"));
        plan.addContent((org.jdom.Content)new Element("transparency").setText(Integer.toString(this.planTransparency)));
        plan.addContent((org.jdom.Content)new Element("compression").setText(Integer.toString(this.pdfCompression)));
        plan.addContent((org.jdom.Content)new Element("infostamp").setText(Integer.toString(this.planStampPosition)));
        Element plansnippt = new Element("plansnippet");
        reportspec.addContent((org.jdom.Content)plansnippt);
        plansnippt.addContent((org.jdom.Content)new Element("sizemm").setText(Integer.toString(this.planSnippetSizeMM)));
        plansnippt.addContent((org.jdom.Content)new Element("iconsize").setText(Integer.toString(this.planIconSize)));
        plansnippt.addContent((org.jdom.Content)new Element("label").setText(this.planSnippetLabel ? "yes" : "no"));
        Element options = new Element("options");
        reportspec.addContent((org.jdom.Content)options);
        options.addContent((org.jdom.Content)new Element("documents").setText(this.includeDocuments ? "yes" : "no"));
        if (this.hyperlinkOnFile) {
            options.addContent((org.jdom.Content)new Element("documentlink").setText("folder"));
        } else {
            options.addContent((org.jdom.Content)new Element("documentlink").setText("document"));
        }
        switch (this.includeImages) {
            case FILENAME: {
                options.addContent((org.jdom.Content)new Element("images").setText("filename"));
                break;
            }
            case NUMBER: {
                options.addContent((org.jdom.Content)new Element("images").setText("number"));
                break;
            }
            default: {
                options.addContent((org.jdom.Content)new Element("images").setText("no"));
            }
        }
        String s = Util.toXml((Element)reportspec);
        return reportspec;
    }

    public void setReportFromXml() {
        if (this.hasAttribute("xml")) {
            String xmlString = this.getAttributeValue("xml");
            Element xml = null;
            try {
                xml = Util.fromXml((String)xmlString);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (xml != null) {
                this.setReportFromXml(xml);
            }
        }
    }

    public void setReportFromXml(Element xml) {
        Element sortElement;
        Element content;
        if (xml == null) {
            this.clear();
            return;
        }
        String s = Util.toXml((Element)xml);
        String prefix = "/themis/project";
        prefix = "";
        try {
            xml = Util.fromXml((String)s);
        }
        catch (JDOMException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.protTitel = XML.getXPathElementText((Element)xml, (String)(prefix + "/reportspec/report/title"), (String)"");
        if (ThemisLicense.isLicenseLevelExact(ThemisLicense.LicenseLevel.FULL)) {
            this.protNummer = XML.getXPathElementText((Element)xml, (String)(prefix + "/reportspec/report/number"), (String)"");
            this.protVerfasser = XML.getXPathElementText((Element)xml, (String)(prefix + "/reportspec/report/author"), (String)"");
            this.protVersion = XML.getXPathElementText((Element)xml, (String)(prefix + "/reportspec/report/version"), (String)"");
            this.protVerteiler = XML.getXPathElementText((Element)xml, (String)(prefix + "/reportspec/report/distribution"), (String)"");
            this.protKenntnis = XML.getXPathElementText((Element)xml, (String)(prefix + "/reportspec/report/information"), (String)"");
            this.protDatum = XML.getXPathElementText((Element)xml, (String)(prefix + "/reportspec/report/date"), (String)"");
            Object sigs = XML.getXPathElements((Element)xml, (String)(prefix + "/reportspec/signatures/signature"));
            this.signatures.clear();
            Iterator iterator = sigs.iterator();
            while (iterator.hasNext()) {
                Element sig = (Element)iterator.next();
                this.signatures.add(new ThemisSignature(sig.getAttributeValue("name", ""), sig.getAttributeValue("funktion", "")));
            }
        }
        this.exportFolder = new File(XML.getXPathElementText((Element)xml, (String)(prefix + "/reportspec/export/folder"), (String)this.app.getSettings().getFolderProjectRoot().getValueAsPath(true)));
        this.exportFilename = XML.getXPathElementText((Element)xml, (String)(prefix + "/reportspec/export/filename"), (String)"");
        this.exportCreateSubfolder = XML.getXPathElementBoolean((Element)xml, (String)(prefix + "/reportspec/export/subfolder"), (boolean)true);
        switch (XML.getXPathElementText((Element)xml, (String)(prefix + "/reportspec/export/format"), (String)"pdf").toLowerCase()) {
            case "pdf": {
                this.exportFormat = ReportFormat.PDF_STANDARD;
                break;
            }
            case "pdf2": {
                this.exportFormat = ReportFormat.PDF_STANDARD_OPEN;
                break;
            }
            case "pdfextended": {
                this.exportFormat = ReportFormat.PDF_EXTENDED;
                break;
            }
            case "pdffree": {
                this.exportFormat = ReportFormat.PDF_FREE;
                break;
            }
            case "xls": {
                this.exportFormat = ReportFormat.EXCEL;
                break;
            }
            case "doc": {
                this.exportFormat = ReportFormat.WORD;
                break;
            }
            default: {
                this.exportFormat = ReportFormat.PDF_STANDARD;
            }
        }
        if (ThemisLicense.isLicenseLevelLessThan(ThemisLicense.LicenseLevel.FULL)) {
            this.exportFormat = ReportFormat.PDF_STANDARD;
        }
        String fn = XML.getXPathElementText((Element)xml, (String)"/reportspec/export/templatefile", null);
        String fndoc = XML.getXPathElementText((Element)xml, (String)"/reportspec/export/templatedocfile", null);
        String fnxls = XML.getXPathElementText((Element)xml, (String)"/reportspec/export/templatexlsfile", null);
        File f = null;
        if (fn != null && !fn.isEmpty()) {
            f = new File(fn);
        } else if (fndoc != null && !fndoc.isEmpty()) {
            f = new File(fndoc);
        } else if (fnxls != null && !fnxls.isEmpty()) {
            f = new File(fnxls);
        }
        if (f != null && f.isFile()) {
            this.setTemplateFile(f);
        }
        if (this.exportFormat == ReportFormat.PDF_STANDARD && XML.getXPathElementBoolean((Element)xml, (String)(prefix + "/reportspec/export/pdfextended"), (boolean)false)) {
            this.exportFormat = ReportFormat.PDF_FREE;
            if (ThemisLicense.isLicenseLevelLessThan(ThemisLicense.LicenseLevel.FULL)) {
                this.exportFormat = ReportFormat.PDF_STANDARD;
            }
        }
        if (ThemisLicense.isLicenseLevelExact(ThemisLicense.LicenseLevel.FULL)) {
            this.layoutFromXml(xml, false);
        }
        if ((content = XML.getXPathElement((Element)xml, (String)(prefix + "/reportspec/content/contenttype"))) != null) {
            switch (content.getText()) {
                case "filter": {
                    this.contentType = Content.FILTER;
                    break;
                }
                case "event": {
                    this.contentType = Content.EVENT;
                    break;
                }
                case "selection": {
                    this.contentType = Content.SELECTION;
                    break;
                }
                case "period": {
                    this.contentType = Content.PERIOD;
                    this.setPeriod(content.getAttributeValue("month"), content.getAttributeValue("year"));
                    break;
                }
                default: {
                    this.contentType = Content.FILTER;
                }
            }
        }
        if (ThemisLicense.isLicenseLevelExact(ThemisLicense.LicenseLevel.FULL)) {
            this.exportWithHistories = XML.getXPathElementBoolean((Element)xml, (String)(prefix + "/reportspec/content/withhistory"), (boolean)false);
            this.exportLocationsWithoutObservations = XML.getXPathElementBoolean((Element)xml, (String)(prefix + "/reportspec/content/locationwithoutobservation"), (boolean)false);
            Element imageElement = XML.getXPathElement((Element)xml, (String)(prefix + "/reportspec/content/images"));
            if (imageElement != null) {
                String imageElementText = imageElement.getText();
                if (imageElementText == null) {
                    imageElementText = "all";
                }
                String imageElementShowDate = imageElement.getAttributeValue("withdate");
                switch (imageElementText.toLowerCase()) {
                    case "all": {
                        this.exportImages = ImageIntegration.ALL;
                        break;
                    }
                    case "event": {
                        this.exportImages = ImageIntegration.EVENT;
                        break;
                    }
                    case "last": {
                        this.exportImages = ImageIntegration.LAST;
                        break;
                    }
                    default: {
                        this.exportImages = ImageIntegration.ALL;
                    }
                }
                this.showDateInImage = "yes".equals(imageElementShowDate) || "ja".equals(imageElementShowDate) || "x".equals(imageElementShowDate);
            } else {
                this.exportImages = ImageIntegration.ALL;
                this.showDateInImage = false;
            }
        }
        if ((sortElement = XML.getXPathElement((Element)xml, (String)(prefix + "/reportspec/content/sort"))) != null) {
            this.sort = sortElement.getText();
            this.sort1 = sortElement.getAttributeValue("sort1");
            this.sort2 = sortElement.getAttributeValue("sort2");
            this.sort3 = sortElement.getAttributeValue("sort3");
        }
        if (!ThemisLicense.isLicenseLevelExact(ThemisLicense.LicenseLevel.NONE)) {
            switch (XML.getXPathElementText((Element)xml, (String)(prefix + "/reportspec/plan/export"), (String)"no").toLowerCase()) {
                case "jpg": {
                    this.exportPlans = true;
                    this.exportPlanFormat = PlanFormat.JPG;
                    break;
                }
                case "singlepdf": {
                    this.exportPlans = true;
                    this.exportPlanFormat = PlanFormat.SINGLEPDF;
                    break;
                }
                case "multiplepdf": {
                    this.exportPlans = true;
                    this.exportPlanFormat = PlanFormat.MULTIPLEPDF;
                    break;
                }
                default: {
                    this.exportPlans = false;
                    this.exportPlanFormat = PlanFormat.MULTIPLEPDF;
                }
            }
            this.exportEmptyPlans = XML.getXPathElementBoolean((Element)xml, (String)(prefix + "/reportspec/plan/emptyPlans"), (boolean)false);
            XML.getXPathElementInt((Element)xml, (String)(prefix + "/reportspec/plan/transparency"), (int)0);
            this.planTransparency = XML.getXPathElementInt((Element)xml, (String)(prefix + "/reportspec/plan/transparency"), (int)2);
            this.pdfCompression = XML.getXPathElementInt((Element)xml, (String)(prefix + "/reportspec/plan/compression"), (int)0);
            this.planStampPosition = XML.getXPathElementInt((Element)xml, (String)(prefix + "/reportspec/plan/infostamp"), (int)0);
            this.planSnippetSizeMM = XML.getXPathElementInt((Element)xml, (String)(prefix + "/reportspec/plansnippet/sizemm"), (int)50);
            this.planIconSize = XML.getXPathElementInt((Element)xml, (String)(prefix + "/reportspec/plansnippet/iconsize"), (int)10);
            if (this.planSnippetSizeMM == 0) {
                int idx = XML.getXPathElementInt((Element)xml, (String)(prefix + "/reportspec/plansnippet/size"), (int)0);
                switch (idx) {
                    case 0: {
                        this.planSnippetSizeMM = 17;
                        break;
                    }
                    case 1: {
                        this.planSnippetSizeMM = 25;
                        break;
                    }
                    case 3: {
                        this.planSnippetSizeMM = 42;
                        break;
                    }
                    case 4: {
                        this.planSnippetSizeMM = 55;
                        break;
                    }
                    default: {
                        this.planSnippetSizeMM = 34;
                    }
                }
            }
            this.planSnippetLabel = XML.getXPathElementBoolean((Element)xml, (String)(prefix + "/reportspec/plansnippet/label"), (boolean)true);
        }
        if (ThemisLicense.isLicenseLevelExact(ThemisLicense.LicenseLevel.FULL)) {
            this.includeDocuments = XML.getXPathElementBoolean((Element)xml, (String)(prefix + "/reportspec/options/documents"), (boolean)false);
            this.hyperlinkOnFile = "document".equalsIgnoreCase(XML.getXPathElementText((Element)xml, (String)(prefix + "/reportspec/options/documentlink"), (String)"folder"));
            switch (XML.getXPathElementText((Element)xml, (String)(prefix + "/reportspec/options/images"), (String)"no").toLowerCase()) {
                case "no": {
                    this.includeImages = ImageExport.NO;
                    break;
                }
                case "filename": {
                    this.includeImages = ImageExport.FILENAME;
                    break;
                }
                case "number": {
                    this.includeImages = ImageExport.NUMBER;
                    break;
                }
                default: {
                    this.includeImages = ImageExport.NO;
                }
            }
        }
    }

    public void layoutFromXml(Element xml, boolean add) {
        this.layoutFromXml(xml, add, null);
    }

    public void layoutFromXml(Element xml, boolean add, HashMap<String, String> renamedFilter) {
        Element pageFormatXml;
        Element pagesizeXml;
        String s = Util.toXml((Element)xml);
        String prefix = "";
        Element pdfs = XML.getXPathElement((Element)xml, (String)(prefix + "/reportspec/layout/pdf"));
        if (!add) {
            this.templatePdfLayout.clear();
        }
        if (pdfs != null) {
            for (Element pdf : pdfs.getChildren()) {
                this.templatePdfLayout.add(PdfContent.fromXml(pdf));
            }
        }
        if (this.pageFormat == null) {
            this.pageFormat = new ReportPageSetup();
        }
        if ((pagesizeXml = XML.getXPathElement((Element)xml, (String)(prefix + "/reportspec/layout/pagesize"))) != null) {
            int pagesize = Util.parseInt((String)pagesizeXml.getAttributeValue("option", "0"), (int)0);
            switch (pagesize) {
                case 1: {
                    this.pageFormat.size = ReportPageSetup.PageSize.DINA4;
                    this.pageFormat.orientation = ReportPageSetup.PageOrientation.LANDSCAPE;
                    break;
                }
                case 2: {
                    this.pageFormat.size = ReportPageSetup.PageSize.DINA3;
                    this.pageFormat.orientation = ReportPageSetup.PageOrientation.PORTRAIT;
                    break;
                }
                default: {
                    this.pageFormat.size = ReportPageSetup.PageSize.DINA4;
                    this.pageFormat.orientation = ReportPageSetup.PageOrientation.PORTRAIT;
                }
            }
        }
        if ((pageFormatXml = XML.getXPathElement((Element)xml, (String)(prefix + "/reportspec/layout/pageformat"))) != null) {
            this.pageFormat.fromXml(pageFormatXml);
        }
    }

    public boolean hasSignature() {
        for (ThemisSignature sig : this.signatures) {
            if (sig.getSignature() == null) continue;
            return true;
        }
        return false;
    }

    public File getSignatureFile(int idx) {
        if (this.signatures.size() > idx) {
            return this.signatures.get(idx).getSignatureFile();
        }
        return null;
    }

    public ThemisSignature getSignature(int idx) {
        if (this.signatures.size() > idx) {
            return this.signatures.get(idx);
        }
        return null;
    }

    public String getPeriodAsString() {
        if (this.periodFromDate == null || this.periodUntilDate == null) {
            this.setPeriod(null, null);
        }
        return this.periodFromDate.format(DateTimeFormatter.ofPattern("dd.MM.yyyy")) + " - " + this.periodUntilDate.format(DateTimeFormatter.ofPattern("dd.MM.yyyy"));
    }

    public void setPeriod(String period, String yearStr) {
        int year = Calendar.getInstance().get(1);
        if (period == null) {
            period = "jahr";
        }
        if (yearStr != null) {
            year = Util.parseInt((String)yearStr, (int)0);
        }
        this.periodYear = Integer.toString(year);
        this.periodMonth = period;
        if (year == 0) {
            Object dt = new Date();
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(((Date)dt).getTime());
            year = cal.get(1);
        }
        switch (period.toLowerCase()) {
            case "jahr": {
                this.periodFromDate = LocalDate.of(year, 1, 1);
                this.periodUntilDate = LocalDate.of(year, 12, 31);
                break;
            }
            case "q1": {
                this.periodFromDate = LocalDate.of(year, 1, 1);
                this.periodUntilDate = LocalDate.of(year, 3, 31);
                break;
            }
            case "q2": {
                this.periodFromDate = LocalDate.of(year, 4, 1);
                this.periodUntilDate = LocalDate.of(year, 6, 30);
                break;
            }
            case "q3": {
                this.periodFromDate = LocalDate.of(year, 7, 1);
                this.periodUntilDate = LocalDate.of(year, 9, 30);
                break;
            }
            case "q4": {
                this.periodFromDate = LocalDate.of(year, 10, 1);
                this.periodUntilDate = LocalDate.of(year, 12, 31);
                break;
            }
            default: {
                int month = Util.parseInt((String)period, (int)1);
                this.periodFromDate = LocalDate.of(year, month, 1);
                this.periodUntilDate = LocalDate.of(year, month + 1, 1).minusDays(1L);
            }
        }
        this.periodEvents.clear();
        ArrayList eventIds = this.project.getEventSearchResult(this.getPeriodFromDate(), this.getPeriodUntilDate()).getResultIds();
        Iterator iterator = eventIds.iterator();
        while (iterator.hasNext()) {
            long eventId = (Long)iterator.next();
            this.periodEvents.add((CmsEvent)this.project.loadElement(eventId, this.project.getUser()));
        }
    }

    public Date getPeriodFromDate() {
        if (this.periodFromDate == null) {
            this.setPeriod(null, null);
        }
        return Date.from(this.periodFromDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public Date getPeriodUntilDate() {
        if (this.periodUntilDate == null) {
            this.setPeriod(null, null);
        }
        return Date.from(this.periodUntilDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public int getPeriodYear() {
        int year = Util.parseInt((String)this.periodYear, (int)0);
        if (year == 0) {
            Date dt = new Date();
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(dt.getTime());
            year = cal.get(1);
        }
        return year;
    }

    public ArrayList<Long> getPeriodEventIds() {
        ArrayList<Long> result = new ArrayList<Long>();
        if (this.periodEvents != null) {
            for (CmsEvent e : this.periodEvents) {
                result.add(e.getId());
            }
        }
        return result;
    }

    public static CmsReport createDefaultReportLayout() {
        CmsReport rep = (CmsReport)ThemisApplication.getInstance().getProject().createElementWithoutId("report", ThemisApplication.getInstance().getProject().getUser());
        rep.exportFormat = ReportFormat.PDF_STANDARD;
        rep.exportPlans = true;
        rep.exportCreateSubfolder = true;
        return rep;
    }

    public void setNumberOfImagesPerRow(int n) {
        this.numberOfImagesPerRow = n;
    }

    public int getNumberOfImagesPerRow() {
        return this.numberOfImagesPerRow;
    }

    public static enum ListPagebreak {
        ZERO(0, "-"),
        ONE(1, "nach jedem Eintrag"),
        TWO(2, "nach 2 Eintr\u00e4gen"),
        THREE(3, "nach 3 Eintr\u00e4gen");

        String label;
        int count;

        private ListPagebreak(int c, String lbl) {
            this.count = c;
            this.label = lbl;
        }

        public int getCount() {
            return this.count;
        }

        public String toString() {
            return this.label;
        }

        public static ListPagebreak getPagebreak(int count) {
            switch (count) {
                case 0: {
                    return ZERO;
                }
                case 1: {
                    return ONE;
                }
                case 2: {
                    return TWO;
                }
                case 3: {
                    return THREE;
                }
            }
            return ZERO;
        }
    }

    public static enum ListFilter {
        NONE("none", "-"),
        DUEDATE("duedate", "F\u00e4lligkeit"),
        MANGEL("mangel", "Mangel"),
        TODO("todo", "Todo");

        String label;
        String code;

        private ListFilter(String c, String lbl) {
            this.code = c;
            this.label = lbl;
        }

        public String getCode() {
            return this.code;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum ImageExport {
        NO,
        NUMBER,
        FILENAME;

    }

    public static enum ImageIntegration {
        ALL,
        EVENT,
        LAST;

    }

    public static enum PlanFormat {
        SINGLEPDF,
        MULTIPLEPDF,
        JPG;

    }

    public static enum ReportFormat {
        EXCEL,
        WORD,
        PDF_STANDARD_OPEN,
        PDF_STANDARD,
        PDF_EXTENDED,
        PDF_FREE;

    }

    public static enum Content {
        FILTER,
        SELECTION,
        EVENT,
        PERIOD;

    }
}

