/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.element;

import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisLogger;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.license.ThemisLicense;
import java.util.Properties;

public abstract class ThemisElement
extends CmsElement {
    Properties props;
    protected ThemisApplication themis = ThemisApplication.getInstance();

    public boolean save(boolean forcesave, boolean ignoreRelations) {
        if (!ThemisLicense.isLicenseLevelExact(ThemisLicense.LicenseLevel.NONE)) {
            String oldMD5 = this.getMD5();
            if (super.save(forcesave, ignoreRelations)) {
                long eventId;
                if (this.hasChanged(oldMD5) && (eventId = this.getProject().getCurrentEventId()) > 0L) {
                    this.getProject().getDatastorage().addEventReference(eventId, this.getId());
                }
                return true;
            }
            return false;
        }
        ThemisLogger.logger.severe("Cannot save element, no license to edit content");
        return false;
    }

    public void setAttributes(Properties props) {
        super.setAttributes(props);
        this.props = props;
    }

    public void setAttributesFromProperties() {
        if (this.props != null) {
            this.setAttributes(this.props);
        }
    }

    protected ThemisProject getProject() {
        return (ThemisProject)this.getApplication();
    }

    protected ThemisApplication getThemisApplication() {
        return ThemisApplication.getInstance();
    }

    public String toFormattedString() {
        StringBuilder sb = new StringBuilder();
        sb.append("##").append(this.getElementcode()).append(".").append("uuid").append("##\n").append(this.getUUID().toString()).append("\n");
        for (CmsAttribute att : this.getDataAttributes()) {
            if (att.isOfType(17) || att.isHidden()) continue;
            sb.append("##").append(this.getElementcode()).append(".").append(att.getCode()).append("##\n").append(att.getValue()).append("\n");
        }
        return sb.toString();
    }
}

