/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.filter;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.storage.SearchResult;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.cms.util.Pair;
import at.grid.themis.ontology.ColorOption;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisColors;
import at.grid.themis.ontology.ThemisLogger;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsFilter;
import at.grid.themis.ontology.filter.ThemisFilterBoolean;
import at.grid.themis.ontology.filter.ThemisFilterDate;
import at.grid.themis.ontology.filter.ThemisFilterListItem;
import at.grid.util.Util;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openide.util.Exceptions;

public class ThemisFilter {
    public static final int STATUS_NOTSET = 0;
    public static final int STATUS_OPEN = 1;
    public static final int STATUS_OPEN_INFO = 2;
    public static final int STATUS_OPEN_CHECK = 3;
    public static final int STATUS_DONE = 4;
    public static final int LOCATION_VISIBILITY_NOTSET = 0;
    public static final int LOCATION_VISIBILITY_DELETED = 1;
    public static final int LOCATION_VISIBILITY_ALL = 2;
    public static final int EVENT_DATE_CONTROLLED = 0;
    public static final int EVENT_DATE_NOTCONTROLLED = 1;
    public static final int EVENT_DATE_CREATED = 2;
    public static final int EVENT_DATE_TODO = 3;
    public static final int EVENT_DATE_PLANNED = 4;
    ThemisApplication app;
    ThemisProject project;
    protected boolean showdeleted = false;
    protected boolean showAll = false;
    ThemisFilterListItem eventId;
    protected int eventOption = 0;
    protected int eventYear = -1;
    protected int eventMonth = 0;
    protected int eventQuarter = 0;
    protected Date eventFromDate = null;
    protected Date eventUntilDate = null;
    protected boolean currentEvent = false;
    protected ArrayList<Long> observationIds = new ArrayList();
    protected ArrayList<Long> locationIds = new ArrayList();
    ThemisFilterListItem companyId;
    protected Date duedate;
    protected String obsTitle;
    protected String obsTextFilter;
    protected String obsCode;
    protected String obsFreetext1;
    protected String obsFreetext2;
    protected String obsFreetext3;
    protected String obsLangtext1;
    protected String obsLangtext2;
    protected String obsAmount;
    protected String obsRisk;
    protected int status;
    ThemisFilterListItem obsRealType;
    ThemisFilterListItem topic;
    ThemisFilterListItem obsType;
    ThemisFilterListItem priority;
    protected List<Pair<Long, Long>> locRanges = new ArrayList<Pair<Long, Long>>();
    protected String locationTitle;
    ThemisFilterListItem locGroup;
    protected String locTextFilter;
    protected ThemisFilterListItem planId;
    boolean currentPlanFilter = false;
    protected String locText1;
    protected String locText2;
    protected String locText3;
    protected String locText4;
    protected String locLongtext1;
    protected String locLongtext2;
    protected String locLongtext3;
    protected String locLongtext4;
    protected String locBarcode;
    ThemisFilterListItem locList1;
    ThemisFilterListItem locList2;
    ThemisFilterListItem locList3;
    ThemisFilterListItem locList4;
    protected ThemisFilterBoolean locFlag1 = new ThemisFilterBoolean(this, this.app);
    protected ThemisFilterBoolean locFlag2 = new ThemisFilterBoolean(this, this.app);
    protected ThemisFilterBoolean locFlag3 = new ThemisFilterBoolean(this, this.app);
    protected ThemisFilterBoolean locFlag4 = new ThemisFilterBoolean(this, this.app);
    protected ThemisFilterDate locDate1 = null;
    protected ThemisFilterDate locDate2 = null;
    protected ThemisFilterDate locDate3 = null;
    protected ThemisFilterDate locDate4 = null;
    protected ThemisFilterListItem locBuildingId;
    protected boolean externalModification = false;
    private boolean triggerEnabled = true;
    ArrayList<Long> filteredlocationids = new ArrayList();
    ArrayList<DataRecord> filteredLocationRecords = null;
    List<DataRecord> filteredObservationRecords = null;
    String previousLocationSort = null;
    String previousLocationWhere = null;
    String previousObservationSort = null;
    String previousObservationWhere = null;
    private boolean empty = true;
    ThemisFilter lastFilter = null;
    private boolean emptyLocations = true;
    ArrayList<ThemisAttribute> observationListAttributes = new ArrayList();
    private CmsFilter filterElement = null;

    public ThemisFilter(ThemisApplication app, boolean trigger, boolean createLastFilter) {
        this.app = app;
        this.project = app.getProject();
        this.triggerEnabled = trigger;
        this.planId = new ThemisFilterListItem(this, app);
        this.locBuildingId = new ThemisFilterListItem(this, app);
        this.eventId = new ThemisFilterListItem(this, app);
        this.companyId = new ThemisFilterListItem(this, app);
        this.obsRealType = new ThemisFilterListItem(this, app);
        this.obsType = new ThemisFilterListItem(this, app);
        this.priority = new ThemisFilterListItem(this, app);
        this.topic = new ThemisFilterListItem(this, app);
        this.locGroup = new ThemisFilterListItem(this, app);
        this.locList1 = new ThemisFilterListItem(this, app);
        this.locList2 = new ThemisFilterListItem(this, app);
        this.locList3 = new ThemisFilterListItem(this, app);
        this.locList4 = new ThemisFilterListItem(this, app);
        this.locDate1 = new ThemisFilterDate(this);
        this.locDate2 = new ThemisFilterDate(this);
        this.locDate3 = new ThemisFilterDate(this);
        this.locDate4 = new ThemisFilterDate(this);
        this.clearAll(trigger, null);
        if (createLastFilter) {
            this.lastFilter = new ThemisFilter(app, false, false);
        }
    }

    public ThemisFilter(ThemisApplication app, boolean trigger) {
        this(app, trigger, true);
    }

    public ThemisFilter(ThemisApplication app) {
        this(app, true, true);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isEmpty2() {
        if (this.currentEvent || !this.eventId.isEmpty() || this.eventYear > 0 || this.eventMonth > 0 || this.eventQuarter > 0 || this.eventFromDate != null || this.eventUntilDate != null) {
            return false;
        }
        if (this.currentPlanFilter) {
            return false;
        }
        if (!("".equals(this.locationTitle) && "".equals(this.locTextFilter) && this.locGroup.isEmpty() && this.planId.isEmpty() && "".equals(this.locText1) && "".equals(this.locText2) && "".equals(this.locText3) && "".equals(this.locText4) && "".equals(this.locLongtext1) && "".equals(this.locLongtext2) && "".equals(this.locLongtext3) && "".equals(this.locLongtext4) && this.locFlag1.isEmpty() && this.locFlag2.isEmpty() && this.locFlag3.isEmpty() && this.locFlag4.isEmpty() && this.locList1.isEmpty() && this.locList2.isEmpty() && this.locList3.isEmpty() && this.locList4.isEmpty() && this.locRanges.isEmpty() && this.locDate1.isEmpty() && this.locDate2.isEmpty() && this.locDate3.isEmpty() && this.locDate4.isEmpty() && "".equals(this.locBarcode) && this.locBuildingId.isEmpty())) {
            return false;
        }
        return "".equals(this.obsTitle) && "".equals(this.obsTextFilter) && this.companyId.isEmpty() && this.duedate == null && "".equals(this.obsCode) && "".equals(this.obsFreetext1) && "".equals(this.obsFreetext2) && "".equals(this.obsFreetext3) && "".equals(this.obsLangtext1) && "".equals(this.obsLangtext2) && "".equals(this.obsAmount) && "".equals(this.obsRisk) && this.status == 0 && this.priority.isEmpty() && this.obsType.isEmpty() && this.obsRealType.isEmpty() && this.topic.isEmpty() && this.observationIds.isEmpty();
    }

    public void updateObservationListAttributes() {
        this.observationListAttributes = this.app.getSettings().getObservationTableAttributes();
    }

    public void reapply() {
        if (this.lastFilter != null && this.isEmpty()) {
            this.setFilter(this.lastFilter);
            this.lastFilter.clearAll(false, null);
        }
    }

    public ThemisFilter getCopy() {
        ThemisFilter f = new ThemisFilter(this.app, false);
        f.currentEvent = this.currentEvent;
        f.eventId.setList(this.eventId.getList());
        f.companyId.setList(this.companyId.getList());
        f.locGroup.setList(this.locGroup.getList());
        f.locList1.setList(this.locList1.getList());
        f.locList2.setList(this.locList2.getList());
        f.locList3.setList(this.locList3.getList());
        f.locList4.setList(this.locList4.getList());
        f.locFlag1.setValue(this.locFlag1.getValue(), null);
        f.locFlag2.setValue(this.locFlag2.getValue(), null);
        f.locFlag3.setValue(this.locFlag3.getValue(), null);
        f.locFlag4.setValue(this.locFlag4.getValue(), null);
        f.obsRealType.setList(this.obsRealType.getList());
        f.obsType.setList(this.obsType.getList());
        f.priority.setList(this.priority.getList());
        f.topic.setList(this.topic.getList());
        f.locBuildingId.setList(this.locBuildingId.getList());
        f.planId.setList(this.planId.getList());
        f.locBarcode = this.locBarcode;
        f.locLongtext1 = this.locLongtext1;
        f.locLongtext2 = this.locLongtext2;
        f.locLongtext3 = this.locLongtext3;
        f.locLongtext4 = this.locLongtext4;
        f.locText1 = this.locText1;
        f.locText2 = this.locText2;
        f.locText3 = this.locText3;
        f.locText4 = this.locText4;
        f.locTextFilter = this.locTextFilter;
        f.locationTitle = this.locationTitle;
        f.locDate1.setDates(this.locDate1, null);
        f.locDate2.setDates(this.locDate2, null);
        f.locDate3.setDates(this.locDate3, null);
        f.locDate4.setDates(this.locDate4, null);
        f.obsAmount = this.obsAmount;
        f.obsCode = this.obsCode;
        f.obsFreetext1 = this.obsFreetext1;
        f.obsFreetext2 = this.obsFreetext2;
        f.obsFreetext3 = this.obsFreetext3;
        f.obsLangtext1 = this.obsLangtext1;
        f.obsLangtext2 = this.obsLangtext2;
        f.obsRisk = this.obsRisk;
        f.obsTextFilter = this.obsTextFilter;
        f.obsTitle = this.obsTitle;
        f.externalModification = this.externalModification;
        f.showAll = this.showAll;
        f.showdeleted = this.showdeleted;
        f.eventMonth = this.eventMonth;
        f.eventOption = this.eventOption;
        f.eventQuarter = this.eventQuarter;
        f.eventYear = this.eventYear;
        f.status = this.status;
        f.duedate = this.duedate == null ? null : new Date(this.duedate.getTime());
        f.eventFromDate = this.eventFromDate == null ? null : new Date(this.eventFromDate.getTime());
        f.eventUntilDate = this.eventUntilDate == null ? null : new Date(this.eventUntilDate.getTime());
        f.observationIds.clear();
        f.observationIds.addAll(this.observationIds);
        f.locationIds.clear();
        f.locationIds.addAll(this.locationIds);
        f.locRanges.clear();
        f.locRanges.addAll(this.locRanges);
        f.empty = this.empty;
        return f;
    }

    public String addFilter(String thisValue, String newValue) {
        if (newValue != null && !"".equals(newValue)) {
            return newValue;
        }
        return thisValue;
    }

    public void setFilter(ThemisFilter flt) {
        this.setFilter(flt, this.isTriggerEnabled());
    }

    public void setFilter(ThemisFilter flt, boolean trigger) {
        boolean triggerState = this.triggerEnabled;
        this.triggerEnabled = false;
        if (flt == null) {
            this.clearAll();
        } else {
            this.currentEvent = flt.currentEvent;
            this.eventId.setList(flt.eventId.getList());
            this.companyId.setList(flt.companyId.getList());
            this.locGroup.setList(flt.locGroup.getList());
            this.locList1.setList(flt.locList1.getList());
            this.locList2.setList(flt.locList2.getList());
            this.locList3.setList(flt.locList3.getList());
            this.locList4.setList(flt.locList4.getList());
            this.obsRealType.setList(flt.obsRealType.getList());
            this.obsType.setList(flt.obsType.getList());
            this.priority.setList(flt.priority.getList());
            this.topic.setList(flt.topic.getList());
            this.locBuildingId.setList(flt.locBuildingId.getList());
            this.planId.setList(flt.planId.getList());
            this.locBarcode = flt.locBarcode;
            this.locLongtext1 = flt.locLongtext1;
            this.locLongtext2 = flt.locLongtext2;
            this.locLongtext3 = flt.locLongtext3;
            this.locLongtext4 = flt.locLongtext4;
            this.locText1 = flt.locText1;
            this.locText2 = flt.locText2;
            this.locText3 = flt.locText3;
            this.locText4 = flt.locText4;
            this.locFlag1.setValue(flt.getLocFlag1().getValue(), null);
            this.locFlag2.setValue(flt.getLocFlag2().getValue(), null);
            this.locFlag3.setValue(flt.getLocFlag3().getValue(), null);
            this.locFlag4.setValue(flt.getLocFlag4().getValue(), null);
            this.locTextFilter = flt.locTextFilter;
            this.locationTitle = flt.locationTitle;
            this.locDate1.setDates(flt.locDate1, null);
            this.locDate2.setDates(flt.locDate2, null);
            this.locDate3.setDates(flt.locDate3, null);
            this.locDate4.setDates(flt.locDate4, null);
            this.obsAmount = flt.obsAmount;
            this.obsCode = flt.obsCode;
            this.obsFreetext1 = flt.obsFreetext1;
            this.obsFreetext2 = flt.obsFreetext2;
            this.obsFreetext3 = flt.obsFreetext3;
            this.obsLangtext1 = flt.obsLangtext1;
            this.obsLangtext2 = flt.obsLangtext2;
            this.obsRisk = flt.obsRisk;
            this.obsTextFilter = flt.obsTextFilter;
            this.obsTitle = flt.obsTitle;
            this.externalModification = flt.externalModification;
            this.showAll = flt.showAll;
            this.showdeleted = flt.showdeleted;
            this.eventMonth = flt.eventMonth;
            this.eventOption = flt.eventOption;
            this.eventQuarter = flt.eventQuarter;
            this.eventYear = flt.eventYear;
            this.status = flt.status;
            this.duedate = flt.duedate == null ? null : new Date(flt.duedate.getTime());
            this.eventFromDate = flt.eventFromDate == null ? null : new Date(flt.eventFromDate.getTime());
            this.eventUntilDate = flt.eventUntilDate == null ? null : new Date(flt.eventUntilDate.getTime());
            this.observationIds.clear();
            this.observationIds.addAll(flt.observationIds);
            this.locationIds.clear();
            this.locationIds.addAll(flt.locationIds);
            this.locRanges.clear();
            this.locRanges.addAll(flt.locRanges);
            this.empty = flt.empty;
        }
        this.resetSearchResult();
        this.triggerEnabled = triggerState;
        if (trigger) {
            this.setTriggerEnabled(true);
        }
    }

    public void setFilterByText(String key, String value, Object source) {
        switch (key.toLowerCase()) {
            case "event.current": {
                boolean isset = "x".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "ja".equalsIgnoreCase(value);
                this.empty = this.empty && isset;
                this.setCurrentEvent(isset);
                break;
            }
            case "event.id": {
                this.empty = false;
                this.getEventId().addItem(Util.parseLong((String)value, (long)-1L), source);
                break;
            }
            case "company.id": {
                this.empty = false;
                this.getCompanyId().addItem(Util.parseLong((String)value, (long)-1L), source);
                break;
            }
            case "group.term": {
                this.empty = false;
                List<Long> ids = this.project.getTemplateManger().getLocationGroupId(value);
                for (long id : ids) {
                    this.getLocGroupId().addItem(id, source);
                }
                break;
            }
            case "location.number": {
                this.empty = false;
                this.setLocRangeAsString(value, source);
                break;
            }
            case "location.text1": {
                this.empty = false;
                this.setLocText1(value, source);
                break;
            }
            case "location.text2": {
                this.empty = false;
                this.setLocText2(value, source);
                break;
            }
            case "location.text3": {
                this.empty = false;
                this.setLocText3(value, source);
                break;
            }
            case "location.list1": {
                this.empty = false;
                long id = this.project.getKeytable("list1").getId(value);
                this.getLocList1().addItem(id < 0L ? Util.parseLong((String)value, (long)-1L) : id, source);
                break;
            }
            case "location.list2": {
                this.empty = false;
                this.getLocList2().addItem(Util.parseLong((String)value, (long)-1L), source);
                break;
            }
            case "location.list3": {
                this.empty = false;
                this.getLocList3().addItem(Util.parseLong((String)value, (long)-1L), source);
                break;
            }
            case "location.list4": {
                this.empty = false;
                this.getLocList4().addItem(Util.parseLong((String)value, (long)-1L), source);
                break;
            }
            case "building.id": {
                this.empty = false;
                this.getLocBuildingId().addItem(Util.parseLong((String)value, (long)-1L), source);
                break;
            }
            case "plan.id": {
                this.empty = false;
                this.getPlanId().addItem(Util.parseLong((String)value, (long)-1L), source);
                break;
            }
            case "observation.type": {
                this.empty = false;
                this.getObsRealType().addItem(Util.parseLong((String)value, (long)-1L), source);
                break;
            }
            case "observation.list1": {
                this.empty = false;
                this.getTopic().addItem(Util.parseLong((String)value, (long)-1L), source);
                break;
            }
            case "observation.list2": {
                this.empty = false;
                this.getObsType().addItem(Util.parseLong((String)value, (long)-1L), source);
                break;
            }
            case "observation.list3": {
                this.empty = false;
                this.getPriority().addItem(Util.parseLong((String)value, (long)-1L), source);
            }
        }
    }

    public boolean isExternalModification() {
        return this.externalModification;
    }

    public void setExternalModification(boolean externalModification) {
        this.externalModification = externalModification;
    }

    public void setTriggerEnabled(boolean enabled) {
        this.setTriggerEnabled(enabled, null, true);
    }

    public void setTriggerEnabled(boolean enabled, Object source, boolean invoke) {
        this.triggerEnabled = enabled;
        if (this.triggerEnabled && invoke) {
            this.app.getActionProvider().invokeAction(ThemisAction.FILTER_CHANGED.from(source, "trigger enabled"));
        }
    }

    public boolean isTriggerEnabled() {
        return this.triggerEnabled;
    }

    public void clearAll() {
        this.clearAll(true, null);
    }

    public synchronized void clearAll(boolean withTrigger, Object source) {
        if (this.lastFilter != null) {
            this.lastFilter.setFilter(this, false);
        }
        if (withTrigger) {
            this.setTriggerEnabled(false);
        }
        this.currentEvent = false;
        this.eventId.clear(null);
        this.eventYear = -1;
        this.eventMonth = 0;
        this.eventQuarter = 0;
        this.eventFromDate = null;
        this.eventUntilDate = null;
        this.currentPlanFilter = false;
        this.locationTitle = "";
        this.locTextFilter = "";
        this.locGroup.clear(null);
        this.planId.clear(null);
        this.locText1 = "";
        this.locText2 = "";
        this.locText3 = "";
        this.locText4 = "";
        this.locLongtext1 = "";
        this.locLongtext2 = "";
        this.locLongtext3 = "";
        this.locLongtext4 = "";
        this.locFlag1.clear(null);
        this.locFlag2.clear(null);
        this.locFlag3.clear(null);
        this.locFlag4.clear(null);
        this.locList1.clear(null);
        this.locList2.clear(null);
        this.locList3.clear(null);
        this.locList4.clear(null);
        this.locRanges.clear();
        this.locDate1.clear();
        this.locDate2.clear();
        this.locDate3.clear();
        this.locDate4.clear();
        this.locBarcode = "";
        this.locBuildingId.clear(null);
        this.obsTitle = "";
        this.obsTextFilter = "";
        this.companyId.clear(null);
        this.duedate = null;
        this.obsCode = "";
        this.obsFreetext1 = "";
        this.obsFreetext2 = "";
        this.obsFreetext3 = "";
        this.obsLangtext1 = "";
        this.obsLangtext2 = "";
        this.obsAmount = "";
        this.obsRisk = "";
        this.status = 0;
        this.priority.clear(null);
        this.obsType.clear(null);
        this.obsRealType.clear(null);
        this.topic.clear(null);
        this.filteredLocationRecords = null;
        this.filteredObservationRecords = null;
        this.previousLocationSort = null;
        this.previousObservationSort = null;
        this.previousObservationWhere = null;
        this.observationIds.clear();
        this.locationIds.clear();
        this.empty = true;
        this.emptyLocations = true;
        this.resetSearchResult();
        if (withTrigger) {
            this.setTriggerEnabled(true, source, true);
        }
    }

    public String getObsTextFilter() {
        return this.obsTextFilter;
    }

    public void setObsFreeText(String obsFreeText, Object source) {
        this.obsTextFilter = obsFreeText;
        this.setFilterChanged(source);
    }

    public boolean isShowDeleted() {
        return this.showdeleted;
    }

    public void setShowDeleted(boolean showdeleted) {
        this.showdeleted = showdeleted;
        this.setFilterChanged(null);
    }

    public void setCurrentEvent(boolean flg) {
        boolean oldVal = this.currentEvent;
        this.currentEvent = flg;
        if (flg) {
            this.getEventId().clear(null);
        }
        this.setFilterChanged(null);
    }

    public boolean isCurrentEvent() {
        return this.currentEvent;
    }

    public ThemisFilterListItem getEventId() {
        return this.eventId;
    }

    public void setEventOption(int idx, Object source) {
        this.eventOption = idx;
        this.setFilterChanged(source);
    }

    @Deprecated
    public int getEventYear() {
        return this.eventYear;
    }

    @Deprecated
    public void setEventYear(int eventYear, Object source) {
        this.eventYear = eventYear;
        this.setFilterChanged(source);
    }

    @Deprecated
    public int getEventMonth() {
        return this.eventMonth;
    }

    @Deprecated
    public void setEventMonth(int eventMonth, Object source) {
        this.eventMonth = eventMonth;
        this.setFilterChanged(source);
    }

    @Deprecated
    public int getEventQuarter() {
        return this.eventQuarter;
    }

    @Deprecated
    public void setEventQuarter(int eventQuarter, Object source) {
        this.eventQuarter = eventQuarter;
        this.setFilterChanged(source);
    }

    public void setEventRange(Date eventFromDate, Date eventUntilDate, Object source) {
        this.eventFromDate = eventFromDate;
        this.eventUntilDate = eventUntilDate;
        this.setFilterChanged(source);
    }

    public Date getEventFromDate() {
        return this.eventFromDate;
    }

    public Date getEventUntilDate() {
        return this.eventUntilDate;
    }

    public void setObservationId(long id, Object source) {
        this.observationIds.clear();
        this.observationIds.add(id);
        this.setFilterChanged(source);
    }

    public void setObservationIds(ArrayList<Long> ids, Object source) {
        this.observationIds.clear();
        this.observationIds.addAll(ids);
        this.setFilterChanged(source);
    }

    public ArrayList<Long> getObservationIds() {
        return this.observationIds;
    }

    public void setLocationId(long id, Object source) {
        this.locationIds.clear();
        this.locationIds.add(id);
        this.setFilterChanged(source);
    }

    public void setLocationIds(ArrayList<Long> ids, Object source) {
        this.locationIds.clear();
        this.locationIds.addAll(ids);
        this.setFilterChanged(source);
    }

    public ArrayList<Long> getLocationIds() {
        return this.locationIds;
    }

    public ThemisFilterListItem getCompanyId() {
        return this.companyId;
    }

    public ThemisFilterListItem getLocGroupId() {
        return this.locGroup;
    }

    public String getObsTitle() {
        return this.obsTitle;
    }

    public void setObsTitle(String title, Object source) {
        this.obsTitle = title;
        this.setFilterChanged(source);
    }

    public String getLocationTitle() {
        return this.locationTitle;
    }

    public void setLocationTitle(String title, Object source) {
        this.locationTitle = title;
        this.setFilterChanged(source);
    }

    public String getLocTextFilter() {
        return this.locTextFilter;
    }

    public void setLocFreeText(String freetext, Object source) {
        this.locTextFilter = freetext;
        this.setFilterChanged(source);
    }

    public String getObsCode() {
        return this.obsCode;
    }

    public void setObsCode(String obsCode, Object source) {
        this.obsCode = obsCode;
        this.setFilterChanged(source);
    }

    public String getObsFreetext1() {
        return this.obsFreetext1;
    }

    public void setObsFreetext1(String obsFreetext1, Object source) {
        this.obsFreetext1 = obsFreetext1;
        this.setFilterChanged(source);
    }

    public String getObsFreetext2() {
        return this.obsFreetext2;
    }

    public void setObsFreetext2(String obsFreetext2, Object source) {
        this.obsFreetext2 = obsFreetext2;
        this.setFilterChanged(source);
    }

    public String getObsFreetext3() {
        return this.obsFreetext3;
    }

    public void setObsFreetext3(String obsFreetext3, Object source) {
        this.obsFreetext3 = obsFreetext3;
        this.setFilterChanged(source);
    }

    public String getObsLangtext1() {
        return this.obsLangtext1 == null ? "" : this.obsLangtext1;
    }

    public void setObsLangtext1(String txt, Object source) {
        this.obsLangtext1 = txt;
        this.setFilterChanged(source);
    }

    public String getObsLangtext2() {
        return this.obsLangtext2 == null ? "" : this.obsLangtext2;
    }

    public void setObsLangtext2(String txt, Object source) {
        this.obsLangtext2 = txt;
        this.setFilterChanged(source);
    }

    public String getObsAmount() {
        return this.obsAmount;
    }

    public void setObsAmount(String obsAmount, Object source) {
        this.obsAmount = obsAmount;
        this.setFilterChanged(source);
    }

    public String getObsRisk() {
        return this.obsRisk;
    }

    public void setObsRisk(String risk, Object source) {
        this.obsRisk = risk;
        this.setFilterChanged(source);
    }

    public String getLocText1() {
        return this.locText1;
    }

    public void setLocText1(String locCode1, Object source) {
        this.locText1 = locCode1;
        this.setFilterChanged(source);
    }

    public String getLocText2() {
        return this.locText2;
    }

    public void setLocText2(String locCode2, Object source) {
        this.locText2 = locCode2;
        this.setFilterChanged(source);
    }

    public String getLocText3() {
        return this.locText3;
    }

    public void setLocText3(String locCode1, Object source) {
        this.locText3 = locCode1;
        this.setFilterChanged(source);
    }

    public String getLocText4() {
        return this.locText4;
    }

    public void setLocText4(String locCode1, Object source) {
        this.locText4 = locCode1;
        this.setFilterChanged(source);
    }

    public String getLocLongtext1() {
        return this.locLongtext1;
    }

    public void setLocLongtext1(String txt, Object source) {
        this.locLongtext1 = txt;
        this.setFilterChanged(source);
    }

    public String getLocLongtext2() {
        return this.locLongtext2;
    }

    public void setLocLongtext2(String txt, Object source) {
        this.locLongtext2 = txt;
        this.setFilterChanged(source);
    }

    public String getLocLongtext3() {
        return this.locLongtext3;
    }

    public void setLocLongtext3(String txt, Object source) {
        this.locLongtext3 = txt;
        this.setFilterChanged(source);
    }

    public String getLocLongtext4() {
        return this.locLongtext4;
    }

    public void setLocLongtext4(String txt, Object source) {
        this.locLongtext4 = txt;
        this.setFilterChanged(source);
    }

    public String getLocBarcode() {
        return this.locBarcode.replaceAll("\\*", "\\%");
    }

    public void setLocBarcode(String locBarcode, Object source) {
        this.locBarcode = locBarcode;
        this.setFilterChanged(source);
    }

    public ThemisFilterListItem getLocList1() {
        return this.locList1;
    }

    public ThemisFilterListItem getLocList2() {
        return this.locList2;
    }

    public ThemisFilterListItem getLocList3() {
        return this.locList3;
    }

    public ThemisFilterListItem getLocList4() {
        return this.locList4;
    }

    public ThemisFilterDate getLocDate1() {
        return this.locDate1;
    }

    public ThemisFilterDate getLocDate2() {
        return this.locDate2;
    }

    public ThemisFilterDate getLocDate3() {
        return this.locDate3;
    }

    public ThemisFilterDate getLocDate4() {
        return this.locDate4;
    }

    public List<Pair<Long, Long>> getLocRange() {
        return this.locRanges;
    }

    public String getLocRangeAsString() {
        if (this.getLocRange().isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Pair<Long, Long> range : this.locRanges) {
            if ((Long)range.value1 < 0L && (Long)range.value2 < 0L) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            if (((Long)range.value1).equals(range.value2)) {
                sb.append(range.value1);
                continue;
            }
            if ((Long)range.value1 >= 0L) {
                sb.append(range.value1).append(" - ");
            }
            if ((Long)range.value2 < 0L) continue;
            if ((Long)range.value1 < 0L) {
                sb.append("- ");
            }
            sb.append(range.value2);
        }
        return sb.toString().trim();
    }

    public void setLocRangeAsString(String rangeAsString, Object source) {
        ArrayList<Pair<Long, Long>> ranges = new ArrayList<Pair<Long, Long>>();
        try {
            String[] rangeStrings;
            for (String rangeString : rangeStrings = rangeAsString.split(",")) {
                long locRangeTo;
                long locRangeFrom;
                block7: {
                    locRangeFrom = -1L;
                    locRangeTo = -1L;
                    try {
                        String[] range = rangeString.split("-");
                        locRangeFrom = Util.parseLong((String)range[0], (long)-1L);
                        if (range.length > 1) {
                            locRangeTo = Util.parseLong((String)range[1], (long)-1L);
                            break block7;
                        }
                        if (rangeString.endsWith("-")) break block7;
                        locRangeTo = locRangeFrom;
                    }
                    catch (Exception ex) {
                        continue;
                    }
                }
                if (locRangeTo >= 0L && locRangeTo < locRangeFrom) {
                    long temp = locRangeTo;
                    locRangeTo = locRangeFrom;
                    locRangeFrom = temp;
                }
                if (locRangeFrom < 0L && locRangeTo < 0L) continue;
                ranges.add((Pair<Long, Long>)new Pair((Object)locRangeFrom, (Object)locRangeTo));
            }
        }
        catch (Exception e) {
            ThemisLogger.logger.warning("Failed to parser number filter range string: " + e.getLocalizedMessage());
        }
        this.setLocRange(ranges, source);
    }

    public void setLocRange(List<Pair<Long, Long>> ranges, Object source) {
        if (ranges == null || ranges.isEmpty()) {
            this.locRanges.clear();
        } else {
            this.locRanges = ranges;
        }
        this.setFilterChanged(source);
    }

    public ThemisFilterListItem getLocBuildingId() {
        return this.locBuildingId;
    }

    public ThemisFilterListItem getPlanId() {
        return this.planId;
    }

    public ThemisFilterBoolean getLocFlag1() {
        return this.locFlag1;
    }

    public ThemisFilterBoolean getLocFlag2() {
        return this.locFlag2;
    }

    public ThemisFilterBoolean getLocFlag3() {
        return this.locFlag3;
    }

    public ThemisFilterBoolean getLocFlag4() {
        return this.locFlag4;
    }

    public Date getDuedate() {
        return this.duedate;
    }

    public void setDuedate(Date duedate, Object source) {
        this.duedate = duedate;
        this.setFilterChanged(source);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status, Object source) {
        this.status = status;
        this.setFilterChanged(source);
    }

    public ThemisFilterListItem getObsType() {
        return this.obsType;
    }

    public ThemisFilterListItem getObsRealType() {
        return this.obsRealType;
    }

    public ThemisFilterListItem getPriority() {
        return this.priority;
    }

    public ThemisFilterListItem getTopic() {
        return this.topic;
    }

    protected void setFilterChanged(Object source) {
        this.empty = false;
        this.resetSearchResult();
        if (this.triggerEnabled) {
            this.app.getActionProvider().invokeAction(ThemisAction.FILTER_CHANGED.from(source, "filter changed"));
        }
    }

    public void setMangelFilter() {
        boolean resetTrigger = this.triggerEnabled;
        this.setTriggerEnabled(false);
        this.clearAll();
        this.setStatus(1, this);
        this.getObsRealType().setItem(1L, this);
        if (resetTrigger) {
            this.setTriggerEnabled(true);
        }
    }

    public void setControlFilter() {
        boolean resetTrigger = this.triggerEnabled;
        this.setTriggerEnabled(false);
        this.clearAll();
        this.getObsRealType().setItem(2L, this);
        if (resetTrigger) {
            this.setTriggerEnabled(true);
        }
    }

    public void setDuedateFilter() {
        boolean resetTrigger = this.triggerEnabled;
        Date dt = this.app.getAppointmentInfoDate();
        this.setTriggerEnabled(false);
        this.clearAll();
        this.setDuedate(dt, this);
        this.setStatus(3, this);
        if (resetTrigger) {
            this.setTriggerEnabled(true);
        }
    }

    public void setTodoFilter() {
        boolean resetTrigger = this.triggerEnabled;
        long eventId = this.app.getProject().getCurrentEventId();
        if (eventId >= 0L) {
            this.setTriggerEnabled(false);
            this.clearAll();
            this.getEventId().setItem(eventId, this);
            this.setEventOption(3, this);
            if (resetTrigger) {
                this.setTriggerEnabled(true);
            }
        } else {
            this.app.getDialog().showWarningDialog(this.app.getProject().getResourceText("app.core.text.noevent", this.app.getLocale()));
        }
    }

    public void setCurrentEventFilter() {
        boolean resetTrigger = this.triggerEnabled;
        this.setTriggerEnabled(false);
        this.clearAll();
        this.setCurrentEvent(true);
        this.setEventOption(0, null);
        if (resetTrigger) {
            this.setTriggerEnabled(true);
        }
    }

    public void setCurrentPlanFilter() {
        boolean resetTrigger = this.triggerEnabled;
        this.setTriggerEnabled(false);
        this.clearAll();
        this.getPlanId().setItem(ThemisApplication.getInstance().getProject().getCurrentPlanId(), this);
        this.currentPlanFilter = true;
        if (resetTrigger) {
            this.setTriggerEnabled(true);
        }
    }

    public boolean hasCurrentPlanFilter() {
        return this.currentPlanFilter;
    }

    public void clearCurrentPlanFilterFlag() {
        this.currentPlanFilter = false;
    }

    public boolean checkObservation(long idObservation) {
        CmsSqlSearch s = this.getSearchLocation(true);
        s.addWhere("observation.idelement = " + idObservation);
        return !s.search().isEmpty();
    }

    public boolean checkObservations(List<Long> ids) {
        CmsSqlSearch s = this.getSearchLocation(true);
        s.addWhere("observation.idelement IN " + Util.toSqlString(ids));
        return s.search().size() == ids.size();
    }

    private boolean checkLocationAttributeUsage(String attcode) {
        ThemisAttribute ta = this.app.getSettings().getLocationAttribute(attcode);
        if (ta == null) {
            return false;
        }
        if (ta.isUsed()) {
            return true;
        }
        for (ThemisAttribute taList : this.observationListAttributes) {
            if (taList == null || !taList.equals(ta)) continue;
            return true;
        }
        return false;
    }

    public CmsSqlSearch getSearchLocation(boolean searchForObservations) {
        String r;
        boolean withObservationCondition = false;
        boolean withBuildings = this.app.getSettings().getShowBuildingsInLocList();
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        CmsElement loc = this.project.getDefaultElement("location");
        CmsElement obs = this.project.getDefaultElement("observation");
        s.setElementtypes("location");
        s.addSelectMeta();
        s.addSelectAttribute(loc.getAttribute("number"));
        s.addSelect("ele.templateid", "templateid");
        s.addSelect("ele.templateid", "templateid");
        boolean usePrefix = this.app.getSettings().getLocationAttribute("prefixsuffix").isUsed();
        if (usePrefix) {
            s.addSelectAttribute(loc.getAttribute("prenumber"));
        }
        boolean useSuffix = this.app.getSettings().getLocationAttribute("suffix").isUsed();
        s.addSelectAttribute(loc.getAttribute("postnumber"));
        s.addSelect((usePrefix ? "IFNULL(ele.prenumber,'') || " : "") + "IFNULL(ele.number,0)" + (useSuffix ? " || IFNULL(ele.postnumber,'') " : ""), "locnumber");
        s.addSelectRelationTerm(loc.getAttribute("locationgroup"));
        s.addSelectRelationId(loc.getAttribute("locationgroup"));
        s.addLeftJoin("tdtaEleLocationgroup AS grp ON locationgroupele.idElement=grp.idElement ");
        s.addSelect("grp.itemsort", "locationgroupsort");
        s.addSelect("ele.titel", "location");
        if ("~".equals(this.locationTitle)) {
            s.addWhere("el.title='' OR el.title IS NULL");
        } else if (!"".equals(this.locationTitle)) {
            s.addWhere("lower(el.title) LIKE " + Util.toSqlString((String)("%" + this.getLocationTitle().toLowerCase() + "%")));
        }
        s.addSelect("ele.description", "description");
        String barcode = this.getLocBarcode();
        if (this.checkLocationAttributeUsage("barcode")) {
            s.addSelect("ele.barcode", "barcode");
            if ("~".equals(barcode)) {
                s.addWhere("ele.barcode='' OR ele.barcode IS NULL");
            } else if ("%".equals(barcode)) {
                s.addWhere("ele.barcode!='' AND ele.barcode IS NOT NULL");
            } else if (!"".equals(barcode)) {
                s.addWhere("ele.barcode LIKE " + Util.toSqlString((String)barcode));
            }
        }
        s.addSelect("ele.quantity", "locquantity");
        if (this.checkLocationAttributeUsage("text1") || !"".equals(this.locText1)) {
            s.addSelect("ele.code", "loccode");
            if ("~".equals(this.locText1)) {
                s.addWhere("ele.code='' OR ele.code IS NULL");
            } else if (!"".equals(this.locText1)) {
                s.addWhere("lower(ele.code) LIKE " + Util.toSqlString((String)("%" + this.getLocText1().toLowerCase() + "%")));
            }
        }
        if (this.checkLocationAttributeUsage("text2") || !"".equals(this.locText2)) {
            s.addSelect("ele.code2", "code2");
            if ("~".equals(this.locText2)) {
                s.addWhere("ele.code2='' OR ele.code2 IS NULL");
            } else if (!"".equals(this.locText2)) {
                s.addWhere("lower(ele.code2) LIKE " + Util.toSqlString((String)("%" + this.getLocText2().toLowerCase() + "%")));
            }
        }
        if (this.checkLocationAttributeUsage("text3") || !"".equals(this.locText3)) {
            s.addSelect("ele.text3", "loctext3");
            if ("~".equals(this.getLocText3())) {
                s.addWhere("ele.text3='' OR ele.text3 IS NULL");
            } else if (!"".equals(this.locText3)) {
                s.addWhere("lower(ele.text3) LIKE " + Util.toSqlString((String)("%" + this.getLocText3().toLowerCase() + "%")));
            }
        }
        if (this.checkLocationAttributeUsage("text4") || !"".equals(this.locText4)) {
            s.addSelect("ele.text4", "loctext4");
            if ("~".equals(this.getLocText4())) {
                s.addWhere("ele.text4='' OR ele.text4 IS NULL");
            } else if (!"".equals(this.locText4)) {
                s.addWhere("lower(ele.text4) LIKE " + Util.toSqlString((String)("%" + this.getLocText4().toLowerCase() + "%")));
            }
        }
        if (this.checkLocationAttributeUsage("longtext1") || !"".equals(this.locLongtext1)) {
            s.addSelect("ele.longtext1", "loclongtext1");
            if ("~".equals(this.getLocLongtext1())) {
                s.addWhere("ele.longtext1='' OR ele.longtext1 IS NULL");
            } else if (!"".equals(this.locLongtext1)) {
                s.addWhere("lower(ele.longtext1) LIKE " + Util.toSqlString((String)("%" + this.getLocLongtext1().toLowerCase() + "%")));
            }
        }
        if (this.checkLocationAttributeUsage("longtext2") || !"".equals(this.locLongtext2)) {
            s.addSelect("ele.longtext2", "loclongtext2");
            if ("~".equals(this.getLocLongtext2())) {
                s.addWhere("ele.longtext2='' OR ele.longtext2 IS NULL");
            } else if (!"".equals(this.locLongtext2)) {
                s.addWhere("lower(ele.longtext2) LIKE " + Util.toSqlString((String)("%" + this.getLocLongtext2().toLowerCase() + "%")));
            }
        }
        if (this.checkLocationAttributeUsage("longtext3") || !"".equals(this.locLongtext3)) {
            s.addSelect("ele.longtext3", "loclongtext3");
            if ("~".equals(this.getLocLongtext3())) {
                s.addWhere("ele.longtext3='' OR ele.longtext3 IS NULL");
            } else if (!"".equals(this.locLongtext3)) {
                s.addWhere("lower(ele.longtext3) LIKE " + Util.toSqlString((String)("%" + this.getLocLongtext3().toLowerCase() + "%")));
            }
        }
        if (this.checkLocationAttributeUsage("longtext4") || !"".equals(this.locLongtext4)) {
            s.addSelect("ele.longtext4", "loclongtext4");
            if ("~".equals(this.getLocLongtext4())) {
                s.addWhere("ele.longtext4='' OR ele.longtext4 IS NULL");
            } else if (!"".equals(this.locLongtext4)) {
                s.addWhere("lower(ele.longtext4) LIKE " + Util.toSqlString((String)("%" + this.getLocLongtext4().toLowerCase() + "%")));
            }
        }
        if (this.checkLocationAttributeUsage("boolean1") || this.locFlag1.getValue() != ThemisFilterBoolean.ThemisFilterBooleanValue.NOTSET) {
            s.addSelect("ele.boolean1", "locboolean1");
            switch (this.locFlag1.getValue()) {
                case NO: {
                    s.addWhere("ele.boolean1 IS NULL OR NOT ele.boolean1");
                    break;
                }
                case YES: {
                    s.addWhere("ele.boolean1");
                }
            }
        }
        if (this.checkLocationAttributeUsage("boolean2") || this.locFlag2.getValue() != ThemisFilterBoolean.ThemisFilterBooleanValue.NOTSET) {
            s.addSelect("ele.boolean2", "locboolean2");
            switch (this.locFlag2.getValue()) {
                case NO: {
                    s.addWhere("ele.boolean2 IS NULL OR NOT ele.boolean2");
                    break;
                }
                case YES: {
                    s.addWhere("ele.boolean2");
                }
            }
        }
        if (this.checkLocationAttributeUsage("boolean3") || this.locFlag3.getValue() != ThemisFilterBoolean.ThemisFilterBooleanValue.NOTSET) {
            s.addSelect("ele.boolean3", "locboolean3");
            switch (this.getLocFlag3().getValue()) {
                case NO: {
                    s.addWhere("ele.boolean3 IS NULL OR NOT ele.boolean3");
                    break;
                }
                case YES: {
                    s.addWhere("ele.boolean3");
                }
            }
        }
        if (this.checkLocationAttributeUsage("boolean4") || this.locFlag4.getValue() != ThemisFilterBoolean.ThemisFilterBooleanValue.NOTSET) {
            s.addSelect("ele.boolean4", "locboolean4");
            switch (this.getLocFlag4().getValue()) {
                case NO: {
                    s.addWhere("ele.boolean4 IS NULL OR NOT ele.boolean4");
                    break;
                }
                case YES: {
                    s.addWhere("ele.boolean4");
                }
            }
        }
        if (this.checkLocationAttributeUsage("list1") || !this.locList1.isEmpty()) {
            s.addSelect("ele.idlist1", "list1id");
            s.addLeftJoin("tkeylist1 AS list1tbl0 ON ele.idlist1=list1tbl0.idlist1 ");
            s.addSelect("list1tbl0.list1Sort", "list1sort");
            s.addLeftJoin("tkeylist1Lng AS list1tbl ON ele.idlist1=list1tbl.idlist1 AND list1tbl.lang=el.lang");
            s.addSelect("list1tbl.list1Term", "list1");
            if (!this.locList1.isEmpty()) {
                s.addWhere("ele.idlist1 IN " + Util.toSqlString(this.locList1.getList()) + (this.locList1.list.contains(-9L) ? " OR ele.idlist1 IS NULL" : ""));
            }
        }
        if (this.checkLocationAttributeUsage("list2") || !this.locList2.isEmpty()) {
            s.addSelect("ele.idlist2", "list2id");
            s.addLeftJoin("tkeylist2 AS list2tbl0 ON ele.idlist2=list2tbl0.idlist2");
            s.addSelect("list2tbl0.list2Sort", "list2sort");
            s.addLeftJoin("tkeylist2Lng AS list2tbl ON ele.idlist2=list2tbl.idlist2 AND list2tbl.lang=el.lang");
            s.addSelect("list2tbl.list2Term", "list2");
            if (!this.getLocList2().isEmpty()) {
                s.addWhere("ele.idlist2 IN " + Util.toSqlString(this.locList2.getList()) + (this.locList2.list.contains(-9L) ? " OR ele.idlist2 IS NULL" : ""));
            }
        }
        if (this.checkLocationAttributeUsage("list3") || !this.locList3.isEmpty()) {
            s.addSelect("ele.idlist3", "loclist3id");
            s.addLeftJoin("tkeylist3 AS list3tbl0 ON ele.idlist3=list3tbl0.idlist3");
            s.addSelect("list3tbl0.list3Sort", "loclist3sort");
            s.addLeftJoin("tkeylist3Lng AS list3tbl ON ele.idlist3=list3tbl.idlist3 AND list3tbl.lang=el.lang");
            s.addSelect("list3tbl.list3Term", "loclist3");
            if (!this.getLocList3().isEmpty()) {
                s.addWhere("ele.idlist3 IN " + Util.toSqlString(this.locList3.getList()) + (this.locList3.list.contains(-9L) ? " OR ele.idlist3 IS NULL" : ""));
            }
        }
        if (this.checkLocationAttributeUsage("list4") || !this.locList4.isEmpty()) {
            s.addSelect("ele.idlist4", "loclist4id");
            s.addLeftJoin("tkeylist4 AS list4tbl0 ON ele.idlist4=list4tbl0.idlist4");
            s.addSelect("list4tbl0.list4Sort", "loclist4sort");
            s.addLeftJoin("tkeylist4Lng AS list4tbl ON ele.idlist4=list4tbl.idlist4 AND list4tbl.lang=el.lang");
            s.addSelect("list4tbl.list4Term", "loclist4");
            if (!this.getLocList4().isEmpty()) {
                s.addWhere("ele.idlist4 IN " + Util.toSqlString(this.locList4.getList()) + (this.locList4.list.contains(-9L) ? " OR ele.idlist4 IS NULL" : ""));
            }
        }
        if (this.checkLocationAttributeUsage("date1")) {
            s.addSelect("ele.date1", "locdate1");
            this.locDate1.addWhere(s, "ele.date1");
        }
        if (this.checkLocationAttributeUsage("date2")) {
            s.addSelect("ele.date2", "locdate2");
            this.locDate2.addWhere(s, "ele.date2");
        }
        if (this.checkLocationAttributeUsage("date3")) {
            s.addSelect("ele.date3", "locdate3");
            this.locDate3.addWhere(s, "ele.date3");
        }
        if (this.checkLocationAttributeUsage("date4")) {
            s.addSelect("ele.date4", "locdate4");
            this.locDate4.addWhere(s, "ele.date4");
        }
        s.addSelectRelationTerm(loc.getAttribute("plan"));
        s.addLeftJoin("tdtaeleplan AS plan ON (planele.idelement=plan.idelement) ");
        s.addSelect("plan.sort", "plansort");
        s.addSelect("plan.idelement", "planid");
        s.addSelect("plan.title", "plantitle");
        s.addSelect("ele.position", "position");
        s.addSelect("ele.labelposition", "labelposition");
        s.addSelect("ele.building", "building");
        s.addLeftJoin("tdtarelation AS buildingrel ON (planele.idelement=buildingrel.elementfrom AND buildingrel.relationcode='planbuilding') ");
        s.addLeftJoin("tdtaelementlng AS building ON (buildingrel.elementto=building.idelement) ");
        s.addSelect("building.title", "planbuilding");
        s.addSelect("ele.iconfile", "iconfile");
        s.addSelectRelationId(loc.getAttribute("icon"));
        if (this.checkLocationAttributeUsage("gps")) {
            s.addSelect("ele.gps", "locgps");
        }
        if (!this.getPlanId().isEmpty()) {
            boolean withNone = this.getPlanId().getList().contains(-9L);
            s.addWhereRelationId(loc.getAttribute("plan"), "IN", Util.toSqlString(this.getPlanId().getList()), withNone);
        }
        if (!this.getLocBuildingId().isEmpty()) {
            CmsAttribute planatt = loc.getAttribute("plan");
            String code = s.getAlias(planatt);
            s.addRelationJoin(planatt, false);
            s.addWhere((String)code + "rel.elementTo IN (SELECT elementfrom FROM tdtaRelation WHERE elementto IN " + Util.toSqlString(this.getLocBuildingId().getList()) + " AND relationcode='planbuilding') OR e.idelement IN " + Util.toSqlString(this.getLocBuildingId().getList()));
        }
        if (this.getLocRange() != null && !this.getLocRange().isEmpty()) {
            StringBuilder sbWhere = new StringBuilder();
            for (Pair pair : this.getLocRange()) {
                if ((Long)pair.value1 != -1L && (Long)pair.value2 != -1L) {
                    if (sbWhere.length() > 0) {
                        sbWhere.append(" OR ");
                    }
                    sbWhere.append("(ele.number BETWEEN ").append(pair.value1).append(" AND ").append(pair.value2).append(")");
                    continue;
                }
                if ((Long)pair.value1 != -1L) {
                    sbWhere.append("(ele.number >= ").append(pair.value1).append(")");
                    continue;
                }
                if ((Long)pair.value2 == -1L) continue;
                sbWhere.append("(ele.number <= ").append(pair.value2).append(")");
            }
            if (sbWhere.length() > 0) {
                s.addWhere(sbWhere.toString());
            }
        }
        if ("~".equals(this.locTextFilter)) {
            s.addWhere("el.title='' OR el.title IS NULL");
        } else if (!"".equals(this.locTextFilter)) {
            String sqlLocFreeText = "lower(el.title) LIKE " + Util.toSqlString((String)("%" + this.getLocTextFilter().toLowerCase() + "%"));
            if (this.app.getSettings().getLocationAttribute("description").isUsed()) {
                sqlLocFreeText = sqlLocFreeText + " OR lower(ele.description) LIKE " + Util.toSqlString((String)("%" + this.getLocTextFilter().toLowerCase() + "%"));
            }
            s.addWhere(sqlLocFreeText);
        }
        s.addSelectRelationId(loc.getAttribute("observations"));
        s.addLeftJoin("tdtaEleObservation AS observation ON observation.idelement=observationsrel.elementTo");
        s.addLeftJoin("tdtaElement AS observationelement ON observationelement.idelement=observationsrel.elementTo");
        s.addLeftJoin("tkeyObstype AS obstypetbl0 ON observation.idType=obstypetbl0.idObstype");
        s.addLeftJoin("tkeyObstypeLng AS obstypetbl ON observation.idType=obstypetbl.idObstype AND obstypetbl.lang=el.lang");
        s.addSelect("observation.idtype", "idtype");
        s.addSelect("obstypetbl0.obstypesort", "typesort");
        s.addSelect("obstypetbl.obstypeterm", "type");
        s.addSelectRelationTerm(obs.getAttribute("responsible"));
        s.addSelect("observation.idelement", "observationid");
        s.addSelect("observation.number", "observationnumber");
        s.addSelect("observation.title", "observationtitle");
        s.addSelect("observation.editor", "editor");
        s.addSelect("observation.duedate", "duedate");
        s.addSelect("observation.donedate", "donedate");
        s.addSelect("observation.done", "done");
        s.addSelect("observation.repeatcount", "repeatcount");
        s.addSelect("observation.idrepeat", "idrepeat");
        s.addSelect("observation.referencedate", "referencedate");
        s.addSelect("observation.description", "observationdescription");
        s.addSelect("observation.hasimage", "hasimage");
        s.addSelect("observation.hasaudio", "hasaudio");
        s.addSelect("observation.code", "code");
        s.addSelect("observation.freetext1", "freetext1");
        s.addSelect("observation.freetext2", "freetext2");
        s.addSelect("observation.freetext3", "freetext3");
        s.addSelect("observation.langtext1", "langtext1");
        s.addSelect("observation.langtext2", "langtext2");
        s.addSelect("observation.float1", "float1");
        s.addSelect("observation.float2", "float2");
        s.addSelect("observation.float3", "float3");
        s.addSelect("observation.float4", "float4");
        s.addSelect("observation.measure", "measure");
        s.addSelect("observation.rpz", "risk");
        s.addSelect("observation.quantity", "quantity");
        s.addLeftJoin("tkeyObservationtype AS observationtypetbl0 ON observation.idObservationtype=observationtypetbl0.idObservationtype");
        s.addSelect("observationtypetbl0.observationtypeSort", "observationtypesort");
        s.addSelect("observationtypetbl0.idobservationtype", "observationtypeid");
        s.addLeftJoin("tkeyObservationtypeLng AS observationtypetbl ON observation.idObservationtype=observationtypetbl.idObservationtype AND observationtypetbl.lang=el.lang");
        s.addSelect("observationtypetbl.observationtypeTerm", "observationtype");
        s.addLeftJoin("tkeypriority AS prioritytbl0 ON observation.idpriority=prioritytbl0.idpriority");
        s.addSelect("prioritytbl0.prioritySort", "prioritysort");
        s.addSelect("prioritytbl0.idpriority", "priorityid");
        s.addLeftJoin("tkeypriorityLng AS prioritytbl ON observation.idpriority=prioritytbl.idpriority AND prioritytbl.lang=el.lang");
        s.addSelect("prioritytbl.priorityTerm", "priority");
        s.addLeftJoin("tkeytopic AS topictbl0 ON observation.idtopic=topictbl0.idtopic");
        s.addSelect("topictbl0.topicSort", "topicsort");
        s.addSelect("topictbl0.idtopic", "topicid");
        s.addLeftJoin("tkeytopicLng AS topictbl ON observation.idtopic=topictbl.idtopic AND topictbl.lang=el.lang");
        s.addSelect("topictbl.topicTerm", "topic");
        s.addSelect((usePrefix ? "IFNULL(ele.prenumber,'') || " : "") + "IFNULL(ele.number,0)" + (useSuffix ? "|| IFNULL(ele.postnumber,'') " : "") + " || '.' || IFNULL(observation.number,0)", "fullnumber");
        s.addLeftJoin("tdtaRelation AS contactrel ON (observation.idelement=contactrel.elementFrom AND contactrel.relationcode='observationcompany') ");
        s.addLeftJoin("tdtaEleCompany AS contact ON contactrel.elementTo=contact.idelement");
        s.addSelect("contact.name", "contactname");
        s.addSelect("contact.email", "contactemail");
        s.addSelect("contact.tel", "contacttel");
        ArrayList<Long> eventIds = new ArrayList<Long>();
        eventIds.addAll(this.getEventId().getList());
        long currentEventId = this.project.getSelectionManager().getCurrentEventId();
        if (this.isCurrentEvent() && currentEventId >= 0L) {
            eventIds.add(currentEventId);
        }
        if (!eventIds.isEmpty()) {
            String eventWhere = null;
            String ids = Util.toSqlString(eventIds);
            switch (this.eventOption) {
                case 0: {
                    s.addLeftJoin("tdtaRelation AS historyrel ON (observation.idelement=historyrel.elementTo AND historyrel.relationcode='historyobservation') ");
                    eventWhere = "(historyrel.elementFrom IN (SELECT elementFrom FROM tdtaRelation WHERE elementTo IN " + ids + " AND relationcode='historyevent') )";
                    break;
                }
                case 1: {
                    eventWhere = "observation.idelement NOT IN (SELECT r2.elementto FROM tdtaRelation AS r1 INNER JOIN tdtaRelation AS r2 ON (r1.elementFrom=r2.elementFrom) WHERE r1.elementTo IN " + ids + " AND r1.relationcode='historyevent' AND r2.relationcode='historyobservation')";
                    break;
                }
                case 2: {
                    StringBuilder eventsql = new StringBuilder();
                    boolean eventsqlfirst = true;
                    for (long eventid : this.getEventId().getList()) {
                        String dtStr = this.project.getDatastorage().getElementAttribute(eventid, "date");
                        if (!eventsqlfirst) {
                            eventsql.append(" OR ");
                        }
                        eventsql.append("observation.creationdate = " + Util.toSqlString((String)dtStr) + " ");
                        eventsqlfirst = false;
                    }
                    if (eventsqlfirst) break;
                    eventWhere = "(" + eventsql.toString() + ") ";
                    break;
                }
                case 4: {
                    s.addLeftJoin("tdtaRelation AS plannedforrel ON (observation.idelement=plannedforrel.elementTo AND plannedforrel.relationcode='plannedobservations') ");
                    eventWhere = "plannedforrel.elementFrom IN " + ids + " ";
                    break;
                }
                case 3: {
                    s.addLeftJoin("tdtaRelation AS plannedforrel ON (observation.idelement=plannedforrel.elementTo AND plannedforrel.relationcode='plannedobservations') ");
                    eventWhere = "(observation.idelement NOT IN (SELECT r2.elementto FROM tdtaRelation AS r1 INNER JOIN tdtaRelation AS r2 ON (r1.elementFrom=r2.elementFrom) WHERE r1.elementTo IN " + ids + " AND r1.relationcode='historyevent' AND r2.relationcode='historyobservation') ";
                    eventWhere = eventWhere + " AND plannedforrel.elementFrom IN " + ids + ")";
                }
            }
            s.addWhere(eventWhere);
            withObservationCondition = true;
        }
        boolean applyEventPeriod = false;
        String eventSubSql = null;
        if (this.eventFromDate != null || this.eventUntilDate != null) {
            applyEventPeriod = true;
            eventSubSql = "SELECT idelement FROM tdtaEleEvent WHERE ";
            if (this.eventFromDate != null) {
                eventSubSql = eventSubSql + "date >= '" + Util.formatDate((Date)this.eventFromDate, (String)Util.DATE_SQL, (TimeZone)this.project.getTimeZone()) + "'";
            }
            if (this.eventUntilDate != null) {
                if (this.eventFromDate != null) {
                    eventSubSql = eventSubSql + " AND ";
                }
                eventSubSql = eventSubSql + "date <= '" + Util.formatDate((Date)this.eventUntilDate, (String)Util.DATE_SQL, (TimeZone)this.project.getTimeZone()) + "'";
            }
            s.addLeftJoin("tdtaRelation AS historyrel ON (observation.idelement=historyrel.elementTo AND historyrel.relationcode='historyobservation') ");
            s.addWhere("historyrel.elementFrom IN (SELECT elementFrom FROM tdtaRelation WHERE elementTo IN (" + eventSubSql + ") AND relationcode='historyevent')");
            withObservationCondition = true;
        }
        String obsIdsWhere = null;
        String locIdsWhere = null;
        if (this.getObservationIds().size() == 1) {
            obsIdsWhere = "observation.idelement = " + this.getObservationIds().get(0);
            withObservationCondition = true;
        } else if (this.getObservationIds().size() > 1) {
            obsIdsWhere = "observation.idelement IN " + Util.toSqlString(this.getObservationIds());
            withObservationCondition = true;
        }
        if (this.getLocationIds().size() == 1) {
            locIdsWhere = "e.idelement = " + this.getLocationIds().get(0);
        } else if (this.getLocationIds().size() > 1) {
            locIdsWhere = "e.idelement IN " + Util.toSqlString(this.getLocationIds());
        }
        if (obsIdsWhere != null && locIdsWhere != null) {
            s.addWhere("(" + obsIdsWhere + " OR " + locIdsWhere + ")");
        } else if (obsIdsWhere != null) {
            s.addWhere(obsIdsWhere);
        } else if (locIdsWhere != null) {
            s.addWhere(locIdsWhere);
        }
        if ("~".equals(this.getObsTitle())) {
            s.addWhere("observation.title='' OR observation.title IS NULL");
            withObservationCondition = true;
        } else if (!"".equals(this.getObsTitle())) {
            s.addWhere("lower(observation.title) LIKE " + Util.toSqlString((String)("%" + this.getObsTitle().toLowerCase() + "%")));
            withObservationCondition = true;
        }
        if ("~".equals(this.getObsTextFilter())) {
            s.addWhere("observation.title='' OR observation.title IS NULL");
            withObservationCondition = true;
        } else if (!"".equals(this.getObsTextFilter())) {
            s.addWhere("lower(observation.title) LIKE " + Util.toSqlString((String)("%" + this.getObsTextFilter().toLowerCase() + "%")) + " OR lower(observation.description) LIKE " + Util.toSqlString((String)("%" + this.getObsTextFilter().toLowerCase() + "%")));
            withObservationCondition = true;
        }
        if ("~".equals(this.getObsCode())) {
            s.addWhere("observation.code='' OR observation.code IS NULL");
            withObservationCondition = true;
        } else if (!"".equals(this.getObsCode())) {
            s.addWhere("lower(observation.code) LIKE " + Util.toSqlString((String)("%" + this.getObsCode().toLowerCase() + "%")));
            withObservationCondition = true;
        }
        if ("~".equals(this.getObsFreetext1())) {
            s.addWhere("observation.freetext1='' OR observation.freetext1 IS NULL");
            withObservationCondition = true;
        } else if (!"".equals(this.getObsFreetext1())) {
            s.addWhere("lower(observation.freetext1) LIKE " + Util.toSqlString((String)("%" + this.getObsFreetext1().toLowerCase() + "%")));
            withObservationCondition = true;
        }
        if ("~".equals(this.getObsFreetext2())) {
            s.addWhere("observation.freetext2='' OR observation.freetext2 IS NULL");
            withObservationCondition = true;
        } else if (!"".equals(this.getObsFreetext2())) {
            s.addWhere("lower(observation.freetext2) LIKE " + Util.toSqlString((String)("%" + this.getObsFreetext2().toLowerCase() + "%")));
            withObservationCondition = true;
        }
        if ("~".equals(this.getObsFreetext3())) {
            s.addWhere("observation.freetext3='' OR observation.freetext3 IS NULL");
            withObservationCondition = true;
        } else if (!"".equals(this.getObsFreetext3())) {
            s.addWhere("lower(observation.freetext3) LIKE " + Util.toSqlString((String)("%" + this.getObsFreetext3().toLowerCase() + "%")));
            withObservationCondition = true;
        }
        if ("~".equals(this.getObsLangtext1())) {
            s.addWhere("observation.langtext1='' OR observation.langtext1 IS NULL");
            withObservationCondition = true;
        } else if (!"".equals(this.getObsLangtext1())) {
            s.addWhere("lower(observation.langtext1) LIKE " + Util.toSqlString((String)("%" + this.getObsLangtext1().toLowerCase() + "%")));
            withObservationCondition = true;
        }
        if ("~".equals(this.getObsLangtext2())) {
            s.addWhere("observation.langtext2='' OR observation.langtext2 IS NULL");
            withObservationCondition = true;
        } else if (!"".equals(this.getObsLangtext2())) {
            s.addWhere("lower(observation.langtext2) LIKE " + Util.toSqlString((String)("%" + this.getObsLangtext2().toLowerCase() + "%")));
            withObservationCondition = true;
        }
        if ("~".equals(this.getObsAmount())) {
            s.addWhere("observation.quantity='' OR observation.code IS NULL");
            withObservationCondition = true;
        } else if (!"".equals(this.getObsAmount())) {
            s.addWhere("lower(observation.quantity) LIKE " + Util.toSqlString((String)("%" + this.getObsAmount().toLowerCase() + "%")));
            withObservationCondition = true;
        }
        if (!this.getCompanyId().isEmpty()) {
            s.addWhere("contact.idelement IN " + Util.toSqlString(this.getCompanyId().getList()) + (this.getCompanyId().list.contains(-9L) ? " OR contact.idelement IS NULL" : ""));
            withObservationCondition = true;
        }
        if (this.getDuedate() != null) {
            s.addWhere("observation.duedate <= '" + Util.formatDate((Date)this.getDuedate(), (String)Util.DATE_SQL, (TimeZone)this.project.getTimeZone()) + "'");
            withObservationCondition = true;
        }
        if ("~".equals(this.getObsRisk())) {
            s.addWhere("observation.rpz='' OR observation.rpz IS NULL");
            withObservationCondition = true;
        } else if (!"".equals(this.getObsRisk()) && (r = this.getObsRisk()).indexOf(";") < 0) {
            if (r.startsWith(">=")) {
                s.addWhere("observation.rpz >= " + r.substring(2));
            } else if (r.startsWith(">")) {
                s.addWhere("observation.rpz > " + r.substring(1));
            } else if (r.startsWith("<=")) {
                s.addWhere("observation.rpz <= " + r.substring(2));
            } else if (r.startsWith("<")) {
                s.addWhere("observation.rpz < " + r.substring(1));
            } else if (r.startsWith("-")) {
                s.addWhere("observation.rpz <= " + r.substring(1));
            } else if (r.endsWith("-")) {
                s.addWhere("observation.rpz >= " + r.substring(0, r.indexOf("-")));
            } else if (r.indexOf("-") > 0) {
                String[] rs = r.split("-");
                s.addWhere("observation.rpz >= " + rs[0] + " AND observation.rpz <= " + rs[1]);
            } else {
                s.addWhere("observation.rpz = " + r);
            }
            withObservationCondition = true;
        }
        if (this.getStatus() == 1) {
            s.addWhere("observation.done IS NULL OR observation.done IS 'false' OR NOT observation.done");
            s.addWhere("observation.idtype=1 OR observation.idtype=4");
            withObservationCondition = true;
        } else if (this.getStatus() == 3) {
            s.addWhere("observation.done IS NULL OR observation.done IS 'false' OR NOT observation.done OR observation.idtype=3");
            s.addWhere("observation.idtype=1 OR observation.idtype=4 OR observation.idtype=2");
            withObservationCondition = true;
        } else if (this.getStatus() == 2) {
            s.addWhere("observation.done IS NULL OR observation.done IS 'false' OR NOT observation.done OR observation.idtype=3");
            s.addWhere("observation.idtype=1 OR observation.idtype=4 OR observation.idtype=3");
            withObservationCondition = true;
        } else if (this.getStatus() == 4) {
            s.addWhere("observation.done");
            s.addWhere("observation.idtype=1 OR observation.idtype=4");
            withObservationCondition = true;
        }
        int hideDoneTaskOption = this.app.getSettings().getDisplayHideDoneTask();
        if (hideDoneTaskOption > 0 && !applyEventPeriod && this.getStatus() != 1 && this.getStatus() != 4) {
            String whereHideDone = (searchForObservations ? "" : "ele.showalways OR ") + "observation.done IS NULL OR NOT observation.done OR observation.idtype IN (" + 3 + "," + 2 + ") ";
            if (hideDoneTaskOption == 2 && currentEventId >= 0L) {
                s.addLeftJoin("tdtaRelation AS historyrel ON (observation.idelement=historyrel.elementTo AND historyrel.relationcode='historyobservation') ");
                whereHideDone = whereHideDone + " OR (historyrel.elementFrom IN (SELECT elementFrom FROM tdtaRelation WHERE elementTo = " + currentEventId + " AND relationcode='historyevent'))";
            }
            s.addWhere(whereHideDone);
        }
        if (!this.getObsType().isEmpty()) {
            s.addWhere("observation.idobservationtype IN " + Util.toSqlString(this.getObsType().getList()) + (this.getObsType().list.contains(-9L) ? " OR observation.idobservationtype IS NULL" : ""));
            withObservationCondition = true;
        }
        if (!this.getObsRealType().isEmpty()) {
            s.addWhere("observation.idtype IN " + Util.toSqlString(this.getObsRealType().getList()));
            withObservationCondition = true;
        }
        if (!this.getPriority().isEmpty()) {
            s.addWhere("observation.idpriority IN " + Util.toSqlString(this.getPriority().getList()) + (this.getPriority().list.contains(-9L) ? " OR observation.idpriority IS NULL" : ""));
            withObservationCondition = true;
        }
        if (!this.getTopic().isEmpty()) {
            s.addWhere("observation.idtopic IN " + Util.toSqlString(this.getTopic().getList()) + (this.getTopic().list.contains(-9L) ? " OR observation.idtopic IS NULL" : ""));
            withObservationCondition = true;
        }
        if (!this.getLocGroupId().isEmpty()) {
            boolean withNone = this.getLocGroupId().getList().contains(-9L);
            s.addWhereRelationId(loc.getAttribute("locationgroup"), "IN", Util.toSqlString(this.getLocGroupId().getList()), withNone);
        }
        if (!this.emptyLocations) {
            s.addWhere("observationelement.idelement IS NOT NULL");
        }
        if (searchForObservations || withObservationCondition) {
            s.addWhere("observationelement.deleted IS NULL or NOT observationelement.deleted");
        }
        if (!withBuildings) {
            s.addWhere("NOT ele.building");
        }
        s.setSort((this.app.getSettings().getLocationAttribute("prefixsuffix").isUsed() ? "ele.prenumber," : "") + "ele.number," + (this.app.getSettings().getLocationAttribute("suffix").isUsed() ? "ele.postnumber," : "") + "observation.number");
        return s;
    }

    public List<DataRecord> getFilteredLocations() {
        return this.getFilteredLocations(this.previousLocationSort, null, true);
    }

    public synchronized List<DataRecord> getFilteredLocations(String sort, String where, boolean remember) {
        if (!this.project.isOpen()) {
            return new ArrayList<DataRecord>();
        }
        if (this.filteredLocationRecords != null) {
            boolean whereEqual;
            boolean sortEqual = sort == null && this.previousLocationSort == null || sort != null && sort.equals(this.previousLocationSort);
            boolean bl = whereEqual = where == null && this.previousLocationWhere == null || where != null && where.equals(this.previousLocationWhere);
            if (sortEqual && whereEqual) {
                this.project.getLogger().fine("Using previously generated list for filtered locations");
                return this.filteredLocationRecords;
            }
        }
        if (remember) {
            this.previousLocationSort = sort;
            this.previousLocationWhere = where;
        }
        long performanceMillis = new Date().getTime();
        CmsSqlSearch s = this.getSearchLocation(false);
        if (sort != null) {
            if ("locnumber".equalsIgnoreCase(sort)) {
                sort = (this.app.getSettings().getLocationAttribute("prefixsuffix").isUsed() ? "ele.prenumber," : "") + "ele.number," + (this.app.getSettings().getLocationAttribute("suffix").isUsed() ? "ele.postnumber," : "") + "observation.number";
            }
            s.setSort(sort);
        }
        if (where != null) {
            s.addWhere(where);
        }
        SearchResult search = s.search();
        List recs = search.getResult();
        String filtersql = s.getSql();
        this.project.getLogger().fine("PERFORMANCE: " + (new Date().getTime() - performanceMillis) + " ms,  getFilteredLocation(" + sort + ")");
        this.filteredLocationRecords = new ArrayList();
        ArrayList<Long> ids = new ArrayList<Long>();
        HashMap<Long, Integer> eleIndex = new HashMap<Long, Integer>();
        HashMap<Long, Integer> obsCount = new HashMap<Long, Integer>();
        long idObs = -1L;
        Date refDateDue = ThemisApplication.getInstance().getAppointmentInfoDate();
        CmsEvent ev = ThemisApplication.getInstance().getProject().getSelectionManager().getCurrentEvent();
        Date refdateOverdue = ev == null ? new Date() : ev.getDateAttribute("date").getDate();
        ColorOption co = this.app.getSettings().getDisplayColorOption();
        for (DataRecord dataRecord : recs) {
            long idLoc = dataRecord.getLong("meta_id");
            idObs = dataRecord.getLong("observationid", Long.valueOf(-1L));
            if (!ids.contains(idLoc)) {
                this.filteredLocationRecords.add(dataRecord);
                eleIndex.put(idLoc, ids.size());
                ids.add(idLoc);
                obsCount.put(idLoc, 0);
            }
            Integer colorlevel = -1;
            if (idObs < 0L) continue;
            obsCount.put(idLoc, (Integer)obsCount.get(idLoc) + 1);
            this.filteredLocationRecords.get((Integer)eleIndex.get(idLoc)).add("hasObservation", "true");
            switch (co.getMethod()) {
                case URGGENCY: {
                    boolean isDue;
                    boolean isControlled = false;
                    boolean isDone = dataRecord.getBoolean("done", Boolean.valueOf(false));
                    Date dt = dataRecord.getDate("duedate", null, this.project.getTimeZone());
                    boolean bl = isDue = dt == null ? true : dt.before(refDateDue);
                    boolean isOverdue = dt == null ? false : !dt.after(refdateOverdue);
                    int type = dataRecord.getInt("idtype", Integer.valueOf(1));
                    colorlevel = ThemisColors.getObservationColorLevel(type, isControlled, isDone, isDue, isOverdue);
                    break;
                }
                case NOCOLOR: 
                case STATIC: {
                    break;
                }
                case STATUS: {
                    boolean isDone = dataRecord.getBoolean("done", Boolean.valueOf(false));
                    colorlevel = isDone ? 1 : 2;
                    break;
                }
                case ATTRIBUTE: {
                    String sqlselect = co.getAttribute().getSqlCode();
                    colorlevel = dataRecord.getInt(sqlselect + "sort");
                }
            }
            if (colorlevel == null || this.filteredLocationRecords.get((Integer)eleIndex.get(idLoc)).getInt("colorlevel", Integer.valueOf(0)) >= colorlevel) continue;
            this.filteredLocationRecords.get((Integer)eleIndex.get(idLoc)).add("colorlevel", Integer.toString(colorlevel));
            Integer bgcolor = co.getColor(dataRecord);
            if (bgcolor == null) continue;
            this.filteredLocationRecords.get((Integer)eleIndex.get(idLoc)).add("colorbackground", Integer.toString(bgcolor));
            this.filteredLocationRecords.get((Integer)eleIndex.get(idLoc)).add("colorforeground", Integer.toString(ColorOption.getForegroundColor(bgcolor)));
        }
        for (Map.Entry entry : obsCount.entrySet()) {
            this.filteredLocationRecords.get((Integer)eleIndex.get(entry.getKey())).add("numObservations", entry.getValue() + "");
        }
        return this.filteredLocationRecords;
    }

    public List<DataRecord> getFilteredObservations() {
        return this.getFilteredObservations(this.previousObservationSort, this.previousObservationWhere, true);
    }

    public synchronized List<DataRecord> getFilteredObservations(String sort, String where) {
        return this.getFilteredObservations(sort, where, true);
    }

    public synchronized List<DataRecord> getFilteredObservations(String sort, String where, boolean remember) {
        if (!this.project.isOpen()) {
            return new ArrayList<DataRecord>();
        }
        if (this.filteredObservationRecords != null) {
            boolean whereEqual;
            boolean sortEqual = sort == null && this.previousObservationSort == null || sort != null && sort.equals(this.previousObservationSort);
            boolean bl = whereEqual = where == null && this.previousObservationWhere == null || where != null && where.equals(this.previousObservationWhere);
            if (sortEqual && whereEqual) {
                this.project.getLogger().fine("Using previously generated list for filtered observations");
                return this.filteredObservationRecords;
            }
        }
        if (remember) {
            this.previousObservationSort = sort;
            this.previousObservationWhere = where;
        }
        CmsSqlSearch s2 = this.getSearchLocation(true);
        if (sort != null) {
            s2.setSort(sort);
        }
        if (where != null) {
            s2.addWhere(where);
        }
        if (remember) {
            this.filteredObservationRecords = s2.search().getResult();
            if (this.isTriggerEnabled()) {
                this.app.getActionProvider().invokeAction(ThemisAction.FILTER_CHANGED.from(this, "get filtered observations with 'remember'"));
            }
            return this.filteredObservationRecords;
        }
        return s2.search().getResult();
    }

    public List<DataRecord> getSelectedObservations() {
        return this.getSelectedObservations(null);
    }

    public List<DataRecord> getSelectedObservations(String sort) {
        String wherestring = "observationelement.idelement in " + Util.toSqlString(this.app.getProject().getSelectionManager().getSelectedObservationIds());
        return this.getFilteredObservations(sort, wherestring);
    }

    public ArrayList<Long> getSelectedObservationIds(String sort) {
        String wherestring = "observationelement.idelement in " + Util.toSqlString(this.app.getProject().getSelectionManager().getSelectedObservationIds());
        return this.getFilteredObservationIds(sort, wherestring);
    }

    public ArrayList<Long> getFilteredObservationIds() {
        return this.getFilteredObservationIds(this.previousObservationSort, this.previousObservationWhere);
    }

    public ArrayList<Long> getFilteredObservationIds(String where) {
        return this.getFilteredObservationIds(this.previousObservationSort, where);
    }

    public ArrayList<Long> getFilteredObservationIds(String sort, String where) {
        ArrayList<Long> result = new ArrayList<Long>();
        List<DataRecord> recs = this.getFilteredObservations(sort, where);
        for (DataRecord rec : recs) {
            if (rec.getLong("observationid") <= 0L) continue;
            result.add(rec.getLong("observationid"));
        }
        return result;
    }

    public ArrayList<Long> getFilteredLocationIds() {
        return this.getFilteredLocationIds(this.previousLocationSort, this.previousLocationWhere, true);
    }

    public ArrayList<Long> getFilteredLocationIds(String sort, String where, boolean remember) {
        ArrayList<Long> result = new ArrayList<Long>();
        List<DataRecord> recs = this.getFilteredLocations(sort, where, remember);
        for (DataRecord rec : recs) {
            result.add(rec.getLong("meta_id"));
        }
        return result;
    }

    public long getNextFilteredObservationId(long currentId) {
        return this.getNextFilteredObservationId(currentId, 1);
    }

    public long getPreviousFilteredObservationId(long currentId) {
        return this.getNextFilteredObservationId(currentId, -1);
    }

    private long getNextFilteredObservationId(long currentId, int step) {
        List<DataRecord> recs = this.getFilteredObservations();
        for (int ii = 0; ii < recs.size(); ++ii) {
            long recId = recs.get(ii).getLong("observationid");
            if (recId != currentId) continue;
            for (int idx = ii + step; idx != ii; idx += step) {
                if (idx == recs.size()) {
                    idx = 0;
                } else if (idx < 0) {
                    idx = recs.size() - 1;
                }
                long newId = recs.get(idx).getLong("observationid");
                if (newId <= 0L) continue;
                return newId;
            }
        }
        return -1L;
    }

    public long getNextFilteredLocationId(long currentId) {
        ArrayList<Long> ids = this.getFilteredLocationIds();
        for (int ii = 0; ii < this.filteredLocationRecords.size(); ++ii) {
            long recId = this.filteredLocationRecords.get(ii).getLong("meta_id");
            if (recId != currentId) continue;
            int idx = ii + 1;
            if (idx == this.filteredLocationRecords.size()) {
                idx = 0;
            }
            return this.filteredLocationRecords.get(idx).getLong("meta_id");
        }
        if (ids.isEmpty()) {
            return -1L;
        }
        int idx = ids.indexOf(currentId);
        if (idx < 0) {
            return (Long)ids.get(0);
        }
        if (idx == ids.size() - 1) {
            return (Long)ids.get(0);
        }
        return (Long)ids.get(idx + 1);
    }

    public ArrayList<Long> getFilteredElementIds() {
        return this.getFilteredElementIds(this.previousObservationSort, this.previousObservationWhere);
    }

    public ArrayList<Long> getFilteredElementIds(String sort, String where) {
        ArrayList<Long> elementIds = new ArrayList<Long>();
        List<DataRecord> recs = this.getFilteredObservations(sort, where);
        for (DataRecord rec : recs) {
            long idobs = rec.getLong("observationid");
            long idloc = rec.getLong("meta_id");
            long id = idobs > 0L ? idobs : idloc;
            if (elementIds.contains(id)) continue;
            elementIds.add(id);
        }
        return elementIds;
    }

    public synchronized void resetSearchResult() {
        this.filteredLocationRecords = null;
        this.filteredObservationRecords = null;
        this.previousLocationSort = null;
        this.previousObservationSort = null;
        this.previousObservationWhere = null;
    }

    public void setEmptyLocation(boolean b) {
        this.emptyLocations = b;
    }

    public boolean getEmptyLocation() {
        return this.emptyLocations;
    }

    public String toXml() {
        return this.getFilterAsXml();
    }

    public String getFilterAsXml() {
        Element root = new Element("filter");
        Element eve = new Element("event");
        eve.addContent((Content)new Element("current").setText(this.currentEvent ? "true" : "false"));
        eve.addContent((Content)new Element("ids").setText(this.eventId.toString()));
        eve.addContent((Content)new Element("option").setText(Integer.toString(this.eventOption)));
        eve.addContent((Content)new Element("fromdate").setText(Util.formatDate((Date)this.eventFromDate, (String)Util.DATE_ISO, (TimeZone)this.app.getTimeZone())));
        eve.addContent((Content)new Element("untildate").setText(Util.formatDate((Date)this.eventUntilDate, (String)Util.DATE_ISO, (TimeZone)this.app.getTimeZone())));
        root.addContent((Content)eve);
        Element loc = new Element("location");
        loc.addContent((Content)new Element("range").setText(this.getLocRangeAsString()));
        loc.addContent((Content)new Element("title").setText(this.locationTitle));
        loc.addContent((Content)new Element("textsearch").setText(this.locTextFilter));
        loc.addContent((Content)new Element("group").setText(this.locGroup.toString()));
        loc.addContent((Content)new Element("plan").setText(this.planId.toString()));
        loc.addContent((Content)new Element("building").setText(this.locBuildingId.toString()));
        loc.addContent((Content)new Element("text1").setText(this.locText1));
        loc.addContent((Content)new Element("text2").setText(this.locText2));
        loc.addContent((Content)new Element("text3").setText(this.locText3));
        loc.addContent((Content)new Element("text4").setText(this.locText4));
        loc.addContent((Content)new Element("longtext1").setText(this.locLongtext1));
        loc.addContent((Content)new Element("longtext2").setText(this.locLongtext2));
        loc.addContent((Content)new Element("longtext3").setText(this.locLongtext3));
        loc.addContent((Content)new Element("longtext4").setText(this.locLongtext4));
        loc.addContent((Content)new Element("barcode").setText(this.locBarcode));
        loc.addContent((Content)new Element("list1").setText(this.locList1.toString()));
        loc.addContent((Content)new Element("list2").setText(this.locList2.toString()));
        loc.addContent((Content)new Element("list3").setText(this.locList3.toString()));
        loc.addContent((Content)new Element("list4").setText(this.locList4.toString()));
        loc.addContent((Content)new Element("checkbox1").setText(this.locFlag1.toString()));
        loc.addContent((Content)new Element("checkbox2").setText(this.locFlag2.toString()));
        loc.addContent((Content)new Element("checkbox3").setText(this.locFlag3.toString()));
        loc.addContent((Content)new Element("checkbox4").setText(this.locFlag4.toString()));
        loc.addContent((Content)new Element("date1").setText(this.locDate1.toString()));
        loc.addContent((Content)new Element("date2").setText(this.locDate2.toString()));
        loc.addContent((Content)new Element("date3").setText(this.locDate3.toString()));
        loc.addContent((Content)new Element("date4").setText(this.locDate4.toString()));
        root.addContent((Content)loc);
        Element obs = new Element("observation");
        obs.addContent((Content)new Element("company").setText(this.companyId.toString()));
        obs.addContent((Content)new Element("duedate").setText(Util.formatDate((Date)this.duedate, (String)Util.DATE_ISO, (TimeZone)this.app.getTimeZone())));
        obs.addContent((Content)new Element("title").setText(this.obsTitle));
        obs.addContent((Content)new Element("textsearch").setText(this.obsTextFilter));
        obs.addContent((Content)new Element("text1").setText(this.obsCode));
        obs.addContent((Content)new Element("text2").setText(this.obsFreetext1));
        obs.addContent((Content)new Element("text3").setText(this.obsFreetext2));
        obs.addContent((Content)new Element("text4").setText(this.obsFreetext3));
        obs.addContent((Content)new Element("langtext1").setText(this.obsLangtext1));
        obs.addContent((Content)new Element("langtext2").setText(this.obsLangtext2));
        obs.addContent((Content)new Element("list1").setText(this.topic.toString()));
        obs.addContent((Content)new Element("list2").setText(this.obsType.toString()));
        obs.addContent((Content)new Element("list3").setText(this.priority.toString()));
        obs.addContent((Content)new Element("amount").setText(this.obsAmount.toString()));
        obs.addContent((Content)new Element("risk").setText(this.obsRisk.toString()));
        obs.addContent((Content)new Element("status").setText(Integer.toString(this.status)));
        obs.addContent((Content)new Element("observationtype").setText(this.obsRealType.toString()));
        root.addContent((Content)obs);
        String xml = Util.toXml((Element)root);
        return xml;
    }

    public void fromXml(String xml) {
        this.clearAll(false, this);
        this.setTriggerEnabled(false);
        SAXBuilder builder = new SAXBuilder();
        try {
            Element obs;
            Element loc;
            Document doc = builder.build((Reader)new StringReader(xml));
            Element eve = doc.getRootElement().getChild("event");
            if (eve != null) {
                this.currentEvent = "true".equals(eve.getChildText("current"));
                this.eventId.fromString(eve.getChildText("ids"));
                this.eventOption = Util.parseInt((String)eve.getChildText("option"), (int)0);
                this.eventFromDate = Util.parseDate((String)eve.getChildText("fromdate"), (String)Util.DATE_ISO, (TimeZone)this.app.getTimeZone(), null);
                this.eventFromDate = Util.parseDate((String)eve.getChildText("untildate"), (String)Util.DATE_ISO, (TimeZone)this.app.getTimeZone(), null);
            }
            if ((loc = doc.getRootElement().getChild("location")) != null) {
                this.setLocRangeAsString(loc.getChildText("range"), this);
                this.locationTitle = loc.getChildText("title");
                this.locTextFilter = loc.getChildText("textsearch");
                this.locGroup.fromString(loc.getChildText("group"));
                this.planId.fromString(loc.getChildText("plan"));
                this.locBuildingId.fromString(loc.getChildText("building"));
                this.locText1 = loc.getChildText("text1");
                this.locText2 = loc.getChildText("text2");
                this.locText3 = loc.getChildText("text3");
                this.locText4 = loc.getChildText("text4");
                this.locLongtext1 = loc.getChildText("longtext1");
                this.locLongtext2 = loc.getChildText("longtext2");
                this.locLongtext3 = loc.getChildText("longtext3");
                this.locLongtext4 = loc.getChildText("longtext4");
                this.locBarcode = loc.getChildText("barcode");
                this.locList1.fromString(loc.getChildText("list1"));
                this.locList2.fromString(loc.getChildText("list2"));
                this.locList3.fromString(loc.getChildText("list3"));
                this.locList4.fromString(loc.getChildText("list4"));
                this.locFlag1.fromString(loc.getChildText("checkbox1"));
                this.locFlag2.fromString(loc.getChildText("checkbox2"));
                this.locFlag3.fromString(loc.getChildText("checkbox3"));
                this.locFlag4.fromString(loc.getChildText("checkbox4"));
                this.locDate1.fromString(loc.getChildText("date1"));
                this.locDate2.fromString(loc.getChildText("date2"));
                this.locDate3.fromString(loc.getChildText("date3"));
                this.locDate4.fromString(loc.getChildText("date4"));
            }
            if ((obs = doc.getRootElement().getChild("observation")) != null) {
                this.setDuedate(Util.parseDate((String)obs.getChildText("duedate"), (String)Util.DATE_ISO, (TimeZone)this.app.getTimeZone(), null), this);
                this.companyId.fromString(obs.getChildText("company"));
                this.obsTitle = obs.getChildText("title");
                this.obsTextFilter = obs.getChildText("textsearch");
                this.obsCode = obs.getChildText("text1");
                this.obsFreetext1 = obs.getChildText("text2");
                this.obsFreetext2 = obs.getChildText("text3");
                this.obsFreetext3 = obs.getChildText("text4");
                this.obsLangtext1 = obs.getChildText("langtext1");
                this.obsLangtext2 = obs.getChildText("langtext2");
                this.topic.fromString(obs.getChildText("list1"));
                this.obsType.fromString(obs.getChildText("list2"));
                this.priority.fromString(obs.getChildText("list3"));
                this.obsAmount = obs.getChildText("amount");
                this.obsRisk = obs.getChildText("risk");
                this.status = Util.parseInt((String)obs.getChildText("status"), (int)0);
                this.obsRealType.fromString(obs.getChildText("observationtype"));
            }
        }
        catch (JDOMException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.setTriggerEnabled(true);
    }

    public void loadFilter(long id) {
        if (!this.project.isOpen() || id < 0L) {
            return;
        }
        this.loadFilter((CmsFilter)this.project.loadElement(id, this.project.getUser()));
    }

    public void loadFilter(CmsFilter flt) {
        if (!this.project.isOpen()) {
            return;
        }
        this.filterElement = flt;
        this.clearAll(false, this);
        if (this.filterElement != null) {
            this.fromXml(this.filterElement.getAttributeValue("xml"));
        }
    }

    public CmsBasicElement saveFilter(long id, String title) {
        if (!this.project.isOpen()) {
            return null;
        }
        if (this.filterElement == null || id < 0L) {
            this.filterElement = (CmsFilter)this.project.createElement("filter");
        }
        this.filterElement.setAttributeValue("name", title);
        this.filterElement.setAttributeValue("xml", this.getFilterAsXml());
        if (id >= 0L) {
            this.filterElement.setId(id);
        }
        this.filterElement.save();
        return new CmsBasicElement((CmsElement)this.filterElement);
    }
}

