/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.filter;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.filter.ThemisFilter;

public class ThemisFilterBoolean {
    private ThemisFilter filter;
    private ThemisApplication app;
    protected ThemisFilterBooleanValue value;

    public ThemisFilterBoolean(ThemisFilter filter, ThemisApplication app) {
        this.filter = filter;
        this.app = app;
    }

    public String toString() {
        switch (this.value) {
            case NO: {
                return "no";
            }
            case NOTSET: {
                return "notset";
            }
            case YES: {
                return "yes";
            }
        }
        return "notset";
    }

    public void fromString(String s) {
        switch (s.toLowerCase()) {
            case "yes": {
                this.value = ThemisFilterBooleanValue.YES;
                break;
            }
            case "no": {
                this.value = ThemisFilterBooleanValue.NO;
                break;
            }
            default: {
                this.value = ThemisFilterBooleanValue.NOTSET;
            }
        }
    }

    public void clear(Object source) {
        this.setValue(ThemisFilterBooleanValue.NOTSET, source);
    }

    public void setValue(ThemisFilterBooleanValue v, Object source) {
        this.value = v;
        this.filter.setFilterChanged(source);
    }

    public void setValue(int idx) {
        switch (idx) {
            case 1: {
                this.value = ThemisFilterBooleanValue.NO;
                break;
            }
            case 2: {
                this.value = ThemisFilterBooleanValue.YES;
                break;
            }
            default: {
                this.value = ThemisFilterBooleanValue.NOTSET;
            }
        }
    }

    public ThemisFilterBooleanValue getValue() {
        return this.value;
    }

    public boolean isEmpty() {
        return this.value == ThemisFilterBooleanValue.NOTSET;
    }

    public static enum ThemisFilterBooleanValue {
        NOTSET,
        NO,
        YES;

    }
}

