/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.filter;

import at.grid.cms.search.CmsSqlSearch;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.util.Util;
import java.util.Date;
import java.util.TimeZone;

public class ThemisFilterDate {
    Date fromDate;
    Date untilDate;
    ThemisFilter filter;
    ThemisProject project;

    public ThemisFilterDate(ThemisFilter f) {
        this.filter = f;
        this.project = ThemisApplication.getInstance().getProject();
    }

    public void clear() {
        this.setDates(null, null, null);
    }

    public void setDates(ThemisFilterDate tfd, Object source) {
        this.setDates(tfd.fromDate, tfd.untilDate, source);
    }

    public void setDates(Date from, Date until, Object source) {
        boolean changed;
        boolean bl = from == null ? this.fromDate != null : (changed = !from.equals(this.fromDate));
        changed = changed || (until == null ? this.untilDate != null : !until.equals(this.untilDate));
        this.fromDate = from;
        this.untilDate = until;
        if (changed) {
            this.filter.setFilterChanged(source);
        }
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public Date getUntilDate() {
        return this.untilDate;
    }

    public void addWhere(CmsSqlSearch s, String fld) {
        if (this.fromDate != null) {
            s.addWhere(fld + " >= " + Util.toSqlString((Date)this.fromDate, (TimeZone)this.project.getTimeZone()));
        }
        if (this.untilDate != null) {
            s.addWhere(fld + " <= " + Util.toSqlString((Date)this.untilDate, (TimeZone)this.project.getTimeZone()));
        }
    }

    public String toString() {
        String d1 = this.fromDate == null ? "" : Util.formatDate((Date)this.fromDate, (String)Util.DATE_ISO, (TimeZone)this.project.getTimeZone());
        String d2 = this.fromDate == null ? "" : Util.formatDate((Date)this.untilDate, (String)Util.DATE_ISO, (TimeZone)this.project.getTimeZone());
        return d1 + "-" + d2;
    }

    public void fromString(String s) {
        if (s == null || "".equals(s) || "-".equals(s)) {
            this.fromDate = null;
            this.untilDate = null;
            return;
        }
        String[] split = s.split("-");
        if (split.length == 1) {
            this.fromDate = Util.parseDate((String)split[0], (String)Util.DATE_ISO, (TimeZone)this.project.getTimeZone(), null);
            this.untilDate = null;
        } else if ("".equals(split[0])) {
            this.fromDate = null;
            this.untilDate = Util.parseDate((String)split[1], (String)Util.DATE_ISO, (TimeZone)this.project.getTimeZone(), null);
        } else {
            this.fromDate = Util.parseDate((String)split[0], (String)Util.DATE_ISO, (TimeZone)this.project.getTimeZone(), null);
            this.untilDate = Util.parseDate((String)split[1], (String)Util.DATE_ISO, (TimeZone)this.project.getTimeZone(), null);
        }
    }

    public boolean isEmpty() {
        return this.fromDate == null && this.untilDate == null;
    }
}

