/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.filter;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.util.Util;
import java.util.ArrayList;

public class ThemisFilterListItem {
    private ThemisFilter filter;
    private ThemisApplication app;
    protected ArrayList<Long> list = new ArrayList();

    public ThemisFilterListItem(ThemisFilter filter, ThemisApplication app) {
        this.filter = filter;
        this.app = app;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (long id : this.list) {
            sb.append(Long.toString(id)).append(" ");
        }
        return sb.toString().trim();
    }

    public void fromString(String s) {
        this.list.clear();
        if (s == null) {
            return;
        }
        String[] split = s.split(" ");
        ArrayList<Long> ids = new ArrayList<Long>();
        for (String id : split) {
            long l = Util.parseLong((String)id, (long)-1L);
            if (l < 0L && l != -9L) continue;
            ids.add(l);
        }
        this.setList(ids);
    }

    public ArrayList<Long> getList() {
        return this.list;
    }

    public void setList(ArrayList<Long> lst) {
        this.list.clear();
        this.list.addAll(lst);
    }

    public void addListAnd(ArrayList<Long> lst) {
        ArrayList<Long> newList = new ArrayList<Long>();
        for (long l : lst) {
            if (this.list.contains(l)) continue;
            newList.add(l);
        }
        this.setList(newList);
    }

    public void addListOr(ArrayList<Long> lst) {
        for (long l : lst) {
            if (this.list.contains(l)) continue;
            this.list.add(l);
        }
    }

    public long getFirstItem() {
        return this.isEmpty() ? -1L : this.getList().get(0);
    }

    public void setItem(long locList1, Object source) {
        this.list.clear();
        this.addItem(locList1, source);
    }

    public void addItem(long locList1, Object source) {
        if (!this.list.contains(locList1) && locList1 != -1L) {
            this.list.add(locList1);
            this.filter.setFilterChanged(source);
        }
    }

    public void removeItem(long locList1, Object source) {
        this.list.remove(locList1);
        this.setFilterChanged(source);
    }

    public void clear(Object source) {
        this.list.clear();
        this.setFilterChanged(source);
    }

    private void setFilterChanged(Object source) {
        this.filter.resetSearchResult();
        if (this.filter.isTriggerEnabled()) {
            this.app.getActionProvider().invokeAction(ThemisAction.FILTER_CHANGED.from(source, "ThemisFilterListItem call"));
        }
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public boolean isSizeOne() {
        return this.list.size() == 1;
    }
}

