/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.importer;

import at.grid.themis.ontology.attribute.ThemisAttribute;

public class AttributeReference {
    public ThemisAttribute ta = null;
    public String elementtype;
    public String attributecode;
    public String attributelabel;

    public AttributeReference(ThemisAttribute ta) {
        this.attributecode = ta.getCmsCode();
        this.attributelabel = ta.getLabel();
        this.ta = ta;
        switch (ta.getTarget()) {
            case OBSERVATION: {
                this.elementtype = "observation";
                break;
            }
            case LOCATION: {
                this.elementtype = "location";
                break;
            }
            case EVENT: {
                this.elementtype = "event";
                break;
            }
            case PROJECT: {
                this.elementtype = "project";
            }
        }
    }

    public AttributeReference(String elementtype, String attributecode, String attributelabel) {
        this.elementtype = elementtype;
        this.attributecode = attributecode;
        this.attributelabel = attributelabel;
    }

    public String toString() {
        switch (this.elementtype) {
            case "location": {
                return "G - " + this.attributelabel;
            }
            case "observation": {
                return "B - " + this.attributelabel;
            }
            case "project": {
                return "PRJ - " + this.attributelabel;
            }
        }
        return this.attributelabel;
    }

    public String getCode() {
        return this.elementtype + "." + this.attributecode;
    }

    public boolean equals(Object ar) {
        if (ar instanceof AttributeReference) {
            return this.getCode().equals(((AttributeReference)ar).getCode());
        }
        return false;
    }
}

