/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.importer;

import at.grid.themis.ontology.importer.ThemisGenericExporter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import org.openide.util.Exceptions;

public class ThemisCsvExporter
extends ThemisGenericExporter {
    private final String separator;

    public ThemisCsvExporter() {
        this("\t");
    }

    public ThemisCsvExporter(String separator) {
        this.separator = separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createExportFile(File f) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(f);
            boolean firstCol = true;
            for (String h : this.headerLabel) {
                if (!firstCol) {
                    fw.write(this.separator);
                }
                fw.write("\"" + this.getHeaderText(h).replaceAll("\"", "\"\"") + "\"");
                firstCol = false;
            }
            fw.write("\n");
            for (Properties p : this.data) {
                if (p == null) continue;
                firstCol = true;
                for (String h : this.header) {
                    if (!firstCol) {
                        fw.write(this.separator);
                    }
                    fw.write("\"" + p.getProperty(h, "").replaceAll("\"", "\"\"") + "\"");
                    firstCol = false;
                }
                fw.write("\n");
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            try {
                fw.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

