/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.importer;

import at.grid.cms.content.KeytableRecord;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.importer.AttributeReference;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class ThemisCsvImporter {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisSettings settings = this.app.getSettings();
    ThemisProject project = this.app.getProject();
    ArrayList<String> columnTitles = new ArrayList();
    List<CSVRecord> records = null;
    int colX = -1;
    int colY = -1;
    int colTitle = -1;
    int colUUID = -1;
    HashMap<Integer, AttributeReference> mapping = new HashMap();
    KeytableRecord createStandardObservation = null;
    File folder = null;
    boolean useTitleForIdent = false;

    public void setCreateStandardObservation(KeytableRecord rec) {
        this.createStandardObservation = rec;
    }

    public void setColumnMappingX(int columnIndex) {
        this.colX = columnIndex;
    }

    public void setColumnMappingY(int columnIndex) {
        this.colY = columnIndex;
    }

    public void setColumnMapping(String col, AttributeReference att) {
        int idx = this.columnTitles.indexOf(col);
        switch (att.getCode().toLowerCase()) {
            case "location.position-x": {
                this.setColumnMappingX(idx);
                break;
            }
            case "location.position-y": {
                this.setColumnMappingY(idx);
                break;
            }
            case "location.title": {
                this.colTitle = idx;
                this.mapping.put(idx, att);
                break;
            }
            case "location.uuid": {
                this.colUUID = idx;
                this.mapping.put(idx, att);
                break;
            }
            default: {
                this.mapping.put(idx, att);
            }
        }
    }

    public void setColumnMapping(HashMap<String, AttributeReference> mapping) {
        this.mapping.clear();
        for (String col : mapping.keySet()) {
            this.setColumnMapping(col, mapping.get(col));
        }
    }

    public void readCsvFile(File f) throws IOException {
        this.folder = f.getParentFile();
        char del = this.getCsvDelimeter(f);
        CSVFormat csvFileFormat = CSVFormat.EXCEL.withDelimiter(del);
        FileReader reader = new FileReader(f);
        CSVParser csvFileParser = new CSVParser((Reader)reader, csvFileFormat);
        this.records = csvFileParser.getRecords();
        CSVRecord header = this.records.get(0);
        this.columnTitles.clear();
        Iterator iter = header.iterator();
        while (iter.hasNext()) {
            this.columnTitles.add((String)iter.next());
        }
    }

    private char getCsvDelimeter(File f) throws FileNotFoundException, IOException {
        BufferedReader br = new BufferedReader(new FileReader(f));
        String ln = br.readLine();
        br.close();
        int delTabCount = ln.split("\t").length;
        int delSemicolCount = ln.split(";").length;
        int delCommaCount = ln.split(",").length;
        if (delTabCount > Math.max(delSemicolCount, delCommaCount)) {
            return '\t';
        }
        if (delSemicolCount > delCommaCount) {
            return ';';
        }
        return ',';
    }

    public ArrayList<String> getColumnTitles() {
        return this.columnTitles;
    }

    public boolean hasCoordinates() {
        return this.colX > 0 && this.colY > 0;
    }

    public int getSize() {
        return this.records.size();
    }

    public void importData(ProgressHandler ph) {
        if (this.records == null || this.records.size() < 2) {
            return;
        }
        boolean errorFound = false;
        ArrayList<String> errorMessages = new ArrayList<String>();
        ArrayList<CmsElementSummary> plans = this.project.getPlans();
        HashMap<String, Long> planIds = new HashMap<String, Long>();
        for (CmsElementSummary plan : plans) {
            planIds.put(plan.getTitle(), plan.getId());
        }
        long planid = -1L;
        String filename = null;
        String filecomment = null;
        boolean ignoreAttributeError = false;
        int count = this.records.size() - 1;
        for (int ii = 1; ii < this.records.size(); ++ii) {
            try {
                CmsLocation loc;
                ph.progress("Import " + ii + " von " + count, ii);
                CSVRecord record = this.records.get(ii);
                if (this.useTitleForIdent && this.colTitle >= 0) {
                    long locId = this.project.getDatastorage().getElementId(record.get(this.colTitle), "location");
                    loc = locId > 0L ? (CmsLocation)this.project.loadElement(locId, this.project.getUser()) : (CmsLocation)this.project.createElement("location");
                } else if (this.colUUID > 0) {
                    UUID uuid = UUID.fromString(record.get(this.colUUID));
                    CmsElement e = this.project.loadElement(uuid, this.project.getUser());
                    if (!(e instanceof CmsLocation)) continue;
                    loc = (CmsLocation)e;
                } else {
                    loc = (CmsLocation)this.project.createElement("location");
                }
                CmsObservation obs = null;
                Properties locProps = new Properties();
                Properties obsProps = new Properties();
                planid = -1L;
                filename = null;
                filecomment = null;
                block15: for (int columnIndex : this.mapping.keySet()) {
                    AttributeReference att = this.mapping.get(columnIndex);
                    switch (att.attributecode) {
                        case "plan": {
                            Long planidLong = (Long)planIds.get(record.get(columnIndex));
                            planid = planidLong == null ? -1L : planidLong;
                            ignoreAttributeError = true;
                            continue block15;
                        }
                        case "upload-file": {
                            filename = record.get(columnIndex);
                            continue block15;
                        }
                        case "upload-comment": {
                            filecomment = record.get(columnIndex);
                            continue block15;
                        }
                    }
                    CmsElement def = this.project.getDefaultElement(att.elementtype);
                    if (def.hasAttribute(att.attributecode) && def.getAttribute(att.attributecode).isNumber() && !Util.isNumber((String)record.get(columnIndex))) {
                        errorMessages.add(this.project.getResourceText("error.csv-import.numberformatexception") + " [" + (ii + 1) + "]");
                        errorFound = true;
                        continue;
                    }
                    if (att.elementtype.equals("location")) {
                        locProps.put(att.attributecode, record.get(columnIndex));
                        continue;
                    }
                    if (!att.elementtype.equals("observation")) continue;
                    obsProps.put(att.attributecode, record.get(columnIndex));
                }
                loc.setAttributes(locProps);
                if (planid > 0L) {
                    loc.getRelationAttribute("plan").add(planid);
                }
                if (!obsProps.isEmpty()) {
                    obs = (CmsObservation)this.project.createElement("observation");
                    obs.setLocation(loc);
                    obs.setNumber(loc.getNextObservationNumber());
                    obs.setAttributes(obsProps);
                } else if (this.createStandardObservation != null) {
                    obs = (CmsObservation)this.project.createElement("observation");
                    obs.setLocation(loc);
                    obs.setNumber(loc.getNextObservationNumber());
                    obs.setAttributeValue("title", this.createStandardObservation.term);
                    obs.getKeyAttribute("type").setValue(this.createStandardObservation.id);
                }
                if (filename != null && !"null".equals(filename) && this.folder != null) {
                    UploadItem item = null;
                    if (this.settings.getImageForObservation() && obs != null) {
                        item = obs.getUploadAttribute("files").addUpload(new File(this.folder, filename));
                    } else if (!this.settings.getImageForObservation()) {
                        item = loc.getUploadAttribute("files").addUpload(new File(this.folder, filename));
                    }
                    if (item != null && filecomment != null) {
                        item.setFileComment(filecomment);
                    }
                }
                loc.save();
                if (obs == null) continue;
                obs.save();
                continue;
            }
            catch (NumberFormatException ex) {
                errorFound = true;
                continue;
            }
            catch (Exception ex) {
                errorFound = true;
            }
        }
    }
}

