/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.importer;

import at.grid.cms.content.UploadItem;
import at.grid.util.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

public abstract class ThemisGenericExporter {
    ArrayList<String> header = new ArrayList();
    ArrayList<String> headerLabel = new ArrayList();
    ArrayList<Properties> data = new ArrayList();
    ArrayList<UploadItem> uploads = new ArrayList();
    Properties groupfunction = null;

    public void addHeader(String h) {
        this.header.add(h);
        this.headerLabel.add(h);
    }

    public void addHeader(String h, String lbl) {
        this.header.add(h);
        this.headerLabel.add(lbl);
    }

    public void setHeader(ArrayList<String> h) {
        this.header.clear();
        this.headerLabel.clear();
        this.header.addAll(h);
        this.headerLabel.addAll(h);
    }

    public void addData(Properties p) {
        this.data.add(p);
    }

    public void addUploads(ArrayList<UploadItem> uploads) {
        this.uploads.addAll(uploads);
    }

    public abstract void createExportFile(File var1);

    public void runExport(File f) {
        this.createExportFile(f);
        if (!this.uploads.isEmpty()) {
            String folderName = f.getName().substring(0, f.getName().lastIndexOf(".")) + "-data";
            File dataDir = new File(f.getParent(), folderName);
            if (!dataDir.exists()) {
                dataDir.mkdirs();
            }
            for (UploadItem upload : this.uploads) {
                File destDir = new File(dataDir, upload.getElementtype());
                if (!destDir.exists()) {
                    destDir.mkdirs();
                }
                File destFile = new File(destDir, upload.getFilename());
                try {
                    Util.copy((File)upload.getFile(), (File)destFile);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void setGroupFunction(Properties gf) {
        if (gf != null) {
            this.groupfunction = new Properties();
            this.groupfunction.putAll((Map<?, ?>)gf);
        } else {
            this.groupfunction = null;
        }
    }

    public String getHeaderText(String h) {
        if (this.groupfunction != null) {
            String gf = this.groupfunction.getProperty(h, "1");
            switch (gf.toLowerCase()) {
                case "s": {
                    return "Summe(" + h + ")";
                }
                case "n": {
                    return "Anzahl(" + h + ")";
                }
                case "g": {
                    return "Gruppe(" + h + ")";
                }
            }
            return "Erste(" + h + ")";
        }
        return h;
    }
}

