/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.importer;

import at.grid.themis.ontology.importer.ThemisReaderGeneric;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class ThemisReaderCsv
extends ThemisReaderGeneric {
    @Override
    public void readFileImpl(File f) throws IOException {
        FileReader reader = new FileReader(f);
        char del = this.getCsvDelimeter(f);
        CSVFormat csvFileFormat = CSVFormat.EXCEL.withDelimiter(del);
        CSVParser csvFileParser = new CSVParser((Reader)reader, csvFileFormat);
        List recs = csvFileParser.getRecords();
        if (recs.isEmpty()) {
            return;
        }
        CSVRecord header = (CSVRecord)recs.get(0);
        for (String col : header) {
            this.columnTitles.add(col);
        }
        recs.remove(0);
        for (CSVRecord record : recs) {
            ArrayList<String> rec = new ArrayList<String>();
            for (int ii = 0; ii < record.size(); ++ii) {
                rec.add(record.get(ii));
            }
            this.records.add(rec);
        }
    }

    private char getCsvDelimeter(File f) throws FileNotFoundException, IOException {
        BufferedReader br = new BufferedReader(new FileReader(f));
        String ln = br.readLine();
        br.close();
        int delTabCount = ln.split("\t").length;
        int delSemicolCount = ln.split(";").length;
        int delCommaCount = ln.split(",").length;
        if (delTabCount > Math.max(delSemicolCount, delCommaCount)) {
            return '\t';
        }
        if (delSemicolCount > delCommaCount) {
            return ';';
        }
        return ',';
    }
}

