/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.importer;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.importer.ThemisReaderGeneric;
import at.grid.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ThemisReaderXlsx
extends ThemisReaderGeneric {
    private ArrayList<Integer> columnIndex = new ArrayList();
    private int sheetIndex = 0;

    public ThemisReaderXlsx(int headerRow, int startDataRow) {
        this.headerRow = headerRow;
        this.startDataRow = startDataRow;
    }

    @Override
    public void setSheet(int idx) {
        this.sheetIndex = idx;
    }

    public void setRows(int headerRow, int startDataRow) {
        this.headerRow = headerRow;
        this.startDataRow = startDataRow;
    }

    public ArrayList<String> getSheetNames(File f) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        FileInputStream is = new FileInputStream(f);
        Workbook wb = WorkbookFactory.create((InputStream)is);
        for (int ii = 0; ii < wb.getNumberOfSheets(); ++ii) {
            names.add(wb.getSheetName(ii));
        }
        wb.close();
        ((InputStream)is).close();
        return names;
    }

    @Override
    public void readFileImpl(File f) throws IOException {
        this.columnIndex.clear();
        FileInputStream is = new FileInputStream(f);
        Workbook wb = WorkbookFactory.create((InputStream)is);
        Sheet sheet = wb.getSheetAt(this.sheetIndex);
        Row r = sheet.getRow(this.headerRow - 1);
        if (r != null) {
            Iterator it = r.cellIterator();
            while (it.hasNext()) {
                Cell c = (Cell)it.next();
                String cval = this.getCellValue(c);
                if ("".equals(cval)) continue;
                this.columnTitles.add(cval);
                this.columnIndex.add(c.getAddress().getColumn());
            }
        }
        int maxRow = sheet.getLastRowNum() + 1;
        for (int row = this.startDataRow; row <= maxRow; ++row) {
            r = sheet.getRow(row - 1);
            if (r == null) continue;
            ArrayList<String> rec = new ArrayList<String>();
            for (int idx : this.columnIndex) {
                Cell c = r.getCell(idx);
                rec.add(this.getCellValue(c));
            }
            this.records.add(rec);
        }
        wb.close();
        if (is != null) {
            ((InputStream)is).close();
        }
    }

    public String getCellValue(Cell c) {
        if (c == null) {
            return "";
        }
        CellType celltype = c.getCellType();
        switch (celltype) {
            case BLANK: 
            case _NONE: 
            case ERROR: {
                return "";
            }
            case FORMULA: {
                try {
                    return c.getStringCellValue();
                }
                catch (Exception exception) {
                    try {
                        double d = c.getNumericCellValue();
                        if (d % 1.0 == 0.0) {
                            return Long.toString((long)d);
                        }
                        return Double.toString(d);
                    }
                    catch (Exception d) {
                        // empty catch block
                    }
                }
            }
            case BOOLEAN: {
                return c.getBooleanCellValue() ? "TRUE" : "FALSE";
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)c)) {
                    Date dt = c.getDateCellValue();
                    return Util.formatDate((Date)dt, (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone());
                }
                double d = c.getNumericCellValue();
                if (d % 1.0 == 0.0) {
                    return Long.toString((long)d);
                }
                return Double.toString(d);
            }
        }
        return c.getStringCellValue();
    }
}

