/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.importer;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.importer.ThemisGenericExporter;
import at.grid.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openide.util.Exceptions;

public class ThemisXlsExporter
extends ThemisGenericExporter {
    @Override
    public void createExportFile(File f) {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet("THEMIS Export");
        int cc = 0;
        int rr = 0;
        XSSFRow row = sheet.createRow(rr);
        for (String h : this.headerLabel) {
            XSSFCell cell = row.createCell(cc);
            cell.setCellValue(this.getHeaderText(h));
            ++cc;
        }
        ++rr;
        for (Properties p : this.data) {
            if (p == null) continue;
            row = sheet.createRow(rr);
            cc = 0;
            for (String h : this.header) {
                XSSFCell cell = row.createCell(cc);
                String cellval = p.getProperty(h);
                if (Util.isDate((String)cellval)) {
                    cell.setCellValue(Util.parseDate((String)cellval, (TimeZone)ThemisApplication.getInstance().getTimeZone()));
                } else if (Util.isDouble((String)cellval)) {
                    cell.setCellValue(Double.parseDouble(cellval));
                } else {
                    cell.setCellValue(cellval);
                }
                ++cc;
            }
            ++rr;
        }
        try {
            FileOutputStream fos = new FileOutputStream(f);
            wb.write((OutputStream)fos);
            wb.close();
            fos.close();
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

