/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.SimpleActionWithReturn;
import at.grid.themis.ontology.javafx.JavaFxFactory;
import at.grid.themis.ontology.javafx.JavaFxSwingDialog;
import java.awt.Dimension;
import java.awt.Frame;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;

public class JavaFxDialog
extends VBox {
    HBox panelButtons;
    SimpleActionWithReturn closeAction;
    SimpleActionWithReturn saveAction;
    Node mainPanel = null;
    Stage stage = null;
    public ThemisApplication app = ThemisApplication.getInstance();
    public ThemisProject project = this.app.getProject();
    private JavaFxSwingDialog dlg;
    private JFXPanel fxPanel;

    public JavaFxDialog(Node main) {
        this.initialise(main);
    }

    public JavaFxDialog() {
        this.initialise();
    }

    public JavaFxDialog(Node main, Dimension minSize) {
        this.initialise(main);
        this.setMinSize(minSize.width, minSize.height);
    }

    public JavaFxDialog(Dimension minSize) {
        this.initialise();
        this.setMinSize(minSize.width, minSize.height);
    }

    public void showAsSwingDialog(Frame f) {
        JavaFxSwingDialog swingDlg = new JavaFxSwingDialog(this.project.getResourceText(this.getDialogCode()), this.getMinSize());
        this.setCloseAction(() -> {
            swingDlg.close();
            return false;
        });
        swingDlg.setParentFrame(f);
        swingDlg.setContent((Node)this);
        this.fxPanel = swingDlg.getFxPanel();
        swingDlg.show();
    }

    public JFXPanel getFxPanel() {
        return this.fxPanel;
    }

    public Window getWindow() {
        Scene scene;
        if (this.fxPanel != null && (scene = this.fxPanel.getScene()) != null) {
            return scene.getWindow();
        }
        return null;
    }

    public Dimension getMinSize() {
        return new Dimension((int)this.getMinWidth() + 20, (int)this.getMinHeight() + 20);
    }

    public String getDialogCode() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public void preInitialise(Node panelMain) {
    }

    public void initialise() {
        this.initialise(this.getMainPanel());
    }

    public void initialise(Node panelMain) {
        this.preInitialise(panelMain);
        if (panelMain == null) {
            panelMain = this.getMainPanel();
        }
        this.getChildren().add((Object)panelMain);
        VBox.setVgrow((Node)panelMain, (Priority)Priority.ALWAYS);
        this.panelButtons = new HBox();
        this.panelButtons.setMinHeight(50.0);
        this.panelButtons.setPrefHeight(50.0);
        this.panelButtons.setAlignment(Pos.CENTER);
        this.panelButtons.setSpacing(10.0);
        this.getChildren().add((Object)this.panelButtons);
    }

    public void setCloseAction(SimpleActionWithReturn a) {
        this.closeAction = a;
    }

    public void setSaveAction(SimpleActionWithReturn a) {
        this.saveAction = a;
    }

    protected Node getMainPanel() {
        return this.mainPanel;
    }

    public Button addSaveButton(String lbl) {
        Button btn = this.createButton(this.project.getResourceText(lbl));
        btn.setGraphic((Node)new ImageView(new Image(JavaFxDialog.class.getResourceAsStream("/at/grid/themis/ontology/javafx/media/confirm24.gif"), 24.0, 24.0, true, true)));
        btn.setPrefWidth(150.0);
        btn.setOnAction(e -> {
            if (this.save()) {
                this.closeDialog();
                if (this.saveAction != null) {
                    this.saveAction.execute();
                }
            }
        });
        this.panelButtons.getChildren().add((Object)btn);
        return btn;
    }

    public Button addCancelButton(String lbl) {
        Button btn = this.createButton(this.project.getResourceText(lbl));
        btn.setPrefWidth(150.0);
        btn.setGraphic((Node)new ImageView(new Image(JavaFxDialog.class.getResourceAsStream("/at/grid/themis/ontology/javafx/media/cancel24.gif"), 24.0, 24.0, true, true)));
        btn.setOnAction(e -> this.closeDialog());
        this.panelButtons.getChildren().add((Object)btn);
        return btn;
    }

    public Button addButton(Button btn) {
        this.panelButtons.getChildren().add((Object)btn);
        return btn;
    }

    public Button addButton(String lbl) {
        Button btn = this.createButton(lbl);
        this.panelButtons.getChildren().add((Object)btn);
        return btn;
    }

    private Button createButton(String lbl) {
        return JavaFxFactory.createButton(lbl, null);
    }

    public void showDialog() {
    }

    public void showDialog(Stage stage) {
        Scene scene = new Scene((Parent)this.getMainPanel(), 600.0, 400.0);
        stage.setScene(scene);
        stage.show();
    }

    public void closeDialog() {
        if (this.stage != null) {
            this.stage.close();
        }
        if (this.closeAction != null) {
            this.closeAction.execute();
        }
        if (this.dlg != null) {
            this.dlg.close();
        }
    }

    public boolean save() {
        return true;
    }

    void setDialog(JavaFxSwingDialog dlg) {
        this.dlg = dlg;
    }
}

