/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx;

import java.io.File;
import java.util.Optional;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextInputDialog;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;

public class JavaFxDialogs {
    public static boolean showYesNoDialog(String message) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Achtung");
        alert.setContentText(message);
        ButtonType yes = new ButtonType("Ja", ButtonBar.ButtonData.YES);
        ButtonType no = new ButtonType("Nein", ButtonBar.ButtonData.NO);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{yes, no});
        Optional result = alert.showAndWait();
        return result.isPresent() && yes.equals(result.get());
    }

    public static String showInputDialog(String message) {
        TextInputDialog dialog = new TextInputDialog("Eingabe");
        dialog.setHeaderText(message);
        Optional result = dialog.showAndWait();
        return (String)result.get();
    }

    public static void showWarnDialog(String message) {
        Alert alert = new Alert(Alert.AlertType.WARNING);
        alert.setTitle("Achtung");
        alert.setContentText(message);
        ButtonType okay = new ButtonType("Okay", ButtonBar.ButtonData.OK_DONE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{okay});
        alert.showAndWait();
    }

    public static File showDirectoryChooser() {
        return JavaFxDialogs.showDirectoryChooser(null);
    }

    public static File showDirectoryChooser(File dir) {
        return JavaFxDialogs.showDirectoryChooser(null, dir);
    }

    public static File showDirectoryChooser(Window stage, File dir) {
        DirectoryChooser chooser = new DirectoryChooser();
        if (dir != null && dir.isDirectory()) {
            chooser.setInitialDirectory(dir);
        }
        return chooser.showDialog(stage);
    }
}

