/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx;

import at.grid.cms.content.Keytable;
import at.grid.cms.content.KeytableRecord;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.javafx.JavaFxIcon;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.PasswordField;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;

public class JavaFxFactory {
    public static final String STYLE_FONT_SIZE_SMALL = "-fx-font-size: 11px;";
    public static final String STYLE_FONT_SIZE = "-fx-font-size: 14px;";
    public static final String STYLE_FONT_SIZE_MEDIUM = "-fx-font-size: 18px;";
    public static final String STYLE_FONT_SIZE_LARGE = "-fx-font-size: 22px;";
    public static final String STYLE_FONT_FAMILY = "-fx-font-family: \"Calibri\";";
    public static final String STYLE_FONT_BOLD = "-fx-font-weight: bold;";
    public static final String STYLE_TEXT_COLOR_GREY = "-fx-text-color: grey; -fx-fill: grey;";
    public static final String STYLE_TEXT_COLOR_LIGHT_GREY = "-fx-text-color: lightgrey; -fx-fill: lightgrey;";
    public static final String STYLE_TEXT = "-fx-font-size: 14px; -fx-font-family: \"Calibri\";";
    public static final String STYLE_TEXT_SMALL = "-fx-font-size: 11px; -fx-font-family: \"Calibri\";";
    public static final String STYLE_TEXT_DISABLED = "-fx-font-size: 14px; -fx-font-family: \"Calibri\"; -fx-text-color: lightgrey; -fx-fill: lightgrey;";
    public static final String STYLE_TEXT_HINT = "-fx-font-size: 14px; -fx-font-family: \"Calibri\"; -fx-text-color: grey; -fx-fill: grey;";
    public static final String STYLE_HEADING = "-fx-font-size: 22px; -fx-font-family: \"Calibri\"; -fx-font-weight: bold;";
    public static final String STYLE_HEADING2 = "-fx-font-size: 18px; -fx-font-family: \"Calibri\"; -fx-font-weight: bold;";
    public static final double MINHEIGHT = 25.0;

    public static Label createLabelHint(String txt) {
        return JavaFxFactory.createLabel(txt, STYLE_TEXT_HINT);
    }

    public static Label createLabel(String txt) {
        return JavaFxFactory.createLabel(txt, STYLE_TEXT);
    }

    public static Label createLabelHeading(String txt) {
        return JavaFxFactory.createLabel(txt, STYLE_HEADING);
    }

    public static Label createLabelHeading2(String txt) {
        return JavaFxFactory.createLabel(txt, STYLE_HEADING2);
    }

    public static Label createLabel(String txt, String style) {
        Label n = new Label(txt);
        n.setMinHeight(25.0);
        JavaFxFactory.setLayout((Node)n, style);
        n.setWrapText(true);
        return n;
    }

    public static Text createTextHint(String txt) {
        return JavaFxFactory.createText(txt, STYLE_TEXT_HINT);
    }

    public static Text createText(String txt) {
        return JavaFxFactory.createText(txt, STYLE_TEXT);
    }

    public static Text createTextHeading(String txt) {
        return JavaFxFactory.createText(txt, STYLE_HEADING);
    }

    public static Text createTextHeading2(String txt) {
        return JavaFxFactory.createText(txt, STYLE_HEADING2);
    }

    public static Text createText(String txt, String style) {
        Text n = new Text(txt);
        JavaFxFactory.setLayout((Node)n, style);
        return n;
    }

    public static CheckBox createCheckbox(boolean checked) {
        return JavaFxFactory.createCheckbox(null, checked);
    }

    public static CheckBox createCheckbox(String label, boolean checked) {
        CheckBox n = new CheckBox(label);
        n.setSelected(checked);
        n.setWrapText(true);
        n.setMinHeight(25.0);
        JavaFxFactory.setLayout((Node)n, STYLE_TEXT);
        n.setAlignment(Pos.TOP_CENTER);
        return n;
    }

    public static RadioButton createRadioButton(String lbl, boolean sel, ToggleGroup g) {
        RadioButton btn = new RadioButton(lbl);
        btn.setMinHeight(25.0);
        JavaFxFactory.setLayout((Node)btn, STYLE_TEXT);
        btn.setToggleGroup(g);
        if (sel) {
            btn.setSelected(true);
        }
        return btn;
    }

    public static ArrayList<RadioButton> createRadioButtons(String sel, String ... labels) {
        ArrayList<RadioButton> buttons = new ArrayList<RadioButton>();
        ToggleGroup toggleGroup = new ToggleGroup();
        for (String lbl : labels) {
            buttons.add(JavaFxFactory.createRadioButton(lbl, sel != null && sel.equals(lbl), toggleGroup));
        }
        return buttons;
    }

    public static DatePicker createDatePicker(Date dt) {
        DatePicker n = new DatePicker();
        if (dt != null) {
            LocalDate ldt = dt.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            n.setValue((Object)ldt);
        }
        n.setMinHeight(25.0);
        n.setMaxWidth(Double.MAX_VALUE);
        JavaFxFactory.setLayout((Node)n, STYLE_TEXT);
        return n;
    }

    public static TextField createTextField(String val) {
        TextField n = new TextField(val);
        n.setMinHeight(25.0);
        JavaFxFactory.setLayout((Node)n, STYLE_TEXT);
        return n;
    }

    public static PasswordField createPasswordField() {
        return JavaFxFactory.createPasswordField("");
    }

    public static PasswordField createPasswordField(String val) {
        PasswordField n = new PasswordField();
        n.setText(val);
        n.setMinHeight(25.0);
        JavaFxFactory.setLayout((Node)n, STYLE_TEXT);
        return n;
    }

    public static TextArea createTextArea(String val) {
        return new TextArea(val);
    }

    public static TextArea createTextAreaSmall(String val) {
        TextArea n = new TextArea(val);
        n.setMinHeight(50.0);
        n.setMaxHeight(75.0);
        JavaFxFactory.setLayout((Node)n, STYLE_TEXT);
        return n;
    }

    public static ComboBox createComboBox(List values, Object sel, boolean withNone) {
        ComboBox n = new ComboBox();
        if (withNone) {
            n.getItems().add((Object)"-");
        }
        if (values != null) {
            n.getItems().addAll((Collection)values);
        }
        if (sel != null && values != null && values.contains(sel)) {
            n.getSelectionModel().select(sel);
        }
        n.setMinHeight(25.0);
        n.setMaxWidth(Double.MAX_VALUE);
        JavaFxFactory.setLayout((Node)n, STYLE_TEXT);
        return n;
    }

    public static ComboBox createComboBoxFromKeytable(String tableCode, boolean withNone, long id) {
        Keytable tbl;
        ThemisProject project = ThemisApplication.getInstance().getProject();
        ComboBox n = new ComboBox();
        if (!project.isOpen()) {
            return n;
        }
        if (withNone) {
            n.getItems().add((Object)new KeytableRecord(-1L, "-", -1));
            if (id < 0L) {
                n.getSelectionModel().select(0);
            }
        }
        if ((tbl = project.getKeytable(tableCode)) == null) {
            return n;
        }
        ArrayList recs = (ArrayList)tbl.getTable().get(project.getUser().getCurrentLanguage());
        if (recs == null) {
            return n;
        }
        for (KeytableRecord rec : recs) {
            n.getItems().add((Object)rec);
            if (rec.id != id) continue;
            n.getSelectionModel().select((Object)rec);
        }
        n.setMaxWidth(Double.MAX_VALUE);
        n.setMinHeight(25.0);
        JavaFxFactory.setLayout((Node)n, STYLE_TEXT);
        return n;
    }

    public static Button createButton(String txt, EventHandler eh) {
        return JavaFxFactory.createButton(txt, null, null, eh);
    }

    public static Button createButton(String txt, String icon, EventHandler eh) {
        return JavaFxFactory.createButton(txt, icon, null, eh);
    }

    public static Button createButton(String txt, String icon, String tooltip, EventHandler eh) {
        Button n = icon == null ? new Button(txt) : new Button(txt, (Node)new ImageView(icon));
        n.setOnAction(eh);
        if (tooltip != null) {
            n.setTooltip(new Tooltip(tooltip));
        }
        n.setMinHeight(25.0);
        JavaFxFactory.setLayout((Node)n, STYLE_TEXT);
        return n;
    }

    public static Button createSvgButton(String icon, EventHandler eh) {
        return JavaFxFactory.createSvgButton(icon, null, eh);
    }

    public static Button createSvgButton(String icon, String tooltip, EventHandler eh) {
        Button btn = new Button("", (Node)new JavaFxIcon(icon, 24.0));
        btn.setMinWidth(40.0);
        btn.setMinHeight(40.0);
        btn.setOnAction(eh);
        if (tooltip != null) {
            btn.setTooltip(new Tooltip(tooltip));
        }
        return btn;
    }

    public static ToggleButton createToggleButton(String txt, boolean sel, ToggleGroup g, EventHandler eh) {
        ToggleButton n = new ToggleButton(txt);
        n.setToggleGroup(g);
        n.setSelected(sel);
        n.setOnAction(eh);
        n.setMinHeight(25.0);
        JavaFxFactory.setLayout((Node)n, STYLE_TEXT);
        return n;
    }

    public static ListView createListView(ArrayList values, Object sel) {
        ListView list = new ListView();
        if (values != null) {
            list.getItems().addAll((Collection)values);
        }
        if (sel != null && values != null && values.contains(sel)) {
            list.getSelectionModel().select(sel);
        }
        list.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        list.setMaxHeight(120.0);
        JavaFxFactory.setLayout((Node)list, STYLE_TEXT);
        return list;
    }

    public static VBox createVBox(Node ... nodes) {
        VBox p = new VBox();
        p.setSpacing(5.0);
        p.setPadding(new Insets(10.0));
        p.setAlignment(Pos.TOP_LEFT);
        if (nodes != null) {
            p.getChildren().addAll((Object[])nodes);
        }
        return p;
    }

    public static HBox createHBox(Node ... nodes) {
        HBox p = new HBox();
        p.setSpacing(5.0);
        p.setPadding(new Insets(10.0));
        p.setAlignment(Pos.TOP_LEFT);
        if (nodes != null) {
            p.getChildren().addAll((Object[])nodes);
        }
        return p;
    }

    public static Region createHorizontalSpacer() {
        Region r = new Region();
        HBox.setHgrow((Node)r, (Priority)Priority.ALWAYS);
        return r;
    }

    public static Region createVerticalSpacer() {
        Region r = new Region();
        VBox.setVgrow((Node)r, (Priority)Priority.ALWAYS);
        return r;
    }

    public static FlowPane createFlowPane(Node ... nodes) {
        FlowPane p = new FlowPane();
        p.setHgap(5.0);
        if (nodes != null) {
            p.getChildren().addAll((Object[])nodes);
        }
        return p;
    }

    public static GridPane createGridPane() {
        GridPane p = new GridPane();
        p.setPadding(new Insets(10.0));
        p.setVgap(5.0);
        p.setHgap(5.0);
        return p;
    }

    private static void setLayout(Node n, String style) {
        GridPane.setValignment((Node)n, (VPos)VPos.TOP);
        GridPane.setMargin((Node)n, (Insets)new Insets(1.0));
        GridPane.setHgrow((Node)n, (Priority)Priority.ALWAYS);
        GridPane.setValignment((Node)n, (VPos)VPos.TOP);
        GridPane.setHalignment((Node)n, (HPos)HPos.LEFT);
        n.setStyle(style);
    }

    public static ColumnConstraints getColumnConstraintsLabel() {
        ColumnConstraints c1 = new ColumnConstraints();
        c1.setHgrow(Priority.NEVER);
        c1.setPrefWidth(-1.0);
        c1.setMaxWidth(-1.0);
        c1.setHalignment(HPos.LEFT);
        c1.setPercentWidth(0.0);
        return c1;
    }

    public static ColumnConstraints getColumnConstraintsField() {
        ColumnConstraints c1 = new ColumnConstraints();
        c1.setHgrow(Priority.ALWAYS);
        c1.setMaxWidth(Double.MAX_VALUE);
        c1.setPercentWidth(-1.0);
        return c1;
    }

    public static ColumnConstraints getColumnConstraintsButton() {
        ColumnConstraints c1 = new ColumnConstraints();
        c1.setHgrow(Priority.NEVER);
        c1.setPrefWidth(-1.0);
        c1.setMaxWidth(-1.0);
        c1.setHalignment(HPos.RIGHT);
        c1.setPercentWidth(0.0);
        return c1;
    }

    public static RowConstraints getRowConstraints() {
        return new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.CENTER, false);
    }
}

