/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx;

import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.SVGPath;

public class JavaFxIcon
extends Group {
    private final String path;
    private final Paint color;
    private final double size;
    public static String CHECK_CIRCLE = "m20.95 33.75 14.55-14.6-3.15-3.2-11.4 11.4-5.55-5.55-3.15 3.2ZM24 45.05q-4.35 0-8.2-1.625-3.85-1.625-6.725-4.5Q6.2 36.05 4.575 32.2 2.95 28.35 2.95 24t1.625-8.2q1.625-3.85 4.5-6.725Q11.95 6.2 15.8 4.55q3.85-1.65 8.15-1.65 4.4 0 8.25 1.65 3.85 1.65 6.725 4.525Q41.8 11.95 43.45 15.8q1.65 3.85 1.65 8.25 0 4.3-1.65 8.15-1.65 3.85-4.525 6.725-2.875 2.875-6.725 4.5-3.85 1.625-8.2 1.625Z";
    public static String CANCEL = "m16.9 33.5 7.1-7.1 7.1 7.1 2.4-2.4-7.1-7.1 7.1-7.1-2.4-2.4-7.1 7.1-7.1-7.1-2.4 2.4 7.1 7.1-7.1 7.1ZM24 45.05q-4.35 0-8.2-1.625-3.85-1.625-6.725-4.5Q6.2 36.05 4.575 32.2 2.95 28.35 2.95 24t1.625-8.2q1.625-3.85 4.5-6.725Q11.95 6.2 15.8 4.55q3.85-1.65 8.15-1.65 4.4 0 8.25 1.65 3.85 1.65 6.725 4.525Q41.8 11.95 43.45 15.8q1.65 3.85 1.65 8.25 0 4.3-1.65 8.15-1.65 3.85-4.525 6.725-2.875 2.875-6.725 4.5-3.85 1.625-8.2 1.625Z";
    public static String CHEVRON_RIGHT = "M18.75 37.05 15.5 33.8l9.9-9.85-9.9-9.9 3.25-3.25L31.9 23.95Z";
    public static String CHEVRON_LEFT = "M28.05 37.05 14.9 23.95 28.05 10.8l3.25 3.25-9.9 9.9 9.9 9.85Z";
    public static String CHEVRON_UP = "M480-528 296-344l-56-56 240-240 240 240-56 56-184-184Z";
    public static String CHEVRON_DOWN = "M480-345 240-585l56-56 184 184 184-184 56 56-240 240Z";
    public static String FOLDER = "M7.55 41q-1.85 0-3.2-1.35T3 36.45V11q0-1.85 1.35-3.225T7.55 6.4h13.1l3.4 3.4h16.5q1.85 0 3.225 1.375T45.15 14.4v22.05q0 1.85-1.375 3.2T40.55 41Z";
    public static String FOLDER_OUTLINED = "M7.55 41q-1.85 0-3.2-1.35T3 36.45V11q0-1.85 1.35-3.225T7.55 6.4h13.1l3.4 3.4h16.5q1.85 0 3.225 1.375T45.15 14.4v22.05q0 1.85-1.375 3.2T40.55 41Zm0-30v25.45h33V14.4H22.2L18.8 11H7.55Zm0 0v25.45Z";
    public static String ADD_CIRCLE = "M22.4 34.2h3.45v-8.3h8.35v-3.45h-8.35V13.8H22.4v8.65h-8.6v3.45h8.6ZM24 45.05q-4.35 0-8.2-1.625-3.85-1.625-6.725-4.5Q6.2 36.05 4.575 32.2 2.95 28.35 2.95 24q0-4.4 1.625-8.225 1.625-3.825 4.5-6.7T15.8 4.55Q19.65 2.9 24 2.9t8.225 1.65Q36.1 6.2 38.95 9.075q2.85 2.875 4.5 6.725 1.65 3.85 1.65 8.2 0 4.4-1.65 8.225-1.65 3.825-4.525 6.675-2.875 2.85-6.725 4.5-3.85 1.65-8.2 1.65Z";
    public static String AUTO_RENEW = "M204-318q-22-38-33-78t-11-82q0-134 93-228t227-94h7l-64-64 56-56 160 160-160 160-56-56 64-64h-7q-100 0-170 70.5T240-478q0 26 6 51t18 49l-60 60ZM481-40 321-200l160-160 56 56-64 64h7q100 0 170-70.5T720-482q0-26-6-51t-18-49l60-60q22 38 33 78t11 82q0 134-93 228t-227 94h-7l64 64-56 56Z";

    public JavaFxIcon(String path, double size) {
        this(path, (Paint)Color.web((String)"#000000"), size);
    }

    public JavaFxIcon(String path, String hex, double size) {
        this(path, (Paint)Color.web((String)hex), size);
    }

    public JavaFxIcon(String path, Paint color, double size) {
        this.path = path;
        this.color = color;
        this.size = size;
        SVGPath svg = new SVGPath();
        svg.setContent(this.path);
        svg.setFill(this.color);
        Bounds bounds = svg.getBoundsInParent();
        double scale = Math.min(this.size / bounds.getWidth(), this.size / bounds.getHeight());
        svg.setScaleX(scale);
        svg.setScaleY(scale);
        this.getChildren().add((Object)svg);
    }
}

